/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.sg;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.WrappingToggleButton;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;

public class CustomToggleButton
extends WrappingToggleButton
implements CellExpanderComponent {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int sgNumber = 0;
    private String sgTitle = null;
    protected boolean underTheCursor = false;
    protected boolean mousePressed = false;
    private CellExpander cellExpander;
    private Point cep;

    public CustomToggleButton(String string) {
        this.sgTitle = string;
        AppearanceManager.updateFont(this);
        CellExpanderManager.sharedInstance().registerComponent(this);
        this.cep = new Point(0, 0);
        this.setBorder(new CustomToggleBorder());
        this.setFocusPainted(false);
        this.setHorizontalAlignment(2);
        this.setMinimumSize(new Dimension(0, 0));
    }

    public void setToolTipText(String string) {
        this.putClientProperty("ToolTipText", string);
        if (string == null) {
            CellExpanderManager.sharedInstance().unregisterComponent(this);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Insets getMargin() {
        return new Insets(2, 2, 2, 2);
    }

    public String getTitle() {
        return this.sgTitle;
    }

    public void setTitle(String string) {
        this.sgTitle = string;
        this.setButtonNumber(this.sgNumber);
    }

    protected void setButtonNumber(int n2) {
        this.sgNumber = n2;
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        reuseStringBuffer.append(n2).append(".&nbsp;").append(this.sgTitle);
        this.setText(ReuseStringBuffer.toString(reuseStringBuffer));
        if (n2 < 10) {
            this.setMnemonic(48 + n2);
        } else if (n2 == 10) {
            this.setMnemonic('0');
        }
        this.setHangingIndent("1. ");
        this.setToolTipText(this.sgTitle);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getModifiers();
        if (n2 == 504) {
            this.underTheCursor = true;
        } else if (n2 == 505) {
            this.underTheCursor = false;
        } else if (n2 == 501) {
            if ((n3 & 0x10) == 16) {
                this.mousePressed = true;
            }
        } else if (n2 == 502 && (n3 & 0x10) == 16) {
            this.mousePressed = false;
        }
        super.processMouseEvent(mouseEvent);
        this.repaint();
    }

    public void invalidate() {
        super.invalidate();
        this.cellExpander = null;
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        if (this.getPreferredSize().width <= this.getSize().width) {
            return null;
        }
        return this.cep;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cellExpander.setForeground(this.getForeground());
            this.cellExpander.setBackground(this.getBackground());
            this.cellExpander.setBorder(this.getBorder());
            this.cellExpander.setFont(this.getFont());
            this.cellExpander.setHangingIndent(this.getHangingIndent());
            String string = this.getText();
            int n2 = string.indexOf(".");
            int n3 = string.indexOf("&nbsp;") > -1 ? 7 : 2;
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            reuseStringBuffer.append("<u>").append(string.substring(0, n2)).append("</u>. ").append(CellExpanderManager.untag(string.substring(n2 + n3)));
            string = ReuseStringBuffer.toString(reuseStringBuffer);
            Dimension dimension = this.getPreferredSize();
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            this.cellExpander.setTipText(string, dimension.width);
            this.cellExpander.setPreferredSize(dimension);
            this.cellExpander.setSize(dimension);
            Point point = new Point(-3, 0);
            this.cellExpander.putClientProperty("translate.point", point);
        }
        this.cellExpander.setEnabled(this.isEnabled());
        return this.cellExpander;
    }

    protected class CustomToggleBorder
    implements Border {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Insets borderInsets = new Insets(3, 2, 3, 2);

        protected CustomToggleBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            CustomToggleButton customToggleButton = CustomToggleButton.this;
            Dimension dimension = CustomToggleButton.this.getSize();
            if (!customToggleButton.isEnabled() && dimension.width == n4) {
                return;
            }
            if (CustomToggleButton.this.isSelected() || customToggleButton.mousePressed && customToggleButton.underTheCursor) {
                graphics.setColor(Color.black);
                graphics.drawLine(n2, n3, n2 + n4, n3);
                graphics.drawLine(n2, n3, n2, n3 + n5);
                graphics.setColor(Color.white);
                graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
                graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5);
            } else if (customToggleButton.underTheCursor || !(component instanceof CustomToggleButton)) {
                graphics.setColor(Color.white);
                graphics.drawLine(n2, n3, n2 + n4, n3);
                graphics.drawLine(n2, n3, n2, n3 + n5);
                graphics.setColor(Color.black);
                graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
                graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5);
            } else {
                graphics.setColor(customToggleButton.getBackground());
                graphics.drawLine(n2, n3, n2 + n4, n3);
                graphics.drawLine(n2, n3, n2, n3 + n5);
                graphics.setColor(customToggleButton.getBackground());
                graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
                graphics.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

