/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.AssistTable;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class WindyScrollPaneUI
extends BasicScrollPaneUI
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JScrollPane scrollpane;

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.scrollpane = (JScrollPane)jComponent;
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        if (AssistManager.getSelectScrollPolicy()) {
            jScrollPane.registerKeyboardAction(new WindyScrollAction("ScrollUp", 1, -1), KeyStroke.getKeyStroke(33, 0), 1);
            jScrollPane.registerKeyboardAction(new WindyScrollAction("ScrollDown", 1, 1), KeyStroke.getKeyStroke(34, 0), 1);
            jScrollPane.registerKeyboardAction(new WindyScrollAction("ScrollLeft", 0, -1), KeyStroke.getKeyStroke(33, 2), 1);
            jScrollPane.registerKeyboardAction(new WindyScrollAction("ScrollDown", 0, 1), KeyStroke.getKeyStroke(34, 2), 1);
            jScrollPane.registerKeyboardAction(new WindyScrollHomeAction("ScrollHome"), KeyStroke.getKeyStroke(36, 2), 1);
            jScrollPane.registerKeyboardAction(new WindyScrollEndAction("ScrollEnd"), KeyStroke.getKeyStroke(35, 2), 1);
        } else {
            super.installKeyboardActions(jScrollPane);
        }
    }

    private class WindyScrollEndAction
    extends ScrollPaneAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected WindyScrollEndAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = WindyScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
            }
        }
    }

    private class WindyScrollHomeAction
    extends ScrollPaneAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected WindyScrollHomeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = WindyScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                jViewport.setViewPosition(new Point(0, 0));
            }
        }
    }

    private class WindyScrollAction
    extends ScrollPaneAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected int orientation;
        protected int direction;

        public WindyScrollAction(String string, int n2, int n3) {
            super(string);
            this.orientation = n2;
            this.direction = n3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport = WindyScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                if (component instanceof AssistTable && this.orientation == 1) {
                    int n2;
                    int n3;
                    if (((JTable)component).isEditing()) {
                        ((AssistTable)component).stopCellEditing();
                    }
                    int n4 = ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, this.orientation, this.direction);
                    int n5 = ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) / n4;
                    ListSelectionModel listSelectionModel = ((JTable)component).getSelectionModel();
                    int n6 = listSelectionModel.getMinSelectionIndex();
                    int n7 = rectangle.y / n4;
                    if (n7 * n4 < rectangle.y) {
                        ++n7;
                    }
                    if ((n3 = (rectangle.y + rectangle.height - n4) / n4) > (n2 = ((JTable)component).getRowCount() - 1)) {
                        n3 = n2;
                    }
                    System.out.println("\nWSBUI toprow: " + n7);
                    System.out.println("WSBUI botrow: " + n3);
                    System.out.println("WSBUI selrow: " + n6);
                    if (this.direction == -1 && n6 != n7) {
                        listSelectionModel.setSelectionInterval(n7, n7);
                        return;
                    }
                    if (this.direction == -1 && n6 == n7) {
                        n7 = n7 - n5 < 0 ? 0 : n7 - n5;
                        listSelectionModel.setSelectionInterval(n7, n7);
                    } else {
                        if (this.direction == 1 && n6 != n3) {
                            listSelectionModel.setSelectionInterval(n3, n3);
                            return;
                        }
                        if (this.direction == 1 && n6 == n3) {
                            n3 = n3 + n5 < n2 ? n3 + n5 : n2;
                            listSelectionModel.setSelectionInterval(n3, n3);
                        }
                    }
                }
                int n8 = component instanceof Scrollable ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : (this.orientation == 1 ? rectangle.height : rectangle.width);
                if (this.orientation == 1) {
                    rectangle.y += n8 * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    }
                } else {
                    rectangle.x += n8 * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    }
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    private abstract class ScrollPaneAction
    extends AbstractAction {
        public final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected ScrollPaneAction(String string) {
            super(string);
        }

        public boolean isEnabled() {
            return WindyScrollPaneUI.this.scrollpane != null && WindyScrollPaneUI.this.scrollpane.isEnabled();
        }
    }
}

