/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.WorkbookPage;
import com.ibm.db2.tools.common.plaf.motif.MotifWorkbookUI;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsWorkbookUI
extends MotifWorkbookUI
implements FocusListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsWorkbookUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.goprev.setVisible(false);
        this.tabWidth = 10;
        this.tabGap = 0;
        this.tpad = 8;
        this.borderInsets.top = 7;
        this.borderInsets.left = 3;
        this.borderInsets.right = 3;
        this.borderInsets.bottom = 3;
        this.extInsets.top = this.borderInsets.top + 6;
        this.extInsets.left = this.borderInsets.left + 6;
        this.extInsets.right = this.borderInsets.right + 6;
        this.extInsets.bottom = this.borderInsets.bottom + 6;
        this.tabStart = this.borderInsets.left;
        this.tabHighlight = true;
        this.tabOverlap = true;
        this.drawBorder = false;
        this.wb.addFocusListener(this);
        this.left.setRolloverEnabled(false);
        this.right.setRolloverEnabled(false);
        this.leftGap = 0;
    }

    protected void updateNested(boolean bl) {
        if (bl) {
            this.borderInsets.top = 7;
            this.borderInsets.left = 0;
            this.borderInsets.bottom = 0;
            this.borderInsets.right = 0;
        } else {
            this.borderInsets.top = 7;
            this.borderInsets.left = 3;
            this.borderInsets.bottom = 3;
            this.borderInsets.right = 3;
        }
        this.tabStart = this.borderInsets.left;
        this.extInsets.top = this.borderInsets.top + 6;
        this.extInsets.left = this.borderInsets.left + 6;
        this.extInsets.bottom = this.borderInsets.bottom + 6;
        this.extInsets.right = this.borderInsets.right + 6;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.wb.removeFocusListener(this);
    }

    public void paintWorkbookBorder(Graphics graphics, Color color, Dimension dimension) {
        graphics.setColor(color.darker());
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.setColor(color.brighter());
        graphics.drawLine(0, 1, dimension.width - 1, 1);
    }

    protected void calculateArrowWidth() {
        this.arrowWidth = this.left.getPreferredSize().width + this.right.getPreferredSize().width + (this.goprev.isVisible() ? 10 + this.goprev.getPreferredSize().width : 0) + 10;
    }

    protected int getTabHeight() {
        Font font = this.wb.getFont();
        if (font == null) {
            return 30;
        }
        this.captionFont = font;
        FontMetrics fontMetrics = ((Component)this.wb).getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        return 4 + n2 + 4;
    }

    protected void paintBorders(Graphics graphics, int n2) {
        Dimension dimension = this.wb.getSize();
        Color color = this.wb.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n3 = this.extInsets.top + n2;
        Rectangle rectangle = this.getFrameRect(n2);
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        graphics.setColor(this.bright3);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n5 - 1);
        graphics.drawLine(rectangle.x, rectangle.y, n4 - 2, rectangle.y);
        graphics.setColor(this.bright1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, n5 - 2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, n4 - 2, rectangle.y + 1);
        graphics.setColor(this.dark3);
        graphics.drawLine(n4 - 1, rectangle.y + 1, n4 - 1, n5 - 1);
        graphics.drawLine(rectangle.x + 1, n5 - 1, n4 - 1, n5 - 1);
        graphics.setColor(this.dark1);
        graphics.drawLine(n4 - 2, rectangle.y + 2, n4 - 2, n5 - 2);
        graphics.drawLine(rectangle.x + 2, n5 - 2, n4 - 2, n5 - 2);
        graphics.setColor(ColorUtil.getScaledColor(color, -20));
        graphics.drawLine(rectangle.x, rectangle.y - 1, n4 - 2, rectangle.y - 1);
        graphics.drawLine(rectangle.x - 1, rectangle.y, rectangle.x - 1, n5 - 2);
        if (!this.wb.isNested() && this.drawBorder) {
            this.paintWorkbookBorder(graphics, color, dimension);
        }
    }

    protected boolean paintOneTab(Graphics graphics, WorkbookPage workbookPage, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        int n7;
        int n8;
        int n9;
        this.tabHeight = this.getTabHeight();
        if (n4 != this.currentPage) {
            --n3;
        }
        Color color = this.wb.getBackground();
        Icon icon = workbookPage.getIcon();
        String string = workbookPage.getTitle();
        boolean bl3 = false;
        int n10 = n9 = n3 + this.tabHeight - 5;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n11 = n8 = string != null ? fontMetrics.stringWidth(string) : 0;
        if (icon != null) {
            n8 += icon.getIconWidth() + 5;
        }
        if (n8 < this.tabWidth) {
            n8 = this.tabWidth;
        }
        int n12 = this.tpad + n8 + this.tpad;
        if (bl2) {
            n12 += this.overlapWidth + this.overlapWidth;
        }
        if (n2 + n12 > n5 - this.tabGap) {
            return false;
        }
        if (n4 == this.currentPage) {
            bl3 = true;
            n10 -= this.doplerShift;
        }
        int n13 = 0;
        int n14 = this.tabHeight;
        if (!bl3) {
            n13 = this.doplerShift;
            n14 -= n13;
            if (bl) {
                graphics.setColor(color);
                graphics.fillRect(n2 - 1, n3 - 1, n12 + 2, n13 + 1);
                graphics.setColor(this.bright3);
                n7 = n3 + this.tabHeight;
                graphics.drawLine(n2, n7, n2 + n12, n7);
                graphics.setColor(this.bright1);
                graphics.drawLine(n2, n7 + 1, n2 + n12, n7 + 1);
                if (n4 == this.firstPage) {
                    graphics.setColor(this.bright3);
                    graphics.drawLine(n2, n7, n2 + 5, n7);
                    graphics.drawLine(n2, n7, n2, n7 + 5);
                    graphics.setColor(this.bright1);
                    graphics.drawLine(n2 + 1, n7 + 1, n2 + 5, n7 + 1);
                    graphics.drawLine(n2 + 1, n7 + 1, n2 + 1, n7 + 5);
                }
            }
        }
        graphics.setColor(color);
        n7 = bl3 ? this.doplerShift + 3 : 0;
        graphics.fillRect(n2, n3 + n13, n12, n14 + n7);
        int n15 = n2 + n12 - 1;
        int n16 = n3 + n13 - 1;
        int n17 = n16 + n14;
        Color color2 = this.bright3;
        Color color3 = this.bright1;
        Color color4 = this.bright1;
        Color color5 = this.dark3;
        Color color6 = this.dark1;
        Color color7 = this.dark1;
        graphics.setColor(color2);
        graphics.drawLine(n2, n16 + 2, n2, n17);
        graphics.drawLine(n2 + 2, n16, n15 - 2, n16);
        graphics.setColor(color3);
        graphics.drawLine(n2 + 1, n16 + 1, n2 + 1, n17);
        graphics.drawLine(n2 + 1, n16 + 2, n2 + 1, n17);
        graphics.drawLine(n2 + 2, n16 + 1, n15 - 2, n16 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n2, n16 + 2, n2 + 2, n16);
        if (bl3) {
            graphics.setColor(ColorUtil.getScaledColor(color, -20));
            graphics.drawLine(n2 - 1, n17 - 1, n2 - 1, n16 + 2);
            graphics.drawLine(n2 - 1, n16 + 2, n2 + 2, n16 - 1);
            graphics.drawLine(n2 + 2, n16 - 1, n15 - 2, n16 - 1);
        }
        graphics.setColor(color5);
        graphics.drawLine(n15, n16 + 2, n15, n17);
        graphics.drawLine(n15, n16 + 2, n15 - 1, n16 + 1);
        graphics.setColor(color6);
        if (!bl3) {
            graphics.drawLine(n15 - 1, n16 + 2, n15 - 1, n17);
        } else {
            graphics.drawLine(n15 - 1, n16 + 2, n15 - 1, n17 + 1);
        }
        if (bl3) {
            if (n4 == this.firstPage) {
                n6 = n3 + n14;
                graphics.setColor(color2);
                graphics.drawLine(n2, n6, n2, n6 + 5);
                graphics.setColor(color3);
                graphics.drawLine(n2 + 1, n6, n2 + 1, n6 + 5);
                graphics.setColor(ColorUtil.getScaledColor(color, -20));
                graphics.drawLine(n2 - 1, n6 - 1, n2 - 1, n6 + 5);
            } else {
                n6 = n3 + n14;
                graphics.setColor(color2);
                graphics.drawLine(n2, n6, n2 + 1, n6);
                graphics.setColor(color3);
                graphics.drawLine(n2, n6 + 1, n2 + 1, n6 + 1);
                graphics.drawLine(n2 + 1, n6, n2 + 1, n6 + 1);
            }
        }
        if (bl3) {
            graphics.setColor(this.getSelectedTextColor());
        } else {
            graphics.setColor(this.wb.getForeground());
        }
        n6 = n2 + n12 / 2 - n8 / 2;
        if (icon != null) {
            int n18 = n3 + this.tabHeight / 2 - icon.getIconHeight() / 2;
            if (!bl3) {
                n18 += this.doplerShift;
            }
            icon.paintIcon(this.wb, graphics, n6, n18);
            n6 += 5 + icon.getIconWidth();
        }
        if (string != null) {
            if (this.wb.isEnabled() && workbookPage.isEnabled()) {
                graphics.drawString(string, n6, n10);
            } else {
                graphics.setColor(color.brighter());
                graphics.drawString(string, n6, n10);
                graphics.setColor(color.darker());
                graphics.drawString(string, n6 - 1, n10 - 1);
            }
            if (bl3 && this.wb.hasFocus()) {
                BasicGraphicsUtils.drawDashedRect(graphics, n2 + 4, n3 + 2, n12 - 8, this.tabHeight - 3);
            }
        }
        workbookPage.setTabBounds(n2, n3, n12, this.tabHeight);
        return true;
    }

    protected void repaintTabRegion() {
        int n2 = this.getTabHeight();
        Dimension dimension = this.wb.getSize();
        int n3 = this.borderInsets.left - 1;
        int n4 = this.borderInsets.top - this.doplerShift - 1;
        int n5 = dimension.width - this.borderInsets.left - this.borderInsets.right + 2;
        int n6 = n2 + 5 + 3;
        this.wb.repaint(0L, n3, n4, n5, n6);
        this.tabSwap = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.wb.getPageCount() == 0 || this.visiblePage == null) {
            return;
        }
        Rectangle rectangle = this.visiblePage.getTabBounds();
        this.wb.repaint(rectangle);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.wb.getPageCount() == 0 || this.visiblePage == null) {
            return;
        }
        Rectangle rectangle = this.visiblePage.getTabBounds();
        this.wb.repaint(rectangle);
    }

    public Color getSelectedTextColor() {
        return Color.black;
    }
}

