/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.plaf.motif.MotifPaneTitleBarUI;
import com.ibm.db2.tools.common.plaf.motif.PaneTextArea;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class WindowsPaneTitleBarUI
extends MotifPaneTitleBarUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean etched = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsPaneTitleBarUI();
    }

    public void installUI(JComponent jComponent) {
        if (!this.etched) {
            this.sinsets.top = 3;
            this.sinsets.bottom = 3;
        }
        super.installUI(jComponent);
        jComponent.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    protected Font getTextFont() {
        return (Font)UIManager.get("Label.font");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        PaneTitleBar paneTitleBar = (PaneTitleBar)jComponent;
        boolean bl = paneTitleBar.isNarrow();
        Color color = jComponent.getBackground();
        graphics.setColor(color);
        Color color2 = ColorUtil.getBrighterColor(color, 3);
        Color color3 = ColorUtil.getBrighterColor(color, 1);
        Color color4 = ColorUtil.getDarkerColor(color, 1);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, jComponent.getWidth() - 1, 0);
        graphics.drawLine(0, 0, 0, jComponent.getHeight() - 1);
        graphics.setColor(color3);
        graphics.drawLine(1, 1, jComponent.getWidth() - 2, 1);
        graphics.drawLine(1, 1, 1, jComponent.getHeight() - 2);
        graphics.setColor(color4);
        graphics.drawLine(1, jComponent.getHeight() - 1, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        graphics.drawLine(jComponent.getWidth() - 1, 1, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        if (bl) {
            return;
        }
        if (this.etched) {
            int n2;
            int n3;
            int n4 = n3 = this.minButton.isVisible() ? this.minButton.getWidth() : 0;
            n3 = n3 == 0 ? 2 : (n3 += this.sinsets.left + this.sinsets.left);
            int n5 = n2 = this.maxButton.isVisible() ? this.maxButton.getWidth() : 0;
            n2 = n2 == 0 ? 2 : (n2 += this.sinsets.right + this.sinsets.right);
            int n6 = jComponent.getWidth() - n3 - n2 - 2;
            graphics.setColor(color);
            if (n6 > 2) {
                graphics.draw3DRect(n3 + 1, 3, n6 - 1, jComponent.getHeight() - 7, false);
            }
        }
    }

    protected PaneTextArea createPaneTextArea(PaneTitleBar paneTitleBar) {
        return new MinimalPaneTextArea(paneTitleBar);
    }

    class MinimalPaneTextArea
    extends PaneTextArea {
        public MinimalPaneTextArea(PaneTitleBar paneTitleBar) {
            super(paneTitleBar);
        }

        protected void paintBackground(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (dimension.width < 10) {
                return;
            }
            int n2 = dimension.width / 2;
            Color color = this.getBackground();
            if (WindowsPaneTitleBarUI.this.etched) {
                graphics.setColor(color.brighter());
                graphics.drawLine(n2 - 1, 3, n2 - 1, dimension.height - 4);
                graphics.setColor(color.darker());
                graphics.drawLine(n2, 3, n2, dimension.height - 4);
            } else {
                graphics.setColor(color);
                graphics.setColor(color.darker());
                graphics.drawLine(0, 2, 0, dimension.height - 3);
                graphics.drawLine(dimension.width / 2 - 1, 2, dimension.width / 2 - 1, dimension.height - 3);
                graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 3);
                graphics.setColor(color.brighter());
                graphics.drawLine(1, 2, 1, dimension.height - 3);
                graphics.drawLine(dimension.width / 2, 2, dimension.width / 2, dimension.height - 3);
                graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height - 3);
            }
        }
    }
}

