/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.DockingArea;
import com.ibm.db2.tools.common.DockingAreaLayout;
import com.ibm.db2.tools.common.plaf.motif.MotifDockingAreaUI;
import com.ibm.db2.tools.common.plaf.windows.DockingBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WindowsDockingAreaUI
extends MotifDockingAreaUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static WindowsDockingAreaUI dockingUI = null;
    static DockingBorder vborder = new DockingBorder(true);

    public static ComponentUI createUI(JComponent jComponent) {
        if (dockingUI == null) {
            dockingUI = new WindowsDockingAreaUI();
            MotifDockingAreaUI.border = new DockingBorder(false);
        }
        return dockingUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        DockingArea dockingArea = (DockingArea)jComponent;
        if (dockingArea.getDockingWindow()) {
            dockingArea.setBorder(null);
        } else {
            dockingArea.setBorder(dockingArea.getOrientation() == 1 ? vborder : MotifDockingAreaUI.border);
            DockingAreaLayout dockingAreaLayout = (DockingAreaLayout)dockingArea.getLayout();
            dockingAreaLayout.setSlotGap(2);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        DockingArea dockingArea = (DockingArea)jComponent;
        if (!dockingArea.getDockingWindow()) {
            DockingAreaLayout dockingAreaLayout = (DockingAreaLayout)dockingArea.getLayout();
            Vector vector = dockingAreaLayout.getSlotDimensions();
            Rectangle rectangle = dockingArea.getBounds();
            Insets insets = dockingArea.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            boolean bl = dockingArea.getOrientation() == 1;
            int n2 = bl ? rectangle.y : rectangle.x;
            Color color = dockingArea.getBackground();
            Color color2 = color.darker();
            Color color3 = color.brighter();
            Dimension dimension = dockingArea.getSize();
            int n3 = 0;
            while (n3 < vector.size()) {
                int n4 = (Integer)vector.elementAt(n3);
                n2 += n4 + dockingAreaLayout.getSlotGap();
                if (dockingArea.getOrientation() == 1) {
                    graphics.setColor(color2);
                    graphics.drawLine(n2, rectangle.y, n2, rectangle.height - 1);
                    graphics.setColor(color3);
                    graphics.drawLine(n2 + 1, rectangle.y, n2 + 1, rectangle.height - 1);
                } else {
                    graphics.setColor(color2);
                    graphics.drawLine(rectangle.x, n2, rectangle.width - 1, n2);
                    graphics.setColor(color3);
                    graphics.drawLine(rectangle.x, n2 + 1, rectangle.width - 1, n2 + 1);
                }
                ++n3;
            }
        }
    }
}

