/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.CustomButton;
import com.ibm.db2.tools.common.plaf.CustomButtonUI;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WindowsCustomButtonUI
extends CustomButtonUI {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static CustomButtonUI cbuttonUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (cbuttonUI == null) {
            cbuttonUI = new WindowsCustomButtonUI();
        }
        return cbuttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        CustomButton customButton = (CustomButton)jComponent;
        customButton.setRolloverEnabled(true);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        CustomButton customButton = (CustomButton)jComponent;
        customButton.setRolloverEnabled(false);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        int n2;
        CustomButton customButton = (CustomButton)jComponent;
        Color color = customButton.getBackground();
        Color color2 = customButton.getForeground();
        ButtonModel buttonModel = customButton.getModel();
        boolean bl = buttonModel.isArmed() && buttonModel.isPressed();
        boolean bl2 = !customButton.isRolloverEnabled() || buttonModel.isRollover();
        int n3 = n2 = bl ? 1 : 0;
        if (bl2) {
            object = customButton.getSize();
            Color color3 = ColorUtil.getDarkerColor(color, 1);
            Color color4 = ColorUtil.getDarkerColor(color, 3);
            Color color5 = ColorUtil.getBrighterColor(color, 1);
            Color color6 = ColorUtil.getBrighterColor(color, 3);
            graphics.setColor(bl ? color4 : color6);
            graphics.drawLine(0, 0, ((Dimension)object).width - 1, 0);
            graphics.drawLine(0, 0, 0, ((Dimension)object).height - 2);
            graphics.setColor(bl ? color3 : color5);
            graphics.drawLine(1, 1, ((Dimension)object).width - 2, 1);
            graphics.drawLine(1, 1, 1, ((Dimension)object).height - 3);
            graphics.setColor(bl ? color5 : color3);
            graphics.drawLine(1, ((Dimension)object).height - 2, ((Dimension)object).width - 2, ((Dimension)object).height - 2);
            graphics.drawLine(((Dimension)object).width - 2, 2, ((Dimension)object).width - 2, ((Dimension)object).height - 2);
            graphics.setColor(bl ? color6 : color4);
            graphics.drawLine(0, ((Dimension)object).height - 1, ((Dimension)object).width - 1, ((Dimension)object).height - 1);
            graphics.drawLine(((Dimension)object).width - 1, 0, ((Dimension)object).width - 1, ((Dimension)object).height - 1);
        }
        graphics.setColor(color2);
        switch (customButton.getShape()) {
            case 0: {
                object = bl ? customButton.getPressedIcon() : customButton.getIcon();
                object.paintIcon(customButton, graphics, 0, 0);
                break;
            }
            case 1: {
                graphics.translate(2 + n2, 5 + n2);
                graphics.drawLine(0, 0, 6, 0);
                graphics.drawLine(1, 1, 5, 1);
                graphics.drawLine(2, 2, 4, 2);
                graphics.drawLine(3, 3, 3, 3);
                graphics.translate(-2 - n2, -5 - n2);
                break;
            }
            case 3: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(0, 3, 0, 3);
                graphics.drawLine(1, 2, 1, 4);
                graphics.drawLine(2, 1, 2, 5);
                graphics.drawLine(3, 0, 3, 6);
                graphics.translate(-4 - n2, -3 - n2);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(0, 0, 0, 6);
                graphics.drawLine(1, 1, 1, 5);
                graphics.drawLine(2, 2, 2, 4);
                graphics.drawLine(3, 3, 3, 3);
                graphics.translate(-4 - n2, -3 - n2);
                break;
            }
            case 7: {
                graphics.translate(3 + n2, 2 + n2);
                graphics.drawRect(0, 0, 8, 8);
                graphics.drawLine(0, 1, 7, 1);
                graphics.translate(-3 - n2, -2 - n2);
                break;
            }
            case 6: {
                graphics.translate(3 + n2, 2 + n2);
                graphics.drawRect(0, 3, 5, 5);
                graphics.drawLine(0, 4, 4, 4);
                graphics.drawRect(2, 0, 5, 5);
                graphics.drawLine(2, 1, 6, 1);
                graphics.setColor(color);
                graphics.drawLine(1, 5, 4, 5);
                graphics.translate(-3 - n2, -2 - n2);
                break;
            }
            case 9: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(0, 0, 6, 0);
                graphics.drawLine(1, 1, 5, 1);
                graphics.drawLine(2, 2, 4, 2);
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(0, 5, 6, 5);
                graphics.drawLine(3, 7, 3, 7);
                graphics.drawLine(2, 8, 4, 8);
                graphics.drawLine(1, 9, 5, 9);
                graphics.drawLine(0, 10, 6, 10);
                graphics.translate(-4 - n2, -3 - n2);
                break;
            }
            case 10: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(3, 0, 3, 0);
                graphics.drawLine(2, 1, 4, 1);
                graphics.drawLine(1, 2, 5, 2);
                graphics.drawLine(0, 3, 6, 3);
                graphics.drawLine(0, 5, 6, 5);
                graphics.drawLine(0, 7, 6, 7);
                graphics.drawLine(1, 8, 5, 8);
                graphics.drawLine(2, 9, 4, 9);
                graphics.drawLine(3, 10, 3, 10);
                graphics.translate(-4 - n2, -3 - n2);
                break;
            }
            case 11: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(0, 0, 0, 6);
                graphics.drawLine(1, 1, 1, 5);
                graphics.drawLine(2, 2, 2, 4);
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(5, 0, 5, 6);
                graphics.drawLine(7, 3, 7, 3);
                graphics.drawLine(8, 2, 8, 4);
                graphics.drawLine(9, 1, 9, 5);
                graphics.drawLine(10, 0, 10, 6);
                graphics.translate(-4 - n2, -3 - n2);
                break;
            }
            case 12: {
                graphics.translate(4 + n2, 3 + n2);
                graphics.drawLine(0, 3, 0, 3);
                graphics.drawLine(1, 2, 1, 4);
                graphics.drawLine(2, 1, 2, 5);
                graphics.drawLine(3, 0, 3, 6);
                graphics.drawLine(5, 0, 5, 6);
                graphics.drawLine(7, 0, 7, 6);
                graphics.drawLine(8, 1, 8, 5);
                graphics.drawLine(9, 2, 9, 4);
                graphics.drawLine(10, 3, 10, 3);
                graphics.translate(-4 - n2, -3 - n2);
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        CustomButton customButton = (CustomButton)jComponent;
        switch (customButton.getShape()) {
            case 0: {
                Icon icon = customButton.getIcon();
                if (icon == null) {
                    return new Dimension(0, 0);
                }
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            case 9: 
            case 10: {
                return new Dimension(15, 17);
            }
            case 11: 
            case 12: {
                return new Dimension(19, 13);
            }
            case 5: {
                return new Dimension(16, 12);
            }
            case 3: 
            case 4: {
                return new Dimension(12, 14);
            }
            case 1: {
                return new Dimension(12, 14);
            }
            case 6: 
            case 7: {
                return new Dimension(16, 14);
            }
        }
        return new Dimension(12, 12);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

