/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.windows;

import com.ibm.db2.tools.common.ComponentSplitter;
import com.ibm.db2.tools.common.SplitterLayout;
import com.ibm.db2.tools.common.TiledComponent;
import com.ibm.db2.tools.common.plaf.motif.MotifComponentSplitterUI;
import com.ibm.db2.tools.common.plaf.windows.DB2WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class WindowsComponentSplitterUI
extends MotifComponentSplitterUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public WindowsComponentSplitterUI() {
        this.eborder = new EmptyBorder(3, 2, 3, 2);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComponentSplitterUI();
    }

    public void installUI(JComponent jComponent) {
        ComponentSplitter componentSplitter;
        this.splitter = componentSplitter = (ComponentSplitter)jComponent;
        componentSplitter.setLayout(new SplitterLayout());
        this.mmon = new MotifComponentSplitterUI.MouseMonitor(componentSplitter);
        componentSplitter.addMouseListener(this.mmon);
        componentSplitter.addMouseMotionListener(this.mmon);
        componentSplitter.setSplitBarSize(5);
        componentSplitter.setBorder(this.eborder);
        componentSplitter.setSplitBarHighlightColor((Color)UIManager.get("Panel.foreground"));
        if (componentSplitter.getRoot() != null) {
            this.installFocusListeners(componentSplitter, componentSplitter.getRoot(), true);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        ComponentSplitter componentSplitter = (ComponentSplitter)jComponent;
        componentSplitter.removeMouseListener(this.mmon);
        componentSplitter.removeMouseMotionListener(this.mmon);
        componentSplitter.setBorder(null);
        if (componentSplitter.getRoot() != null) {
            this.installFocusListeners(componentSplitter, componentSplitter.getRoot(), false);
        }
    }

    public Insets getInsets() {
        return new Insets(3, 2, 3, 2);
    }

    protected void makeSplitBarNarrower(boolean bl, Rectangle rectangle) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ComponentSplitter componentSplitter = (ComponentSplitter)jComponent;
        TiledComponent tiledComponent = componentSplitter.getRoot();
        Rectangle rectangle = jComponent.getBounds();
        if (componentSplitter.getComponentCount() == 0) {
            return;
        }
        TiledComponent tiledComponent2 = componentSplitter.getMaximizedComponent();
        if (tiledComponent2 == null) {
            TiledComponent tiledComponent3 = null;
            if (tiledComponent.getType() == 3) {
                this.paintComponentBorder(componentSplitter, tiledComponent, graphics);
                if (tiledComponent.getComponent() == componentSplitter.getSelectedComponent() && tiledComponent.isVisible()) {
                    tiledComponent3 = tiledComponent;
                }
            } else {
                tiledComponent3 = this.paintBorders(componentSplitter, graphics, jComponent.getBackground(), tiledComponent);
            }
            if (tiledComponent3 != null && tiledComponent3.isFocusPainted()) {
                this.paintFocusPane(componentSplitter, tiledComponent3, graphics);
            }
        } else {
            this.paintComponentBorder(componentSplitter, tiledComponent2, graphics);
            if (tiledComponent2.isFocusPainted()) {
                this.paintFocusPane(componentSplitter, tiledComponent2, graphics);
            }
        }
    }

    TiledComponent paintBorders(ComponentSplitter componentSplitter, Graphics graphics, Color color, TiledComponent tiledComponent) {
        int n2 = tiledComponent.getChildCount();
        TiledComponent tiledComponent2 = null;
        int n3 = 0;
        while (n3 < n2) {
            TiledComponent tiledComponent3 = tiledComponent.getChildAt(n3);
            if (tiledComponent3.isVisible()) {
                if (tiledComponent3.getType() != 3) {
                    TiledComponent tiledComponent4 = this.paintBorders(componentSplitter, graphics, color, tiledComponent3);
                    if (tiledComponent4 != null) {
                        tiledComponent2 = tiledComponent4;
                    }
                } else {
                    this.paintComponentBorder(componentSplitter, tiledComponent3, graphics);
                    if (tiledComponent3.getComponent() == componentSplitter.getSelectedComponent()) {
                        tiledComponent2 = tiledComponent3;
                    }
                }
            }
            ++n3;
        }
        return tiledComponent2;
    }

    protected void paintComponentBorder(ComponentSplitter componentSplitter, TiledComponent tiledComponent, Graphics graphics) {
        Component component = tiledComponent.getComponent();
        Rectangle rectangle = component.getBounds();
        Color color = componentSplitter.getBackground();
        graphics.translate(rectangle.x - 1, rectangle.y - 1);
        int n2 = rectangle.width + 2;
        int n3 = rectangle.height + 2;
        graphics.setColor(color.darker());
        graphics.drawLine(0, 0, n2 - 2, 0);
        graphics.drawLine(0, 0, 0, n3 - 2);
        graphics.setColor(color.brighter());
        graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
        graphics.translate(-rectangle.x + 1, -rectangle.y + 1);
    }

    protected void paintFocusPane(ComponentSplitter componentSplitter, TiledComponent tiledComponent, Graphics graphics) {
        Rectangle rectangle = tiledComponent.getComponent().getBounds();
        graphics.setColor(DB2WindowsLookAndFeel.getFocusIndicationColor());
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
    }
}

