/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.AbstractBorder;

public class PuzzleBorder
extends AbstractBorder
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean vertical = false;
    protected boolean soft = false;
    protected boolean puzzle = true;
    int bend = 5;
    int xpad = 5;
    int ypad = 1;

    public PuzzleBorder(boolean bl) {
        this.vertical = bl;
    }

    public void setPuzzle(boolean bl) {
        this.puzzle = bl;
        if (!this.puzzle) {
            this.xpad = 2;
            this.ypad = 0;
        } else {
            this.xpad = 5;
            this.ypad = 1;
        }
    }

    public Insets getBorderInsets(Component component) {
        if (!this.puzzle) {
            return new Insets(this.ypad, this.xpad, this.ypad, this.xpad);
        }
        return !this.vertical ? new Insets(this.ypad, this.xpad, this.ypad, this.xpad + this.bend) : new Insets(this.xpad, this.ypad, this.xpad + this.bend, this.ypad);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void setBendWidth(int n2) {
        this.bend = n2;
    }

    public void setPadding(int n2, int n3) {
        this.xpad = n2;
        this.ypad = n3;
    }

    public void setSoft(boolean bl) {
        this.soft = bl;
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.vertical) {
            int n6 = n2 + n4;
            int n7 = n3 + n5;
            int n8 = n2 + n4 / 2;
            int n9 = n7;
            Color color = component.getBackground();
            if (this.soft) {
                graphics.setColor(ColorUtil.getBrighterColor(color, 2));
            } else {
                graphics.setColor(color.brighter());
            }
            if (!this.puzzle) {
                graphics.drawLine(n2, n9 - 1, n6 - 1, n9 - 1);
                graphics.setColor(color.darker());
                graphics.drawLine(n2, n9 - 2, n6 - 1, n9 - 2);
            } else {
                graphics.drawLine(n2, n9 - 1, n8 - 1 - this.bend, n9 - 1);
                graphics.drawLine(n8 - 1 - this.bend, n9 - 1, n8 - 1, n9 - 1 - this.bend);
                graphics.drawLine(n8 - 1, n9 - 1 - this.bend, n8 - 1 + this.bend, n9 - 1);
                graphics.drawLine(n8 - 1 + this.bend, n9 - 1, n6 - 1, n9 - 1);
                graphics.setColor(color.darker());
                graphics.drawLine(n2, n9 - 2, n8 - 1 - this.bend, n9 - 2);
                graphics.drawLine(n8 - 1 - this.bend, n9 - 2, n8 - 1, n9 - 2 - this.bend);
                graphics.drawLine(n8 - 1, n9 - 2 - this.bend, n8 - 1 + this.bend, n9 - 2);
                graphics.drawLine(n8 - 1 + this.bend, n9 - 2, n6 - 1, n9 - 2);
            }
        } else {
            int n10 = n2 + n4;
            int n11 = n3 + n5;
            int n12 = n10;
            int n13 = n3 + n5 / 2;
            Color color = component.getBackground();
            if (this.soft) {
                graphics.setColor(ColorUtil.getBrighterColor(color, 2));
            } else {
                graphics.setColor(color.brighter());
            }
            if (!this.puzzle) {
                graphics.drawLine(n10 - 1, n3, n10 - 1, n11 - 1);
                graphics.setColor(color.darker());
                graphics.drawLine(n10 - 2, n3, n10 - 2, n11 - 1);
            } else {
                graphics.drawLine(n10 - 1, n3, n10 - 1, n13 - 1 - this.bend);
                graphics.drawLine(n10 - 1, n13 - 1 - this.bend, n10 - 1 - this.bend, n13 - 1);
                graphics.drawLine(n10 - 1 - this.bend, n13 - 1, n10 - 1, n13 - 1 + this.bend);
                graphics.drawLine(n10 - 1, n13 - 1 + this.bend, n10 - 1, n11 - 1);
                graphics.setColor(color.darker());
                graphics.drawLine(n10 - 2, n3, n10 - 2, n13 - 1 - this.bend);
                graphics.drawLine(n10 - 2, n13 - 1 - this.bend, n10 - 2 - this.bend, n13 - 1);
                graphics.drawLine(n10 - 2 - this.bend, n13 - 1, n10 - 2, n13 - 1 + this.bend);
                graphics.drawLine(n10 - 2, n13 - 1 + this.bend, n10 - 2, n11 - 1);
            }
        }
    }
}

