/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CustomButton;
import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.SmartLabel;
import com.ibm.db2.tools.common.support.ColorUtil;
import com.ibm.db2.tools.common.support.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PaneTextArea
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Insets insets = new Insets(4, 4, 4, 4);
    protected static int sepHgap = 5;
    protected static int viewHgap = 5;
    protected int sepHeight = 0;
    protected SmartLabel title;
    protected SmartLabel view;
    protected AbstractButton linkButton;
    protected AbstractButton titleButton;
    protected AbstractButton viewButton;
    protected PaneTitleBar tbar;
    protected static Icon linkIcon;
    protected static Icon linkIconSel;
    JPopupMenu titlePopup = null;
    PopupHandler titleHandler = null;
    StateListener titleState = null;
    JPopupMenu viewPopup = null;
    PopupHandler viewHandler = null;
    StateListener viewState = null;
    static boolean imagesLoaded;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea;

    public PaneTextArea(PaneTitleBar paneTitleBar) {
        this.loadImages();
        this.tbar = paneTitleBar;
        this.title = new SmartLabel();
        this.title.setHorizontalAlignment(0);
        this.view = new SmartLabel();
        this.view.setHorizontalAlignment(0);
        this.makeButtons();
        this.linkButton = new NoFocusToggle();
        this.linkButton.setIcon(linkIcon);
        this.linkButton.setSelectedIcon(linkIconSel);
        this.linkButton.setBorderPainted(false);
        this.linkButton.setFocusPainted(false);
        this.linkButton.setBorder(null);
        this.linkButton.setCursor(Cursor.getPredefinedCursor(12));
        this.linkButton.setOpaque(false);
        this.linkButton.setActionCommand("LinkButton");
        this.linkButton.setRequestFocusEnabled(false);
        this.linkButton.setToolTipText(paneTitleBar.getLinkButtonToolTipText());
        this.setLayout(new TextLayout());
        this.add(this.title);
        this.add(this.view);
        this.add(this.titleButton);
        this.add(this.viewButton);
        this.add(this.linkButton);
        this.addMouseListener(this);
        this.title.addMouseListener(this);
        this.view.addMouseListener(this);
        paneTitleBar.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.title.addMouseMotionListener(this);
        this.view.addMouseMotionListener(this);
        paneTitleBar.addMouseMotionListener(this);
        this.linkButton.addActionListener(this);
    }

    void updateLink() {
        this.linkButton.setVisible(this.tbar.isLinkButtonVisible());
        this.linkButton.setSelected(this.tbar.getLinkState());
        this.linkButton.setToolTipText(this.tbar.getLinkButtonToolTipText());
    }

    protected void makeButtons() {
        this.titleButton = new CustomButton(1);
        this.titleButton.setActionCommand("TitleButton");
        this.titleButton.addActionListener(this);
        this.titleButton.setRequestFocusEnabled(false);
        ((CustomButton)this.titleButton).setFocusTraversable(false);
        this.viewButton = new CustomButton(1);
        this.viewButton.setActionCommand("ViewButton");
        this.viewButton.addActionListener(this);
        this.viewButton.setRequestFocusEnabled(false);
        ((CustomButton)this.viewButton).setFocusTraversable(false);
    }

    protected void handleTitleClick() {
    }

    protected void handleViewClick() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = this.tbar.getPane().getClient();
        if (component != null) {
            component.requestFocus();
        }
        if (mouseEvent.getClickCount() == 2) {
            this.tbar.fireActionEvent(new ActionEvent(this.tbar.getPane(), 1001, "TitleDoubleClick"));
        } else if (mouseEvent.getSource() == this.title) {
            this.handleTitleClick();
        } else if (mouseEvent.getSource() == this.view) {
            this.handleViewClick();
        }
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.tbar.isMouseRemapEnabled()) {
            this.redirectMouseEvent(mouseEvent);
        }
    }

    private void redirectMouseEvent(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (component == this.tbar) {
            return;
        }
        Point point = mouseEvent.getPoint();
        RedirectMouseEvent redirectMouseEvent = new RedirectMouseEvent(this.tbar, mouseEvent, point.x, point.y);
        if (mouseEvent.getID() == 503 || mouseEvent.getID() == 506) {
            this.tbar.fireMouseMotionEvent(redirectMouseEvent);
        } else {
            this.tbar.fireMouseEvent(redirectMouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.linkButton) {
            this.tbar.setLinkState(this.linkButton.isSelected());
            this.tbar.fireActionEvent(new ActionEvent(this.tbar.getPane(), 1001, "LinkButton"));
            this.linkButton.setToolTipText(this.tbar.getLinkButtonToolTipText());
        } else if (object == this.titleButton) {
            this.tbar.fireActionEvent(new ActionEvent(this.tbar.getPane(), 1001, "TitleButton"));
            this.handleTitleAction();
        } else if (object == this.viewButton) {
            this.tbar.fireActionEvent(new ActionEvent(this.tbar.getPane(), 1001, "ViewButton"));
            this.handleViewAction();
        }
    }

    public void handleTitleAction() {
        if (this.titlePopup == null) {
            this.titlePopup = new JPopupMenu();
            this.titlePopup.setInvoker(this.titleButton);
            this.titleHandler = new PopupHandler(true);
            this.titleState = new StateListener(this.titleButton);
            this.titleButton.addChangeListener(this.titleState);
            this.titlePopup.addPopupMenuListener(this.titleState);
        } else {
            if (this.titleState.myCancel) {
                this.titlePopup.setVisible(false);
                this.titleState.myCancel = false;
                return;
            }
            this.titlePopup.removeAll();
        }
        if (this.tbar.getPane().handleTitlePopup(this.titlePopup)) {
            Serializable serializable;
            Serializable serializable2;
            int n2 = 0;
            while (n2 < this.titlePopup.getComponentCount()) {
                serializable2 = this.titlePopup.getComponent(n2);
                if (serializable2 instanceof JMenuItem) {
                    serializable = (JMenuItem)serializable2;
                    if (serializable instanceof JCheckBoxMenuItem) {
                        ((JCheckBoxMenuItem)serializable).addItemListener(this.titleHandler);
                    } else {
                        serializable.addActionListener(this.titleHandler);
                    }
                }
                ++n2;
            }
            serializable2 = null;
            serializable = null;
            if (!this.titleButton.isShowing() || !this.isShowing()) {
                return;
            }
            serializable2 = this.titleButton.getLocationOnScreen();
            serializable = this.getLocationOnScreen();
            Dimension dimension = this.titlePopup.getPreferredSize();
            Dimension dimension2 = this.titleButton.getPreferredSize();
            Dimension dimension3 = this.getSize();
            int n3 = ((Point)serializable).x + dimension3.width / 2 - dimension.width;
            int n4 = ((Point)serializable).y + dimension3.height;
            this.titlePopup.setLocation(n3, n4);
            this.titlePopup.setVisible(true);
        }
        this.titleState.myCancel = false;
    }

    public void handleViewAction() {
        if (this.viewPopup == null) {
            this.viewPopup = new JPopupMenu();
            this.viewPopup.setInvoker(this.viewButton);
            this.viewHandler = new PopupHandler(false);
            this.viewState = new StateListener(this.viewButton);
            this.viewButton.addChangeListener(this.viewState);
            this.viewPopup.addPopupMenuListener(this.viewState);
        } else {
            if (this.viewState.myCancel) {
                this.viewPopup.setVisible(false);
                this.viewState.myCancel = false;
                return;
            }
            this.viewPopup.removeAll();
        }
        if (this.tbar.getPane().handleViewPopup(this.viewPopup)) {
            Serializable serializable;
            Serializable serializable2;
            int n2 = 0;
            while (n2 < this.viewPopup.getComponentCount()) {
                serializable2 = this.viewPopup.getComponent(n2);
                if (serializable2 instanceof JMenuItem) {
                    serializable = (JMenuItem)serializable2;
                    if (serializable instanceof JCheckBoxMenuItem) {
                        ((JCheckBoxMenuItem)serializable).addItemListener(this.viewHandler);
                    } else {
                        serializable.addActionListener(this.viewHandler);
                    }
                }
                ++n2;
            }
            serializable2 = null;
            serializable = null;
            if (!this.viewButton.isShowing() || !this.isShowing()) {
                return;
            }
            serializable2 = this.viewButton.getLocationOnScreen();
            serializable = this.getLocationOnScreen();
            Dimension dimension = this.viewPopup.getPreferredSize();
            Dimension dimension2 = this.viewButton.getPreferredSize();
            Dimension dimension3 = this.getSize();
            int n3 = ((Point)serializable).x + dimension3.width - dimension.width;
            int n4 = ((Point)serializable).y + dimension3.height;
            this.viewPopup.setLocation(n3, n4);
            this.viewPopup.setVisible(true);
        }
        this.viewState.myCancel = false;
    }

    protected void loadImages() {
        if (imagesLoaded) {
            return;
        }
        linkIcon = ImageUtil.loadIcon(class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea == null ? (class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea = PaneTextArea.class$("com.ibm.db2.tools.common.plaf.motif.PaneTextArea")) : class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea, "images/arowupt.gif");
        linkIconSel = ImageUtil.loadIcon(class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea == null ? (class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea = PaneTextArea.class$("com.ibm.db2.tools.common.plaf.motif.PaneTextArea")) : class$com$ibm$db2$tools$common$plaf$motif$PaneTextArea, "images/arowbrupt.gif");
        imagesLoaded = true;
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        super.paint(graphics);
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n2 = dimension.width / 2;
        int n3 = dimension.height / 2;
        Color color = this.getBackground();
        Color color2 = ColorUtil.getScaledColor(color, 40);
        Color color3 = ColorUtil.getScaledColor(color, 20);
        int n4 = this.tbar.isViewButtonVisible() ? this.viewButton.getPreferredSize().width : 0;
        int n5 = PaneTextArea.insets.left + n4 + PaneTextArea.insets.right;
        boolean bl = false;
        if (dimension.width > n5 + 10) {
            bl = true;
        }
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(1, 0, 1, dimension.height - 1);
        graphics.setColor(color);
        graphics.drawLine(2, 1, 2, dimension.height - 2);
        if (bl) {
            graphics.setColor(color);
            graphics.fill3DRect(n2 - 1, 4, 2, dimension.height - 8, true);
        }
        Color color4 = ColorUtil.getScaledColor(color, -100);
        Color color5 = ColorUtil.getScaledColor(color, -50);
        graphics.setColor(color);
        graphics.drawLine(dimension.width - 3, 1, dimension.width - 3, dimension.height - 3);
        graphics.setColor(color5);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 1);
        graphics.setColor(color4);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        imagesLoaded = false;
    }

    class PopupHandler
    implements ActionListener,
    ItemListener {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        boolean title;

        PopupHandler(boolean bl) {
            this.title = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.title) {
                PaneTextArea.this.tbar.getPane().titleItemSelected(actionEvent.getSource(), actionEvent.getSource());
            } else {
                PaneTextArea.this.tbar.getPane().viewItemSelected(actionEvent.getSource(), actionEvent.getSource());
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.title) {
                PaneTextArea.this.tbar.getPane().titleItemSelected(itemEvent.getSource(), itemEvent.getItem());
            } else {
                PaneTextArea.this.tbar.getPane().viewItemSelected(itemEvent.getSource(), itemEvent.getItem());
            }
        }
    }

    class RedirectMouseEvent
    extends MouseEvent {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public RedirectMouseEvent(Component component, MouseEvent mouseEvent, int n2, int n3) {
            super(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }
    }

    class StateListener
    implements ChangeListener,
    PopupMenuListener {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        AbstractButton b;
        boolean pressed = false;
        boolean myCancel = false;

        StateListener(AbstractButton abstractButton) {
            this.b = abstractButton;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = this.b.getModel();
            this.pressed = buttonModel.isArmed() && buttonModel.isPressed();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.myCancel = this.pressed;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    protected class NoFocusToggle
    extends JToggleButton {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected NoFocusToggle() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void updateUI() {
            super.updateUI();
            super.setBorder(null);
        }
    }

    class TextLayout
    implements LayoutManager,
    Serializable {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        TextLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        private Dimension calculateSize() {
            int n2 = PaneTextArea.this.view.getFullPreferredSize().width;
            int n3 = PaneTextArea.this.title.getFullPreferredSize().width;
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = PaneTextArea.this.tbar.isViewButtonVisible() ? PaneTextArea.this.viewButton.getPreferredSize() : dimension;
            Dimension dimension3 = PaneTextArea.this.tbar.isTitleButtonVisible() ? PaneTextArea.this.titleButton.getPreferredSize() : dimension;
            int n4 = PaneTextArea.this.tbar.isLinkButtonVisible() ? PaneTextArea.this.linkButton.getPreferredSize().width : 0;
            int n5 = n4 + viewHgap + n3 + viewHgap + dimension3.width;
            int n6 = n2 + viewHgap + dimension2.width;
            int n7 = n5 > n6 ? n5 : n6;
            int n8 = PaneTextArea.insets.left + n7 + sepHgap + 2 + sepHgap + n7 + PaneTextArea.insets.right;
            int n9 = dimension2.height;
            if (PaneTextArea.this.sepHeight > n9) {
                n9 = PaneTextArea.this.sepHeight;
            }
            return new Dimension(n8, n9 += PaneTextArea.insets.top + PaneTextArea.insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize();
        }

        public void layoutContainer(Container container) {
            int n2;
            Dimension dimension;
            Dimension dimension2 = container.getSize();
            Dimension dimension3 = new Dimension(0, 0);
            Dimension dimension4 = PaneTextArea.this.tbar.isViewButtonVisible() ? PaneTextArea.this.viewButton.getPreferredSize() : dimension3;
            Dimension dimension5 = PaneTextArea.this.tbar.isLinkButtonVisible() ? PaneTextArea.this.linkButton.getPreferredSize() : dimension3;
            int n3 = dimension2.height / 2 - dimension5.height / 2;
            PaneTextArea.this.linkButton.setLocation(PaneTextArea.insets.left, n3);
            PaneTextArea.this.linkButton.setSize(PaneTextArea.this.linkButton.getPreferredSize());
            int n4 = dimension2.height / 2 - dimension4.height / 2;
            PaneTextArea.this.viewButton.setLocation(dimension2.width - dimension4.width - PaneTextArea.insets.right, n4);
            PaneTextArea.this.viewButton.setSize(dimension4);
            Dimension dimension6 = dimension = PaneTextArea.this.tbar.isTitleButtonVisible() ? PaneTextArea.this.titleButton.getPreferredSize() : dimension3;
            if (dimension4.height == 0) {
                n4 = dimension2.height / 2 - dimension.height / 2;
            }
            PaneTextArea.this.titleButton.setLocation(dimension2.width / 2 - viewHgap - dimension.width, n4);
            PaneTextArea.this.titleButton.setSize(dimension);
            int n5 = dimension2.width / 2;
            int n6 = dimension2.height / 2;
            int n7 = n5 - PaneTextArea.insets.left - sepHgap - viewHgap - dimension5.width - viewHgap - dimension.width;
            int n8 = n5 - sepHgap - viewHgap - dimension4.width - PaneTextArea.insets.right;
            if (n7 > 0) {
                n2 = PaneTextArea.insets.left + dimension5.width + viewHgap;
                PaneTextArea.this.title.setVisible(true);
                PaneTextArea.this.title.setSize(n7, dimension2.height);
                PaneTextArea.this.title.setLocation(n2, 0);
            } else {
                PaneTextArea.this.title.setVisible(false);
            }
            if (n8 > 0) {
                n2 = n5 + sepHgap + viewHgap / 2;
                PaneTextArea.this.view.setVisible(true);
                PaneTextArea.this.view.setSize(n8, dimension2.height);
                PaneTextArea.this.view.setLocation(n2, 0);
            } else {
                PaneTextArea.this.view.setVisible(false);
            }
        }
    }
}

