/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CustomButton;
import com.ibm.db2.tools.common.Workbook;
import com.ibm.db2.tools.common.WorkbookPage;
import com.ibm.db2.tools.common.plaf.WorkbookUI;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class MotifWorkbookUI
extends WorkbookUI
implements LayoutManager,
ChangeListener,
MouseListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int firstPage = 0;
    protected int lastPage = 0;
    protected int currentPage = 0;
    protected int tabHeight = 30;
    protected int tabWidth = 50;
    protected int shaftHeight = 8;
    protected int arrowWidth = 75;
    protected int tabGap = 0;
    protected int tpad = 12;
    protected int doplerShift = 3;
    protected int blendOverlap = 5;
    protected int leftGap = 2;
    protected Font captionFont = new Font("Helvetica", 1, 12);
    protected boolean drawBorder = true;
    protected boolean goprevVisible = false;
    protected CustomButton left;
    protected CustomButton right;
    protected CustomButton goprev;
    protected Workbook wb;
    protected WorkbookPage visiblePage;
    protected WorkbookPage prevPage = null;
    protected Insets borderInsets = new Insets(7, 5, 5, 5);
    protected Insets extInsets;
    protected boolean tabOverlap;
    protected boolean tabHighlight;
    protected int overlapWidth;
    protected boolean tabSwap;
    protected boolean dirty;
    protected ButtonHandler bh;
    protected int tabStart;
    boolean savedNested;
    protected Color dark1;
    protected Color dark2;
    protected Color dark3;
    protected Color bright1;
    protected Color bright2;
    protected Color bright3;

    public MotifWorkbookUI() {
        this.extInsets = new Insets(this.borderInsets.top + 10, this.borderInsets.left + 10, this.borderInsets.bottom + 10, this.borderInsets.right + 10);
        this.tabOverlap = false;
        this.tabHighlight = true;
        this.overlapWidth = 3;
        this.tabSwap = false;
        this.dirty = false;
        this.tabStart = this.borderInsets.left;
        this.savedNested = false;
        this.tabWidth = 40;
        this.tabGap = 0;
        this.tpad = 10;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifWorkbookUI();
    }

    public void installUI(JComponent jComponent) {
        Workbook workbook = (Workbook)jComponent;
        this.left = new CustomButton(3);
        this.right = new CustomButton(4);
        this.goprev = new CustomButton(5);
        this.goprev.setVisible(this.goprevVisible);
        workbook.addComponent(this.left);
        workbook.addComponent(this.right);
        workbook.addComponent(this.goprev);
        workbook.setLayout(this);
        workbook.addChangeListener(this);
        workbook.addMouseListener(this);
        this.bh = new ButtonHandler();
        this.left.addActionListener(this.bh);
        this.right.addActionListener(this.bh);
        this.wb = workbook;
        this.tabOverlap = true;
        this.visiblePage = workbook.getCurrentPage();
        this.prevPage = workbook.getPreviousPage();
        this.currentPage = workbook.getCurrentPageNumber();
        this.savedNested = workbook.isNested();
        this.captionFont = new Font("SansSerif", 1, 12);
    }

    public void pageRemoved(WorkbookPage workbookPage) {
        if (workbookPage == this.visiblePage) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, workbookPage, 2));
            Component component = this.visiblePage.getClient();
            if (component != null) {
                this.wb.removeComponent(component);
            }
            this.visiblePage = null;
        }
        this.wb.invalidate();
        this.wb.validate();
    }

    public void allPagesRemoved() {
        this.visiblePage = null;
        this.prevPage = null;
        this.currentPage = -1;
        this.wb.invalidate();
        this.wb.validate();
    }

    public void uninstallUI(JComponent jComponent) {
        this.wb.removeComponent(this.left);
        this.wb.removeComponent(this.right);
        this.wb.removeComponent(this.goprev);
        this.left.removeActionListener(this.bh);
        this.right.removeActionListener(this.bh);
        this.wb.setLayout(null);
        this.wb.removeChangeListener(this);
        this.wb.removeMouseListener(this);
    }

    public Color getSelectedTextColor() {
        return Color.blue.darker().darker();
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        return 0;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        return new Rectangle();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    Dimension calculateSize() {
        Component component;
        boolean bl = !this.wb.getTabsVisible();
        Component component2 = component = this.visiblePage != null ? this.visiblePage.getClient() : null;
        if (bl && component != null) {
            return component.getPreferredSize();
        }
        this.tabHeight = this.getTabHeight();
        int n2 = this.extInsets.top + this.tabHeight;
        Dimension dimension = component != null ? component.getSize() : new Dimension(0, 0);
        int n3 = this.extInsets.left + dimension.width + this.extInsets.right;
        int n4 = n2 + dimension.height + this.extInsets.bottom;
        return new Dimension(n3, n4);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize();
    }

    public void layoutContainer(Container container) {
        Component component;
        Workbook workbook = (Workbook)container;
        Dimension dimension = workbook.getSize();
        boolean bl = !workbook.getTabsVisible();
        boolean bl2 = false;
        Component component2 = this.prevPage != null ? this.prevPage.getClient() : null;
        Component component3 = component = this.visiblePage != null ? this.visiblePage.getClient() : null;
        if (component2 != null && component2.getParent() == null && component != null && SwingUtilities.findFocusOwner(component2) != null) {
            bl2 = true;
        }
        if (bl) {
            this.goprev.setVisible(false);
            this.left.setVisible(false);
            this.right.setVisible(false);
            if (this.visiblePage != null && component != null) {
                component.setLocation(0, 0);
                component.setSize(dimension.width, dimension.height);
                component.setVisible(true);
                component.validate();
                if (bl2) {
                    this.transferFocusTo(component);
                }
                return;
            }
        }
        this.tabHeight = this.getTabHeight();
        int n2 = this.extInsets.top + this.tabHeight;
        if (this.visiblePage != null && component != null) {
            component.setLocation(this.extInsets.left, n2);
            component.setSize(dimension.width - this.extInsets.left - this.extInsets.right, dimension.height - n2 - this.extInsets.bottom);
            component.setVisible(true);
            component.validate();
            if (bl2) {
                this.transferFocusTo(component);
            }
        }
        this.calculateArrowWidth();
        int n3 = dimension.width - this.borderInsets.right - this.arrowWidth;
        int n4 = this.borderInsets.top + this.tabHeight - this.shaftHeight / 2 - this.left.getPreferredSize().height;
        int n5 = n3;
        this.left.setLocation(n5, n4);
        this.left.setSize(this.left.getPreferredSize());
        this.right.setLocation(n5 += this.left.getPreferredSize().width + this.leftGap, n4);
        this.right.setSize(this.right.getPreferredSize());
        n5 += this.right.getPreferredSize().width + 10;
        if (this.goprevVisible) {
            this.goprev.setVisible(true);
            this.goprev.setLocation(n5, n4);
            this.goprev.setSize(this.goprev.getPreferredSize());
        }
    }

    protected void transferFocusTo(Component component) {
        boolean bl = true;
        if (component.isFocusTraversable()) {
            component.requestFocus();
            bl = false;
        } else if (component instanceof JComponent && ((JComponent)component).requestDefaultFocus()) {
            bl = false;
        }
        if (bl) {
            this.wb.requestFocus();
        }
    }

    protected void calculateArrowWidth() {
        this.arrowWidth = this.left.getPreferredSize().width + this.right.getPreferredSize().width + (this.goprev.isVisible() ? 10 + this.goprev.getPreferredSize().width : 0) + 10;
    }

    protected int getTabHeight() {
        Font font = this.captionFont;
        if (font == null) {
            return 30;
        }
        FontMetrics fontMetrics = ((Component)this.wb).getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        return 6 + n2 + 5;
    }

    protected void calculateColorShades(Color color) {
        this.dark1 = ColorUtil.getDarkerColor(color, 1);
        this.dark2 = ColorUtil.getDarkerColor(color, 2);
        this.dark3 = ColorUtil.getDarkerColor(color, 3);
        this.bright1 = ColorUtil.getBrighterColor(color, 1);
        this.bright2 = ColorUtil.getBrighterColor(color, 2);
        this.bright3 = ColorUtil.getBrighterColor(color, 3);
    }

    protected void paintBorders(Graphics graphics, int n2) {
        Dimension dimension = this.wb.getSize();
        Color color = this.wb.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n3 = this.extInsets.top + n2;
        Rectangle rectangle = this.getFrameRect(n2);
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        graphics.setColor(this.bright3);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n5 - 1);
        graphics.drawLine(rectangle.x, rectangle.y, n4 - 1, rectangle.y);
        graphics.setColor(this.bright2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, n5 - 2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, n4 - 2, rectangle.y + 1);
        graphics.setColor(this.bright1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 2, rectangle.x + 2, n5 - 3);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 2, n4 - 3, rectangle.y + 2);
        graphics.setColor(this.dark3);
        graphics.drawLine(n4 - 1, rectangle.y + 1, n4 - 1, n5 - 1);
        graphics.drawLine(rectangle.x + 1, n5 - 1, n4 - 1, n5 - 1);
        graphics.setColor(this.dark2);
        graphics.drawLine(n4 - 2, rectangle.y + 2, n4 - 2, n5 - 2);
        graphics.drawLine(rectangle.x + 2, n5 - 2, n4 - 2, n5 - 2);
        graphics.setColor(this.dark1);
        graphics.drawLine(n4 - 3, rectangle.y + 3, n4 - 3, n5 - 3);
        graphics.drawLine(rectangle.x + 3, n5 - 3, n4 - 3, n5 - 3);
        if (!this.wb.isNested() && this.drawBorder) {
            this.paintWorkbookBorder(graphics, color, dimension);
        }
    }

    protected void paintWorkbookBorder(Graphics graphics, Color color, Dimension dimension) {
        graphics.setColor(color.darker());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    protected Rectangle getFrameRect(int n2) {
        Dimension dimension = this.wb.getSize();
        int n3 = this.borderInsets.top + n2;
        return new Rectangle(this.borderInsets.left, n3, dimension.width - this.borderInsets.left - this.borderInsets.right, dimension.height - n3 - this.borderInsets.bottom);
    }

    protected void paintTabShaft(Graphics graphics, boolean bl) {
        this.tabHeight = this.getTabHeight();
        Rectangle rectangle = this.getFrameRect(this.tabHeight);
        int n2 = this.borderInsets.top + this.shaftHeight;
        int n3 = rectangle.width - this.arrowWidth;
        if (bl) {
            graphics.setColor(this.wb.getBackground());
            graphics.fillRect(this.borderInsets.left, this.borderInsets.top, n3, this.tabHeight);
        }
    }

    protected void paintTabs(Graphics graphics, Dimension dimension, boolean bl) {
        Font font = this.captionFont;
        graphics.setColor(Color.black);
        graphics.setFont(font);
        boolean bl2 = true;
        int n2 = this.tabStart;
        int n3 = dimension.width - this.borderInsets.right - this.arrowWidth;
        int n4 = 0;
        if (this.tabOverlap) {
            n2 += this.overlapWidth;
        }
        int n5 = this.firstPage;
        while (n5 < this.wb.getPageCount()) {
            WorkbookPage workbookPage = this.wb.getPageAt(n5);
            if (!this.paintOneTab(graphics, workbookPage, n2, this.borderInsets.top, n5, n3, bl, false)) {
                bl2 = false;
                break;
            }
            if (this.visiblePage == workbookPage) {
                n4 = n5;
            }
            this.lastPage = n5++;
            n2 += workbookPage.getTabBounds().width + this.tabGap;
        }
        if (this.tabOverlap && this.visiblePage != null) {
            n2 = this.visiblePage.getTabBounds().x - this.overlapWidth;
            this.paintOneTab(graphics, this.visiblePage, n2, this.borderInsets.top, n4, n3, bl, true);
        }
        this.right.setVisible(!bl2);
        this.left.setVisible(this.firstPage != 0);
    }

    protected boolean paintOneTab(Graphics graphics, WorkbookPage workbookPage, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        int n7;
        int n8;
        int n9;
        this.tabHeight = this.getTabHeight();
        Color color = this.wb.getBackground();
        Icon icon = workbookPage.getIcon();
        String string = workbookPage.getTitle();
        boolean bl3 = false;
        int n10 = n9 = n3 + this.tabHeight - 5;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n11 = n8 = string != null ? fontMetrics.stringWidth(string) : 0;
        if (icon != null) {
            n8 += icon.getIconWidth() + 5;
        }
        if (n8 < this.tabWidth) {
            n8 = this.tabWidth;
        }
        int n12 = this.tpad + n8 + this.tpad;
        if (bl2) {
            n12 += this.overlapWidth + this.overlapWidth;
        }
        if (n2 + n12 > n5 - this.tabGap) {
            return false;
        }
        if (n4 == this.currentPage) {
            bl3 = true;
            n10 -= this.doplerShift;
        }
        int n13 = 0;
        int n14 = this.tabHeight;
        if (!bl3) {
            n13 = this.doplerShift;
            n14 -= n13;
            if (bl) {
                graphics.setColor(color);
                graphics.fillRect(n2 - 1, n3 - 1, n12 + 2, n13 + 1);
                graphics.setColor(this.bright3);
                n7 = n3 + this.tabHeight;
                graphics.drawLine(n2, n7, n2 + n12, n7);
                graphics.setColor(this.bright2);
                graphics.drawLine(n2, n7 + 1, n2 + n12, n7 + 1);
                graphics.setColor(this.bright1);
                graphics.drawLine(n2, n7 + 2, n2 + n12, n7 + 2);
                if (n4 == this.firstPage) {
                    graphics.setColor(this.bright3);
                    graphics.drawLine(n2, n7, n2 + 5, n7);
                    graphics.drawLine(n2, n7, n2, n7 + 5);
                    graphics.setColor(this.bright2);
                    graphics.drawLine(n2 + 1, n7 + 1, n2 + 5, n7 + 1);
                    graphics.drawLine(n2 + 1, n7 + 1, n2 + 1, n7 + 5);
                    graphics.setColor(this.bright1);
                    graphics.drawLine(n2 + 2, n7 + 2, n2 + 5, n7 + 2);
                    graphics.drawLine(n2 + 2, n7 + 2, n2 + 2, n7 + 5);
                }
            }
        }
        graphics.setColor(color);
        n7 = bl3 ? this.doplerShift + 3 : 0;
        graphics.fillRect(n2, n3 + n13, n12, n14 + n7);
        int n15 = n2 + n12 - 1;
        int n16 = n3 + n13 - 1;
        int n17 = n16 + n14;
        Color color2 = this.bright3;
        Color color3 = this.bright2;
        Color color4 = this.bright1;
        Color color5 = this.dark3;
        Color color6 = this.dark2;
        Color color7 = this.dark1;
        if (this.tabHighlight && !bl3) {
            color2 = color3;
            color3 = color4;
            color5 = color6;
            color6 = color7;
        }
        graphics.setColor(color2);
        graphics.drawLine(n2, n16 + 2, n2, n17);
        graphics.drawLine(n2 + 2, n16, n15 - 2, n16);
        graphics.setColor(color3);
        graphics.drawLine(n2 + 1, n16 + 1, n2 + 1, n17);
        graphics.drawLine(n2 + 1, n16 + 2, n2 + 1, n17);
        graphics.drawLine(n2 + 2, n16 + 1, n15 - 2, n16 + 1);
        graphics.setColor(color4);
        graphics.drawLine(n2 + 2, n16 + 2, n2 + 2, n17);
        graphics.drawLine(n2 + 2, n16 + 2, n15 - 2, n16 + 2);
        graphics.setColor(color2);
        graphics.drawLine(n2, n16 + 2, n2 + 2, n16);
        graphics.setColor(color5);
        graphics.drawLine(n15, n16 + 2, n15, n17);
        graphics.drawLine(n15, n16 + 2, n15 - 1, n16 + 1);
        graphics.setColor(color6);
        if (!bl3) {
            graphics.drawLine(n15 - 1, n16 + 2, n15 - 1, n17);
        } else {
            graphics.drawLine(n15 - 1, n16 + 2, n15 - 1, n17 + 1);
        }
        graphics.setColor(color7);
        if (!bl3) {
            graphics.drawLine(n15 - 2, n16 + 3, n15 - 2, n17);
        } else {
            graphics.drawLine(n15 - 2, n16 + 3, n15 - 2, n17 + 2);
        }
        if (bl3) {
            graphics.setColor(color4);
            graphics.drawLine(n15 - 2, n17 + 3, n15, n17 + 3);
        }
        if (bl3) {
            if (n4 == this.firstPage) {
                n6 = n3 + n14;
                graphics.setColor(color2);
                graphics.drawLine(n2, n6, n2, n6 + 5);
                graphics.setColor(color3);
                graphics.drawLine(n2 + 1, n6, n2 + 1, n6 + 5);
                graphics.setColor(color4);
                graphics.drawLine(n2 + 2, n6, n2 + 2, n6 + 5);
            } else {
                n6 = n3 + n14;
                graphics.setColor(color2);
                graphics.drawLine(n2, n6, n2 + 1, n6);
                graphics.setColor(color3);
                graphics.drawLine(n2, n6 + 1, n2 + 2, n6 + 1);
                graphics.drawLine(n2 + 1, n6, n2 + 1, n6 + 1);
                graphics.setColor(color4);
                graphics.drawLine(n2, n6 + 2, n2 + 2, n6 + 2);
                graphics.drawLine(n2 + 2, n6, n2 + 2, n6 + 2);
            }
        }
        n6 = n2 + n12 / 2 - n8 / 2;
        if (icon != null) {
            int n18 = n3 + this.tabHeight / 2 - icon.getIconHeight() / 2;
            if (!bl3) {
                n18 += this.doplerShift;
            }
            icon.paintIcon(this.wb, graphics, n6, n18);
            n6 += 5 + icon.getIconWidth();
        }
        if (bl3) {
            graphics.setColor(this.getSelectedTextColor());
        } else {
            graphics.setColor(Color.black);
        }
        if (string != null) {
            if (this.wb.isEnabled() && workbookPage.isEnabled()) {
                graphics.drawString(string, n6, n10);
            } else {
                graphics.setColor(color.brighter());
                graphics.drawString(string, n6, n10);
                graphics.setColor(color.darker());
                graphics.drawString(string, n6 - 1, n10 - 1);
            }
        }
        workbookPage.setTabBounds(n2, n3, n12, this.tabHeight);
        return true;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.wb.getTabsVisible()) {
            return;
        }
        Dimension dimension = this.wb.getSize();
        this.tabHeight = this.getTabHeight();
        this.paintBorders(graphics, this.tabHeight);
        this.paintTabShaft(graphics, false);
        this.paintTabs(graphics, dimension, false);
    }

    protected void updateNested(boolean bl) {
        if (bl) {
            this.borderInsets.top = 7;
            this.borderInsets.left = 0;
            this.borderInsets.bottom = 0;
            this.borderInsets.right = 0;
        } else {
            this.borderInsets.top = 7;
            this.borderInsets.left = 5;
            this.borderInsets.bottom = 5;
            this.borderInsets.right = 5;
        }
        this.tabStart = this.borderInsets.left;
        this.extInsets.top = this.borderInsets.top + 10;
        this.extInsets.left = this.borderInsets.left + 10;
        this.extInsets.bottom = this.borderInsets.bottom + 10;
        this.extInsets.right = this.borderInsets.right + 10;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.prevPage = this.visiblePage;
        this.flipPages(this.visiblePage, this.wb.getCurrentPage());
        Component component = null;
        Dimension dimension = null;
        if (this.savedNested != this.wb.isNested()) {
            this.savedNested = this.wb.isNested();
            this.updateNested(this.savedNested);
        }
        if (this.visiblePage != null && (component = this.visiblePage.getClient()) != null) {
            dimension = component.getSize();
        }
        this.wb.doLayout();
        if (component != null) {
            Dimension dimension2 = component.getSize();
            if (dimension2.width != dimension.width || dimension2.height != dimension.height) {
                component.invalidate();
                component.validate();
            }
            component.repaint();
        }
        this.currentPage = this.wb.getSelectedIndex();
        if (this.tabSwap) {
            this.repaintTabRegion();
        } else {
            this.dirty = true;
            this.wb.repaint();
        }
    }

    protected void repaintTabRegion() {
        int n2 = this.getTabHeight();
        Dimension dimension = this.wb.getSize();
        int n3 = this.borderInsets.left;
        int n4 = this.borderInsets.top - this.doplerShift;
        int n5 = dimension.width - this.borderInsets.left - this.borderInsets.right;
        int n6 = n2 + 5;
        this.wb.repaint(0L, n3, n4, n5, n6);
        this.tabSwap = false;
    }

    public void flipPages(WorkbookPage workbookPage, WorkbookPage workbookPage2) {
        Component component;
        Component component2 = workbookPage != null ? workbookPage.getClient() : null;
        Component component3 = component = workbookPage2 != null ? workbookPage2.getClient() : null;
        if (workbookPage == workbookPage2 && component2 == component) {
            return;
        }
        if (component2 != null) {
            this.wb.removeComponent(component2);
        }
        if (component != null) {
            this.wb.addComponent(component);
        }
        this.visiblePage = workbookPage2;
        if (workbookPage != null) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, workbookPage, 2));
        }
        if (workbookPage2 != null) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, workbookPage2, 1));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.wb.getPageCount() == 0) {
            return;
        }
        int n2 = this.firstPage;
        while (n2 <= this.lastPage) {
            WorkbookPage workbookPage = this.wb.getPageAt(n2);
            Rectangle rectangle = workbookPage.getTabBounds();
            if (rectangle.contains(point)) {
                if (!this.wb.isEnabled() || !workbookPage.isEnabled()) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.visiblePage != workbookPage) {
                    this.tabSwap = true;
                    this.wb.showPage(workbookPage);
                    break;
                }
                this.wb.requestFocus();
                if (mouseEvent.getClickCount() != 2) break;
                this.wb.fireActionEvent(new ActionEvent(workbookPage, 1001, workbookPage.getTitle()));
                break;
            }
            ++n2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MotifWorkbookUI.this.right) {
                int n2 = MotifWorkbookUI.this.wb.getPageCount();
                if (MotifWorkbookUI.this.firstPage + 1 < n2) {
                    ++MotifWorkbookUI.this.firstPage;
                    if (MotifWorkbookUI.this.visiblePage != null && MotifWorkbookUI.this.wb.getCurrentPageNumber() >= MotifWorkbookUI.this.firstPage && MotifWorkbookUI.this.wb.getCurrentPageNumber() <= MotifWorkbookUI.this.lastPage) {
                        MotifWorkbookUI.this.wb.invalidate();
                        MotifWorkbookUI.this.wb.validate();
                        MotifWorkbookUI.this.wb.repaint();
                    } else {
                        WorkbookPage workbookPage = MotifWorkbookUI.this.wb.getPageAt(MotifWorkbookUI.this.firstPage);
                        MotifWorkbookUI.this.wb.showPage(workbookPage);
                    }
                }
            } else if (object == MotifWorkbookUI.this.left && MotifWorkbookUI.this.firstPage > 0) {
                --MotifWorkbookUI.this.firstPage;
                if (MotifWorkbookUI.this.visiblePage != null && MotifWorkbookUI.this.wb.getCurrentPageNumber() >= MotifWorkbookUI.this.firstPage && MotifWorkbookUI.this.wb.getCurrentPageNumber() <= MotifWorkbookUI.this.lastPage) {
                    MotifWorkbookUI.this.wb.invalidate();
                    MotifWorkbookUI.this.wb.validate();
                    MotifWorkbookUI.this.wb.repaint();
                } else {
                    WorkbookPage workbookPage = MotifWorkbookUI.this.wb.getPageAt(MotifWorkbookUI.this.firstPage);
                    MotifWorkbookUI.this.wb.showPage(workbookPage);
                }
            }
        }
    }
}

