/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CustomButton;
import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.plaf.PaneTitleBarUI;
import com.ibm.db2.tools.common.plaf.motif.PaneTextArea;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class MotifPaneTitleBarUI
extends PaneTitleBarUI
implements ActionListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int hgap = 5;
    protected int mingap = 2;
    protected int statusHeight = 30;
    protected Insets sinsets = new Insets(5, 5, 5, 5);
    protected AbstractButton maxButton;
    protected AbstractButton minButton;
    protected PaneTextArea textArea;
    protected boolean useDefaultFont = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifPaneTitleBarUI();
    }

    public void installUI(JComponent jComponent) {
        PaneTitleBar paneTitleBar = (PaneTitleBar)jComponent;
        this.maxButton = new CustomButton(7);
        this.maxButton.setActionCommand("MaximizeButton");
        this.maxButton.addActionListener(this);
        this.maxButton.setRequestFocusEnabled(false);
        ((CustomButton)this.maxButton).setFocusTraversable(false);
        this.minButton = new CustomButton();
        this.minButton.setActionCommand("MinimizeButton");
        this.minButton.addActionListener(this);
        this.minButton.setRequestFocusEnabled(false);
        ((CustomButton)this.minButton).setFocusTraversable(false);
        this.updateButtons(paneTitleBar);
        if (!this.useDefaultFont) {
            paneTitleBar.setTextFont(this.getTextFont());
        }
        this.textArea = this.createPaneTextArea(paneTitleBar);
        paneTitleBar.setLayout(new TitleLayout());
        paneTitleBar.add((Component)this.minButton, new Integer(20));
        paneTitleBar.add((Component)this.maxButton, new Integer(20));
        paneTitleBar.add((Component)this.textArea, new Integer(20));
        this.updateLink(paneTitleBar);
        this.updateTitle(paneTitleBar);
        this.updateView(paneTitleBar);
    }

    protected Font getTextFont() {
        return new Font("Dialog", 1, 11);
    }

    protected PaneTextArea createPaneTextArea(PaneTitleBar paneTitleBar) {
        return new PaneTextArea(paneTitleBar);
    }

    public void uninstallUI(JComponent jComponent) {
        PaneTitleBar paneTitleBar = (PaneTitleBar)jComponent;
        paneTitleBar.remove(this.minButton);
        paneTitleBar.remove(this.maxButton);
        paneTitleBar.remove(this.textArea);
        paneTitleBar.setLayout(null);
        this.maxButton = null;
        this.minButton = null;
        this.textArea = null;
    }

    public void updateTitle(PaneTitleBar paneTitleBar) {
        this.textArea.title.setText(paneTitleBar.getTitle());
        this.textArea.title.setIntendedIcon(paneTitleBar.getTitleIcon());
        this.textArea.title.setFont(paneTitleBar.getTextFont());
        this.textArea.invalidate();
        this.textArea.validate();
        paneTitleBar.invalidate();
        paneTitleBar.validate();
    }

    public void updateLink(PaneTitleBar paneTitleBar) {
        this.textArea.updateLink();
    }

    public void updateView(PaneTitleBar paneTitleBar) {
        this.textArea.view.setText(paneTitleBar.getViewName());
        this.textArea.view.setIntendedIcon(paneTitleBar.getViewIcon());
        this.textArea.view.setFont(paneTitleBar.getTextFont());
        this.textArea.invalidate();
        this.textArea.validate();
        paneTitleBar.invalidate();
        paneTitleBar.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        PaneTitleBar paneTitleBar = this.textArea.tbar;
        if (object == this.maxButton) {
            paneTitleBar.fireActionEvent(new ActionEvent(paneTitleBar.getPane(), 1001, this.maxButton.getActionCommand()));
        } else if (object == this.minButton) {
            paneTitleBar.fireActionEvent(new ActionEvent(paneTitleBar.getPane(), 1001, this.minButton.getActionCommand()));
        }
    }

    public void updateButtons(PaneTitleBar paneTitleBar) {
        ((CustomButton)this.minButton).setShape(paneTitleBar.isMinimizeButtonVertical() ? (paneTitleBar.isMinimizeButtonActive() ? 10 : 9) : (paneTitleBar.isMinimizeButtonActive() ? 12 : 11));
        ((CustomButton)this.maxButton).setShape(paneTitleBar.isMaximizeButtonActive() ? 6 : 7);
        ((CustomButton)this.maxButton).setVisible(paneTitleBar.isMaximizeButtonVisible());
        ((CustomButton)this.minButton).setVisible(paneTitleBar.isMinimizeButtonVisible());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        PaneTitleBar paneTitleBar = (PaneTitleBar)jComponent;
        Dimension dimension = paneTitleBar.getSize();
        Color color = paneTitleBar.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Color color2 = ColorUtil.getScaledColor(color, 20);
        Color color3 = ColorUtil.getScaledColor(color, -20);
        Color color4 = ColorUtil.getScaledColor(color, -40);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.setColor(color3);
        graphics.fillRect(0, dimension.height - 2, dimension.width, 1);
        graphics.setColor(color4);
        graphics.fillRect(0, dimension.height - 1, dimension.width, 1);
    }

    protected class TitleLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            PaneTitleBar paneTitleBar = (PaneTitleBar)container;
            Dimension dimension = new Dimension();
            Dimension dimension2 = MotifPaneTitleBarUI.this.maxButton.getPreferredSize();
            Dimension dimension3 = paneTitleBar.isMinimizeButtonVisible() ? MotifPaneTitleBarUI.this.minButton.getPreferredSize() : new Dimension(0, 0);
            Dimension dimension4 = MotifPaneTitleBarUI.this.textArea.getPreferredSize();
            dimension.width = MotifPaneTitleBarUI.this.sinsets.left + dimension3.width + MotifPaneTitleBarUI.this.hgap + dimension4.width + MotifPaneTitleBarUI.this.hgap + dimension2.width + MotifPaneTitleBarUI.this.sinsets.right;
            dimension.height = MotifPaneTitleBarUI.this.sinsets.top + dimension2.height + MotifPaneTitleBarUI.this.sinsets.bottom;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = MotifPaneTitleBarUI.this.minButton.getPreferredSize();
            return new Dimension(MotifPaneTitleBarUI.this.mingap + dimension.width + MotifPaneTitleBarUI.this.mingap, MotifPaneTitleBarUI.this.sinsets.top + dimension.height + MotifPaneTitleBarUI.this.sinsets.right);
        }

        public void layoutContainer(Container container) {
            PaneTitleBar paneTitleBar = (PaneTitleBar)container;
            Dimension dimension = paneTitleBar.getSize();
            if (dimension.width == 0) {
                return;
            }
            boolean bl = paneTitleBar.isNarrow();
            Dimension dimension2 = MotifPaneTitleBarUI.this.maxButton.getPreferredSize();
            if (bl) {
                MotifPaneTitleBarUI.this.maxButton.setVisible(false);
                MotifPaneTitleBarUI.this.textArea.setVisible(false);
            } else {
                if (paneTitleBar.isMaximizeButtonVisible()) {
                    MotifPaneTitleBarUI.this.maxButton.setVisible(true);
                    MotifPaneTitleBarUI.this.maxButton.setLocation(dimension.width - dimension2.width - MotifPaneTitleBarUI.this.sinsets.right, MotifPaneTitleBarUI.this.sinsets.top);
                    MotifPaneTitleBarUI.this.maxButton.setSize(dimension2);
                } else {
                    MotifPaneTitleBarUI.this.maxButton.setVisible(false);
                }
                MotifPaneTitleBarUI.this.textArea.setVisible(true);
            }
            Dimension dimension3 = MotifPaneTitleBarUI.this.minButton.getPreferredSize();
            if (paneTitleBar.isMinimizeButtonVisible()) {
                MotifPaneTitleBarUI.this.minButton.setLocation(bl ? dimension.width / 2 - dimension3.width / 2 : MotifPaneTitleBarUI.this.sinsets.left, dimension.height / 2 - dimension3.height / 2);
                MotifPaneTitleBarUI.this.minButton.setSize(dimension3);
            } else {
                MotifPaneTitleBarUI.this.minButton.setVisible(false);
                dimension3 = new Dimension(0, 0);
            }
            if (bl) {
                return;
            }
            Dimension dimension4 = MotifPaneTitleBarUI.this.textArea.getPreferredSize();
            int n2 = dimension4.width;
            int n3 = dimension.width - MotifPaneTitleBarUI.this.sinsets.left - dimension3.width - MotifPaneTitleBarUI.this.hgap - MotifPaneTitleBarUI.this.hgap - dimension2.width - MotifPaneTitleBarUI.this.sinsets.right;
            if (n2 > n3) {
                n2 = n3;
            }
            int n4 = dimension4.height;
            int n5 = dimension.width / 2 - n2 / 2;
            MotifPaneTitleBarUI.this.textArea.setLocation(n5, 0);
            MotifPaneTitleBarUI.this.textArea.setSize(n2, dimension.height);
        }
    }
}

