/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.MinorTab;
import com.ibm.db2.tools.common.Workbook;
import com.ibm.db2.tools.common.WorkbookPage;
import com.ibm.db2.tools.common.plaf.WorkbookUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class MotifMinorWorkbookUI
extends WorkbookUI
implements LayoutManager,
ChangeListener,
ItemListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JPanel tabPanel;
    protected ButtonGroup bgr;
    protected WorkbookPage prevPage = null;
    protected WorkbookPage visiblePage = null;
    protected Workbook wb;
    protected MinorTab currentTab = null;
    boolean savedNested = false;
    boolean dontShow = false;
    int cnt = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifMinorWorkbookUI();
    }

    public void installUI(JComponent jComponent) {
        this.wb = (Workbook)jComponent;
        this.savedNested = this.wb.isNested();
        this.bgr = new ButtonGroup();
        this.wb.setLayout(this);
        this.wb.addChangeListener(this);
        this.tabPanel = new JPanel();
        this.tabPanel.setLayout(new FlowLayout(0, 5, 0));
        this.tabPanel.setOpaque(false);
        this.wb.addComponent(this.tabPanel);
        this.updateTabBorder(this.savedNested);
        this.prevPage = this.wb.getPreviousPage();
        this.visiblePage = this.wb.getCurrentPage();
        SwingUtilities.invokeLater(new Runnable(){

            public synchronized void run() {
                MotifMinorWorkbookUI.this.secondInstallPhase();
            }
        });
    }

    protected void secondInstallPhase() {
        this.createTabs();
        SwingUtilities.invokeLater(new Runnable(){

            public synchronized void run() {
                MotifMinorWorkbookUI.this.wb.invalidate();
                MotifMinorWorkbookUI.this.wb.validate();
            }
        });
    }

    public void uninstallUI(JComponent jComponent) {
        Workbook workbook = (Workbook)jComponent;
        this.destroyTabs();
        workbook.removeComponent(this.tabPanel);
        this.tabPanel = null;
        this.bgr = null;
        workbook.removeChangeListener(this);
        workbook.setLayout(null);
    }

    public Color getSelectedTextColor() {
        return Color.blue.darker().darker();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        return 0;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        return new Rectangle();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    Dimension calculateSize() {
        Component component;
        boolean bl = !this.wb.getTabsVisible();
        Component component2 = component = this.visiblePage != null ? this.visiblePage.getClient() : null;
        if (bl && component != null) {
            return component.getPreferredSize();
        }
        Dimension dimension = component != null ? component.getSize() : new Dimension(0, 0);
        int n2 = dimension.width;
        int n3 = dimension.height + this.tabPanel.getPreferredSize().height;
        return new Dimension(n2, n3);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize();
    }

    public void layoutContainer(Container container) {
        Component component;
        Workbook workbook = (Workbook)container;
        Dimension dimension = workbook.getSize();
        boolean bl = !workbook.getTabsVisible();
        boolean bl2 = false;
        Component component2 = this.prevPage != null ? this.prevPage.getClient() : null;
        Component component3 = component = this.visiblePage != null ? this.visiblePage.getClient() : null;
        if (component2 != null && component2.getParent() == null && component != null && SwingUtilities.findFocusOwner(component2) != null) {
            bl2 = true;
        }
        if (bl && this.visiblePage != null && component != null) {
            component.setLocation(0, 0);
            component.setSize(dimension.width, dimension.height);
            component.setVisible(true);
            component.validate();
            if (bl2) {
                this.transferFocusTo(component);
            }
            return;
        }
        Dimension dimension2 = this.tabPanel.getPreferredSize();
        this.tabPanel.setLocation(0, 0);
        this.tabPanel.setSize(dimension.width, dimension2.height);
        if (this.visiblePage != null && component != null) {
            component.setLocation(0, dimension2.height);
            component.setSize(dimension.width, dimension.height - dimension2.height);
            component.setVisible(true);
            component.validate();
            if (bl2) {
                this.transferFocusTo(component);
            }
        }
    }

    protected void transferFocusTo(Component component) {
        boolean bl = true;
        if (component.isFocusTraversable()) {
            component.requestFocus();
            bl = false;
        } else if (component instanceof JComponent && ((JComponent)component).requestDefaultFocus()) {
            bl = false;
        }
        if (bl) {
            this.wb.requestFocus();
        }
    }

    protected void updateTabBorder(boolean bl) {
        if (bl) {
            this.tabPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        } else {
            this.tabPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.prevPage = this.visiblePage;
        this.flipPages(this.visiblePage, this.wb.getCurrentPage());
        Component component = null;
        Dimension dimension = null;
        if (this.savedNested != this.wb.isNested()) {
            this.savedNested = this.wb.isNested();
            this.updateTabBorder(this.savedNested);
        }
        if (this.visiblePage != null) {
            component = this.visiblePage.getClient();
            if (component != null) {
                dimension = component.getSize();
            }
            if (this.currentTab == null || this.visiblePage != this.currentTab.getUserData()) {
                this.currentTab = this.findTabFor(this.visiblePage);
                if (this.currentTab != null) {
                    this.dontShow = true;
                    this.currentTab.setSelected(true);
                    this.dontShow = false;
                }
            }
        }
        this.wb.doLayout();
        this.wb.repaint();
    }

    public void flipPages(WorkbookPage workbookPage, WorkbookPage workbookPage2) {
        Component component;
        Component component2 = workbookPage != null ? workbookPage.getClient() : null;
        Component component3 = component = workbookPage2 != null ? workbookPage2.getClient() : null;
        if (workbookPage == workbookPage2 && component2 == component) {
            return;
        }
        if (component2 != null) {
            this.wb.removeComponent(component2);
        }
        if (component != null) {
            this.wb.addComponent(component);
        }
        this.visiblePage = workbookPage2;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MinorTab minorTab;
        Object object;
        if (this.dontShow) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            object = itemEvent.getSource();
            minorTab = (MinorTab)object;
            this.wb.showPage((WorkbookPage)minorTab.getUserData());
            minorTab.setForeground(this.getSelectedTextColor());
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, minorTab.getUserData(), 1));
        }
        if (itemEvent.getStateChange() == 2) {
            object = itemEvent.getSource();
            minorTab = (MinorTab)object;
            minorTab.setForeground(Color.black);
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, minorTab.getUserData(), 2));
        }
    }

    public void pageAdded(WorkbookPage workbookPage) {
        MinorTab minorTab = this.createTabFor(workbookPage);
        ++this.cnt;
        if (this.cnt == 1) {
            minorTab.setSelected(true);
        }
        this.visiblePage = this.wb.getCurrentPage();
        this.prevPage = this.wb.getPreviousPage();
        this.currentTab = this.findTabFor(this.visiblePage);
        this.dontShow = true;
        this.currentTab.setSelected(true);
        this.dontShow = false;
    }

    public void pageRemoved(WorkbookPage workbookPage) {
        MinorTab minorTab = this.findTabFor(workbookPage);
        if (minorTab != null) {
            minorTab.removeItemListener(this);
            this.tabPanel.remove(minorTab);
            this.bgr.remove(minorTab);
        }
        if (this.wb.getPageCount() == 0 && this.visiblePage != null && this.visiblePage.getClient() != null) {
            this.wb.removeComponent(this.visiblePage.getClient());
        }
        --this.cnt;
        this.visiblePage = this.wb.getCurrentPage();
        this.prevPage = this.wb.getPreviousPage();
        this.currentTab = this.findTabFor(this.visiblePage);
        this.dontShow = true;
        this.currentTab.setSelected(true);
        this.dontShow = false;
        this.wb.invalidate();
        this.wb.validate();
    }

    protected MinorTab findTabFor(WorkbookPage workbookPage) {
        int n2 = 0;
        while (n2 < this.tabPanel.getComponentCount()) {
            MinorTab minorTab = (MinorTab)this.tabPanel.getComponent(n2);
            if (minorTab.getUserData() == workbookPage) {
                return minorTab;
            }
            ++n2;
        }
        return null;
    }

    public void tabModified(WorkbookPage workbookPage) {
        MinorTab minorTab = this.findTabFor(workbookPage);
        minorTab.setText(workbookPage.getTitle());
        minorTab.setIcon(workbookPage.getIcon());
        minorTab.setEnabled(workbookPage.isEnabled());
        minorTab.invalidate();
        this.tabPanel.invalidate();
        this.tabPanel.validate();
    }

    protected void createTabs() {
        int n2 = 0;
        while (n2 < this.wb.getPageCount()) {
            WorkbookPage workbookPage = this.wb.getPageAt(n2);
            MinorTab minorTab = this.createTabFor(workbookPage);
            if (n2 == this.wb.getCurrentPageNumber()) {
                this.dontShow = true;
                minorTab.setSelected(true);
                this.currentTab = minorTab;
                this.dontShow = false;
            }
            ++n2;
        }
    }

    protected void destroyTabs() {
        int n2 = 0;
        while (n2 < this.tabPanel.getComponentCount()) {
            MinorTab minorTab = (MinorTab)this.tabPanel.getComponent(n2);
            minorTab.removeItemListener(this);
            this.bgr.remove(minorTab);
            ++n2;
        }
        this.tabPanel.removeAll();
    }

    protected MinorTab createTabFor(WorkbookPage workbookPage) {
        MinorTab minorTab = this.findTabFor(workbookPage);
        if (minorTab != null) {
            return minorTab;
        }
        minorTab = new MinorTab(workbookPage.getTitle(), workbookPage.getIcon());
        minorTab.setEnabled(workbookPage.isEnabled());
        minorTab.setUserData(workbookPage);
        minorTab.addItemListener(this);
        this.tabPanel.add(minorTab);
        this.bgr.add(minorTab);
        return minorTab;
    }
}

