/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.MinorTab;
import com.ibm.db2.tools.common.plaf.MinorTabUI;
import com.ibm.db2.tools.common.support.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class MotifMinorTabUI
extends MinorTabUI {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static MinorTabUI minorTabUI;
    protected static Insets insets;
    protected static AbstractBorder border;
    protected static Font minorTabFont;

    public MotifMinorTabUI() {
        border = new EmptyBorder(insets);
        minorTabFont = new Font("Helvetica", 1, 11);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (minorTabUI == null || !(minorTabUI instanceof MotifMinorTabUI)) {
            minorTabUI = new MotifMinorTabUI();
        }
        return minorTabUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        abstractButton.setBorder(border);
        abstractButton.setBorderPainted(false);
        abstractButton.setFocusPainted(false);
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setOpaque(false);
        if (minorTabFont != null) {
            abstractButton.setFont(minorTabFont);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent.getBorder() == border) {
            jComponent.setBorder(null);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        MinorTab minorTab = (MinorTab)jComponent;
        this.paintMinorTabBorder(graphics, minorTab);
        super.paint(graphics, jComponent);
    }

    protected void paintMinorTabBorder(Graphics graphics, MinorTab minorTab) {
        ButtonModel buttonModel = minorTab.getModel();
        Dimension dimension = minorTab.getSize();
        boolean bl = buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected();
        Color color = minorTab.getBackground();
        Color color2 = ColorUtil.getBrighterColor(color, 1);
        Color color3 = ColorUtil.getBrighterColor(color, 3);
        Color color4 = ColorUtil.getDarkerColor(color, 1);
        Color color5 = ColorUtil.getDarkerColor(color, 3);
        graphics.setColor(!bl ? color3 : color5);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 2);
        graphics.setColor(!bl ? color2 : color4);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 3);
        graphics.setColor(bl ? color3 : color5);
        graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.setColor(bl ? color2 : color4);
        graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
    }

    static {
        insets = new Insets(5, 6, 5, 6);
        border = null;
        minorTabFont = null;
    }
}

