/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CellLayout;
import com.ibm.db2.tools.common.FrameStatusLine;
import com.ibm.db2.tools.common.StatusButton;
import com.ibm.db2.tools.common.StatusComboBox;
import com.ibm.db2.tools.common.TaskIndicator;
import com.ibm.db2.tools.common.plaf.FrameStatusLineUI;
import com.ibm.db2.tools.common.plaf.motif.MotifStatusBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class MotifFrameStatusLineUI
extends FrameStatusLineUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    MessageComboBox messageSegment;
    StatusButton imageSegment;
    TaskIndicator taskSegment;
    Border imageBorder;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifFrameStatusLineUI();
    }

    public void installUI(JComponent jComponent) {
        FrameStatusLine frameStatusLine = (FrameStatusLine)jComponent;
        CellLayout cellLayout = new CellLayout(frameStatusLine);
        this.messageSegment = new MessageComboBox(frameStatusLine);
        this.imageSegment = new StatusButton();
        MotifStatusBorder motifStatusBorder = new MotifStatusBorder();
        frameStatusLine.removeAll();
        this.imageSegment.setVerticalAlignment(0);
        this.imageSegment.setHorizontalAlignment(0);
        this.imageSegment.setEnabled(false);
        this.imageSegment.addActionListener(new StatusListener(frameStatusLine));
        this.imageBorder = this.imageSegment.getBorder();
        this.taskSegment = new TaskIndicator();
        this.taskSegment.setPreferredSize(new Dimension(100, 18));
        this.taskSegment.setBorder(new CompoundBorder(motifStatusBorder, new EmptyBorder(2, 2, 2, 2)));
        cellLayout.setFill(3);
        cellLayout.setWeight(0, 1);
        cellLayout.addToCell(this.imageSegment, 0, 0);
        cellLayout.addToCell(this.taskSegment, 1, 0);
        cellLayout.setWeight(1, 1);
        cellLayout.setFill(1);
        cellLayout.addToCell(this.messageSegment, 2, 0);
        Vector vector = frameStatusLine.getUserComponents();
        cellLayout.setWeight(0, 1);
        cellLayout.setFill(1);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                int n3 = 3 + n2;
                cellLayout.addToCell((Component)vector.elementAt(n2), n3, 0);
                ++n2;
            }
        }
    }

    public void updateMessage(FrameStatusLine frameStatusLine) {
        this.messageSegment.setText(frameStatusLine.getMessage());
    }

    public void updateIcon(FrameStatusLine frameStatusLine) {
        this.imageSegment.setIcon(frameStatusLine.getStatusIcon());
        this.imageSegment.setDisabledIcon(frameStatusLine.getStatusIcon());
    }

    public void updateCancel(FrameStatusLine frameStatusLine) {
        this.imageSegment.setEnabled(frameStatusLine.isCancelEnabled() && !frameStatusLine.isCanceled());
        String string = (String)frameStatusLine.getClientProperty("TipCancelTask");
        if (this.imageSegment.isEnabled()) {
            this.imageSegment.setToolTipText(string);
        } else {
            this.imageSegment.setToolTipText(null);
        }
        frameStatusLine.setStatusIcon(frameStatusLine.isCancelEnabled() ? FrameStatusLine.stopIcon : FrameStatusLine.okIcon);
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public TaskIndicator getTaskIndicator() {
        return this.taskSegment;
    }

    class StatusListener
    implements ActionListener {
        FrameStatusLine status;

        public StatusListener(FrameStatusLine frameStatusLine) {
            this.status = frameStatusLine;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.status.setCanceled(true);
        }
    }

    class MessageComboBox
    extends StatusComboBox {
        int capacity = 10;
        String blank = "  ";
        FrameStatusLine status;

        public MessageComboBox(FrameStatusLine frameStatusLine) {
            this.status = frameStatusLine;
            this.addItem(this.blank);
        }

        public void setText(String string) {
            if (!this.status.isMessageHistoryEnabled()) {
                if (this.getItemCount() > 1) {
                    this.removeAllItems();
                    this.addItem(this.blank);
                }
                super.setDirectTextEnabled(true);
                super.setDirectText(string);
            } else {
                super.setDirectTextEnabled(false);
                if (string.length() == 0) {
                    this.setSelectedIndex(0);
                } else {
                    int n2 = this.getItemCount();
                    if (n2 >= this.capacity) {
                        this.removeItemAt(1);
                    }
                    this.addItem(string);
                    this.setSelectedIndex(this.getItemCount() - 1);
                }
            }
            this.repaint();
            this.status.repaint();
        }
    }

    protected class NoTraversableButton
    extends JButton {
        protected NoTraversableButton() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

