/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.ComponentSplitter;
import com.ibm.db2.tools.common.SplitterLayout;
import com.ibm.db2.tools.common.TiledComponent;
import com.ibm.db2.tools.common.plaf.ComponentSplitterUI;
import com.ibm.db2.tools.common.plaf.motif.MotifPaneBorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class MotifComponentSplitterUI
extends ComponentSplitterUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ComponentSplitter splitter;
    protected MotifPaneBorder border;
    protected Border eborder;
    Component splitbar = null;
    Point loc = null;
    SplitHit hit = new SplitHit();
    protected MouseMonitor mmon;

    public MotifComponentSplitterUI() {
        this.border = new MotifPaneBorder();
        this.eborder = new EmptyBorder(4, 4, 4, 4);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifComponentSplitterUI();
    }

    public void installUI(JComponent jComponent) {
        ComponentSplitter componentSplitter;
        this.splitter = componentSplitter = (ComponentSplitter)jComponent;
        componentSplitter.setLayout(new SplitterLayout());
        this.mmon = new MouseMonitor(componentSplitter);
        componentSplitter.addMouseListener(this.mmon);
        componentSplitter.addMouseMotionListener(this.mmon);
        componentSplitter.setSplitBarHighlightColor(Color.red.darker().darker());
        componentSplitter.setSplitBarSize(8);
        componentSplitter.setBorder(componentSplitter.isBorderPainted() ? this.eborder : null);
        if (componentSplitter.getRoot() != null) {
            this.installFocusListeners(componentSplitter, componentSplitter.getRoot(), true);
        }
    }

    public void borderUpdated() {
        if (this.splitter.isBorderPainted()) {
            this.splitter.setBorder(this.eborder);
        } else {
            this.splitter.setBorder(null);
        }
        this.splitter.invalidate();
        this.splitter.validate();
        this.splitter.repaint();
    }

    public void componentAdded(ComponentSplitter componentSplitter, TiledComponent tiledComponent) {
        this.installFocusListeners(componentSplitter, tiledComponent, true);
    }

    public void componentRemoved(ComponentSplitter componentSplitter, TiledComponent tiledComponent) {
        this.installFocusListeners(componentSplitter, tiledComponent, false);
    }

    protected void installFocusListeners(ComponentSplitter componentSplitter, TiledComponent tiledComponent, boolean bl) {
        block2: {
            block1: {
                Component component;
                block3: {
                    if (tiledComponent.getType() != 3) break block1;
                    component = tiledComponent.getComponent();
                    if (component == null) break block2;
                    if (!bl) break block3;
                    FocusMonitor focusMonitor = new FocusMonitor(componentSplitter, component);
                    focusMonitor.startFocusMonitoring(component);
                    tiledComponent.setFocusMonitor(focusMonitor);
                    break block2;
                }
                FocusMonitor focusMonitor = (FocusMonitor)tiledComponent.getFocusMonitor();
                if (focusMonitor == null) break block2;
                focusMonitor.stopFocusMonitoring(component);
                break block2;
            }
            int n2 = 0;
            while (n2 < tiledComponent.getChildCount()) {
                this.installFocusListeners(componentSplitter, tiledComponent.getChildAt(n2), bl);
                ++n2;
            }
        }
    }

    public Insets getInsets() {
        return this.splitter.isBorderPainted() ? new Insets(4, 4, 4, 4) : new Insets(0, 0, 0, 0);
    }

    public void uninstallUI(JComponent jComponent) {
        ComponentSplitter componentSplitter = (ComponentSplitter)jComponent;
        componentSplitter.removeMouseListener(this.mmon);
        componentSplitter.removeMouseMotionListener(this.mmon);
        if (componentSplitter.getBorder() == this.border) {
            componentSplitter.setBorder(null);
        }
        this.border = null;
        this.eborder = null;
        componentSplitter.setLayout(null);
        if (componentSplitter.getRoot() != null) {
            this.installFocusListeners(componentSplitter, componentSplitter.getRoot(), false);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        ComponentSplitter componentSplitter = (ComponentSplitter)jComponent;
        TiledComponent tiledComponent = componentSplitter.getRoot();
        Rectangle rectangle = jComponent.getBounds();
        if (componentSplitter.getComponentCount() == 0) {
            return;
        }
        boolean bl2 = bl = componentSplitter.getMaximizedComponent() != null;
        if (bl && componentSplitter.isFocusIndicationEnabled()) {
            graphics.setColor(componentSplitter.getFocusIndicationColor());
        } else {
            graphics.setColor(jComponent.getBackground());
        }
        if (componentSplitter.isBorderPainted()) {
            this.border.setFlat(bl && componentSplitter.isFocusIndicationEnabled());
            this.border.paintBorder(jComponent, graphics, 0, 0, rectangle.width, rectangle.height);
            this.border.setFlat(false);
        }
        if (!bl) {
            TiledComponent tiledComponent2 = null;
            if (tiledComponent.getType() == 3) {
                this.paintComponentBorder(componentSplitter, tiledComponent, graphics);
                if (tiledComponent.getComponent() == componentSplitter.getSelectedComponent() && tiledComponent.isVisible()) {
                    tiledComponent2 = tiledComponent;
                }
            } else {
                tiledComponent2 = this.paintSplitArea(componentSplitter, graphics, jComponent.getBackground(), tiledComponent);
            }
            if (tiledComponent2 != null && tiledComponent2.isFocusPainted()) {
                this.paintFocusPane(componentSplitter, tiledComponent2, graphics);
            }
        }
    }

    TiledComponent paintSplitArea(ComponentSplitter componentSplitter, Graphics graphics, Color color, TiledComponent tiledComponent) {
        int n2 = tiledComponent.getChildCount();
        TiledComponent tiledComponent2 = null;
        int n3 = 0;
        while (n3 < n2) {
            TiledComponent tiledComponent3 = tiledComponent.getChildAt(n3);
            if (tiledComponent3.isVisible()) {
                Rectangle rectangle = new Rectangle(tiledComponent3.getSplitbarBounds());
                if (n3 < n2 - 1) {
                    boolean bl;
                    boolean bl2 = bl = tiledComponent.getType() == 2;
                    if (bl) {
                        rectangle.width /= 2;
                        rectangle.height += 2;
                        --rectangle.y;
                    } else {
                        rectangle.height /= 2;
                        rectangle.width += 2;
                        --rectangle.x;
                    }
                    this.paintSplitBar(rectangle, graphics, color, bl);
                }
                if (tiledComponent3.getType() != 3) {
                    TiledComponent tiledComponent4 = this.paintSplitArea(componentSplitter, graphics, color, tiledComponent3);
                    if (tiledComponent4 != null) {
                        tiledComponent2 = tiledComponent4;
                    }
                } else {
                    this.paintComponentBorder(componentSplitter, tiledComponent3, graphics);
                    if (tiledComponent3.getComponent() == componentSplitter.getSelectedComponent()) {
                        tiledComponent2 = tiledComponent3;
                    }
                }
            }
            ++n3;
        }
        return tiledComponent2;
    }

    protected void paintSplitBar(Rectangle rectangle, Graphics graphics, Color color, boolean bl) {
        MotifPaneBorder.paintBorderSeparator(graphics, color, rectangle, bl);
        if (bl) {
            rectangle.x += rectangle.width;
        } else {
            rectangle.y += rectangle.height;
        }
        MotifPaneBorder.paintBorderSeparator(graphics, color, rectangle, bl);
    }

    protected void paintComponentBorder(ComponentSplitter componentSplitter, TiledComponent tiledComponent, Graphics graphics) {
    }

    protected void paintFocusPane(ComponentSplitter componentSplitter, TiledComponent tiledComponent, Graphics graphics) {
        Rectangle rectangle = new Rectangle(tiledComponent.getBounds());
        graphics.setColor(componentSplitter.getFocusIndicationColor());
        rectangle.x -= 4;
        rectangle.y -= 4;
        rectangle.width += 8;
        rectangle.height += 8;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2 + n2 + 1;
            graphics.drawRect(rectangle.x + n2, rectangle.y + n2, rectangle.width - n3, rectangle.height - n3);
            ++n2;
        }
    }

    protected void makeSplitBarNarrower(boolean bl, Rectangle rectangle) {
        if (bl) {
            ++rectangle.x;
            --rectangle.y;
            rectangle.width -= 2;
            rectangle.height += 2;
        } else {
            --rectangle.x;
            ++rectangle.y;
            rectangle.height -= 2;
            rectangle.width += 2;
        }
    }

    void updateLayout() {
        Point point = this.splitbar.getLocation();
        Rectangle rectangle = this.hit.r1;
        Rectangle rectangle2 = this.hit.r2;
        int n2 = this.hit.p1.getSplitRatio();
        int n3 = this.hit.p2.getSplitRatio();
        int n4 = n2 + n3;
        if (((SplitBar)((Object)this.splitbar)).getType() == 2) {
            int n5 = rectangle.width + rectangle2.width;
            int n6 = point.x - this.loc.x;
            int n7 = rectangle.width + n6;
            n2 = n7 * n4 / n5;
            n3 = n4 - n2;
        } else {
            int n8 = rectangle.height + rectangle2.height;
            int n9 = point.y - this.loc.y;
            int n10 = rectangle.height + n9;
            n2 = n10 * n4 / n8;
            n3 = n4 - n2;
        }
        this.hit.p1.setSplitRatio(n2);
        this.hit.p2.setSplitRatio(n3);
    }

    class HeavySplitBar
    extends Canvas
    implements SplitBar,
    MouseListener,
    MouseMotionListener {
        int type;
        ComponentSplitter splitter;

        public HeavySplitBar(ComponentSplitter componentSplitter, int n2) {
            this.splitter = componentSplitter;
            this.type = n2;
            this.setBackground(Color.red.darker());
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n2) {
            this.type = n2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (MotifComponentSplitterUI.this.splitbar != null) {
                MotifComponentSplitterUI.this.splitbar.setVisible(false);
                MotifComponentSplitterUI.this.updateLayout();
                this.splitter.invalidate();
                this.splitter.validate();
                this.splitter.repaint();
                MotifComponentSplitterUI.this.splitbar = null;
                MotifComponentSplitterUI.this.loc = null;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.splitter == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Point point2 = this.splitter.getLocation();
            Dimension dimension = this.splitter.getSize();
            int n2 = point2.x;
            int n3 = point2.y;
            if (this.type == 1) {
                n3 += point.y;
            } else {
                n2 += point.x;
            }
            MotifComponentSplitterUI.this.splitbar.setLocation(n2, n3);
            MotifComponentSplitterUI.this.splitbar.repaint();
            if (this.splitter.isContinuousLayout()) {
                MotifComponentSplitterUI.this.updateLayout();
                this.splitter.invalidate();
                this.splitter.validate();
                this.splitter.repaint();
            }
        }
    }

    class LightSplitBar
    extends JComponent
    implements SplitBar {
        int type;
        ComponentSplitter splitter;
        int maxNegative;
        int maxPositive;

        public LightSplitBar(ComponentSplitter componentSplitter, int n2) {
            this.splitter = componentSplitter;
            this.setType(n2);
            this.setBackground(componentSplitter.getSplitBarHighlightColor());
        }

        public void paint(Graphics graphics) {
            if (!this.splitter.isContinuousLayout()) {
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n2) {
            this.type = n2;
            if (n2 == 2) {
                this.maxNegative = MotifComponentSplitterUI.this.hit.p1.getBounds().width;
                this.maxPositive = MotifComponentSplitterUI.this.hit.p2.getBounds().width;
            } else {
                this.maxNegative = MotifComponentSplitterUI.this.hit.p1.getBounds().height;
                this.maxPositive = MotifComponentSplitterUI.this.hit.p2.getBounds().height;
            }
        }

        public void setLocation(int n2, int n3) {
            int n4 = this.type == 2 ? n2 - MotifComponentSplitterUI.this.loc.x : n3 - MotifComponentSplitterUI.this.loc.y;
            if (n4 > 0 && n4 > this.maxPositive) {
                return;
            }
            if (n4 < 0 && n4 < -this.maxNegative) {
                return;
            }
            super.setLocation(n2, n3);
        }
    }

    static interface SplitBar {
        public int getType();
    }

    protected class MouseMonitor
    implements MouseListener,
    MouseMotionListener {
        ComponentSplitter splitter;
        LightSplitBar lightBar = null;
        HeavySplitBar heavyBar = null;
        Cursor defaultCursor = Cursor.getDefaultCursor();
        Cursor verticalCursor = Cursor.getPredefinedCursor(11);
        Cursor horizontalCursor = Cursor.getPredefinedCursor(8);

        SplitHit testHit(TiledComponent tiledComponent, Point point) {
            int n2 = tiledComponent.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                TiledComponent tiledComponent2 = tiledComponent.getChildAt(n3);
                if (n3 < n2 - 1 && tiledComponent2.getSplitbarBounds().contains(point)) {
                    MotifComponentSplitterUI.this.hit.p1 = tiledComponent2;
                    MotifComponentSplitterUI.this.hit.p2 = tiledComponent.getChildAt(n3 + 1);
                    MotifComponentSplitterUI.this.hit.hit = true;
                    return MotifComponentSplitterUI.this.hit;
                }
                if (tiledComponent2.getType() != 3 && this.testHit(tiledComponent2, point) != null) {
                    return MotifComponentSplitterUI.this.hit;
                }
                ++n3;
            }
            return null;
        }

        public MouseMonitor(ComponentSplitter componentSplitter) {
            this.splitter = componentSplitter;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.testHit(this.splitter.getRoot(), mouseEvent.getPoint()) != null) {
                this.showHit();
            } else {
                this.hideHit();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.hideHit();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!MotifComponentSplitterUI.this.hit.hit) {
                return;
            }
            if (this.splitter.getRoot().isLightweight()) {
                if (this.lightBar == null) {
                    this.lightBar = new LightSplitBar(this.splitter, MotifComponentSplitterUI.this.hit.p1.getParent().getType());
                    this.splitter.add((Component)this.lightBar, JLayeredPane.DRAG_LAYER);
                } else {
                    this.lightBar.setType(MotifComponentSplitterUI.this.hit.p1.getParent().getType());
                }
                MotifComponentSplitterUI.this.splitbar = this.lightBar;
            } else {
                if (this.heavyBar == null) {
                    this.heavyBar = new HeavySplitBar(this.splitter, MotifComponentSplitterUI.this.hit.p1.getParent().getType());
                    this.splitter.add((Component)this.heavyBar, JLayeredPane.DRAG_LAYER);
                } else {
                    this.heavyBar.setType(MotifComponentSplitterUI.this.hit.p1.getParent().getType());
                }
                MotifComponentSplitterUI.this.splitbar = this.heavyBar;
            }
            Rectangle rectangle = MotifComponentSplitterUI.this.hit.p1.getSplitbarBounds();
            MotifComponentSplitterUI.this.makeSplitBarNarrower(((SplitBar)((Object)MotifComponentSplitterUI.this.splitbar)).getType() == 2, rectangle);
            MotifComponentSplitterUI.this.splitbar.setBounds(rectangle);
            MotifComponentSplitterUI.this.splitbar.setVisible(true);
            MotifComponentSplitterUI.this.loc = MotifComponentSplitterUI.this.splitbar.getLocation();
            MotifComponentSplitterUI.this.hit.r1 = MotifComponentSplitterUI.this.hit.p1.getBounds();
            MotifComponentSplitterUI.this.hit.r2 = MotifComponentSplitterUI.this.hit.p2.getBounds();
            this.splitter.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.testHit(this.splitter.getRoot(), mouseEvent.getPoint()) != null) {
                this.showHit();
            } else {
                this.hideHit();
            }
            if (MotifComponentSplitterUI.this.splitbar != null) {
                MotifComponentSplitterUI.this.splitbar.setVisible(false);
                MotifComponentSplitterUI.this.updateLayout();
                this.splitter.invalidate();
                this.splitter.validate();
                this.splitter.repaint();
                MotifComponentSplitterUI.this.loc = null;
                MotifComponentSplitterUI.this.splitbar = null;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.testHit(this.splitter.getRoot(), mouseEvent.getPoint()) != null) {
                this.showHit();
            } else {
                this.hideHit();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (MotifComponentSplitterUI.this.splitbar != null) {
                Point point = mouseEvent.getPoint();
                Point point2 = MotifComponentSplitterUI.this.splitbar.getLocation();
                SplitBar splitBar = (SplitBar)((Object)MotifComponentSplitterUI.this.splitbar);
                if (splitBar.getType() == 1) {
                    MotifComponentSplitterUI.this.splitbar.setLocation(point2.x, point.y);
                } else {
                    MotifComponentSplitterUI.this.splitbar.setLocation(point.x, point2.y);
                }
                if (this.splitter.isContinuousLayout()) {
                    MotifComponentSplitterUI.this.updateLayout();
                    this.splitter.invalidate();
                    this.splitter.validate();
                    this.splitter.repaint();
                }
            }
        }

        void showHit() {
            this.splitter.setCursor(MotifComponentSplitterUI.this.hit.p1.getParent().getType() == 2 ? this.verticalCursor : this.horizontalCursor);
        }

        void hideHit() {
            this.splitter.setCursor(this.defaultCursor);
            MotifComponentSplitterUI.this.hit.hit = false;
        }
    }

    class SplitHit
    implements Serializable {
        TiledComponent p1;
        TiledComponent p2;
        boolean hit;
        Rectangle r1;
        Rectangle r2;

        SplitHit() {
        }
    }

    protected class FocusMonitor
    implements FocusListener,
    ContainerListener {
        Component root;
        ComponentSplitter splitter;
        boolean hasFocus = false;

        public FocusMonitor(ComponentSplitter componentSplitter, Component component) {
            this.splitter = componentSplitter;
            this.root = component;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!this.hasFocus) {
                if (!this.splitter.isAncestorOf(this.root)) {
                    return;
                }
                this.hasFocus = true;
                this.splitter.setSelectedComponent(this.root);
                Rectangle rectangle = this.root.getBounds();
                int n2 = this.splitter.getSplitBarSize();
                int n3 = n2 + n2;
                this.splitter.repaint(rectangle.x - n2, rectangle.y - n2, rectangle.width + n3, rectangle.height + n3);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.hasFocus && !focusEvent.isTemporary() && !this.splitter.isMenuFocus()) {
                if (!this.splitter.isAncestorOf(this.root)) {
                    return;
                }
                this.hasFocus = false;
                this.splitter.setSelectedComponent(null);
                Rectangle rectangle = this.root.getBounds();
                int n2 = this.splitter.getSplitBarSize();
                int n3 = n2 + n2;
                this.splitter.repaint(rectangle.x - n2, rectangle.y - n2, rectangle.width + n3, rectangle.height + n3);
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            this.startFocusMonitoring(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.stopFocusMonitoring(containerEvent.getChild());
        }

        public void startFocusMonitoring(Component component) {
            component.addFocusListener(this);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this);
                int n2 = 0;
                while (n2 < container.getComponentCount()) {
                    this.startFocusMonitoring(container.getComponent(n2));
                    ++n2;
                }
            }
        }

        public void stopFocusMonitoring(Component component) {
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this);
                int n2 = 0;
                while (n2 < container.getComponentCount()) {
                    this.stopFocusMonitoring(container.getComponent(n2));
                    ++n2;
                }
            }
        }
    }
}

