/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.CommonToolBar;
import com.ibm.db2.tools.common.DockingArea;
import com.ibm.db2.tools.common.DockingPane;
import com.ibm.db2.tools.common.plaf.CommonToolBarUI;
import com.ibm.db2.tools.common.plaf.DockedDragBorder;
import com.ibm.db2.tools.common.plaf.motif.PuzzleBorder;
import com.ibm.db2.tools.common.plaf.motif.ToolBarLayout;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class MotifCommonToolBarUI
extends CommonToolBarUI
implements PropertyChangeListener,
WindowListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LayoutManager tbarLayout;
    protected boolean dockingWindow;
    protected int orientation = 0;
    protected Border dockedBorder;
    protected Border horBorder;
    protected Border verBorder;
    protected DraggingListener draggingListener;
    protected boolean floating;
    protected int floatingX;
    protected int floatingY;
    protected JFrame floatingFrame;
    protected Container dockingSource;
    protected int dockingSensitivity = 0;
    protected DragWindow dragWindow;
    protected Timer robbyTimer;
    protected static final int MOVE_UNIT = 9;
    protected static final int DRAG_SENSITIVITY = 10;
    protected static Cursor draggingHand;
    protected static Cursor grabbingHand;
    protected static Cursor hiddenCursor;
    protected static boolean noRobot;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingPane;
    static /* synthetic */ Class class$javax$swing$JRootPane;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingArea;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Window;

    public MotifCommonToolBarUI() {
        this(false);
    }

    public MotifCommonToolBarUI(boolean bl) {
        this.dockingWindow = bl;
        if (bl) {
            this.tbarLayout = null;
        } else {
            this.createBorders();
            this.tbarLayout = new ToolBarLayout();
        }
        if (draggingHand == null) {
            draggingHand = Toolkit.getDefaultToolkit().createCustomCursor(CommonImageRepository.getImage(CommonImageRepository.IMAGE_CLOSED_HAND), new Point(10, 8), "Hand to grab a view for dragging");
            grabbingHand = Toolkit.getDefaultToolkit().createCustomCursor(CommonImageRepository.getImage(CommonImageRepository.IMAGE_OPEN_HAND), new Point(10, 8), "Hand to drag a view for docking or floating");
            hiddenCursor = Toolkit.getDefaultToolkit().createCustomCursor(CommonImageRepository.getImage(CommonImageRepository.IMAGE_HIDDEN_CURSOR), new Point(10, 8), "Hidden cursor for docking");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("floatable")) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (object instanceof Boolean && ((Boolean)object).booleanValue() && object2 instanceof Boolean && !((Boolean)object2).booleanValue()) {
                this.dockingListener = new DockingListener(this.toolBar);
                ((CommonToolBar)this.toolBar).addDockingListeners(this.dockingListener, this.dockingListener);
                this.draggingListener = new DraggingListener(this.toolBar);
            } else if (object instanceof Boolean && !((Boolean)object).booleanValue() && object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                if (this.dockingListener != null && this.toolBar instanceof CommonToolBar) {
                    ((CommonToolBar)this.toolBar).removeDockingListeners(this.dockingListener, this.dockingListener);
                    this.dockingListener = null;
                }
                if (this.draggingListener != null && this.floatingFrame != null) {
                    this.draggingListener.removeListener(this.floatingFrame);
                    this.draggingListener = null;
                }
            }
        }
    }

    protected void dragTo(Point point, Point point2) {
        Container container;
        if (this.floatingFrame != null) {
            container = null;
            if (this.floatingFrame.getGlassPane() instanceof SourceMap) {
                container = (SourceMap)this.floatingFrame.getGlassPane();
            } else {
                container = new SourceMap();
                this.floatingFrame.getRootPane().setGlassPane(container);
            }
            container.setVisible(true);
        }
        if (this.toolBar.isFloatable()) {
            try {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.dockingSource == null) {
                    return;
                }
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindowM(this.toolBar);
                }
                container = this.dockingSource;
                if (!this.dockingSource.isShowing()) {
                    if (!(this.dockingSource instanceof DockingArea)) {
                        return;
                    }
                    container = ((DockingArea)this.dockingSource).getDockingPane();
                    if (container == null) {
                        return;
                    }
                }
                Dimension dimension = this.getDragWindowSize((DockingArea)this.dockingSource);
                Point point3 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point3, container);
                this.dragWindow.setDockable(true);
                Point point4 = this.dragWindow.getOffset();
                if (point4 == null) {
                    point4 = new Point(Math.min(dimension.width - 7, point2.x), Math.min(dimension.height - 7, point2.y));
                    this.dragWindow.setOffset(point4);
                }
                point3.x -= point4.x;
                point3.y -= point4.y;
                if (this.canDock(container, point3)) {
                    Object object;
                    int n2;
                    this.dragWindow.setCursor(hiddenCursor);
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setForeground(this.getDockingColor());
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                    if (((DockingArea)this.dockingSource).getConstraint() <= 3) {
                        if (this.dockingSource instanceof DockingArea) {
                            n2 = ((DockingArea)this.dockingSource).getOrientation();
                        } else {
                            object = this.getDockingConstraint(container, point2);
                            n2 = this.mapConstraintToOrientation((String)object);
                        }
                        this.dragWindow.setOrientation(n2);
                    }
                    ((Component)this.dragWindow).setSize(dimension);
                    point2 = point4;
                    n2 = AssistManager.getDockingMapPolicy();
                    if (this.dockingWindow && n2 != 0) {
                        object = null;
                        object = container instanceof DockingPane ? (DockingPane)container : (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, container);
                        if (object != null) {
                            JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = MotifCommonToolBarUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, container);
                            DockingMap dockingMap = null;
                            if (jRootPane == null) {
                                return;
                            }
                            if (jRootPane.getGlassPane() instanceof DockingMap) {
                                dockingMap = (DockingMap)jRootPane.getGlassPane();
                            } else {
                                dockingMap = new DockingMap();
                                jRootPane.setGlassPane(dockingMap);
                            }
                            dockingMap.setVisible(false);
                            Point point5 = SwingUtilities.convertPoint(container, point3, jRootPane);
                            Component component = SwingUtilities.getDeepestComponentAt(jRootPane, point5.x, point5.y);
                            Container container2 = null;
                            if (component instanceof BasicSplitPaneDivider) {
                                container2 = component.getParent();
                            } else if ((component instanceof JTabbedPane || component instanceof JSplitPane) && "DockingContainer".equals(component.getName())) {
                                container2 = (Container)component;
                            } else if (component instanceof DockingArea) {
                                container2 = (Container)component;
                            } else {
                                Container container3 = container2 = SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingArea == null ? (class$com$ibm$db2$tools$common$DockingArea = MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingArea")) : class$com$ibm$db2$tools$common$DockingArea, component);
                                while (container3 != null) {
                                    container2 = container3;
                                    container3 = SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingArea == null ? MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingArea") : class$com$ibm$db2$tools$common$DockingArea, container3);
                                }
                            }
                            if (container2 != null && (container2.getParent() instanceof JSplitPane && ((JSplitPane)container2.getParent()).getLeftComponent() != this.dockingSource && ((JSplitPane)container2.getParent()).getRightComponent() != this.dockingSource || container2.getParent() instanceof JTabbedPane)) {
                                container2 = container2.getParent();
                            }
                            dockingMap.setArea(container2, this.dockingSource, n2);
                            dockingMap.setVisible(true);
                        }
                    }
                } else {
                    this.dragWindow.setCursor(draggingHand);
                    this.dragWindow.setDockable(false);
                    JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = MotifCommonToolBarUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, container);
                    if (jRootPane != null) {
                        jRootPane.getGlassPane().setVisible(false);
                    }
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setForeground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                    if (((DockingArea)this.dockingSource).getConstraint() <= 3) {
                        this.dragWindow.setOrientation(0);
                    }
                    Dimension dimension2 = null;
                    dimension2 = this.isFloating() ? this.floatingFrame.getSize() : ((CommonToolBar)this.toolBar).getFloatingSize();
                    if (dimension2 == null) {
                        dimension2 = this.toolBar.getSize();
                    }
                    ((CommonToolBar)this.toolBar).setFloatingSize(dimension2);
                    ((Component)this.dragWindow).setSize(dimension2);
                    point4 = this.dragWindow.getOffset();
                    if (point4 == null) {
                        point2.x = Math.min(dimension2.width - 7, point2.x);
                        if (this.isFloating()) {
                            Insets insets = this.floatingFrame.getInsets();
                            point2.y = insets.top + 9;
                        } else {
                            point2.y = Math.min(dimension2.height - 7, point2.y);
                        }
                        this.dragWindow.setOffset(point2);
                    } else {
                        point2 = point4;
                    }
                }
                ((Component)this.dragWindow).setLocation(point.x - point2.x, point.y - point2.y);
                if (!this.dragWindow.isVisible()) {
                    this.dragWindow.show();
                }
                if (((DockingArea)this.dockingSource).getConstraint() > 3) {
                    this.dragWindow.setPanes(((DockingArea)this.dockingSource).getDockingPane().getClientDescription(this.dragWindow, (DockingArea)this.dockingSource));
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected Dimension getDragWindowSize(DockingArea dockingArea) {
        Dimension dimension;
        if (dockingArea.getConstraint() <= 3) {
            dimension = this.toolBar.getPreferredSize();
        } else {
            dimension = dockingArea.getDockingPane().getSize();
            double d2 = Math.sqrt(4000.0 / (double)(dimension.height * dimension.width));
            int n2 = dimension.width;
            dimension.width = (int)((double)dimension.width * d2);
            dimension.height = (int)((double)dimension.height * d2);
        }
        return dimension;
    }

    public void setFloatingLocation(int n2, int n3) {
        this.floatingX = n2;
        this.floatingY = n3;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.dockingSource == null) {
            this.dockingSource = this.toolBar.getParent();
        }
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                ((Component)this.dragWindow).setVisible(false);
            }
            boolean bl2 = this.isFloating();
            this.floating = bl;
            if (bl) {
                Dimension dimension;
                object = this.findFocusedComponent(this.toolBar);
                JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = MotifCommonToolBarUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, this.toolBar);
                if (jRootPane != null) {
                    jRootPane.getGlassPane().setVisible(false);
                }
                ((DockingArea)this.dockingSource).setDockingDescription(((DockingArea)this.dockingSource).getDockingPane().getClientDescription());
                if (point != null) {
                    this.setFloatingLocation(point.x, point.y);
                }
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingFrame == null) {
                    this.floatingFrame = this.createFloatingFrame(this.toolBar);
                }
                if ((dimension = ((CommonToolBar)this.toolBar).getFloatingSize()) == null) {
                    dimension = this.toolBar.getSize();
                    if (this.dockingWindow) {
                        dimension.height += 9;
                    }
                }
                if (!bl2) {
                    Insets insets = this.floatingFrame.getInsets();
                    dimension.width += insets.left + insets.right;
                    dimension.height += insets.top + insets.bottom;
                    if (this.dockingWindow) {
                        dimension.height += 9;
                    }
                }
                this.floatingFrame.getContentPane().add((Component)this.toolBar, "Center");
                ((Component)this.floatingFrame).setSize(dimension);
                ((Component)this.floatingFrame).setLocation(this.floatingX, this.floatingY);
                this.floatingFrame.show();
                this.draggingListener.addListener(this.floatingFrame);
                this.toolBar.requestFocus();
                if (object != this.toolBar) {
                    ((Component)object).requestFocus();
                }
            } else {
                if (this.floatingFrame == null) {
                    this.floatingFrame = this.createFloatingFrame(this.toolBar);
                }
                ((Component)this.floatingFrame).setVisible(false);
                this.draggingListener.removeListener(this.floatingFrame);
                ((CommonToolBar)this.toolBar).setFloatingSize(this.toolBar.getSize());
                object = this.getDockingConstraint(this.dockingSource, point);
                this.orientation = point == null && this.dockingSource instanceof DockingArea ? ((DockingArea)this.dockingSource).getOrientation() : this.mapConstraintToOrientation((String)object);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                String string = "N";
                if (this.dragWindow != null) {
                    string = this.dragWindow.getPanes();
                }
                if (this.dockingWindow) {
                    this.toolBar.setBorder(null);
                }
                this.dockingSource.add((Component)this.toolBar, string);
                JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = MotifCommonToolBarUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, this.dockingSource);
                if (jRootPane != null) {
                    jRootPane.getGlassPane().setVisible(false);
                }
            }
            this.updateBorder();
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (point == null) {
            return;
        }
        if (this.toolBar.isFloatable()) {
            if (this.floatingFrame != null && this.floatingFrame.getGlassPane() instanceof SourceMap) {
                this.floatingFrame.getGlassPane().setVisible(false);
            }
            try {
                Point point3 = null;
                if (this.dragWindow != null) {
                    point3 = this.dragWindow.getOffset();
                    if (point3 == null) {
                        this.dragWindow.setOffset(point2);
                        point3 = point2;
                    }
                } else if (point3 == null) {
                    return;
                }
                this.setFloatingLocation(point.x - point3.x, point.y - point3.y);
                if (this.dockingSource != null) {
                    Container container = this.dockingSource;
                    if (!this.dockingSource.isShowing()) {
                        if (!(this.dockingSource instanceof DockingArea)) {
                            return;
                        }
                        container = ((DockingArea)this.dockingSource).getDockingPane();
                        if (container == null) {
                            return;
                        }
                    }
                    Point point4 = (Point)point.clone();
                    SwingUtilities.convertPointFromScreen(point4, container);
                    point4.x -= point3.x;
                    point4.y -= point3.y;
                    if (this.dragWindow == null && this.canDock(container, point4)) {
                        this.setFloating(false, point4);
                    } else if (this.dragWindow != null && this.dragWindow.isVisible() && this.dragWindow.isDockable()) {
                        this.setFloating(false, point4);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected String getDockingConstraint(Component component, Point point) {
        String string = "North";
        if (this.dockingWindow) {
            string = this.getQuadrant(component, point);
        } else if (point != null && component.contains(point)) {
            if (this.dockingSensitivity == 0) {
                this.dockingSensitivity = this.toolBar.getSize().height;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                string = "South";
            }
            if (point.x < this.dockingSensitivity) {
                string = "West";
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                string = "East";
            }
            if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    protected int mapConstraintToOrientation(String string) {
        int n2 = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n2 = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n2 = 0;
            }
        }
        return n2;
    }

    public boolean canDock(Component component, Point point) {
        if (this.dockingWindow) {
            if (this.draggingListener != null && this.draggingListener.isMoveOnly()) {
                return false;
            }
            DockingPane dockingPane = null;
            if (component instanceof DockingPane) {
                dockingPane = (DockingPane)component;
            } else if (component instanceof DockingArea) {
                dockingPane = ((DockingArea)component).getDockingPane();
                if (dockingPane == null && SwingUtilities.getWindowAncestor(component) == null) {
                    return false;
                }
                point = SwingUtilities.convertPoint(component, point, dockingPane);
            } else {
                dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, component);
                point = SwingUtilities.convertPoint(component, point, dockingPane);
            }
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = MotifCommonToolBarUI.class$("java.awt.Frame")) : class$java$awt$Frame, component);
            if (dockingPane == null || frame == null || frame.getState() == 1) {
                return false;
            }
            Rectangle rectangle = dockingPane.getClientBounds();
            Point point2 = null;
            if (dockingPane.getParent() == null || !dockingPane.getParent().isShowing()) {
                return false;
            }
            point2 = dockingPane.getParent().getLocationOnScreen();
            if (point.x < rectangle.x || point.y < rectangle.y || point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height) {
                return false;
            }
            Component component2 = SwingUtilities.getDeepestComponentAt(dockingPane, point.x, point.y);
            if (this.floatingFrame.isVisible()) {
                return true;
            }
            if (component2 == null) {
                return true;
            }
            if (component.getParent() instanceof JTabbedPane) {
                return true;
            }
            if (component instanceof DockingArea && DockingPane.betweenSplitters(dockingPane, (DockingArea)component, point)) {
                return true;
            }
            return !SwingUtilities.isDescendingFrom(component2, component);
        }
        Dimension dimension = this.toolBar.getSize();
        point.x += dimension.width / 2;
        point.y += dimension.height / 2;
        SwingUtilities.convertPoint(null, point, component);
        return super.canDock(component, point);
    }

    protected String getQuadrant(Component component, Point point) {
        DockingPane dockingPane = null;
        if (point == null) {
            if (component instanceof DockingArea) {
                switch (((DockingArea)component).getConstraint()) {
                    case 4: {
                        return "DOCK_NORTH";
                    }
                    case 5: {
                        return "DOCK_WEST";
                    }
                    case 6: {
                        return "DOCK_SOUTH";
                    }
                    case 7: {
                        return "DOCK_EAST";
                    }
                }
                return "DOCK_NORTH";
            }
            return "North";
        }
        if (component instanceof CommonToolBar && this.dockingSource != null) {
            dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this.dockingSource);
        } else if (component instanceof DockingPane) {
            dockingPane = (DockingPane)component;
        } else if (component instanceof DockingArea) {
            dockingPane = ((DockingArea)component).getDockingPane();
            point = SwingUtilities.convertPoint(component, point, dockingPane);
        } else {
            dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = MotifCommonToolBarUI.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, component);
            point = SwingUtilities.convertPoint(component, point, dockingPane);
        }
        if (dockingPane == null) {
            return "DOCK_NORTH";
        }
        Rectangle rectangle = dockingPane.getClientBounds();
        if (point.y == 0) {
            return "DOCK_NORTH";
        }
        if (point.y - rectangle.height == 0) {
            return "DOCK_SOUTH";
        }
        if (point.x / point.y <= rectangle.width / rectangle.height) {
            if (point.x / (point.y - rectangle.height) <= rectangle.width / (rectangle.height * -1)) {
                return "DOCK_SOUTH";
            }
            return "DOCK_WEST";
        }
        if (point.x / (point.y - rectangle.height) <= rectangle.width / (rectangle.height * -1)) {
            return "DOCK_EAST";
        }
        return "DOCK_NORTH";
    }

    protected Component findFocusedComponent(Container container) {
        Component component = null;
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = MotifCommonToolBarUI.class$("java.awt.Window")) : class$java$awt$Window, container);
        if (window != null) {
            component = window.getFocusOwner();
        }
        if (component == null) {
            component = container;
        }
        return component;
    }

    public JFrame createFloatingFrame(JToolBar jToolBar) {
        FloatingFrame floatingFrame = new FloatingFrame(jToolBar.getName());
        if (jToolBar instanceof CommonToolBar) {
            JFrame jFrame = ((CommonToolBar)jToolBar).getFrame();
            if (jFrame != null) {
                Image image = jFrame.getIconImage();
                ((Frame)floatingFrame).setIconImage(image);
            }
            floatingFrame.setHelpPanelID(((CommonToolBar)jToolBar).getHelpPanelID());
        }
        if (this.dockingWindow) {
            floatingFrame.setTitle(((CommonToolBar)jToolBar).getDockingTitle());
            floatingFrame.setResizable(true);
            jToolBar.setBorder(this.dockedBorder);
            jToolBar.setCursor(grabbingHand);
        } else {
            floatingFrame.setResizable(false);
            jToolBar.setBorder(null);
        }
        floatingFrame.addWindowListener(this);
        return floatingFrame;
    }

    protected DragWindow createDragWindowM(JToolBar jToolBar) {
        Container container;
        Frame frame = null;
        if (this.toolBar != null && (container = SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = MotifCommonToolBarUI.class$("java.awt.Frame")) : class$java$awt$Frame, this.toolBar)) != null && container instanceof Frame) {
            frame = (Frame)container;
        }
        if (this.floatingFrame == null) {
            this.floatingFrame = this.createFloatingFrame(this.toolBar);
        }
        frame = this.floatingFrame;
        return new DragWindow(frame);
    }

    protected void createBorders() {
        if (this.horBorder == null) {
            this.horBorder = new PuzzleBorder(false);
        }
        if (this.verBorder == null) {
            this.verBorder = new PuzzleBorder(true);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifCommonToolBarUI(((CommonToolBar)jComponent).getDockingWindow());
    }

    public void setOrientation(int n2) {
        super.setOrientation(n2);
        this.orientation = n2;
        ((CommonToolBar)this.toolBar).syncOrientation(n2 == 0 ? 0 : 1);
        if (this.tbarLayout == null) {
            this.tbarLayout = new BoxLayout(this.toolBar, n2 == 0 ? 0 : 1);
        }
        ((Container)this.toolBar).setLayout(this.tbarLayout);
    }

    public void syncOrientation(int n2) {
        if (n2 != this.orientation) {
            this.orientation = n2;
            if (this.tbarLayout == null) {
                this.tbarLayout = new BoxLayout(this.toolBar, this.orientation == 0 ? 0 : 1);
            }
            ((Container)this.toolBar).setLayout(this.tbarLayout);
        }
        this.updateBorder();
    }

    protected void updateBorder() {
        if (this.toolBar == null) {
            return;
        }
        if (this.dockingWindow) {
            if (this.dockedBorder == null) {
                this.dockedBorder = DockedDragBorder.getInstance();
            }
            if (this.floating) {
                this.toolBar.setBorder(this.dockedBorder);
                this.toolBar.setCursor(grabbingHand);
            } else {
                this.toolBar.setBorder(null);
            }
            return;
        }
        if (this.horBorder instanceof PuzzleBorder) {
            ((PuzzleBorder)this.horBorder).setPuzzle(((CommonToolBar)this.toolBar).isPuzzleEdge());
        }
        if (this.verBorder instanceof PuzzleBorder) {
            ((PuzzleBorder)this.verBorder).setPuzzle(((CommonToolBar)this.toolBar).isPuzzleEdge());
        }
        if (this.orientation == 0) {
            this.toolBar.setBorder(this.horBorder);
        } else {
            this.toolBar.setBorder(this.verBorder);
        }
    }

    protected void installListeners() {
        this.toolBar.addPropertyChangeListener("floatable", this);
        if (this.toolBar instanceof CommonToolBar && this.toolBar.isFloatable()) {
            this.dockingListener = new DockingListener(this.toolBar);
            this.draggingListener = new DraggingListener(this.toolBar);
            ((CommonToolBar)this.toolBar).addDockingListeners(this.dockingListener, this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            if (this.toolBar instanceof CommonToolBar) {
                this.toolBar.addFocusListener(this.toolBarFocusListener);
            } else {
                Component[] componentArray = this.toolBar.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    componentArray[n2].addFocusListener(this.toolBarFocusListener);
                    ++n2;
                }
            }
        }
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener("floatable", this);
        if (this.dockingListener != null && this.toolBar instanceof CommonToolBar && this.toolBar.isFloatable()) {
            ((CommonToolBar)this.toolBar).removeDockingListeners(this.dockingListener, this.dockingListener);
            this.dockingListener = null;
        }
        if (this.draggingListener != null && this.floatingFrame != null) {
            this.draggingListener.removeListener(this.floatingFrame);
            this.draggingListener = null;
        }
        if (this.propertyListener != null) {
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            if (this.toolBar instanceof CommonToolBar) {
                this.toolBar.removeFocusListener(this.toolBarFocusListener);
            } else {
                Component[] componentArray = this.toolBar.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    componentArray[n2].removeFocusListener(this.toolBarFocusListener);
                    ++n2;
                }
            }
            this.toolBarFocusListener = null;
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.dockingWindow = ((CommonToolBar)this.toolBar).getDockingWindow();
        this.dockingSensitivity = 0;
        this.floatingY = 0;
        this.floatingX = 0;
        if (this.horBorder instanceof PuzzleBorder) {
            ((PuzzleBorder)this.horBorder).setPuzzle(((CommonToolBar)this.toolBar).isPuzzleEdge());
        }
        if (this.verBorder instanceof PuzzleBorder) {
            ((PuzzleBorder)this.verBorder).setPuzzle(((CommonToolBar)this.toolBar).isPuzzleEdge());
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this.floatingFrame) {
            boolean bl = true;
            if (this.dockingSource != null && this.dockingSource instanceof DockingArea) {
                if (((DockingArea)this.dockingSource).getDockingWindow() && !((DockingArea)this.dockingSource).hasClient()) {
                    ((DockingArea)this.dockingSource).add((CommonToolBar)this.getToolBar());
                    if (this.floatingFrame.isShowing()) {
                        ((CommonToolBar)this.getToolBar()).setFloatingLocation(this.floatingFrame.getLocationOnScreen());
                    }
                }
                if (!(bl = ((DockingArea)this.dockingSource).fireCloseAction())) {
                    this.floating = false;
                    this.updateBorder();
                    ((DockingArea)this.dockingSource).getDockingPane().restoreView((DockingArea)this.dockingSource);
                }
            }
            ((Component)this.floatingFrame).setVisible(false);
            if (!this.dockingWindow) {
                this.dragWindow = null;
                this.setFloating(false, null);
            }
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    protected Component getFocusableDescendent(Container container) {
        if (container == null) {
            return null;
        }
        Component[] componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (componentArray[n3].isFocusTraversable() && componentArray[n3].isShowing()) {
                return componentArray[n3];
            }
            if (componentArray[n3] instanceof Container) {
                return this.getFocusableDescendent((Container)componentArray[n3]);
            }
            ++n3;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        noRobot = false;
    }

    protected class DockingMap
    extends JPanel {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Container source;
        protected Container area;
        protected boolean drawDockingSymbols;
        protected static final int SPLITTER_SPAN = 20;
        protected Color obscuro;
        static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingPane;

        public DockingMap() {
            this.setOpaque(false);
            SystemColor systemColor = SystemColor.textHighlight;
            Color color = new Color(255 - systemColor.getRed(), 255 - systemColor.getGreen(), 255 - systemColor.getBlue());
            this.setForeground(systemColor);
            this.setBackground(color);
            this.obscuro = new Color(systemColor.getRed(), systemColor.getGreen(), systemColor.getBlue(), 127);
        }

        public void setArea(Container container, Container container2, int n2) {
            this.area = container;
            this.source = container2;
            this.drawDockingSymbols = n2 == 2;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.ui != null && this.area != null) {
                Graphics graphics2 = graphics.create();
                graphics2.setColor(this.getForeground());
                Container container = SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingMap.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this.area);
                if (container != null) {
                    Rectangle rectangle = container.getBounds();
                    this.paintArea(graphics2, container, rectangle);
                }
            }
        }

        protected boolean isMappingWindow(Container container) {
            if (container instanceof JTabbedPane && "DockingContainer".equals(container.getName())) {
                return true;
            }
            if (container instanceof DockingArea && container != this.source) {
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    if (componentArray[n2] instanceof CommonToolBar && ((CommonToolBar)componentArray[n2]).getDockingWindow()) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        protected void graySource(Graphics graphics, Rectangle rectangle) {
            Color color = graphics.getColor();
            graphics.setColor(this.obscuro);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }

        protected void paintArea(Graphics graphics, Component component, Rectangle rectangle) {
            if (this.source == component) {
                this.graySource(graphics, rectangle);
            } else if ((component instanceof JTabbedPane || component instanceof DockingArea) && this.isMappingWindow((Container)component)) {
                this.paintPanel(graphics, component, rectangle);
            } else if (component instanceof JSplitPane && "DockingContainer".equals(component.getName())) {
                Rectangle rectangle2;
                Serializable serializable;
                int n2 = ((JSplitPane)component).getOrientation();
                int n3 = (20 - ((JSplitPane)component).getDividerSize()) / 2;
                Component component2 = ((JSplitPane)component).getLeftComponent();
                Rectangle rectangle3 = SwingUtilities.convertRectangle(component, component2.getBounds(), this.getParent());
                int n4 = 0;
                n4 = n2 == 1 ? rectangle3.y + component.getSize().height / 2 - 1 : rectangle3.x + component.getSize().width / 2 - 1;
                if (component2 instanceof JSplitPane) {
                    if (((JSplitPane)component2).getLeftComponent() == this.source) {
                        serializable = SwingUtilities.convertRectangle(this.source.getParent(), this.source.getBounds(), this.getParent());
                        this.graySource(graphics, (Rectangle)serializable);
                        component2 = ((JSplitPane)component2).getRightComponent();
                    } else if (((JSplitPane)component2).getRightComponent() == this.source) {
                        serializable = SwingUtilities.convertRectangle(this.source.getParent(), this.source.getBounds(), this.getParent());
                        this.graySource(graphics, (Rectangle)serializable);
                        component2 = ((JSplitPane)component2).getLeftComponent();
                    }
                }
                rectangle3 = SwingUtilities.convertRectangle(component2.getParent(), component2.getBounds(), this.getParent());
                if (this.source.getParent() != component) {
                    if (n2 == 1) {
                        rectangle3.width -= n3;
                        graphics.drawLine(rectangle3.x + rectangle3.width, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height);
                        graphics.drawLine(rectangle3.x + rectangle3.width, n4, rectangle3.x + rectangle3.width + 10, n4);
                        if (this.drawDockingSymbols) {
                            this.drawSymbol(graphics, 0, rectangle3.x + rectangle3.width + 10, n4 - 20);
                            this.drawSymbol(graphics, 2, rectangle3.x + rectangle3.width + 10, n4 + 20);
                        }
                    } else {
                        rectangle3.height -= n3;
                        graphics.drawLine(rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height);
                        graphics.drawLine(n4, rectangle3.y + rectangle3.height, n4, rectangle3.y + rectangle3.height + 10);
                        if (this.drawDockingSymbols) {
                            this.drawSymbol(graphics, 1, n4 - 20, rectangle3.y + rectangle3.height + 10);
                            this.drawSymbol(graphics, 3, n4 + 20, rectangle3.y + rectangle3.height + 10);
                        }
                    }
                }
                this.paintArea(graphics, component2, rectangle3);
                serializable = ((JSplitPane)component).getRightComponent();
                if (serializable instanceof JSplitPane) {
                    if (((JSplitPane)serializable).getLeftComponent() == this.source) {
                        rectangle2 = SwingUtilities.convertRectangle(this.source.getParent(), this.source.getBounds(), this.getParent());
                        this.graySource(graphics, rectangle2);
                        serializable = ((JSplitPane)serializable).getRightComponent();
                    } else if (((JSplitPane)serializable).getRightComponent() == this.source) {
                        rectangle2 = SwingUtilities.convertRectangle(this.source.getParent(), this.source.getBounds(), this.getParent());
                        this.graySource(graphics, rectangle2);
                        serializable = ((JSplitPane)serializable).getLeftComponent();
                    }
                }
                rectangle2 = SwingUtilities.convertRectangle(((Component)serializable).getParent(), ((Component)serializable).getBounds(), this.getParent());
                if (this.source.getParent() != component) {
                    if (n2 == 1) {
                        rectangle2.x += n3;
                        rectangle2.width -= n3;
                        graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height);
                        graphics.drawLine(rectangle3.x + rectangle3.width, n4, rectangle2.x, n4);
                        if (this.drawDockingSymbols && rectangle2.x - (rectangle3.x + rectangle3.width) > 22) {
                            this.drawSymbol(graphics, 0, rectangle2.x - 10, n4 - 20);
                            this.drawSymbol(graphics, 2, rectangle2.x - 10, n4 + 20);
                        }
                    } else {
                        rectangle2.y += n3;
                        rectangle2.height -= n3;
                        graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y);
                        graphics.drawLine(n4, rectangle3.y + rectangle3.height, n4, rectangle2.y);
                        if (this.drawDockingSymbols && rectangle2.y - (rectangle3.y + rectangle3.height) > 22) {
                            this.drawSymbol(graphics, 1, n4 - 20, rectangle2.y - 10);
                            this.drawSymbol(graphics, 3, n4 + 20, rectangle2.y - 10);
                        }
                    }
                }
                this.paintArea(graphics, (Component)serializable, rectangle2);
            } else if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                int n5 = 0;
                while (n5 < componentArray.length) {
                    Rectangle rectangle4 = component instanceof DockingPane ? componentArray[n5].getBounds() : SwingUtilities.convertRectangle(componentArray[n5], componentArray[n5].getBounds(), component);
                    this.paintArea(graphics, componentArray[n5], rectangle4);
                    ++n5;
                }
            }
            graphics.dispose();
        }

        protected void paintPanel(Graphics graphics, Component component, Rectangle rectangle) {
            int n2 = rectangle.width / 4;
            int n3 = rectangle.height / 4;
            int n4 = n2 + n2;
            int n5 = n3 + n3;
            int n6 = n4 + n2;
            int n7 = n5 + n3;
            Rectangle rectangle2 = new Rectangle(rectangle.x + n2, rectangle.y + n3, n4, n5);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (component instanceof JTabbedPane) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + n2, rectangle.y + n3);
                graphics.drawLine(rectangle.x + n6, rectangle.y + n7, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + n6, rectangle.y + n3);
                graphics.drawLine(rectangle.x + n2, rectangle.y + n7, rectangle.x, rectangle.y + rectangle.height);
                int n8 = ((JTabbedPane)component).getTabPlacement();
                int n9 = ((JTabbedPane)component).getTabCount();
                if (this.source.getParent() != component) {
                    ++n9;
                }
                if (n8 == 1 || n8 == 3) {
                    int n10 = n4 / n9;
                    int n11 = 1;
                    while (n11 < n9) {
                        graphics.drawLine(rectangle.x + n2 + n11 * n10, rectangle.y + n3, rectangle.x + n2 + n11 * n10, rectangle.y + n7);
                        if (this.drawDockingSymbols && n10 > 15) {
                            this.drawSymbol(graphics, n11 == 1 ? 4 : 5, rectangle.x + n2 + n11 * n10 - n10 / 2, rectangle.y + rectangle.height / 2);
                            graphics.drawString(Integer.toString(n11), rectangle.x + n2 + n11 * n10 - n10 / 2 - 3, rectangle.y + rectangle.height / 2 + 15);
                        }
                        ++n11;
                    }
                    if (this.drawDockingSymbols && n10 > 15) {
                        this.drawSymbol(graphics, 6, rectangle.x + n2 + n4 - n10 / 2, rectangle.y + rectangle.height / 2);
                        graphics.drawString(Integer.toString(n9), rectangle.x + n2 + n4 - n10 / 2 - 3, rectangle.y + rectangle.height / 2 + 15);
                    }
                } else {
                    int n12 = n5 / n9;
                    int n13 = 1;
                    while (n13 < n9) {
                        graphics.drawLine(rectangle.x + n2, rectangle.y + n3 + n13 * n12, rectangle.x + n6, rectangle.y + n3 + n13 * n12);
                        if (this.drawDockingSymbols && n12 > 15) {
                            this.drawSymbol(graphics, n13 == 1 ? 4 : 5, rectangle.x + rectangle.width / 2, rectangle.y + n3 + n13 * n12 - n12 / 2);
                            graphics.drawString(Integer.toString(n13), rectangle.x + rectangle.width / 2 + 8, rectangle.y + n3 + n13 * n12 - n12 / 2 + 4);
                        }
                        ++n13;
                    }
                    if (this.drawDockingSymbols && n12 > 15) {
                        this.drawSymbol(graphics, 6, rectangle.x + rectangle.width / 2, rectangle.y + n3 + n5 - n12 / 2);
                        graphics.drawString(Integer.toString(n9), rectangle.x + rectangle.width / 2 + 8, rectangle.y + n3 + n5 - n12 / 2 + 4);
                    }
                }
            } else {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + n4, rectangle.y + n3, rectangle.x + n4, rectangle.y + n7);
                graphics.drawLine(rectangle.x + n2, rectangle.y + n5, rectangle.x + n6, rectangle.y + n5);
                if (this.drawDockingSymbols && n2 > 15 && n3 > 15) {
                    this.drawSymbol(graphics, 4, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                }
            }
            if (this.drawDockingSymbols && n2 > 15 && n3 > 15) {
                this.drawSymbol(graphics, 0, rectangle.x + rectangle.width / 2, rectangle.y + 5);
                this.drawSymbol(graphics, 1, rectangle.x + 5, rectangle.y + rectangle.height / 2);
                this.drawSymbol(graphics, 2, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height - 10);
                this.drawSymbol(graphics, 3, rectangle.x + rectangle.width - 5, rectangle.y + rectangle.height / 2);
            }
        }

        protected void drawSymbol(Graphics graphics, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(n3, n4);
            if (n2 >= 4) {
                Polygon polygon = new Polygon();
                if (n2 == 4) {
                    polygon.addPoint(0, 0);
                    polygon.addPoint(4, 0);
                    polygon.addPoint(4, 2);
                    polygon.addPoint(11, 2);
                    polygon.addPoint(11, 9);
                    polygon.addPoint(0, 9);
                } else if (n2 == 5) {
                    polygon.addPoint(0, 2);
                    polygon.addPoint(3, 2);
                    polygon.addPoint(3, 0);
                    polygon.addPoint(7, 0);
                    polygon.addPoint(7, 2);
                    polygon.addPoint(11, 2);
                    polygon.addPoint(11, 9);
                    polygon.addPoint(0, 9);
                } else if (n2 == 6) {
                    polygon.addPoint(0, 2);
                    polygon.addPoint(7, 2);
                    polygon.addPoint(7, 0);
                    polygon.addPoint(11, 0);
                    polygon.addPoint(11, 9);
                    polygon.addPoint(0, 9);
                }
                graphics2D.translate(-6, -6);
                graphics2D.setColor(this.getBackground());
                graphics2D.fillPolygon(polygon);
                graphics2D.setColor(this.getForeground());
                graphics2D.drawPolygon(polygon);
            } else {
                Polygon polygon = new Polygon();
                polygon.addPoint(5, 0);
                polygon.addPoint(10, 5);
                polygon.addPoint(10, 6);
                polygon.addPoint(7, 6);
                polygon.addPoint(7, 10);
                polygon.addPoint(3, 10);
                polygon.addPoint(3, 6);
                polygon.addPoint(0, 6);
                polygon.addPoint(0, 5);
                Point point = new Point();
                switch (n2) {
                    case 0: {
                        graphics2D.translate(-6, 5);
                        break;
                    }
                    case 1: {
                        graphics2D.rotate(-1.5707963267948966, 5.0, -1.0);
                        point.x = -1;
                        point.y = 1;
                        break;
                    }
                    case 2: {
                        graphics2D.rotate(Math.PI, 2.0, 0.0);
                        point.x = -1;
                        break;
                    }
                    case 3: {
                        graphics2D.rotate(1.5707963267948966, 0.0, -6.0);
                        point.x = 1;
                        point.y = -1;
                    }
                }
                graphics2D.setColor(this.getBackground());
                graphics2D.translate(point.x, point.y);
                graphics2D.fillPolygon(polygon);
                graphics2D.translate(-point.x, -point.y);
                graphics2D.setColor(this.getForeground());
                graphics2D.drawPolygon(polygon);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected class SourceMap
    extends JPanel {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Color obscuro;

        public SourceMap() {
            this.setOpaque(false);
            SystemColor systemColor = SystemColor.textHighlight;
            this.obscuro = new Color(systemColor.getRed(), systemColor.getGreen(), systemColor.getBlue(), 127);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.ui != null) {
                Rectangle rectangle = this.getBounds();
                Color color = graphics.getColor();
                graphics.setColor(this.obscuro);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(color);
            }
        }
    }

    public class FloatingFrame
    extends JFrame
    implements Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected int helpPanelID = 0;

        public FloatingFrame(String string) {
            super(string);
        }

        public void setHelpPanelID(int n2) {
            this.helpPanelID = n2;
        }

        public int getHelpPanelID() {
            return this.helpPanelID;
        }
    }

    protected class DragWindow
    extends JWindow
    implements Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Color borderColor = SystemColor.windowBorder;
        protected int orientation = MotifCommonToolBarUI.this.getToolBar().getOrientation();
        protected Point doffset;
        protected Point foffset;
        protected boolean dockable;
        protected String paneDesc;
        protected int index;
        protected Insets insets;
        protected Color tabColor;
        protected Color selectHigh;
        protected Color selectLow;
        protected BevelBorder rb;

        protected DragWindow(Frame frame) {
            super(frame);
            this.setCursor(hiddenCursor);
            this.insets = new Insets(2, 2, 2, 2);
            this.rb = new BevelBorder(0);
        }

        public void setForeground(Color color) {
            int n2 = color.getRed() + color.getGreen() + color.getBlue();
            if (n2 < 200) {
                color = this.lighter(color, 50);
            } else if (n2 > 565) {
                color = this.darker(color, 50);
            }
            super.setForeground(color);
            this.selectHigh = this.lighter(color, 35);
            this.selectLow = this.darker(color, 35);
            this.tabColor = n2 > 383 ? this.darker(color, 70) : this.lighter(color, 70);
        }

        public void setBackground(Color color) {
            super.setBackground(color);
        }

        public void setOrientation(int n2) {
            if (this.isShowing()) {
                if (n2 == this.orientation) {
                    return;
                }
                this.orientation = n2;
            }
        }

        public Point getOffset() {
            return this.dockable ? this.doffset : this.foffset;
        }

        public void setOffset(Point point) {
            if (this.dockable) {
                this.doffset = point;
            } else {
                this.foffset = point;
            }
        }

        public boolean isDockable() {
            return this.dockable;
        }

        public void setDockable(boolean bl) {
            this.dockable = bl;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public void setPanes(String string) {
            boolean bl = true;
            if (this.paneDesc != null && string != null) {
                bl = !this.paneDesc.equals(string);
            }
            this.paneDesc = string;
            if (bl) {
                this.repaint();
            }
        }

        public String getPanes() {
            return this.paneDesc;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void paint(Graphics graphics) {
            Object object;
            super.paint(graphics);
            Color color = graphics.getColor();
            graphics.setColor(((Component)this).getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.dockable && this.paneDesc != null && this.paneDesc.length() > 0) {
                object = new StringTokenizer(this.paneDesc, "[];HVCEWNSTBLRewnstblr", true);
                Vector<String> vector = new Vector<String>();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    if ("ewns".indexOf(string) > -1 && ((StringTokenizer)object).hasMoreTokens()) {
                        vector.addElement(string + ((StringTokenizer)object).nextToken());
                        continue;
                    }
                    vector.addElement(string);
                }
                this.index = 0;
                this.paintPane(graphics, vector, new Rectangle(3, 3, dimension.width - 6, dimension.height - 6));
            }
            graphics.setColor(this.rb.getHighlightOuterColor(this));
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.drawLine(1, 0, dimension.width - 1, 0);
            graphics.setColor(this.rb.getShadowOuterColor(this));
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 2);
            graphics.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
            graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, dimension.height - 3);
            graphics.setColor(this.rb.getShadowInnerColor(this));
            graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 3);
            graphics.drawLine(2, 2, 2, dimension.height - 3);
            graphics.drawLine(3, 2, dimension.width - 3, 2);
            if (MotifCommonToolBarUI.this.dockingWindow && this.dockable) {
                object = new Color(255 - this.getBorderColor().getRed(), 255 - this.getBorderColor().getGreen(), 255 - this.getBorderColor().getBlue());
                graphics.setColor((Color)object);
                graphics.drawLine(0, 0, 0, 5);
                graphics.drawLine(0, 0, 5, 0);
                graphics.setColor(this.getBorderColor());
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(1, 2, 2, 1);
                graphics.drawLine(1, 3, 3, 1);
                graphics.drawLine(1, 4, 4, 1);
            }
            graphics.setColor(color);
        }

        protected void paintPane(Graphics graphics, Vector vector, Rectangle rectangle) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            String string = "0";
            char c2 = '\u0000';
            char c3 = '\u0000';
            float f2 = 0.5f;
            int n2 = 0;
            Rectangle rectangle2 = null;
            while (bl2 && this.index < vector.size()) {
                String string2 = (String)vector.get(this.index);
                c2 = string2.charAt(0);
                switch (c2) {
                    case '[': {
                        Rectangle rectangle3;
                        if (!bl3 && bl2) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                            rectangle3 = bl ? new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2) : new Rectangle(rectangle.x, rectangle.y, n2, rectangle.height);
                            ++this.index;
                            this.paintPane(graphics, vector, rectangle3);
                        }
                        bl3 = true;
                        break;
                    }
                    case 'H': {
                        bl = false;
                        bl3 = false;
                        break;
                    }
                    case 'V': {
                        bl = true;
                        bl3 = false;
                        break;
                    }
                    case 'C': {
                        if (n2 == 0) {
                            this.fillArea(graphics, rectangle);
                            c3 = '\u0000';
                            bl2 = false;
                            break;
                        }
                        c3 = c2;
                        string = string2;
                        break;
                    }
                    case 'e': 
                    case 'n': 
                    case 's': 
                    case 'w': {
                        if (n2 == 0) {
                            this.fillArea(graphics, rectangle);
                            c3 = '\u0000';
                            if (rectangle.x > 3) {
                                --rectangle.x;
                            }
                            if (rectangle.y > 3) {
                                --rectangle.y;
                            }
                            this.drawTabs(graphics, rectangle, string2);
                            bl2 = false;
                            break;
                        }
                        c3 = c2;
                        string = string2;
                        break;
                    }
                    case 'E': 
                    case 'N': 
                    case 'S': 
                    case 'W': {
                        boolean bl4;
                        if (n2 == 0) {
                            int n3 = 0;
                            bl4 = false;
                            switch (c2) {
                                case 'N': {
                                    bl4 = true;
                                    n3 = rectangle.height - rectangle.height / 2;
                                    rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n3);
                                    break;
                                }
                                case 'S': {
                                    bl4 = true;
                                    n3 = rectangle.height - rectangle.height / 2;
                                    rectangle2 = new Rectangle(rectangle.x, rectangle.y + n3, rectangle.width, n3);
                                    --n3;
                                    break;
                                }
                                case 'E': {
                                    bl4 = false;
                                    n3 = rectangle.width - rectangle.width / 2;
                                    rectangle2 = new Rectangle(rectangle.x + n3, rectangle.y, n3, rectangle.height);
                                    --n3;
                                    break;
                                }
                                case 'W': {
                                    bl4 = false;
                                    n3 = rectangle.width - rectangle.width / 2;
                                    rectangle2 = new Rectangle(rectangle.x, rectangle.y, n3, rectangle.height);
                                }
                            }
                            this.fillArea(graphics, rectangle2);
                            c3 = '\u0000';
                            this.drawSplitter(graphics, rectangle, bl4, n3);
                            bl2 = false;
                            break;
                        }
                        c3 = c2;
                        string = string2;
                        break;
                    }
                    case 'T': {
                        if (!bl3) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                        }
                        vector.insertElementAt("[", this.index + 1);
                        vector.insertElementAt("V", this.index + 2);
                        vector.insertElementAt("0.333", this.index + 3);
                        vector.insertElementAt("C", this.index + 4);
                        vector.insertElementAt(";", this.index + 5);
                        vector.addElement("]");
                        break;
                    }
                    case 'B': {
                        if (!bl3) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                        }
                        int n4 = this.findMatchingClose(vector, this.index + 1);
                        vector.insertElementAt("[", this.index + 1);
                        vector.insertElementAt("V", this.index + 2);
                        vector.insertElementAt("0.667", this.index + 3);
                        vector.insertElementAt(";", n4 + 4);
                        vector.insertElementAt("C", n4 + 5);
                        vector.insertElementAt("]", n4 + 6);
                        break;
                    }
                    case 'L': {
                        if (!bl3) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                        }
                        vector.insertElementAt("[", this.index + 1);
                        vector.insertElementAt("H", this.index + 2);
                        vector.insertElementAt("0.333", this.index + 3);
                        vector.insertElementAt("C", this.index + 4);
                        vector.insertElementAt(";", this.index + 5);
                        vector.addElement("]");
                        break;
                    }
                    case 'R': {
                        if (!bl3) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                        }
                        int n4 = this.findMatchingClose(vector, this.index + 1);
                        vector.insertElementAt("[", this.index + 1);
                        vector.insertElementAt("H", this.index + 2);
                        vector.insertElementAt("0.667", this.index + 3);
                        vector.insertElementAt(";", n4 + 4);
                        vector.insertElementAt("C", n4 + 5);
                        vector.insertElementAt("]", n4 + 6);
                        break;
                    }
                    case ';': {
                        boolean bl4;
                        if (!bl3) {
                            this.drawSplitter(graphics, rectangle, bl, n2);
                        }
                        Rectangle rectangle3 = bl ? new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2) : new Rectangle(rectangle.x, rectangle.y, n2, rectangle.height);
                        if (c3 != '\u0000' && n2 > 0) {
                            if (c3 == 'C') {
                                this.fillArea(graphics, rectangle3);
                                c3 = '\u0000';
                                rectangle3 = bl ? new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height - n2) : new Rectangle(rectangle.x + n2, rectangle.y, rectangle.width - n2, rectangle.height);
                                ++this.index;
                                this.paintPane(graphics, vector, rectangle3);
                            } else {
                                int n5 = 0;
                                bl4 = false;
                                switch (c3) {
                                    case 'e': 
                                    case 'n': 
                                    case 's': 
                                    case 'w': {
                                        this.fillArea(graphics, rectangle3);
                                        if (rectangle3.x > 3) {
                                            --rectangle3.x;
                                        }
                                        if (rectangle3.y > 3) {
                                            --rectangle3.y;
                                        }
                                        this.drawTabs(graphics, rectangle3, string);
                                        c3 = '\u0000';
                                        break;
                                    }
                                    case 'E': 
                                    case 'N': 
                                    case 'S': 
                                    case 'W': {
                                        switch (c3) {
                                            case 'N': {
                                                bl4 = true;
                                                n5 = rectangle3.height - rectangle3.height / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y + 1, rectangle3.width, n5);
                                                break;
                                            }
                                            case 'S': {
                                                bl4 = true;
                                                n5 = rectangle3.height - rectangle3.height / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y + n5, rectangle3.width, n5);
                                                --n5;
                                                break;
                                            }
                                            case 'E': {
                                                bl4 = false;
                                                n5 = rectangle3.width - rectangle3.width / 2;
                                                rectangle2 = new Rectangle(rectangle3.x + n5, rectangle3.y, n5, rectangle3.height);
                                                --n5;
                                                break;
                                            }
                                            case 'W': {
                                                bl4 = false;
                                                n5 = rectangle3.width - rectangle3.width / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y, n5, rectangle3.height);
                                            }
                                        }
                                        this.fillArea(graphics, rectangle2);
                                        c3 = '\u0000';
                                        this.drawSplitter(graphics, rectangle3, bl4, n5);
                                    }
                                }
                            }
                        }
                        if (this.index >= vector.size() - 1 || ((String)vector.get(this.index + 1)).equals("]")) break;
                        rectangle3 = bl ? new Rectangle(rectangle.x, rectangle.y + n2 + 1, rectangle.width, rectangle.height - n2 - 1) : new Rectangle(rectangle.x + n2 + 1, rectangle.y, rectangle.width - n2 - 1, rectangle.height);
                        ++this.index;
                        this.paintPane(graphics, vector, rectangle3);
                        break;
                    }
                    case ']': {
                        Rectangle rectangle3;
                        if (c3 != '\u0000') {
                            rectangle3 = bl ? new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height - n2) : new Rectangle(rectangle.x + n2, rectangle.y, rectangle.width - n2, rectangle.height);
                            if (c3 == 'C') {
                                this.fillArea(graphics, rectangle3);
                                c3 = '\u0000';
                            } else {
                                int n6 = 0;
                                switch (c3) {
                                    case 'e': 
                                    case 'n': 
                                    case 's': 
                                    case 'w': {
                                        this.fillArea(graphics, rectangle3);
                                        if (rectangle3.x > 3) {
                                            --rectangle3.x;
                                        }
                                        if (rectangle3.y > 3) {
                                            --rectangle3.y;
                                        }
                                        this.drawTabs(graphics, rectangle3, string);
                                        c3 = '\u0000';
                                        break;
                                    }
                                    case 'E': 
                                    case 'N': 
                                    case 'S': 
                                    case 'W': {
                                        switch (c3) {
                                            case 'N': {
                                                bl = true;
                                                n6 = rectangle3.height - rectangle3.height / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, n6);
                                                break;
                                            }
                                            case 'S': {
                                                bl = true;
                                                n6 = rectangle3.height - rectangle3.height / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y + n6, rectangle3.width, n6);
                                                --n6;
                                                break;
                                            }
                                            case 'E': {
                                                bl = false;
                                                n6 = rectangle3.width - rectangle3.width / 2;
                                                rectangle2 = new Rectangle(rectangle3.x + n6, rectangle3.y, n6, rectangle3.height);
                                                --n6;
                                                break;
                                            }
                                            case 'W': {
                                                bl = false;
                                                n6 = rectangle3.width - rectangle3.width / 2;
                                                rectangle2 = new Rectangle(rectangle3.x, rectangle3.y, n6, rectangle3.height);
                                            }
                                        }
                                        this.fillArea(graphics, rectangle2);
                                        this.drawSplitter(graphics, rectangle3, bl, n6);
                                        c3 = '\u0000';
                                    }
                                }
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    case '0': {
                        try {
                            f2 = Float.parseFloat(string2);
                            if (bl) {
                                n2 = Math.round(f2 * (float)rectangle.height);
                                break;
                            }
                            n2 = Math.round(f2 * (float)rectangle.width);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("MotifCommonToolBar$DragWindow.paint: Internal error: NumberFormatException.");
                        }
                    }
                }
                if (!bl2) continue;
                ++this.index;
            }
        }

        protected void fillArea(Graphics graphics, Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.getForeground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(this.selectHigh);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            graphics.setColor(this.selectLow);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(color);
        }

        protected int findMatchingClose(Vector vector, int n2) {
            int n3 = 0;
            int n4 = vector.size();
            while (n2 < n4) {
                if (vector.get(n2).equals("[")) {
                    ++n3;
                } else if (vector.get(n2).equals("]")) {
                    --n3;
                }
                if (n3 == 0) {
                    return n2;
                }
                ++n2;
            }
            return n4 - 1;
        }

        protected void drawSplitter(Graphics graphics, Rectangle rectangle, boolean bl, int n2) {
            graphics.setColor(this.getBorderColor());
            if (bl) {
                graphics.drawLine(rectangle.x, rectangle.y + n2, rectangle.x + rectangle.width, rectangle.y + n2);
            } else {
                graphics.drawLine(rectangle.x + n2, rectangle.y, rectangle.x + n2, rectangle.y + rectangle.height);
            }
        }

        protected Color lighter(Color color, int n2) {
            return new Color(Math.min(color.getRed() + n2, 255), Math.min(color.getGreen() + n2, 255), Math.min(color.getBlue() + n2, 255));
        }

        protected Color darker(Color color, int n2) {
            return new Color(Math.max(color.getRed() - n2, 0), Math.max(color.getGreen() - n2, 0), Math.max(color.getBlue() - n2, 0));
        }

        protected void drawTabs(Graphics graphics, Rectangle rectangle, String string) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            char c2 = string.charAt(0);
            int n8 = 0;
            int n9 = 1;
            int n10 = 0;
            if (string.length() > 1) {
                try {
                    n7 = string.indexOf(47);
                    n8 = Integer.parseInt(string.substring(1, n7));
                    if (n7 > -1 && string.length() > n7 + 1) {
                        try {
                            n9 = Integer.parseInt(string.substring(n7 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            n9 = 1;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n8 = 0;
                }
            }
            n7 = 8;
            int n11 = 8;
            int n12 = 0;
            int n13 = 0;
            Color color = graphics.getColor();
            SystemColor systemColor = SystemColor.control;
            graphics.setColor(systemColor);
            Polygon[] polygonArray = null;
            Point[] pointArray = null;
            Point[] pointArray2 = null;
            Point[] pointArray3 = null;
            Point[] pointArray4 = new Point[4];
            if (c2 == 'n') {
                n11 = rectangle.width / (n9 + 1);
                if (n11 < (n7 = Math.min(n7, rectangle.height / 2))) {
                    n11 = rectangle.width / 2;
                    n9 = 1;
                }
                polygonArray = new Polygon[n9];
                pointArray = new Point[6];
                pointArray2 = new Point[8];
                pointArray3 = new Point[2];
                n10 = Math.min(n9, n8);
                n12 = n11;
                n6 = rectangle.x > 3 ? rectangle.x + 1 : rectangle.x;
                n5 = rectangle.y > 3 ? rectangle.y + 1 : rectangle.y;
                n4 = rectangle.x + rectangle.width;
                n13 = 0;
                while (n13 < n10) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n6, n5);
                    polygonArray[n13].addPoint(rectangle.x + n12 + 1, n5);
                    polygonArray[n13].addPoint(rectangle.x + n12, rectangle.y + n7);
                    polygonArray[n13].addPoint(n6, rectangle.y + n7);
                    n12 += n11;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[0] = new Point(rectangle.x + n11, rectangle.y);
                    pointArray[1] = new Point(n4 - 1, rectangle.y);
                    pointArray2[0] = new Point(rectangle.x + n11 + 2, rectangle.y + 1);
                    pointArray2[1] = new Point(n4 - 2, rectangle.y + 1);
                    pointArray2[2] = new Point(rectangle.x + n11 + 1, rectangle.y);
                    pointArray2[3] = new Point(rectangle.x + n11, rectangle.y + n7);
                    pointArray2[4] = new Point(rectangle.x + 1, rectangle.y + n7 + 1);
                    pointArray2[5] = new Point(rectangle.x + n12 - n11, rectangle.y + n7 + 1);
                } else {
                    pointArray[0] = new Point(rectangle.x + n12 - n11, rectangle.y);
                    pointArray[1] = new Point(rectangle.x + n12 - 1, rectangle.y);
                    pointArray2[0] = new Point(rectangle.x + n12 - n11 + 2, rectangle.y + 1);
                    pointArray2[1] = new Point(rectangle.x + n12 - 2, rectangle.y + 1);
                    if (n10 > 0) {
                        pointArray2[2] = new Point(rectangle.x + n12 - n11 + 2, rectangle.y);
                        pointArray2[3] = new Point(rectangle.x + n12 - n11 + 1, rectangle.y + n7);
                    }
                    if (n10 < n9) {
                        pointArray3[0] = new Point(rectangle.x + n12 - 2, rectangle.y);
                        pointArray3[1] = new Point(rectangle.x + n12 - 1, rectangle.y + n7);
                    }
                    if (n10 > 0) {
                        pointArray2[4] = new Point(rectangle.x + 1, rectangle.y + n7 + 1);
                        pointArray2[5] = new Point(rectangle.x + n12 - n11 + 1, rectangle.y + n7 + 1);
                    }
                }
                if (n10 < n9) {
                    pointArray2[6] = new Point(rectangle.x + n12 - 1, rectangle.y + n7 + 1);
                    pointArray2[7] = new Point(n4 - 1, rectangle.y + n7 + 1);
                }
                n13 = n10;
                while (n13 < n9 - 1) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(rectangle.x + n12 - 1, rectangle.y);
                    polygonArray[n13].addPoint(rectangle.x + n12 + n11 - 1, rectangle.y);
                    polygonArray[n13].addPoint(rectangle.x + n12 + n11, rectangle.y + n7);
                    polygonArray[n13].addPoint(rectangle.x + n12, rectangle.y + n7);
                    n12 += n11;
                    ++n13;
                }
                if (n10 < n9) {
                    polygonArray[n9 - 1] = new Polygon();
                    n5 = rectangle.y > 3 ? rectangle.y + 1 : rectangle.y;
                    polygonArray[n9 - 1].addPoint(rectangle.x + n12 - 1, n5);
                    polygonArray[n9 - 1].addPoint(n4, n5);
                    polygonArray[n9 - 1].addPoint(n4, rectangle.y + n7 + 1);
                    polygonArray[n9 - 1].addPoint(rectangle.x + n12, rectangle.y + n7 + 1);
                    n12 += n11;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[2] = new Point(rectangle.x + n12 - n11, rectangle.y);
                    pointArray[3] = new Point(rectangle.x + n12 - n11 - 1, rectangle.y + n7);
                    pointArray[4] = new Point(rectangle.x, rectangle.y + n7);
                    pointArray[5] = new Point(rectangle.x + n12 - n11 - 1, rectangle.y + n7);
                } else {
                    pointArray[2] = new Point(rectangle.x + n12 - n11 - 1, rectangle.y);
                    pointArray[3] = new Point(rectangle.x + n12 - n11, rectangle.y + n7);
                    pointArray[4] = new Point(rectangle.x + n12 - n11, rectangle.y + n7);
                    pointArray[5] = new Point(n4, rectangle.y + n7);
                }
            } else if (c2 == 's') {
                n11 = rectangle.width / (n9 + 1);
                if (n11 < (n7 = Math.min(n7, rectangle.height / 2))) {
                    n11 = rectangle.width / 2;
                    n9 = 1;
                }
                polygonArray = new Polygon[n9];
                pointArray = new Point[6];
                pointArray2 = new Point[2];
                pointArray3 = new Point[8];
                n10 = Math.min(n9, n8);
                n12 = n11;
                n6 = rectangle.x > 3 ? rectangle.x + 1 : rectangle.x;
                n5 = rectangle.y > 3 ? rectangle.y + 1 : rectangle.y;
                n4 = rectangle.x + rectangle.width;
                n3 = rectangle.y + rectangle.height;
                int n14 = n3 < this.getSize().height - 4 ? n3 + 1 : n3;
                n13 = 0;
                while (n13 < n10) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n6, n3 - n7);
                    polygonArray[n13].addPoint(rectangle.x + n12 - 1, n3 - n7);
                    if (n9 == 1 && n10 == 1) {
                        polygonArray[n13].addPoint(rectangle.x + n12, n14);
                        polygonArray[n13].addPoint(n6, n14);
                    } else {
                        polygonArray[n13].addPoint(rectangle.x + n12, n3);
                        polygonArray[n13].addPoint(n6, n3);
                    }
                    n12 += n11;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[0] = new Point(rectangle.x + n11, n3);
                    pointArray[1] = new Point(n4 - 1, n3);
                    pointArray3[0] = new Point(rectangle.x + n11 + 2, n3 - 1);
                    pointArray3[1] = new Point(n4 - 2, n3 - 1);
                    pointArray2[0] = new Point(rectangle.x + n11, n3 - n7 - 1);
                    pointArray2[1] = new Point(rectangle.x + n11 + 1, n3 - 1);
                    pointArray3[4] = new Point(rectangle.x + 1, n3 - n7 - 1);
                    pointArray3[5] = new Point(rectangle.x + n12 - n11, n3 - n7 - 1);
                } else {
                    pointArray[0] = new Point(rectangle.x + n12 - n11, n3);
                    pointArray[1] = new Point(rectangle.x + n12 - 1, n3);
                    pointArray3[0] = new Point(rectangle.x + n12 - n11 + 2, n3 - 1);
                    pointArray3[1] = new Point(rectangle.x + n12 - 2, n3 - 1);
                    if (n10 > 0) {
                        pointArray2[0] = new Point(rectangle.x + n12 - n11, n3 - n7);
                        pointArray2[1] = new Point(rectangle.x + n12 - n11 + 1, n3 - 1);
                    }
                    if (n10 < n9) {
                        pointArray3[2] = new Point(rectangle.x + n12, n3 - n7);
                        pointArray3[3] = new Point(rectangle.x + n12 - 1, n3);
                    }
                    if (n10 > 0) {
                        pointArray3[4] = new Point(rectangle.x + 1, n3 - n7 - 1);
                        pointArray3[5] = new Point(rectangle.x + n12 - n11, n3 - n7 - 1);
                    }
                }
                if (n10 < n9) {
                    pointArray3[6] = new Point(rectangle.x + n12, n3 - n7 - 1);
                    pointArray3[7] = new Point(n4 - 1, n3 - n7 - 1);
                }
                n13 = n10;
                while (n13 < n9) {
                    n5 = n3;
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(rectangle.x + n12 + 1, n5 - n7);
                    polygonArray[n13].addPoint(n4, n5 - n7);
                    polygonArray[n13].addPoint(n4, n5);
                    polygonArray[n13].addPoint(rectangle.x + n12, n5);
                    n12 += n11;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[2] = new Point(rectangle.x + n12 - n11 - 1, n3 - n7 - 1);
                    pointArray[3] = new Point(rectangle.x + n12 - n11, n3 - 1);
                    pointArray[4] = new Point(rectangle.x, n3 - n7);
                    pointArray[5] = new Point(rectangle.x + n12 - n11 - 2, n3 - n7);
                } else {
                    pointArray[2] = new Point(rectangle.x + n12 - n11 + 1, n3 - n7);
                    pointArray[3] = new Point(rectangle.x + n12 - n11, n3);
                    pointArray[4] = new Point(rectangle.x + n12 - n11 + 1, n3 - n7);
                    pointArray[5] = new Point(n4, n3 - n7);
                }
            } else if (c2 == 'w') {
                n7 = rectangle.height / (n9 + 1);
                if (n7 < (n11 = Math.min(n11, rectangle.width / 2))) {
                    n7 = rectangle.height / 2;
                    n9 = 1;
                }
                polygonArray = new Polygon[n9];
                pointArray = new Point[6];
                pointArray2 = new Point[8];
                pointArray3 = new Point[2];
                n10 = Math.min(n9, n8);
                n12 = n7;
                n6 = rectangle.x > 3 ? rectangle.x + 1 : rectangle.x;
                n4 = rectangle.x + rectangle.width;
                n2 = n4 < this.getSize().width - 4 ? n4 + 1 : n4;
                n3 = rectangle.y + rectangle.height;
                n5 = rectangle.y > 3 ? rectangle.y + 1 : rectangle.y;
                n13 = 0;
                while (n13 < n10) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n6, n5);
                    polygonArray[n13].addPoint(rectangle.x + n11, n5);
                    polygonArray[n13].addPoint(rectangle.x + n11, rectangle.y + n12);
                    polygonArray[n13].addPoint(n6, rectangle.y + n12 + 1);
                    n12 += n7;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[0] = new Point(rectangle.x, rectangle.y + n7 + 1);
                    pointArray[1] = new Point(rectangle.x, rectangle.y + rectangle.height - 1);
                    pointArray2[0] = new Point(rectangle.x + 1, rectangle.y + n7 + 2);
                    pointArray2[1] = new Point(rectangle.x + 1, rectangle.y + rectangle.height - 1);
                    pointArray2[2] = new Point(n6, rectangle.y + n7 + 2);
                    pointArray2[3] = new Point(n6 + n11, rectangle.y + n7 + 1);
                    pointArray2[4] = new Point(n6 + n11 + 1, rectangle.y + 1);
                    pointArray2[5] = new Point(n6 + n11 + 1, rectangle.y + n7);
                } else {
                    pointArray[0] = new Point(rectangle.x, rectangle.y + n12 - n7 + 1);
                    pointArray[1] = new Point(rectangle.x, rectangle.y + n12 - 1);
                    pointArray2[0] = new Point(rectangle.x + 1, rectangle.y + n12 - n7 + 2);
                    pointArray2[1] = new Point(rectangle.x + 1, rectangle.y + n12 - 2);
                    if (n10 > 0) {
                        pointArray2[2] = new Point(n6, rectangle.y + n12 - n7 + 2);
                        pointArray2[3] = new Point(n6 + n11, rectangle.y + n12 - n7 + 1);
                    }
                    if (n10 < n9) {
                        pointArray3[0] = new Point(n6, n5 + n12 - 1);
                        pointArray3[1] = new Point(n6 + n11, n5 + n12);
                    }
                    if (n10 > 0) {
                        pointArray2[4] = new Point(n6 + n11 + 1, rectangle.y + 1);
                        pointArray2[5] = new Point(n6 + n11 + 1, rectangle.y + n12 - n7);
                    }
                }
                if (n10 < n9) {
                    pointArray2[6] = new Point(n6 + n11 + 1, rectangle.y + n12);
                    pointArray2[7] = new Point(n6 + n11 + 1, rectangle.y + rectangle.height - 1);
                }
                n13 = n10;
                while (n13 < n9 - 1) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n6, rectangle.y + n12 - 1);
                    polygonArray[n13].addPoint(n6 + n11, rectangle.y + n12);
                    polygonArray[n13].addPoint(n6 + n11, rectangle.y + rectangle.height);
                    polygonArray[n13].addPoint(n6, rectangle.y + rectangle.height);
                    n12 += n7;
                    ++n13;
                }
                if (n10 < n9) {
                    polygonArray[n9 - 1] = new Polygon();
                    polygonArray[n9 - 1].addPoint(n6, n5 + n12 - 1);
                    polygonArray[n9 - 1].addPoint(n6 + n11, n5 + n12);
                    polygonArray[n9 - 1].addPoint(n6 + n11, n5 + rectangle.height);
                    polygonArray[n9 - 1].addPoint(n6, n5 + rectangle.height);
                    n12 += n7;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[2] = new Point(n6, rectangle.y + n12 - n7 + 1);
                    pointArray[3] = new Point(n6 + n11 - 1, rectangle.y + n12 - n7);
                    pointArray[4] = new Point(n6 + n11, rectangle.y);
                    pointArray[5] = new Point(n6 + n11, rectangle.y + n12 - n7);
                } else {
                    pointArray[2] = new Point(n6, rectangle.y + n12 - n7);
                    pointArray[3] = new Point(n6 + n11, rectangle.y + n12 - n7 + 1);
                    pointArray[4] = new Point(n6 + n11, rectangle.y + n12 - n7);
                    pointArray[5] = new Point(n6 + n11, rectangle.y + rectangle.height);
                }
            } else if (c2 == 'e') {
                n7 = rectangle.height / (n9 + 1);
                if (n7 < (n11 = Math.min(n11, rectangle.width / 2))) {
                    n7 = rectangle.height / 2;
                    n9 = 1;
                }
                polygonArray = new Polygon[n9];
                pointArray = new Point[6];
                pointArray2 = new Point[2];
                pointArray3 = new Point[8];
                n10 = Math.min(n9, n8);
                n12 = n7;
                n4 = rectangle.x + rectangle.width;
                n2 = n4 < this.getSize().width - 4 ? n4 + 1 : n4;
                n3 = rectangle.y + rectangle.height;
                n5 = rectangle.y > 3 ? rectangle.y + 1 : rectangle.y;
                n13 = 0;
                while (n13 < n10) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n4 - n11, n5);
                    polygonArray[n13].addPoint(n4, n5);
                    polygonArray[n13].addPoint(n4, n5 + n12);
                    polygonArray[n13].addPoint(n4 - n11, n5 + n12 - 1);
                    n12 += n7;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[0] = new Point(n2 - 1, rectangle.y + n7 + 1);
                    pointArray[1] = new Point(n2 - 1, n3);
                    pointArray3[0] = new Point(n2 - 2, rectangle.y + n7 + 2);
                    pointArray3[1] = new Point(n2 - 2, n3 - 1);
                    pointArray2[0] = new Point(n2, rectangle.y + n7 + 2);
                    pointArray2[1] = new Point(n2 - n11, rectangle.y + n7 + 1);
                    pointArray3[2] = new Point(n4 - n11 - 1, rectangle.y + 1);
                    pointArray3[3] = new Point(n4 - n11 - 1, rectangle.y + n7);
                } else {
                    pointArray[0] = new Point(n2 - 1, rectangle.y + n12 - n7);
                    pointArray[1] = new Point(n2 - 1, rectangle.y + n12 - 1);
                    pointArray3[0] = new Point(n2 - 2, rectangle.y + n12 - n7 + 1);
                    pointArray3[1] = new Point(n2 - 2, rectangle.y + n12 - 2);
                    if (n10 > 0) {
                        pointArray2[0] = new Point(n2 - n11, rectangle.y + n12 - n7);
                        pointArray2[1] = new Point(n2, rectangle.y + n12 - n7 + 1);
                    }
                    if (n10 < n9) {
                        pointArray3[2] = new Point(n4 - n11, rectangle.y + n12 - 1);
                        pointArray3[3] = new Point(n4 - 1, rectangle.y + n12 - 2);
                    }
                    if (n10 > 0) {
                        pointArray3[4] = new Point(n4 - n11 - 1, rectangle.y + 1);
                        pointArray3[5] = new Point(n4 - n11 - 1, rectangle.y + n7);
                    }
                }
                if (n10 < n9) {
                    pointArray3[6] = new Point(n4 - n11 - 1, rectangle.y + n12);
                    pointArray3[7] = new Point(n4 - n11 - 1, n3 - 1);
                }
                n4 = rectangle.x + rectangle.width;
                n13 = n10;
                while (n13 < n9) {
                    polygonArray[n13] = new Polygon();
                    polygonArray[n13].addPoint(n4 - n11, rectangle.y + n12);
                    polygonArray[n13].addPoint(n4, rectangle.y + n12 - 1);
                    polygonArray[n13].addPoint(n4, n3);
                    polygonArray[n13].addPoint(n4 - n11, n3);
                    n12 += n7;
                    ++n13;
                }
                if (n9 == 1 && n10 == 1) {
                    pointArray[2] = new Point(n4 - n11, rectangle.y + n12 - n7);
                    pointArray[3] = new Point(n4, rectangle.y + n12 - n7 + 1);
                    pointArray[4] = new Point(n4 - n11, rectangle.y);
                    pointArray[5] = new Point(n4 - n11, rectangle.y + n12 - n7);
                } else {
                    pointArray[2] = new Point(n4 - n11, rectangle.y + n12 - n7);
                    pointArray[3] = new Point(n4 - 1, rectangle.y + n12 - n7 - 1);
                    pointArray[4] = new Point(n4 - n11, rectangle.y + n12 - n7);
                    pointArray[5] = new Point(n4 - n11, n3);
                }
            }
            if (polygonArray != null && polygonArray.length > 0) {
                n13 = n10 - 1;
                while (n13 >= 0) {
                    if (n13 < polygonArray.length - 1) {
                        graphics.setColor(this.tabColor);
                    } else {
                        graphics.setColor(systemColor);
                    }
                    graphics.fillPolygon(polygonArray[n13]);
                    if (n10 != 1 || n9 != 1) {
                        graphics.setColor(this.getBorderColor());
                        graphics.drawPolygon(polygonArray[n13]);
                    }
                    --n13;
                }
                n13 = n10;
                while (n13 < polygonArray.length) {
                    if (n13 < polygonArray.length - 1) {
                        graphics.setColor(this.tabColor);
                        graphics.fillPolygon(polygonArray[n13]);
                    } else {
                        graphics.setColor(((Component)this).getBackground());
                        graphics.fillPolygon(polygonArray[n13]);
                    }
                    ++n13;
                }
                n13 = n10;
                while (n13 < polygonArray.length - 1) {
                    graphics.setColor(this.getBorderColor());
                    graphics.drawPolygon(polygonArray[n13]);
                    ++n13;
                }
                int n15 = 0;
                if (pointArray2 != null) {
                    graphics.setColor(this.selectHigh);
                    while (n15 < pointArray2.length) {
                        if (pointArray2[n15] != null) {
                            graphics.drawLine(pointArray2[n15].x, pointArray2[n15].y, pointArray2[n15 + 1].x, pointArray2[n15 + 1].y);
                        }
                        n15 += 2;
                    }
                }
                if (pointArray3 != null) {
                    n15 = 0;
                    graphics.setColor(this.selectLow);
                    while (n15 < pointArray3.length) {
                        if (pointArray3[n15] != null) {
                            graphics.drawLine(pointArray3[n15].x, pointArray3[n15].y, pointArray3[n15 + 1].x, pointArray3[n15 + 1].y);
                        }
                        n15 += 2;
                    }
                }
                if (pointArray != null) {
                    n15 = 0;
                    graphics.setColor(this.getBorderColor());
                    while (n15 < pointArray.length) {
                        if (pointArray[n15] != null) {
                            graphics.drawLine(pointArray[n15].x, pointArray[n15].y, pointArray[n15 + 1].x, pointArray[n15 + 1].y);
                        }
                        n15 += 2;
                    }
                }
            } else {
                graphics.setColor(this.getBorderColor());
            }
            graphics.setColor(color);
        }

        public Insets getInsets() {
            return this.insets;
        }

        private void dumpPoly(Polygon polygon, Rectangle rectangle) {
            PathIterator pathIterator = polygon.getPathIterator(null);
            float[] fArray = new float[2];
            int n2 = pathIterator.currentSegment(fArray);
            while (n2 != 4) {
                if (rectangle != null) {
                    fArray[0] = fArray[0] - (float)rectangle.x;
                    fArray[1] = fArray[1] - (float)rectangle.y;
                }
                System.out.println("\t(" + (int)fArray[0] + "," + (int)fArray[1] + ")");
                pathIterator.next();
                n2 = pathIterator.currentSegment(fArray);
            }
        }
    }

    public class DockingListener
    implements MouseInputListener,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;
        protected Point dragOrigin;
        protected Point offset;

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component;
            if (!mouseEvent.isPopupTrigger() && (component = MotifCommonToolBarUI.this.getFocusableDescendent(this.toolBar)) != null) {
                component.requestFocus();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                if (!this.toolBar.isEnabled()) {
                    return;
                }
                this.isDragging = false;
                this.dragOrigin = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(this.dragOrigin, mouseEvent.getComponent());
                this.toolBar.setCursor(draggingHand);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                if (!this.toolBar.isEnabled()) {
                    return;
                }
                if (this.isDragging) {
                    Point point = mouseEvent.getPoint();
                    if (point != null) {
                        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                    }
                    if (this.origin != null && point != null) {
                        MotifCommonToolBarUI.this.floatAt(point, this.offset);
                    }
                }
                this.origin = null;
                this.isDragging = false;
                this.dragOrigin = null;
                this.toolBar.setCursor(grabbingHand);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.toolBar.setCursor(grabbingHand);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.toolBar.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (MotifCommonToolBarUI.this.robbyTimer != null && MotifCommonToolBarUI.this.robbyTimer.isRunning()) {
                MotifCommonToolBarUI.this.robbyTimer.stop();
            }
            this.isDragging = true;
            this.toolBar.setCursor(draggingHand);
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            if (this.origin == null) {
                if (!mouseEvent.getComponent().isShowing()) {
                    return;
                }
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
                this.offset = new Point(point.x - this.origin.x, point.y - this.origin.y);
            }
            if (this.dragOrigin != null && Math.abs(this.dragOrigin.x - point.x) + Math.abs(this.dragOrigin.y - point.y) > 20) {
                MotifCommonToolBarUI.this.dragTo(point, this.offset);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class DraggingListener
    implements ComponentListener,
    ActionListener,
    AWTEventListener,
    Serializable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected JFrame fFrame;
        protected JToolBar toolBar;
        protected Point origin = null;
        protected Dimension originalSize = null;
        protected Robot robby;
        protected boolean moveOnly;
        static /* synthetic */ Class class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarUI$FloatingFrame;

        public DraggingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
            this.moveOnly = false;
            if (!noRobot) {
                try {
                    this.robby = new Robot();
                }
                catch (AWTException aWTException) {
                    this.toolBar = null;
                    noRobot = true;
                }
            }
        }

        public boolean isMoveOnly() {
            return this.moveOnly;
        }

        public void addListener(JFrame jFrame) {
            if (this.toolBar == null) {
                return;
            }
            if (this.fFrame == null) {
                jFrame.addComponentListener(this);
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
                this.fFrame = jFrame;
            } else if (this.fFrame != jFrame) {
                this.fFrame.removeComponentListener(this);
                jFrame.addComponentListener(this);
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
                this.fFrame = jFrame;
            }
            if (this.fFrame.isShowing()) {
                this.origin = this.fFrame.getLocationOnScreen();
            }
            this.originalSize = this.fFrame.getSize();
        }

        public void removeListener(JFrame jFrame) {
            if (this.toolBar == null) {
                return;
            }
            if (this.fFrame != null && jFrame != null) {
                jFrame.removeComponentListener(this);
                this.fFrame = null;
            }
            if (this.robby != null) {
                this.robby.mouseRelease(16);
            }
            this.origin = null;
            this.originalSize = null;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            int n2;
            if (aWTEvent instanceof KeyEvent && (n2 = ((KeyEvent)aWTEvent).getKeyCode()) == 18) {
                int n3 = aWTEvent.getID();
                if (this.moveOnly && n3 == 402) {
                    this.moveOnly = false;
                } else if (!this.moveOnly && n3 == 401) {
                    this.moveOnly = true;
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.origin = null;
            this.originalSize = null;
            ((CommonToolBar)this.toolBar).setFloatingSize(this.toolBar.getSize());
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.toolBar == null || !this.toolBar.isEnabled()) {
                return;
            }
            Point point = null;
            if (!componentEvent.getComponent().isShowing()) {
                return;
            }
            point = componentEvent.getComponent().getLocationOnScreen();
            Dimension dimension = componentEvent.getComponent().getSize();
            if (this.origin != null) {
                int n2 = Math.abs(this.origin.x - point.x);
                int n3 = Math.abs(this.origin.y - point.y);
                if (n2 == 1 && n3 == 0 || n2 == 0 && n3 == 1 || n2 % 9 == 0 && n3 % 9 == 0) {
                    this.origin = point;
                } else {
                    if (MotifCommonToolBarUI.this.robbyTimer != null && MotifCommonToolBarUI.this.robbyTimer.isRunning()) {
                        MotifCommonToolBarUI.this.robbyTimer.stop();
                    }
                    int n4 = n2 + n3;
                    if (this.robby != null && this.origin != null && dimension.equals(this.originalSize) && n4 > 10 && n4 < 20) {
                        Point point2 = null;
                        if (!this.toolBar.isShowing()) {
                            return;
                        }
                        point2 = this.toolBar.getLocationOnScreen();
                        Dimension dimension2 = this.toolBar.getSize();
                        this.robby.mouseRelease(16);
                        if (MotifCommonToolBarUI.this.dockingWindow) {
                            this.robby.mouseMove(point2.x + dimension2.width / 2, point2.y + 3);
                        } else {
                            this.robby.mouseMove(point2.x + dimension2.width - 5, point2.y + dimension2.height / 2);
                        }
                        this.robby.mousePress(16);
                        if (MotifCommonToolBarUI.this.robbyTimer == null) {
                            MotifCommonToolBarUI.this.robbyTimer = new Timer(500, this);
                            MotifCommonToolBarUI.this.robbyTimer.setInitialDelay(500);
                            MotifCommonToolBarUI.this.robbyTimer.setRepeats(false);
                        }
                        MotifCommonToolBarUI.this.robbyTimer.start();
                    } else if (dimension.equals(this.originalSize) && n4 > 20) {
                        this.origin = null;
                        Point point3 = (Point)point.clone();
                        SwingUtilities.convertPointFromScreen(point3, MotifCommonToolBarUI.this.dockingSource);
                        if (!this.moveOnly && MotifCommonToolBarUI.this.canDock(MotifCommonToolBarUI.this.dockingSource, point3)) {
                            ((Component)MotifCommonToolBarUI.this.floatingFrame).setVisible(false);
                            MotifCommonToolBarUI.this.setFloatingLocation(point3.x, point3.y);
                            ((CommonToolBar)this.toolBar).setFloatingSize(this.toolBar.getSize());
                            MotifCommonToolBarUI.this.dragWindow.setPanes(((DockingArea)MotifCommonToolBarUI.this.dockingSource).getDockingPane().getClientDescription(componentEvent.getComponent(), (DockingArea)MotifCommonToolBarUI.this.dockingSource));
                            MotifCommonToolBarUI.this.setFloating(false, point3);
                        }
                    }
                }
            } else {
                if (componentEvent.getComponent().isShowing()) {
                    this.origin = componentEvent.getComponent().getLocationOnScreen();
                }
                this.originalSize = componentEvent.getComponent().getSize();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MotifCommonToolBarUI.this.robbyTimer) {
                Container container;
                this.robby.mouseRelease(16);
                if (this.toolBar != null && (container = SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarUI$FloatingFrame == null ? (class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarUI$FloatingFrame = DraggingListener.class$("com.ibm.db2.tools.common.plaf.motif.MotifCommonToolBarUI$FloatingFrame")) : class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarUI$FloatingFrame, this.toolBar)) != null) {
                    if (container.isShowing()) {
                        this.origin = container.getLocationOnScreen();
                    }
                    this.originalSize = container.getSize();
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

