/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf.motif;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.CommonToolBarButton;
import com.ibm.db2.tools.common.plaf.CommonToolBarButtonUI;
import com.ibm.db2.tools.common.support.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class MotifCommonToolBarButtonUI
extends CommonToolBarButtonUI
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static int borderShiftX = 0;
    protected static int borderShiftY = 0;
    protected static MotifCommonToolBarButtonUI tbuttonUI;
    protected static Border savedBorder;
    protected int textHorizontalMargin = 3;
    protected int iconShiftX = 0;
    protected int iconShiftY = 0;
    protected static Image borderUp;
    protected static Image borderDown;
    protected static Icon iborderUp;
    protected static Icon iborderDown;
    protected static boolean imagesLoaded;
    protected static boolean filtered;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarButtonUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (tbuttonUI == null) {
            tbuttonUI = new MotifCommonToolBarButtonUI();
            borderShiftX = 1;
            borderShiftY = 1;
        }
        return tbuttonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        CommonToolBarButton commonToolBarButton = (CommonToolBarButton)jComponent;
        savedBorder = jComponent.getBorder();
        commonToolBarButton.setBorder(null);
        this.iconShiftX = -1;
        this.iconShiftY = -1;
        this.defaultTextShiftOffset = 1;
        commonToolBarButton.setBorderPainted(false);
        this.defaultTextShiftOffset = 1;
        if (!imagesLoaded) {
            this.loadImages(true, jComponent);
            iborderUp = new ImageIcon(borderUp);
            iborderDown = new ImageIcon(borderDown);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (savedBorder != null) {
            jComponent.setBorder(savedBorder);
        }
        if (imagesLoaded) {
            this.loadImages(false, jComponent);
        }
        iborderUp = null;
        iborderDown = null;
    }

    protected boolean isRolloverSupported() {
        return true;
    }

    protected void loadImages(boolean bl, JComponent jComponent) {
        if (bl) {
            ImageUtil.setRelativeClass(class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarButtonUI == null ? (class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarButtonUI = MotifCommonToolBarButtonUI.class$("com.ibm.db2.tools.common.plaf.motif.MotifCommonToolBarButtonUI")) : class$com$ibm$db2$tools$common$plaf$motif$MotifCommonToolBarButtonUI);
            borderUp = CommonImageRepository.getCommonIcon(CommonImageRepository.NV_UP_BUTTON).getImage();
            borderDown = CommonImageRepository.getCommonIcon(CommonImageRepository.NV_DOWN_BUTTON).getImage();
            Color color = jComponent.getBackground();
            if (ImageUtil.isFilteringNeeded(color)) {
                borderUp = ImageUtil.filterImage(borderUp, color);
                borderDown = ImageUtil.filterImage(borderDown, color);
                filtered = true;
            }
            imagesLoaded = true;
        } else {
            borderUp = null;
            borderDown = null;
            imagesLoaded = false;
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        CommonToolBarButton commonToolBarButton = (CommonToolBarButton)jComponent;
        Dimension dimension = commonToolBarButton.getSize();
        ButtonModel buttonModel = commonToolBarButton.getModel();
        boolean bl = buttonModel.isArmed() && buttonModel.isPressed();
        int n2 = commonToolBarButton.getBorderMode();
        Icon icon = bl ? iborderDown : iborderUp;
        Rectangle rectangle = new Rectangle(dimension);
        Insets insets = jComponent.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = commonToolBarButton.getText();
        if (commonToolBarButton.getIcon() == null) {
            icon = null;
        }
        if (string != null) {
            rectangle.width -= this.textHorizontalMargin + this.textHorizontalMargin;
            string = SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, commonToolBarButton.getVerticalAlignment(), commonToolBarButton.getHorizontalAlignment(), commonToolBarButton.getVerticalTextPosition(), commonToolBarButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, 0);
        } else {
            if (null != icon) {
                rectangle2.width = icon.getIconWidth();
                rectangle2.height = icon.getIconHeight();
            }
            rectangle2.x = dimension.width / 2 - rectangle2.width / 2;
            rectangle2.y = dimension.height / 2 - rectangle2.height / 2;
        }
        if (bl && commonToolBarButton.getIcon() == null && commonToolBarButton.getText() != null) {
            this.setTextShiftOffset();
        } else {
            this.clearTextShiftOffset();
        }
        if (n2 == 3 || !this.isRolloverSupported() || n2 == 2 && (buttonModel.isRollover() || commonToolBarButton.isRequestFocusEnabled() && commonToolBarButton.hasFocus())) {
            if (icon != null) {
                icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            } else {
                graphics.setColor(jComponent.getBackground());
                graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, !bl);
            }
        }
        if (string != null) {
            this.paintText(graphics, (JComponent)commonToolBarButton, rectangle3, string);
        }
        this.clearTextShiftOffset();
        if (commonToolBarButton.getIcon() != null) {
            this.paintIcon(graphics, commonToolBarButton, rectangle2);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        CommonToolBarButton commonToolBarButton = (CommonToolBarButton)jComponent;
        String string = commonToolBarButton.getText();
        Insets insets = commonToolBarButton.getInsets();
        if (string == null) {
            return new Dimension(iborderUp.getIconWidth() + insets.left + insets.right, iborderUp.getIconHeight() + insets.top + insets.bottom);
        }
        Icon icon = commonToolBarButton.getIcon();
        Font font = commonToolBarButton.getFont();
        FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Icon icon2 = commonToolBarButton.getIcon() != null ? iborderUp : null;
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon2, commonToolBarButton.getVerticalAlignment(), commonToolBarButton.getHorizontalAlignment(), commonToolBarButton.getVerticalTextPosition(), commonToolBarButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, 0);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        rectangle4.width += insets.left + insets.right + this.textHorizontalMargin + this.textHorizontalMargin;
        rectangle4.height += insets.top + insets.bottom;
        if (icon == null) {
            rectangle4.width += 4;
            rectangle4.height += 4;
        }
        return rectangle4.getSize();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void paintIcon(Graphics graphics, CommonToolBarButton commonToolBarButton, Rectangle rectangle) {
        Icon icon = commonToolBarButton.getIcon();
        if (icon != null) {
            Rectangle rectangle2 = new Rectangle();
            ButtonModel buttonModel = commonToolBarButton.getModel();
            int n2 = buttonModel.isArmed() && buttonModel.isPressed() ? 1 : 0;
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
            rectangle2.x = rectangle.x + rectangle.width / 2 - rectangle2.width / 2 + n2 + this.iconShiftX;
            rectangle2.y = rectangle.y + rectangle.height / 2 - rectangle2.height / 2 + n2 + this.iconShiftY;
            super.paintIcon(graphics, commonToolBarButton, rectangle2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        savedBorder = null;
        imagesLoaded = false;
        filtered = false;
    }
}

