/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ViewTableHeaderUI
extends BasicTableHeaderUI {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ComponentUI createUI(JComponent jComponent) {
        return new ViewTableHeaderUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumn tableColumn;
        if (this.header == null || this.header.getColumnModel() == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle3 = new Rectangle(0, 0, dimension.width, dimension.height);
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            tableColumn = enumeration.nextElement();
            rectangle3.width = tableColumn.getWidth();
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (tableColumn != this.header.getDraggedColumn()) {
                    this.paintHead(graphics, rectangle3, n2);
                } else {
                    graphics.setColor(this.header.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n3 = n2;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n2;
        }
        tableColumn = this.header.getDraggedColumn();
        if (tableColumn != null && rectangle2 != null) {
            rectangle2.x += this.header.getDraggedDistance();
            this.paintHead(graphics, rectangle2, n3);
        }
    }

    protected JTableHeader getHeader() {
        return this.header;
    }

    protected void installListeners() {
        this.mouseInputListener = new RollupMouseInputHandler();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void uninstallListeners() {
        if (this.header != null) {
            super.uninstallListeners();
        }
    }

    protected void paintHead(Graphics graphics, Rectangle rectangle, int n2) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (null == tableCellRenderer) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        boolean bl = false;
        if (this.header instanceof ViewTableHeader) {
            bl = ((ViewTableHeader)this.header).getHeaderManager().getFocusColumn() == n2;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, bl, -1, n2);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.header != null) {
            super.uninstallUI(jComponent);
        } else {
            this.uninstallDefaults();
            this.uninstallKeyboardActions();
            this.rendererPane = null;
        }
    }

    public class RollupMouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        public RollupMouseInputHandler() {
            super(ViewTableHeaderUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TableColumn tableColumn;
            super.mousePressed(mouseEvent);
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = ViewTableHeaderUI.this.getHeader().getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(point.x);
            if (n2 != -1 && (tableColumn = tableColumnModel.getColumn(n2)) instanceof ViewTableColumn && ((ViewTableColumn)tableColumn).isRollup()) {
                ViewTableHeaderUI.this.getHeader().setDraggedColumn(null);
            }
        }
    }
}

