/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.filesystem.FileChooser;
import com.ibm.db2.tools.common.filesystem.LocalFileSystemView;
import com.ibm.db2.tools.common.uamanager.UAManager;
import com.ibm.db2.tools.common.ui.progress.BasicProgressIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;

public class FileChooserUI
extends javax.swing.plaf.FileChooserUI {
    private boolean _directorySelected = false;
    private File _directory = null;
    protected String openDialogTitleText = null;
    protected String saveDialogTitleText = null;
    protected String okButtonText = null;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String lookInLabelText = null;
    protected String saveInLabelText = null;
    protected String fileNameLabelText = null;
    protected String filesOfTypeLabelText = null;
    protected String fileDirListLabelText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String upFolderToolTipText = null;
    protected String homeFolderToolTipText = null;
    protected String newFolderToolTipText = null;
    protected String listViewButtonToolTipText = null;
    protected String detailsViewButtonToolTipText = null;
    protected String fileNameHeaderText = null;
    protected String fileSizeHeaderText = null;
    protected String fileTypeHeaderText = null;
    protected String fileDateHeaderText = null;
    protected String fileAttrHeaderText = null;
    protected String fileDescriptionText = null;
    protected String directoryDescriptionText = null;
    protected String acceptAllFilterDescription = null;
    protected AlignedLabel lookInLabel = null;
    protected AlignedLabel fileNameLabel = null;
    protected AlignedLabel filesOfTypeLabel = null;
    protected JLabel fileDirListLabel = null;
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected JToggleButton listViewButton = null;
    protected JToggleButton detailsViewButton = null;
    protected JButton upFolderButton = null;
    protected JButton homeFolderButton = null;
    protected JButton newFolderButton = null;
    protected AlignedButton approveButton = null;
    protected AlignedButton cancelButton = null;
    protected JPanel topPanel = null;
    protected JPanel centerPanel = null;
    protected JPanel bottomPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel listViewPanel = null;
    protected JPanel detailsViewPanel = null;
    protected JPanel currentViewPanel = null;
    protected JComboBox directoryComboBox = null;
    protected DirectoryComboBoxModel directoryComboBoxModel = null;
    protected JComboBox filterComboBox = null;
    protected FilterComboBoxModel filterComboBoxModel = null;
    protected Action approveSelectionAction = new ApproveSelectionAction();
    protected Action cancelSelectionAction = new CancelSelectionAction();
    protected Action updateAction = new UpdateAction();
    protected Action newFolderAction = new NewFolderAction();
    protected Action goHomeAction = new GoHomeAction();
    protected Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    protected Action directoryComboBoxAction = new DirectoryComboBoxAction();
    protected Action changeDirectoryAction = new ChangeDirectoryAction();
    protected FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FileChooserUI.this.applyEdit();
            }
        }
    };
    protected AssistField fileNameTextField = null;
    protected ListSelectionModel listSelectionModel = null;
    protected JList list = null;
    protected JTable detailsTable = null;
    protected JFileChooser filechooser = null;
    protected PropertyChangeListener propertyChangeListener = null;
    protected AncestorListener ancestorListener = null;
    protected AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    protected DirectoryModel model = null;
    protected File previousDirectory = null;
    protected BasicFileView fileView = new BasicFileView();
    protected JPanel accessoryPanel = null;
    protected BasicProgressIndicator progressIndicator = null;
    protected boolean busyCursorOn = false;
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    protected static int PREF_WIDTH = 590;
    protected static int PREF_HEIGHT = 376;
    protected static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    protected static int MIN_WIDTH = 590;
    protected static int MIN_HEIGHT = 376;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    protected static int LIST_PREF_WIDTH = 405;
    protected static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    protected static int TOOLBAR_WIDTH = 137;
    protected static final Dimension hstrut11 = new Dimension(11, 1);
    protected static final Dimension vstrut4 = new Dimension(1, 4);
    protected static final Dimension vstrut5 = new Dimension(1, 5);
    protected static final Dimension vstrut10 = new Dimension(1, 10);
    protected static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    int lastIndex = -1;
    boolean editing = false;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FileChooserUI((JFileChooser)jComponent);
    }

    public FileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createDirectoryModel();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.setUAKeys();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setBorder(new EmptyBorder(12, 12, 11, 11));
        jFileChooser.setLayout(new BoxLayout(jFileChooser, 1));
        this.createMainPanels(jFileChooser);
        jFileChooser.add(this.topPanel);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        jFileChooser.add(this.centerPanel);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        jFileChooser.add(this.getBottomPanel());
        FileChooserUI.groupLabels(new AlignedLabel[]{this.lookInLabel, this.fileNameLabel, this.filesOfTypeLabel});
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.model);
        this.ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JRootPane jRootPane;
                FileChooserUI.this.fileNameTextField.requestFocus();
                JButton jButton = FileChooserUI.this.getApproveButton(FileChooserUI.this.getFileChooser());
                if (jButton != null && (jRootPane = SwingUtilities.getRootPane(jButton)) != null) {
                    jRootPane.setDefaultButton(jButton);
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        jFileChooser.addAncestorListener(this.ancestorListener);
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.model);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
        jFileChooser.removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("FileChooser.ancestorInputMap");
        }
        return null;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        this.openDialogTitleText = CmStringPool.get(335);
        this.saveDialogTitleText = CmStringPool.get(336);
        this.openButtonText = CmStringPool.get(335);
        this.saveButtonText = CmStringPool.get(336);
        this.okButtonText = CmStringPool.get(358);
        this.cancelButtonText = CmStringPool.get(359);
        this.lookInLabelText = CmStringPool.get(343);
        this.saveInLabelText = CmStringPool.get(344);
        this.fileNameLabelText = CmStringPool.get(346);
        this.filesOfTypeLabelText = CmStringPool.get(347);
        this.fileDirListLabelText = CmStringPool.get(421);
        this.openButtonToolTipText = CmStringPool.get(331);
        this.saveButtonToolTipText = CmStringPool.get(333);
        this.cancelButtonToolTipText = CmStringPool.get(334);
        this.upFolderToolTipText = CmStringPool.get(348);
        this.homeFolderToolTipText = CmStringPool.get(349);
        this.newFolderToolTipText = CmStringPool.get(350);
        this.listViewButtonToolTipText = CmStringPool.get(351);
        this.detailsViewButtonToolTipText = CmStringPool.get(352);
        this.fileNameHeaderText = CmStringPool.get(353);
        this.fileSizeHeaderText = CmStringPool.get(354);
        this.fileTypeHeaderText = CmStringPool.get(355);
        this.fileDateHeaderText = CmStringPool.get(356);
        this.fileAttrHeaderText = CmStringPool.get(357);
        this.fileDescriptionText = CmStringPool.get(338);
        this.directoryDescriptionText = CmStringPool.get(337);
        this.acceptAllFilterDescription = CmStringPool.get(360) + " (*.*)";
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.openDialogTitleText = null;
        this.saveDialogTitleText = null;
        this.okButtonText = null;
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.lookInLabelText = null;
        this.saveInLabelText = null;
        this.fileNameLabelText = null;
        this.filesOfTypeLabelText = null;
        this.fileDirListLabelText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.upFolderToolTipText = null;
        this.homeFolderToolTipText = null;
        this.newFolderToolTipText = null;
        this.listViewButtonToolTipText = null;
        this.detailsViewButtonToolTipText = null;
        this.fileNameHeaderText = null;
        this.fileSizeHeaderText = null;
        this.fileTypeHeaderText = null;
        this.fileDateHeaderText = null;
        this.fileAttrHeaderText = null;
        this.fileDescriptionText = null;
        this.directoryDescriptionText = null;
        this.acceptAllFilterDescription = null;
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_DIRECTORY_IMAGE);
        this.fileIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_FILE_IMAGE);
        this.computerIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_COMPUTER_IMAGE);
        this.hardDriveIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_HARDDRIVE_IMAGE);
        this.floppyDriveIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_FLOPPYDRIVE_IMAGE);
        this.newFolderIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_NEWFOLDER_IMAGE);
        this.upFolderIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_UPFOLDER_IMAGE);
        this.homeFolderIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_HOMEFOLDER_IMAGE);
        this.listViewIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_LISTVIEW_IMAGE);
        this.detailsViewIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FC_DETAILSVIEW_IMAGE);
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n2 = FileChooserUI.PREF_SIZE.width;
        int n3 = FileChooserUI.PREF_SIZE.height;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n2 ? n2 : dimension.width, dimension.height < n3 ? n3 : dimension.height);
        }
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void createMainPanels(JFileChooser jFileChooser) {
        Object object;
        this.lookInLabel = new AlignedLabel(this.lookInLabelText);
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.directoryComboBox.setName("CmStringPool.CMN_FILECHOOSER_LOOKIN_LABEL");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.setSelectedItem(file);
        }
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setMaximumRowCount(12);
        this.upFolderButton = new FileChooserIconButton(this.getChangeToParentDirectoryAction(), this.upFolderIcon, this.upFolderToolTipText);
        this.upFolderButton.setName("CmStringPool.CMN_FILECHOOSER_UPFOLDER_TOOLTIP");
        if (file != null) {
            object = jFileChooser.getFileSystemView();
            this.upFolderButton.setEnabled(!((FileSystemView)object).isRoot(file));
        }
        object = new FileChooserIconButton(this.getGoHomeAction(), this.homeFolderIcon, this.homeFolderToolTipText);
        ((Component)object).setName("CmStringPool.CMN_FILECHOOSER_HOMEFOLDER_TOOLTIP");
        FileChooserIconButton fileChooserIconButton = new FileChooserIconButton(this.getNewFolderAction(), this.newFolderIcon, this.newFolderToolTipText);
        fileChooserIconButton.setName("CmStringPool.CMN_FILECHOOSER_NEWFOLDER_TOOLTIP");
        ButtonGroup buttonGroup = new ButtonGroup();
        ViewButtonListener viewButtonListener = new ViewButtonListener(jFileChooser);
        this.listViewButton = new FileChooserToggleIconButton(this.listViewIcon, this.listViewButtonToolTipText);
        this.listViewButton.setSelected(true);
        this.listViewButton.addActionListener(viewButtonListener);
        this.listViewButton.setName("CmStringPool.CMN_FILECHOOSER_LISTVIEW_TOOLTIP");
        buttonGroup.add(this.listViewButton);
        this.detailsViewButton = new FileChooserToggleIconButton(this.detailsViewIcon, this.detailsViewButtonToolTipText);
        this.listViewButton.setSelected(false);
        this.detailsViewButton.addActionListener(viewButtonListener);
        this.detailsViewButton.setName("CmStringPool.CMN_FILECHOOSER_DETAILSVIEW_TOOLTIP");
        buttonGroup.add(this.detailsViewButton);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.putClientProperty("JToolBar.isRollover", new Boolean(true));
        jToolBar.setPreferredSize(new Dimension(TOOLBAR_WIDTH, (int)jToolBar.getPreferredSize().getHeight()));
        jToolBar.add(this.upFolderButton);
        jToolBar.add((Component)object);
        jToolBar.add(fileChooserIconButton);
        jToolBar.add(this.listViewButton);
        jToolBar.add(this.detailsViewButton);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.topPanel.add(this.lookInLabel);
        this.topPanel.add(Box.createRigidArea(hstrut11));
        this.topPanel.add(this.directoryComboBox);
        this.topPanel.add(Box.createRigidArea(hstrut11));
        this.topPanel.add(jToolBar);
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(jFileChooser);
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        JPanel jPanel = this.getBottomPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        this.fileNameTextField = new AssistField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.setName("CmStringPool.CMN_FILECHOOSER_FILENAME_LABEL");
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!FileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    FileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        jPanel3.add(this.fileNameLabel);
        jPanel3.add(Box.createRigidArea(hstrut11));
        jPanel3.add(this.fileNameTextField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel){

            public Dimension getMaximumSize() {
                Dimension dimension = new Dimension(32770, 24);
                Dimension dimension2 = FileChooserUI.this.fileNameTextField.getMaximumSize();
                if (dimension2 != null) {
                    dimension.width = dimension2.width;
                    dimension.height = dimension2.height;
                }
                return dimension;
            }
        };
        this.filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.filterComboBox.setName("CmStringPool.CMN_FILECHOOSER_FILESOFTYPE_LABEL");
        jPanel4.add(this.filesOfTypeLabel);
        jPanel4.add(Box.createRigidArea(hstrut11));
        jPanel4.add(this.filterComboBox);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(vstrut5));
        jPanel2.add(jPanel4);
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new AlignedButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.setName("CmStringPool.CMN_FILECHOOSER_OPENBUTTON_LABEL");
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.getDocument().addDocumentListener(this.approveButton);
        this.approveButton.updateEnabledStatus();
        this.cancelButton = new AlignedButton(this.cancelButtonText);
        this.cancelButton.setName("CmStringPool.CMN_FILECHOOSER_CANCELBUTTON_LABEL");
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        FileChooserUI.groupButtons(new AlignedButton[]{this.approveButton, this.cancelButton});
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.getButtonPanel().add(this.cancelButton);
        this.buttonPanel.setPreferredSize(new Dimension(TOOLBAR_WIDTH, (int)this.buttonPanel.getPreferredSize().getHeight()));
        this.getBottomPanel().add(jPanel2);
        this.getBottomPanel().add(Box.createRigidArea(hstrut11));
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(){

            /*
             * Handled impossible loop by adding 'first' condition
             * Enabled aggressive block sorting
             */
            public int getNextMatch(String string, int n2, Position.Bias bias) {
                boolean bl;
                ListModel listModel = this.getModel();
                int n3 = listModel.getSize();
                if (string == null) throw new IllegalArgumentException();
                if (n2 < 0) throw new IllegalArgumentException();
                if (n2 >= n3) {
                    throw new IllegalArgumentException();
                }
                boolean bl2 = bias == Position.Bias.Backward;
                int n4 = n2;
                boolean bl3 = true;
                do {
                    if (!bl3 || (bl3 = false) || !true) {
                        String string2 = jFileChooser2.getName((File)listModel.getElementAt(n4));
                        if (string2.regionMatches(true, 0, string, 0, string.length())) {
                            return n4;
                        }
                        n4 += bl2 ? -1 : 1;
                    }
                    if (bl2) {
                        if (n4 < 0) return -1;
                        bl = true;
                        continue;
                    }
                    if (n4 >= n3) return -1;
                    bl = true;
                } while (bl);
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setName("CmStringPool.CMN_FILECHOOSER_LIST");
        this.fileDirListLabel = new JLabel(this.fileDirListLabelText);
        this.fileDirListLabel.setLabelFor(this.list);
        this.list.setVisibleRowCount(-1);
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getDirectoryModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.list.addKeyListener(this.createKeyListener(jFileChooser, this.list));
        this.listSelectionModel = this.list.getSelectionModel();
        this.getDirectoryModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        final JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser2);
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser2.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n2, bl);
            }

            public boolean isCellSelected(int n2, int n3) {
                return this.isRowSelected(n2) && this.convertColumnIndexToModel(n3) == 0;
            }
        };
        this.detailsTable.setRowSelectionAllowed(false);
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setIntercellSpacing(hstrut11);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.detailsTable.setName("CmStringPool.CMN_FILECHOOSER_TABLE");
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        DetailsTableHeaderRenderer detailsTableHeaderRenderer = new DetailsTableHeaderRenderer();
        int n2 = 0;
        while (n2 < 5) {
            tableColumnArray[n2] = tableColumnModel.getColumn(n2);
            tableColumnArray[n2].setPreferredWidth(this.COLUMN_WIDTHS[n2]);
            tableColumnArray[n2].setHeaderRenderer(detailsTableHeaderRenderer);
            ++n2;
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser2);
        this.detailsTable.setDefaultRenderer(class$java$io$File == null ? (class$java$io$File = FileChooserUI.class$("java.io.File")) : class$java$io$File, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = FileChooserUI.class$("java.util.Date")) : class$java$util$Date, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = FileChooserUI.class$("java.lang.Object")) : class$java$lang$Object, detailsTableCellRenderer);
        final JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor(jTextField){

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n2 = FileChooserUI.this.detailsTable.rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && FileChooserUI.this.detailsTable.isRowSelected(n2);
                }
                if (eventObject instanceof KeyEvent) {
                    return ((KeyEvent)eventObject).getKeyCode() == 113;
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n2, n3);
                if (object instanceof File) {
                    jTextField.setText(jFileChooser2.getName((File)object));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
                return component;
            }
        });
        JList jList = new JList(detailsTableModel.listModel){
            JTable table;
            {
                this.table = FileChooserUI.this.detailsTable;
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n2, int n3) {
                Rectangle rectangle = this.table.getCellRect(n2, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n3, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public boolean getDragEnabled() {
                return false;
            }

            public void setDragEnabled(boolean bl) {
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        this.detailsTable.addKeyListener(this.createKeyListener(jFileChooser, jList));
        this.fileDirListLabel.setLabelFor(this.detailsTable);
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                FileChooserUI.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void fixNameColumnWidth(int n2) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n3 = this.detailsTable.getPreferredSize().width;
        if (n3 < n2) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2 - n3);
        }
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    protected static void groupLabels(AlignedLabel[] alignedLabelArray) {
        int n2 = 0;
        while (n2 < alignedLabelArray.length) {
            AlignedLabel.access$302(alignedLabelArray[n2], alignedLabelArray);
            ++n2;
        }
    }

    private static void groupButtons(AlignedButton[] alignedButtonArray) {
        int n2 = 0;
        while (n2 < alignedButtonArray.length) {
            AlignedButton.access$402(alignedButtonArray[n2], alignedButtonArray);
            ++n2;
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        if (this.getFileChooser().getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        int n2 = this.getFileChooser().getApproveButtonMnemonic();
        return n2;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = this.getFileChooser().getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (this.getFileChooser().getDialogType() == 0) {
            return this.openButtonText;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return this.saveButtonText;
        }
        return this.okButtonText;
    }

    public void addFileNameTextFieldDocumentListener(DocumentListener documentListener) {
        this.fileNameTextField.getDocument().addDocumentListener(documentListener);
    }

    public void removeFileNameTextFieldDocumentListener(DocumentListener documentListener) {
        this.fileNameTextField.getDocument().removeDocumentListener(documentListener);
    }

    public void addFileNameTextFieldAssistListener(AssistListener assistListener) {
        this.fileNameTextField.addAssistListener(assistListener);
    }

    public void removeFileNameTextFieldAssistListener(AssistListener assistListener) {
        this.fileNameTextField.removeAssistListener(assistListener);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FileChooserUI.this.editing) {
                    FileChooserUI.this.cancelEdit();
                } else {
                    FileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return FileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        actionMapUIResource.put("changeDirectory", this.changeDirectoryAction);
        return actionMapUIResource;
    }

    protected void setUAKeys() {
        block2: {
            try {
                this.directoryComboBox.putClientProperty("UAKey", "FileChooserUI_directoryComboBox");
                this.upFolderButton.putClientProperty("UAKey", "FileChooserUI_upFolderButton");
                this.homeFolderButton.putClientProperty("UAKey", "FileChooserUI_homeFolderButton");
                this.newFolderButton.putClientProperty("UAKey", "FileChooserUI_newFolderButton");
                this.listViewButton.putClientProperty("UAKey", "FileChooserUI_listViewButton");
                this.detailsViewButton.putClientProperty("UAKey", "FileChooserUI_detailsViewButton");
                this.list.putClientProperty("UAKey", "FileChooserUI_list");
                this.detailsTable.putClientProperty("UAKey", "FileChooserUI_detailsTable");
                this.fileNameTextField.putClientProperty("UAKey", "FileChooserUI_fileNameTextField");
                this.filterComboBox.putClientProperty("UAKey", "FileChooserUI_filterComboBox");
                this.approveButton.putClientProperty("UAKey", "FileChooserUI_approveButton");
                this.cancelButton.putClientProperty("UAKey", "FileChooserUI_cancelButton");
            }
            catch (Exception exception) {
                if (!UAManager.getDebug()) break block2;
                System.out.println(exception);
            }
        }
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public DirectoryModel getDirectoryModel() {
        return this.model;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getDirectoryModel().validateFileCache();
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (fileArray != null && n2 < fileArray.length) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[n2]));
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean fileExists(File file) {
        boolean bl = false;
        FileSystemView fileSystemView = this.getFileChooser().getFileSystemView();
        if (fileSystemView instanceof LocalFileSystemView) {
            try {
                bl = ((LocalFileSystemView)fileSystemView).pathExistsThrowsException(file);
            }
            catch (Exception exception) {
                this.displayLastFileSystemError();
            }
        } else {
            bl = file.exists();
        }
        return bl;
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
                    FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        File[] fileArray = null;
                        Object[] objectArray = jList.getSelectedValues();
                        if (objectArray != null) {
                            if (objectArray.length == 1 && ((File)objectArray[0]).isDirectory() && jFileChooser.isTraversable((File)objectArray[0]) && jFileChooser.getFileSelectionMode() == 0) {
                                FileChooserUI.this.setDirectorySelected(true);
                                FileChooserUI.this.setDirectory((File)objectArray[0]);
                            } else {
                                File[] fileArray2;
                                fileArray = new File[objectArray.length];
                                int n2 = 0;
                                int n3 = 0;
                                while (n3 < objectArray.length) {
                                    fileArray2 = (File[])objectArray[n3];
                                    if (jFileChooser.isFileSelectionEnabled() && fileArray2.isFile() || jFileChooser.isDirectorySelectionEnabled() && fileArray2.isDirectory()) {
                                        fileArray[n2++] = fileArray2;
                                    }
                                    ++n3;
                                }
                                if (n2 == 0) {
                                    fileArray = null;
                                } else if (n2 < objectArray.length) {
                                    fileArray2 = new File[n2];
                                    System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                                    fileArray = fileArray2;
                                }
                                FileChooserUI.this.setDirectorySelected(false);
                            }
                        }
                        jFileChooser.setSelectedFiles(fileArray);
                    } else {
                        File file = (File)jList.getSelectedValue();
                        if (file != null && file.isDirectory() && jFileChooser.isTraversable(file) && jFileChooser.getFileSelectionMode() == 0) {
                            FileChooserUI.this.setDirectorySelected(true);
                            FileChooserUI.this.setDirectory(file);
                            jFileChooser.setSelectedFile(null);
                        } else {
                            FileChooserUI.this.setDirectorySelected(false);
                            if (file != null) {
                                jFileChooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
        };
    }

    private KeyListener createKeyListener(JFileChooser jFileChooser, JList jList) {
        return new KeyListener(jList);
    }

    protected void createDirectoryModel() {
        this.model = new DirectoryModel(this.getFileChooser());
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public Action getApproveSelectionAction() {
        return new ApproveSelectionAction();
    }

    public Action getCancelSelectionAction() {
        return new CancelSelectionAction();
    }

    public Action getNewFolderAction() {
        return new NewFolderAction();
    }

    public Action getGoHomeAction() {
        return new GoHomeAction();
    }

    public Action getChangeToParentDirectoryAction() {
        return new ChangeToParentDirectoryAction();
    }

    public Action getUpdateAction() {
        return new UpdateAction();
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n2) {
        this.lastIndex = n2;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editing) {
            this.editing = false;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n2) {
        this.ensureIndexIsVisible(n2);
        if (this.listViewPanel.isVisible()) {
            this.editing = true;
            Rectangle rectangle = this.list.getCellBounds(n2, n2);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            File file = (File)this.getDirectoryModel().getElementAt(n2);
            this.editCell.setText(this.getFileChooser().getName(file));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n2, 0);
        }
    }

    private void applyEdit() {
        if (this.editing) {
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null) {
                String string = jFileChooser.getName(file);
                String string2 = file.getName();
                String string3 = this.editCell.getText().trim();
                if (!string3.equals(string)) {
                    int n2;
                    String string4 = string3;
                    int n3 = string2.length();
                    if (n3 > (n2 = string.length()) && string2.charAt(n2) == '.') {
                        string4 = string3 + string2.substring(n2);
                    }
                    FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                    File file2 = fileSystemView.createFileObject(file.getParentFile(), string4);
                    boolean bl = false;
                    if (fileSystemView instanceof LocalFileSystemView) {
                        try {
                            bl = ((LocalFileSystemView)fileSystemView).renameFileThrowsException(file, file2);
                        }
                        catch (Exception exception) {
                            this.displayLastFileSystemError();
                        }
                    } else {
                        bl = file.renameTo(file2);
                    }
                    this.cancelEdit();
                    if (bl) {
                        this.getDirectoryModel().validateFileCache();
                        if (jFileChooser.isMultiSelectionEnabled()) {
                            jFileChooser.setSelectedFiles(new File[]{file2});
                        } else {
                            jFileChooser.setSelectedFile(file2);
                        }
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            int n2;
            int n3;
            int n4;
            File[] fileArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray = this.list.getSelectedValues();
            int n5 = 0;
            while (n5 < objectArray.length) {
                n4 = 0;
                n3 = 0;
                while (n3 < fileArray.length) {
                    if (fileArray[n3].equals(objectArray[n5])) {
                        n4 = 1;
                        break;
                    }
                    ++n3;
                }
                if (n4 == 0 && (n2 = this.getDirectoryModel().indexOf(objectArray[n5])) >= 0) {
                    this.listSelectionModel.removeSelectionInterval(n2, n2);
                }
                ++n5;
            }
            n4 = 0;
            while (n4 < fileArray.length) {
                int n6;
                n3 = 0;
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (fileArray[n4].equals(objectArray[n2])) {
                        n3 = 1;
                        break;
                    }
                    ++n2;
                }
                if (n3 == 0 && (n6 = this.getDirectoryModel().indexOf(fileArray[n4])) >= 0) {
                    this.listSelectionModel.addSelectionInterval(n6, n6);
                }
                ++n4;
            }
        } else {
            int n7;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n7 = this.getDirectoryModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n7, n7);
                this.ensureIndexIsVisible(n7);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private void ensureIndexIsVisible(int n2) {
        if (n2 >= 0) {
            this.list.ensureIndexIsVisible(n2);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n2, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getDirectoryModel().indexOf(file));
    }

    public void displayLastFileSystemError() {
        FileSystemView fileSystemView = this.getFileChooser().getFileSystemView();
        if (fileSystemView instanceof LocalFileSystemView) {
            String string = ((LocalFileSystemView)fileSystemView).getErrorMessage();
            this.showNormalCursor();
            Container container = this.getFileChooser().getTopLevelAncestor();
            if (container != null && container instanceof JDialog) {
                new CommonMessage((JDialog)container, CmStringPool.get(4), string, 0, CmStringPool.get(4), null, 512, null, true, true);
            } else {
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = FileChooserUI.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this.getFileChooser());
                new CommonMessage(jFrame == null ? new JFrame() : jFrame, CmStringPool.get(4), string, 0, CmStringPool.get(4), null, 512, null, true, true);
            }
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    FileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    FileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    FileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    FileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    FileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    FileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    FileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    FileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    FileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("CancelSelection")) {
                    FileChooserUI.this.applyEdit();
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        // empty if block
                    }
                    if (FileChooserUI.this.detailsTable != null) {
                        FileChooserUI.this.detailsTable.setComponentOrientation(componentOrientation);
                        FileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    FileChooserUI.this.fileNameTextField.selectAll();
                    FileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
        this.setFileSelected();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        }
        this.setFileSelected();
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.upFolderButton.setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                this.setFileName(file.getPath());
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    protected void setDirectorySelected(boolean bl) {
        this._directorySelected = bl;
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl) {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected File getDirectory() {
        return this._directory;
    }

    protected void setDirectory(File file) {
        this._directory = file;
    }

    protected boolean isDirectorySelected() {
        return this._directorySelected;
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    public void showBusyCursor() {
        if (!this.busyCursorOn) {
            this.setBusyCursor(true);
        }
    }

    public void showNormalCursor() {
        if (this.busyCursorOn) {
            this.setBusyCursor(false);
        }
    }

    public void setBusyCursor(boolean bl) {
        Runnable runnable = null;
        runnable = bl ? new Runnable(){

            public void run() {
                FileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(3));
                FileChooserUI.this.busyCursorOn = true;
            }
        } : new Runnable(){

            public void run() {
                FileChooserUI.this.getFileChooser().setCursor(Cursor.getPredefinedCursor(0));
                FileChooserUI.this.busyCursorOn = false;
            }
        };
        if (runnable != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AlignedButton
    extends JButton
    implements DocumentListener {
        private AlignedButton[] group;
        private int maxWidth = 0;

        AlignedButton(String string) {
            super(string);
            this.setAlignmentX(1.0f);
            this.setAlignmentY(0.0f);
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 15, dimension.height);
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 15, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.group.length) {
                    n2 = Math.max(this.group[n3].getSuperPreferredWidth(), n2);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.group.length) {
                    this.group[n4].maxWidth = n2;
                    ++n4;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        private void updateEnabledStatus() {
            String string = FileChooserUI.this.getFileName();
            if (string != null) {
                if ((string = string.trim()).equals("")) {
                    if (this.isEnabled()) {
                        this.setEnabled(false);
                    }
                } else if (!this.isEnabled()) {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledStatus();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledStatus();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        static /* synthetic */ AlignedButton[] access$402(AlignedButton alignedButton, AlignedButton[] alignedButtonArray) {
            alignedButton.group = alignedButtonArray;
            return alignedButtonArray;
        }
    }

    public class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth = 0;

        public AlignedLabel(String string) {
            super(string);
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 5, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.group.length) {
                    n2 = Math.max(this.group[n3].getSuperPreferredWidth(), n2);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.group.length) {
                    this.group[n4].maxWidth = n2;
                    ++n4;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$302(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    protected static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        protected ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n2;
                int n3;
                int n4 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n4];
                Insets insets = container.getInsets();
                int n5 = insets.top + this.topMargin;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n4) {
                    dimensionArray[n7] = componentArray[n7].getPreferredSize();
                    n6 = Math.max(n6, dimensionArray[n7].width);
                    ++n7;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n3 = container.getSize().width - insets.left - n6;
                    n2 = this.hGap + n6;
                } else {
                    n3 = insets.left;
                    n2 = -(this.hGap + n6);
                }
                int n8 = n4 - 1;
                while (n8 >= 0) {
                    componentArray[n8].setBounds(n3, n5, n6, dimensionArray[n8].height);
                    n3 -= n2;
                    --n8;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n2 = componentArray.length;
                int n3 = 0;
                Insets insets = container.getInsets();
                int n4 = this.topMargin + insets.top + insets.bottom;
                int n5 = insets.left + insets.right;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2) {
                    Dimension dimension = componentArray[n7].getPreferredSize();
                    n3 = Math.max(n3, dimension.height);
                    n6 = Math.max(n6, dimension.width);
                    ++n7;
                }
                return new Dimension(n5 + n2 * n6 + (n2 - 1) * this.hGap, n4 + n3);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    public class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n2 + this.depth * 10, n3);
            } else {
                this.icon.paintIcon(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    protected class FileChooserToggleIconButton
    extends JToggleButton {
        public FileChooserToggleIconButton(Icon icon, String string) {
            if (icon != null) {
                this.setIcon(icon);
            }
            if (string != null) {
                this.setToolTipText(string);
            }
            this.setText(null);
            this.setMargin(shrinkwrap);
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.addChangeListener(new ChangeListener(this){
                ButtonModel model;
                private final /* synthetic */ FileChooserToggleIconButton this$1;
                {
                    this.this$1 = fileChooserToggleIconButton;
                    this.model = this.this$1.getModel();
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.setBorderPainted(this.model.isRollover());
                }
            });
        }
    }

    protected class FileChooserIconButton
    extends JButton {
        public FileChooserIconButton(Action action, Icon icon, String string) {
            if (action != null) {
                this.setAction(action);
            }
            if (icon != null) {
                this.setIcon(icon);
            }
            if (string != null) {
                this.setToolTipText(string);
            }
            this.setText(null);
            this.setMargin(shrinkwrap);
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.addChangeListener(new ChangeListener(this){
                ButtonModel model;
                private final /* synthetic */ FileChooserIconButton this$1;
                {
                    this.this$1 = fileChooserIconButton;
                    this.model = this.this$1.getModel();
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.setBorderPainted(this.model.isRollover());
                }
            });
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        protected DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(FileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = FileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = FileChooserUI.this.directoryComboBoxModel.getDepth(n2);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            if (n3 == 1 || n3 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }
    }

    protected class DetailsTableHeaderRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            JTableHeader jTableHeader;
            if (FileChooserUI.this.detailsTable != null && (jTableHeader = FileChooserUI.this.detailsTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
            }
            this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            if (n3 == 1 || n3 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            this.setFont(jTable.getFont());
            this.setValue(object);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
            File file = (File)object;
            String string = FileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = FileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                FileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File file) {
            String string = null;
            if (file != null && (string = file.getName()).equals("")) {
                string = file.getPath();
            }
            return string;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            if (file.isDirectory()) {
                return FileChooserUI.this.directoryDescriptionText;
            }
            return FileChooserUI.this.fileDescriptionText;
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = file != null && file.isDirectory() ? (FileChooserUI.this.getFileChooser().getFileSystemView().isRoot(file) ? FileChooserUI.this.hardDriveIcon : FileChooserUI.this.directoryIcon) : FileChooserUI.this.fileIcon;
            this.cacheIcon(file, icon);
            return icon;
        }

        public Boolean isTraversable(File file) {
            if (file.isDirectory()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return FileChooserUI.this.acceptAllFilterDescription;
        }
    }

    protected class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            FileChooserUI.this.setFileSelected();
        }
    }

    protected class EditActionListener
    implements ActionListener {
        protected EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileChooserUI.this.applyEdit();
        }
    }

    protected class KeyListener
    extends KeyAdapter
    implements ResultProcessor {
        File selectedFileToDelete = null;
        JList list = null;
        static /* synthetic */ Class class$javax$swing$JFrame;

        public KeyListener(JList jList) {
            this.list = jList;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 113 && !FileChooserUI.this.editing && FileChooserUI.this.getEditIndex() >= 0) {
                FileChooserUI.this.editFileName(FileChooserUI.this.getEditIndex());
            }
            if (keyEvent.getKeyCode() == 116) {
                FileChooserUI.this.getFileChooser().rescanCurrentDirectory();
            } else if (keyEvent.getKeyCode() == 127) {
                File[] fileArray;
                JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
                if (jFileChooser.isMultiSelectionEnabled()) {
                    Object[] objectArray = this.list.getSelectedValues();
                    fileArray = new File[objectArray.length];
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        fileArray[n2] = (File)objectArray[n2];
                        ++n2;
                    }
                    jFileChooser.setSelectedFiles(null);
                } else {
                    fileArray = new File[]{(File)this.list.getSelectedValue()};
                    jFileChooser.setSelectedFile(null);
                }
                int n3 = 0;
                while (n3 < fileArray.length) {
                    this.selectedFileToDelete = fileArray[n3];
                    String string = null;
                    int n4 = 392;
                    if (fileArray[n3].isDirectory()) {
                        n4 = 393;
                    }
                    Object[] objectArray = new String[]{fileArray[n3].getName()};
                    string = CmStringPool.get(n4, objectArray);
                    Container container = FileChooserUI.this.getFileChooser().getTopLevelAncestor();
                    if (container != null && container instanceof JDialog) {
                        new CommonMessage((JDialog)container, CmStringPool.get(196), string, 1, CmStringPool.get(196), null, 16, (ResultProcessor)this, true, true);
                    } else {
                        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? KeyListener.class$("javax.swing.JFrame") : class$javax$swing$JFrame, FileChooserUI.this.getFileChooser());
                        new CommonMessage(jFrame == null ? new JFrame() : jFrame, CmStringPool.get(196), string, 1, CmStringPool.get(196), null, 16, (ResultProcessor)this, true, true);
                    }
                    ++n3;
                }
            }
        }

        public void processResult(Object object, Object object2) {
            ((CommonMessage)object).close();
            boolean bl = true;
            if ("Yes".equals(object2) && this.selectedFileToDelete != null) {
                FileSystemView fileSystemView = FileChooserUI.this.getFileChooser().getFileSystemView();
                if (fileSystemView instanceof LocalFileSystemView) {
                    try {
                        ((LocalFileSystemView)fileSystemView).deleteFileDirThrowsException(this.selectedFileToDelete);
                    }
                    catch (Exception exception) {
                        FileChooserUI.this.displayLastFileSystemError();
                        bl = false;
                    }
                } else {
                    this.selectedFileToDelete.delete();
                }
                if (bl) {
                    FileChooserUI.this.getFileChooser().rescanCurrentDirectory();
                }
            }
            this.selectedFileToDelete = null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            if (mouseEvent.getClickCount() == 2 && (n2 = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (FileChooserUI.this.getFileChooser().isTraversable(file)) {
                    FileChooserUI.this.previousDirectory = FileChooserUI.this.getFileChooser().getCurrentDirectory();
                    this.list.clearSelection();
                    ((FileChooser)FileChooserUI.this.getFileChooser()).setCurrentDirectory(file, false);
                } else {
                    FileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
                    int n2 = this.list.locationToIndex(mouseEvent.getPoint());
                    if (!(jFileChooser.isMultiSelectionEnabled() && jFileChooser.getSelectedFiles().length > 1 || n2 < 0 || !this.list.isSelectedIndex(n2) || FileChooserUI.this.getEditIndex() != n2 || FileChooserUI.this.editing)) {
                        FileChooserUI.this.editFileName(n2);
                    } else if (n2 >= 0) {
                        FileChooserUI.this.setEditIndex(n2);
                    } else {
                        FileChooserUI.this.resetEditIndex();
                    }
                } else {
                    FileChooserUI.this.resetEditIndex();
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                // empty if block
            }
        }
    }

    protected class ViewButtonListener
    implements ActionListener {
        JFileChooser fc;

        ViewButtonListener(JFileChooser jFileChooser) {
            this.fc = jFileChooser;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            JPanel jPanel = FileChooserUI.this.currentViewPanel;
            if (jToggleButton == FileChooserUI.this.detailsViewButton) {
                if (FileChooserUI.this.detailsViewPanel == null) {
                    FileChooserUI.this.detailsViewPanel = FileChooserUI.this.createDetailsView(this.fc);
                    FileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                }
                FileChooserUI.this.currentViewPanel = FileChooserUI.this.detailsViewPanel;
            } else {
                FileChooserUI.this.currentViewPanel = FileChooserUI.this.listViewPanel;
            }
            if (FileChooserUI.this.currentViewPanel != jPanel) {
                FileChooserUI.this.centerPanel.remove(jPanel);
                FileChooserUI.this.centerPanel.add((Component)FileChooserUI.this.currentViewPanel, "Center");
                FileChooserUI.this.centerPanel.revalidate();
                FileChooserUI.this.centerPanel.repaint();
            }
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
            ((FileChooser)jFileChooser).setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(FileChooserUI.this.getDirectoryName()), false);
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (FileChooserUI.this.isDirectorySelected() && (serializable = FileChooserUI.this.getDirectory()) != null) {
                try {
                    serializable = ((File)serializable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((FileChooser)FileChooserUI.this.getFileChooser()).setCurrentDirectory((File)serializable, false);
                return;
            }
            serializable = FileChooserUI.this.getFileChooser();
            String string = FileChooserUI.this.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    do {
                        String string2;
                        int n2;
                        if ((n2 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n2);
                            string = string.substring(n2 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        File file3 = fileSystemView.createFileObject(string2);
                        if (!file3.isAbsolute()) {
                            file3 = fileSystemView.createFileObject(file, string2);
                        }
                        arrayList.add(file3);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = arrayList.toArray(new File[arrayList.size()]);
                    }
                } else {
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.createFileObject(file, string);
                    }
                    boolean bl = file2 != null && file2.isDirectory();
                    boolean bl2 = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl3 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl4 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    if (bl && bl2 && !bl3) {
                        ((FileChooser)serializable).setCurrentDirectory(file2, false);
                        return;
                    }
                    if (!(!bl && bl4 || bl && bl3 || bl3 && !FileChooserUI.this.fileExists(file2))) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null) {
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(new File[]{file2});
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }
    }

    protected class ChangeDirectoryAction
    extends AbstractAction {
        protected ChangeDirectoryAction() {
            super("changeDirectory");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
            file = FileChooserUI.this.isDirectorySelected() ? FileChooserUI.this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && file.isDirectory()) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((FileChooser)jFileChooser).setCurrentDirectory(file, false);
                return;
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            if (fileSystemView instanceof LocalFileSystemView) {
                try {
                    file2 = ((LocalFileSystemView)fileSystemView).createNewFolderThrowsException(file);
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file2});
                    } else {
                        jFileChooser.setSelectedFile(file2);
                    }
                }
                catch (Exception exception) {
                    FileChooserUI.this.displayLastFileSystemError();
                    return;
                }
            }
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            FileChooser fileChooser = (FileChooser)FileChooserUI.this.getFileChooser();
            String string = fileChooser.getHomeDirectoryPath();
            if (string != null) {
                file = fileChooser.getFileSystemView().createFileObject(string);
            }
            ((FileChooser)FileChooserUI.this.getFileChooser()).setCurrentDirectory(file, false);
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object var2_2 = null;
            if (FileChooserUI.this.upFolderButton != null && FileChooserUI.this.upFolderButton.hasFocus()) {
                FileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)FileChooserUI.this.directoryComboBox.getSelectedItem();
            ((FileChooser)FileChooserUI.this.getFileChooser()).setCurrentDirectory(file, false);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = FileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                FileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                FileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = FileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n2 = 0;
                while (n2 < this.filters.length) {
                    if (this.filters[n2] == fileFilter) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    FileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return FileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return FileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        File selectedDirectory = null;
        File directoryToAdd = null;
        File[] baseFolders;
        int[] depths = null;
        int rootsFetchID = 0;

        public DirectoryComboBoxModel() {
            File file = FileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directoryToAdd = file;
            ++this.rootsFetchID;
            LoadRootsThread loadRootsThread = null;
            loadRootsThread = new LoadRootsThread(this.rootsFetchID);
            loadRootsThread.start();
        }

        private void updateDirectoryComboBox() {
            File file;
            this.directories.clear();
            this.directories.addAll(Arrays.asList(this.baseFolders));
            File file2 = null;
            try {
                file2 = this.directoryToAdd.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = this.directoryToAdd;
            }
            File file3 = file = file2;
            Vector<File> vector = new Vector<File>(10);
            do {
                vector.addElement(file3);
            } while ((file3 = file3.getParentFile()) != null);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                file3 = (File)vector.get(n3);
                if (this.directories.contains(file3)) {
                    int n4 = this.directories.indexOf(file3);
                    int n5 = n3 - 1;
                    while (n5 >= 0) {
                        this.directories.insertElementAt(vector.get(n5), n4 + n3 - n5);
                        --n5;
                    }
                    break;
                }
                ++n3;
            }
            this.calculateDepths();
            this.setSelectedItem(file);
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int n2 = 0;
            while (n2 < this.depths.length) {
                File file = (File)this.directories.get(n2);
                File file2 = file.getParentFile();
                this.depths[n2] = 0;
                if (file2 != null) {
                    int n3 = n2 - 1;
                    while (n3 >= 0) {
                        if (file2.equals((File)this.directories.get(n3))) {
                            this.depths[n2] = this.depths[n3] + 1;
                            break;
                        }
                        --n3;
                    }
                }
                ++n2;
            }
        }

        public int getDepth(int n2) {
            return this.depths != null && n2 >= 0 && n2 < this.depths.length ? this.depths[n2] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }

        protected class UpdateRoots
        implements Runnable {
            private File[] rootFolders;
            private boolean doFire = true;
            private Object lock = new Object();
            private int rid;

            public UpdateRoots(File[] fileArray, int n2) {
                this.rootFolders = fileArray;
                this.rid = n2;
            }

            synchronized void cancel() {
                Object object = this.lock;
                synchronized (object) {
                    this.doFire = false;
                }
            }

            public void run() {
                block7: {
                    try {
                        if (DirectoryComboBoxModel.this.rootsFetchID != this.rid) break block7;
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.doFire) {
                                DirectoryComboBoxModel.this.baseFolders = new File[this.rootFolders.length];
                                int n2 = 0;
                                while (n2 < this.rootFolders.length) {
                                    DirectoryComboBoxModel.this.baseFolders[n2] = this.rootFolders[n2];
                                    ++n2;
                                }
                            }
                            DirectoryComboBoxModel.this.updateDirectoryComboBox();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        protected class LoadRootsThread
        extends Thread {
            File[] rootFolders;
            int rid;

            public LoadRootsThread(int n2) {
                super("Basic L&F Roots Loading Thread");
                this.rid = n2;
            }

            public void run() {
                Vector<UpdateRoots> vector = new Vector<UpdateRoots>(10);
                FileChooser fileChooser = (FileChooser)FileChooserUI.this.getFileChooser();
                FileSystemView fileSystemView = fileChooser.getFileSystemView();
                if (fileSystemView instanceof LocalFileSystemView) {
                    try {
                        this.rootFolders = ((LocalFileSystemView)fileSystemView).getRootsThrowsException();
                    }
                    catch (Exception exception) {
                        FileChooserUI.this.displayLastFileSystemError();
                        this.rootFolders = new File[0];
                    }
                } else {
                    this.rootFolders = fileSystemView.getRoots();
                }
                UpdateRoots updateRoots = new UpdateRoots(this.rootFolders, this.rid);
                vector.addElement(updateRoots);
                SwingUtilities.invokeLater(updateRoots);
                if (this.isInterrupted()) {
                    this.cancelRunnables(vector);
                    return;
                }
            }

            public void cancelRunnables(Vector vector) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((UpdateRoots)vector.elementAt(n2)).cancel();
                    ++n2;
                }
            }
        }
    }

    protected class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$java$util$Date;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{FileChooserUI.this.fileNameHeaderText, FileChooserUI.this.fileSizeHeaderText, FileChooserUI.this.fileTypeHeaderText, FileChooserUI.this.fileDateHeaderText, FileChooserUI.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = FileChooserUI.this.getDirectoryModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = DetailsTableModel.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = DetailsTableModel.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n2);
        }

        public Object getValueAt(int n2, int n3) {
            File file = (File)this.listModel.getElementAt(n2);
            switch (n3) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (file.isDirectory()) {
                        return null;
                    }
                    if (file.length() < 0L) {
                        return "";
                    }
                    if (file.length() == 0L) {
                        return "0 KB";
                    }
                    long l2 = file.length() / 1024L;
                    if (l2 < 1024L) {
                        return (l2 == 0L ? 1L : l2) + " KB";
                    }
                    if ((l2 /= 1024L) < 1024L) {
                        return l2 + " MB";
                    }
                    return (l2 /= 1024L) + " GB";
                }
                case 2: {
                    return ((LocalFileSystemView)this.chooser.getFileSystemView()).getSystemTypeDescription(file);
                }
                case 3: {
                    long l3 = file.lastModified();
                    return l3 <= 0L ? null : new Date(l3);
                }
                case 4: {
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n2, int n3) {
            if (n3 == 0) {
                JFileChooser jFileChooser = FileChooserUI.this.getFileChooser();
                File file = (File)this.getValueAt(n2, n3);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        int n4;
                        String string4 = string3;
                        int n5 = string2.length();
                        if (n5 > (n4 = string.length()) && string2.charAt(n4) == '.') {
                            string4 = string3 + string2.substring(n4);
                        }
                        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                        File file2 = fileSystemView.createFileObject(file.getParentFile(), string4);
                        boolean bl = false;
                        if (fileSystemView instanceof LocalFileSystemView) {
                            try {
                                bl = ((LocalFileSystemView)fileSystemView).renameFileThrowsException(file, file2);
                            }
                            catch (Exception exception) {
                                FileChooserUI.this.displayLastFileSystemError();
                            }
                        } else {
                            bl = file.renameTo(file2);
                        }
                        if (bl) {
                            FileChooserUI.this.getDirectoryModel().validateFileCache();
                            if (jFileChooser.isMultiSelectionEnabled()) {
                                jFileChooser.setSelectedFiles(new File[]{file2});
                            } else {
                                jFileChooser.setSelectedFile(file2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    protected class DirectoryModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private JFileChooser filechooser = null;
        private Vector fileCache = null;
        private LoadFilesThread loadThread = null;
        private Vector files = null;
        private Vector directories = null;
        private int filesFetchID = 0;

        public DirectoryModel(JFileChooser jFileChooser) {
            this.filechooser = jFileChooser;
            this.validateFileCache();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
                this.invalidateFileCache();
                this.validateFileCache();
            }
        }

        public void invalidateFileCache() {
            this.files = null;
            this.directories = null;
            this.fileCache = null;
        }

        public void validateFileCache() {
            File file = this.filechooser.getCurrentDirectory();
            if (file == null) {
                this.invalidateFileCache();
                return;
            }
            if (this.loadThread != null) {
                this.loadThread.interrupt();
            }
            ++this.filesFetchID;
            this.invalidateFileCache();
            this.fileCache = new Vector(50);
            this.fireContentsChanged();
            FileChooserUI.this.showBusyCursor();
            this.loadThread = new LoadFilesThread(file, this.filesFetchID);
            this.loadThread.start();
        }

        public void fireContentsChanged() {
            this.files = null;
            this.directories = null;
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public int getSize() {
            if (this.fileCache != null) {
                return this.fileCache.size();
            }
            return 0;
        }

        public boolean contains(Object object) {
            if (this.fileCache != null) {
                return this.fileCache.contains(object);
            }
            return false;
        }

        public int indexOf(Object object) {
            if (this.fileCache != null) {
                return this.fileCache.indexOf(object);
            }
            return 0;
        }

        public Object getElementAt(int n2) {
            if (this.fileCache != null) {
                return this.fileCache.elementAt(n2);
            }
            return null;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        protected void sort(Vector vector) {
            this.quickSort(vector, 0, vector.size() - 1);
        }

        /*
         * Unable to fully structure code
         */
        private void quickSort(Vector var1_1, int var2_2, int var3_3) {
            block5: {
                var4_4 = var2_2;
                var5_5 = var3_3;
                if (var3_3 <= var2_2) break block5;
                var6_6 = (File)var1_1.elementAt((var2_2 + var3_3) / 2);
                ** GOTO lbl16
                {
                    ++var4_4;
                    do {
                        if (var4_4 < var3_3 && this.lt((File)var1_1.elementAt(var4_4), var6_6)) continue block0;
                        while (var5_5 > var2_2 && this.lt(var6_6, (File)var1_1.elementAt(var5_5))) {
                            --var5_5;
                        }
                        if (var4_4 > var5_5) continue;
                        this.swap(var1_1, var4_4, var5_5);
                        ++var4_4;
                        --var5_5;
lbl16:
                        // 3 sources

                    } while (var4_4 <= var5_5);
                }
                if (var2_2 < var5_5) {
                    this.quickSort(var1_1, var2_2, var5_5);
                }
                if (var4_4 < var3_3) {
                    this.quickSort(var1_1, var4_4, var3_3);
                }
            }
        }

        private void swap(Vector vector, int n2, int n3) {
            Object e2 = vector.elementAt(n2);
            vector.setElementAt(vector.elementAt(n3), n2);
            vector.setElementAt(e2, n3);
        }

        protected boolean lt(File file, File file2) {
            return file.getName().toLowerCase().compareTo(file2.getName().toLowerCase()) < 0;
        }

        protected class UpdateFiles
        implements Runnable {
            private Vector files;
            private boolean doFire = true;
            private Object lock = new Object();
            private int fid;

            public UpdateFiles(Vector vector, int n2) {
                this.files = vector;
                this.fid = n2;
            }

            synchronized void cancel() {
                Object object = this.lock;
                synchronized (object) {
                    this.doFire = false;
                }
            }

            public void run() {
                block7: {
                    try {
                        if (DirectoryModel.this.filesFetchID != this.fid) break block7;
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.doFire && DirectoryModel.this.fileCache != null) {
                                int n2 = 0;
                                while (n2 < this.files.size()) {
                                    DirectoryModel.this.fileCache.addElement(this.files.elementAt(n2));
                                    ++n2;
                                }
                            }
                            FileChooserUI.this.showNormalCursor();
                            DirectoryModel.this.fireContentsChanged();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        protected class LoadFilesThread
        extends Thread {
            File currentDirectory = null;
            int fid;

            public LoadFilesThread(File file, int n2) {
                super("Basic L&F File Loading Thread");
                this.currentDirectory = file;
                this.fid = n2;
            }

            public void run() {
                Object object;
                Vector<Object> vector = new Vector<Object>(10);
                FileChooser fileChooser = (FileChooser)FileChooserUI.this.getFileChooser();
                FileSystemView fileSystemView = fileChooser.getFileSystemView();
                File[] fileArray = null;
                if (fileSystemView instanceof LocalFileSystemView) {
                    try {
                        fileArray = ((LocalFileSystemView)fileSystemView).getFilesThrowsException(this.currentDirectory, fileChooser.isFileHidingEnabled());
                    }
                    catch (Exception exception) {
                        FileChooserUI.this.displayLastFileSystemError();
                        if (((DirectoryModel)DirectoryModel.this).FileChooserUI.this.previousDirectory != null) {
                            fileChooser.setCurrentDirectory(((DirectoryModel)DirectoryModel.this).FileChooserUI.this.previousDirectory, false);
                        }
                        fileArray = new File[]{};
                    }
                } else {
                    fileArray = fileSystemView.getFiles(this.currentDirectory, fileChooser.isFileHidingEnabled());
                }
                Vector<File> vector2 = new Vector<File>();
                int n2 = 0;
                while (n2 < fileArray.length) {
                    if (DirectoryModel.this.filechooser.accept(fileArray[n2])) {
                        vector2.addElement(fileArray[n2]);
                    }
                    ++n2;
                }
                DirectoryModel.this.sort(vector2);
                Vector<Object> vector3 = new Vector<Object>(4);
                Vector<Object> vector4 = new Vector<Object>();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    object = (File)vector2.elementAt(n3);
                    boolean bl = DirectoryModel.this.filechooser.isTraversable((File)object);
                    if (bl) {
                        vector3.addElement(object);
                    } else if (!bl && DirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                        vector4.addElement(object);
                    }
                    if (vector3.size() == 4 || n3 == vector2.size() - 1) {
                        UpdateFiles updateFiles = new UpdateFiles(vector3, this.fid);
                        vector.addElement(updateFiles);
                        SwingUtilities.invokeLater(updateFiles);
                        vector3 = new Vector(4);
                    }
                    if (this.isInterrupted()) {
                        this.cancelRunnables(vector);
                        return;
                    }
                    ++n3;
                }
                object = new UpdateFiles(vector4, this.fid);
                vector.addElement(object);
                SwingUtilities.invokeLater((Runnable)object);
                if (this.isInterrupted()) {
                    this.cancelRunnables(vector);
                    return;
                }
            }

            public void cancelRunnables(Vector vector) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((UpdateFiles)vector.elementAt(n2)).cancel();
                    ++n2;
                }
            }
        }
    }
}

