/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.support.DockingTitle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class DockingTitleUI
extends BasicLabelUI
implements MouseListener,
Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    protected static Color selectedTitleColor = UIManager.getColor("activeCaption");
    protected static Color selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
    protected static Color notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
    protected static Color notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    protected static Cursor draggingHand;
    protected static Cursor grabbingHand;

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "activeCaption", "activeCaptionText", "InternalFrame.titleFont");
        if (draggingHand == null) {
            draggingHand = Toolkit.getDefaultToolkit().createCustomCursor(CommonImageRepository.getImage(CommonImageRepository.IMAGE_CLOSED_HAND), new Point(10, 8), "Hand to grab a view for dragging");
            grabbingHand = Toolkit.getDefaultToolkit().createCustomCursor(CommonImageRepository.getImage(CommonImageRepository.IMAGE_OPEN_HAND), new Point(10, 8), "Hand to drag a view for docking or floating");
            jLabel.setCursor(grabbingHand);
        }
        jLabel.addMouseListener(this);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            if (jComponent instanceof DockingTitle && ((DockingTitle)jComponent).getRotation() == 1) {
                graphics.fillRect(0, 0, jComponent.getHeight(), jComponent.getWidth());
            } else {
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        jComponent.setCursor(grabbingHand);
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        if (jComponent instanceof DockingTitle && ((DockingTitle)jComponent).isActive()) {
            jComponent.setForeground(selectedTextColor);
            jComponent.setBackground(selectedTitleColor);
            jComponent.getParent().setBackground(selectedTitleColor);
        } else {
            jComponent.setForeground(notSelectedTextColor);
            jComponent.setBackground(notSelectedTitleColor);
            jComponent.getParent().setBackground(notSelectedTitleColor);
        }
        JLabel jLabel = (JLabel)jComponent;
        boolean bl = false;
        if (jLabel instanceof DockingTitle && ((DockingTitle)jLabel).getRotation() == 1) {
            bl = true;
        }
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        DockingTitleUI.paintViewR.x = DockingTitleUI.paintViewInsets.left;
        DockingTitleUI.paintViewR.y = DockingTitleUI.paintViewInsets.top;
        if (bl) {
            DockingTitleUI.paintViewR.height = jComponent.getWidth() - (DockingTitleUI.paintViewInsets.left + DockingTitleUI.paintViewInsets.right);
            DockingTitleUI.paintViewR.width = jComponent.getHeight() - (DockingTitleUI.paintViewInsets.top + DockingTitleUI.paintViewInsets.bottom);
        } else {
            DockingTitleUI.paintViewR.width = jComponent.getWidth() - (DockingTitleUI.paintViewInsets.left + DockingTitleUI.paintViewInsets.right);
            DockingTitleUI.paintViewR.height = jComponent.getHeight() - (DockingTitleUI.paintViewInsets.top + DockingTitleUI.paintViewInsets.bottom);
        }
        DockingTitleUI.paintIconR.height = 0;
        DockingTitleUI.paintIconR.width = 0;
        DockingTitleUI.paintIconR.y = 0;
        DockingTitleUI.paintIconR.x = 0;
        DockingTitleUI.paintTextR.height = 0;
        DockingTitleUI.paintTextR.width = 0;
        DockingTitleUI.paintTextR.y = 0;
        DockingTitleUI.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, DockingTitleUI.paintIconR.x, DockingTitleUI.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                int n2 = DockingTitleUI.paintTextR.x;
                int n3 = DockingTitleUI.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n2, n3);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n2, n3);
                }
            }
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (((DockingTitle)jComponent).getRotation() == 1) {
            dimension.width = dimension.height;
            dimension.height = 20;
        } else {
            dimension.width = 20;
        }
        return dimension;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(draggingHand);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(grabbingHand);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

