/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class CommonComboPopup
extends BasicComboPopup {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean showOnTop = false;

    public CommonComboPopup(JComboBox jComboBox) {
        super(jComboBox);
    }

    public CommonComboPopup(JComboBox jComboBox, boolean bl) {
        super(jComboBox);
        this.showOnTop = bl;
    }

    public void show() {
        Dimension dimension = this.list.getPreferredScrollableViewportSize();
        dimension.width += 5;
        int n2 = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
            n2 += 2;
        }
        if (this.comboBox.getItemCount() >= this.comboBox.getMaximumRowCount()) {
            int n3 = this.scroller.getVerticalScrollBar().getSize().width;
            dimension.width = n3 == 0 ? (dimension.width += 16) : (dimension.width += n3);
        }
        Dimension dimension2 = this.comboBox.getSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > dimension3.width - 10) {
            dimension.width = dimension3.width - 10;
        }
        dimension.setSize(dimension.width, n2);
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        this.scroller.setMaximumSize(rectangle.getSize());
        this.scroller.setPreferredSize(rectangle.getSize());
        this.scroller.setMinimumSize(rectangle.getSize());
        this.list.invalidate();
        this.synchListSelectionWithComboBoxSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, rectangle.x, rectangle.y);
    }

    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        Point point;
        Serializable serializable;
        boolean bl;
        Rectangle rectangle2 = new Rectangle(n2, this.showOnTop ? -n5 : n3, n4, n5);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl2 = bl = this.getDialog() != null;
        if (bl) {
            serializable = this.getDialog();
            point = null;
            if (serializable instanceof JDialog) {
                JRootPane jRootPane = ((JDialog)serializable).getRootPane();
                rectangle = jRootPane.getBounds();
                point = jRootPane.isShowing() ? jRootPane.getLocationOnScreen() : new Point();
                rectangle.x = point.x;
                rectangle.y = point.y;
            } else {
                rectangle = serializable.getBounds();
            }
            point = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointFromScreen(point, this.comboBox);
            rectangle.x = point.x;
            rectangle.y = point.y;
        } else {
            rectangle = new Rectangle();
            serializable = new Point(0, 0);
            SwingUtilities.convertPointFromScreen((Point)serializable, this.comboBox);
            rectangle.x = ((Point)serializable).x;
            rectangle.y = ((Point)serializable).y;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        serializable = new Rectangle(0, this.showOnTop ? n3 : -rectangle2.height, rectangle2.width, rectangle2.height);
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, (Rectangle)serializable)) {
            return serializable;
        }
        point = null;
        point = this.comboBox.isShowing() ? this.comboBox.getLocationOnScreen() : new Point();
        if (this.showOnTop) {
            if (point.y - rectangle2.height < 0) {
                rectangle2.y = n3;
            }
        } else if (point.y + rectangle2.height > dimension.height) {
            rectangle2.y = -rectangle2.height;
        }
        if (point.x + rectangle2.width > dimension.width) {
            rectangle2.x = dimension.width - (point.x + rectangle2.width + 10);
        }
        return rectangle2;
    }

    private Dialog getDialog() {
        Container container = this.comboBox.getParent();
        while (container != null && !(container instanceof Dialog) && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container instanceof Dialog) {
            return (Dialog)container;
        }
        return null;
    }

    protected void synchListSelectionWithComboBoxSelection() {
        int n2 = this.comboBox.getSelectedIndex();
        if (n2 == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n2);
        }
    }
}

