/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class AssistTableUI
extends BasicTableUI
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JTable theTable;
    private Hashtable registeredKeyStrokes = new Hashtable();

    public AssistTableUI(JTable jTable) {
        this.theTable = jTable;
        this.table = jTable;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AssistTableUI((JTable)jComponent);
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.registeredKeyStrokes.put(keyStroke, actionListener);
        this.theTable.registerKeyboardAction(actionListener, keyStroke, 1);
    }

    protected KeyListener createKeyListener() {
        return new AssistKeyHandler();
    }

    public class AssistKeyHandler
    implements KeyListener,
    Serializable {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 0) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            if (AssistTableUI.this.registeredKeyStrokes.get(keyStroke) != null) {
                return;
            }
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            if (AssistTableUI.this.theTable == null || AssistTableUI.this.theTable.getSelectionModel() == null || AssistTableUI.this.theTable.getColumnModel() == null) {
                return;
            }
            int n2 = AssistTableUI.this.theTable.getSelectionModel().getAnchorSelectionIndex();
            int n3 = AssistTableUI.this.theTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n2 != -1 && n3 != -1 && !AssistTableUI.this.theTable.isEditing() && !AssistTableUI.this.theTable.editCellAt(n2, n3)) {
                return;
            }
            Component component = AssistTableUI.this.theTable.getEditorComponent();
            if (AssistTableUI.this.theTable.isEditing() && component != null) {
                Component component2 = component;
                if (component2 != null && component2 instanceof JScrollPane) {
                    component2 = ((JScrollPane)component).getViewport().getView();
                }
                if (component2 instanceof JTextComponent) {
                    JTextComponent jTextComponent = (JTextComponent)component;
                    Keymap keymap = jTextComponent.getKeymap();
                    Action action = keymap.getAction(keyStroke);
                    if (action == null) {
                        action = keymap.getDefaultAction();
                    }
                    if (action != null) {
                        ActionEvent actionEvent = new ActionEvent(jTextComponent, 1001, String.valueOf(keyEvent.getKeyChar()));
                        action.actionPerformed(actionEvent);
                        keyEvent.consume();
                    }
                }
            }
        }
    }
}

