/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import com.ibm.db2.tools.common.AssistField;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;

public class AssistFieldView
extends FieldView {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected AssistField field;

    public AssistFieldView(Element element, AssistField assistField) {
        super(element);
        this.field = assistField;
    }

    protected void drawLine(int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement().getElement(n2);
        try {
            if (element.isLeaf()) {
                this.drawElement(element, graphics, n3, n4);
            } else {
                int n5 = element.getElementCount();
                int n6 = 0;
                while (n6 < n5) {
                    Element element2 = element.getElement(n6);
                    n3 = this.drawElement(element2, graphics, n3, n4);
                    ++n6;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new Error("Can't render line: " + n2);
        }
    }

    private int drawElement(Element element, Graphics graphics, int n2, int n3) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        int n4 = jTextComponent.getSelectionStart();
        int n5 = jTextComponent.getSelectionEnd();
        int n6 = element.getStartOffset();
        int n7 = element.getEndOffset();
        n7 = Math.min(this.getDocument().getLength(), n7);
        AttributeSet attributeSet = element.getAttributes();
        if (this.isComposedTextAttributeDefined(attributeSet)) {
            Color color = this.field.isEnabled() ? this.field.getForeground() : this.field.getDisabledTextColor();
            graphics.setColor(color);
            n2 = this.drawComposedText(attributeSet, graphics, n2, n3, n6 - element.getStartOffset(), n7 - element.getStartOffset());
        } else if (n4 == n5) {
            n2 = this.drawUnselectedText(graphics, n2, n3, n6, n7, true);
        } else if (n6 >= n4 && n6 <= n5 && n7 >= n4 && n7 <= n5) {
            n2 = this.drawSelectedText(graphics, n2, n3, n6, n7);
        } else if (n4 >= n6 && n4 <= n7) {
            if (n5 >= n6 && n5 <= n7) {
                n2 = this.drawUnselectedText(graphics, n2, n3, n6, n4, false);
                n2 = this.drawSelectedText(graphics, n2, n3, n4, n5);
                n2 = this.drawUnselectedText(graphics, n2, n3, n5, n7, false);
            } else {
                n2 = this.drawUnselectedText(graphics, n2, n3, n6, n4, false);
                n2 = this.drawSelectedText(graphics, n2, n3, n4, n7);
            }
        } else if (n5 >= n6 && n5 <= n7) {
            n2 = this.drawSelectedText(graphics, n2, n3, n6, n5);
            n2 = this.drawUnselectedText(graphics, n2, n3, n5, n7, false);
        } else {
            n2 = this.drawUnselectedText(graphics, n2, n3, n6, n7, false);
        }
        return n2;
    }

    protected boolean isComposedTextAttributeDefined(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    protected int drawComposedText(AttributeSet attributeSet, Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n4 >= n5) {
            return n2;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n4, n5);
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, n2, n3);
        return n2 + (int)textLayout.getAdvance();
    }

    protected int drawUnselectedText(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) throws BadLocationException {
        Color color = this.field.isEnabled() ? this.field.getForeground() : this.field.getDisabledTextColor();
        graphics.setColor(color);
        Document document = this.getDocument();
        int n6 = document.getLength();
        String string = document.getText(0, document.getLength());
        int n7 = 0;
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.field.getInsets();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this.field.getParent(), this.field.getBounds(), this.field);
        rectangle2.x += insets.left;
        rectangle2.width -= insets.left + insets.right;
        rectangle2.height -= insets.top + insets.bottom;
        if (bl && this.field.getPaintClipped() && !this.field.hasFocus()) {
            Rectangle rectangle3 = new Rectangle();
            String string2 = SwingUtilities.layoutCompoundLabel(graphics.getFontMetrics(), string, null, 0, this.field.getHorizontalAlignment(), 1, 4, rectangle2, new Rectangle(), rectangle3, 0);
            if (rectangle.width == rectangle2.width && !string.equals(string2)) {
                graphics.drawString(string2, rectangle.x, n3);
            } else {
                graphics.drawString(string2, rectangle2.x, n3);
                n7 = rectangle.width;
            }
            n7 = rectangle2.width - n2;
        } else {
            string = document.getText(n4, n5 - n4);
            graphics.drawString(string, n2, n3);
            n7 = graphics.getFontMetrics().stringWidth(string);
        }
        return n2 + n7;
    }
}

