/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.plaf;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.plaf.AssistFieldView;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class AssistFieldUI
extends BasicTextFieldUI
implements PropertyChangeListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean docIsComplex = false;

    public static ComponentUI createUI(JComponent jComponent) {
        AssistFieldUI assistFieldUI = new AssistFieldUI();
        jComponent.addPropertyChangeListener("i18n", assistFieldUI);
        return assistFieldUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("i18n") && (object = propertyChangeEvent.getNewValue()) instanceof Boolean) {
            this.docIsComplex = (Boolean)object;
        }
    }

    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    public View create(Element element) {
        if (this.docIsComplex) {
            return super.create(element);
        }
        return new AssistFieldView(element, (AssistField)super.getComponent());
    }

    protected void installDefaults() {
        super.installDefaults();
        JTextComponent jTextComponent = this.getComponent();
        Insets insets = jTextComponent.getMargin();
        if (insets == null || insets instanceof UIResource) {
            jTextComponent.setMargin(UIManager.getInsets("AssistField.margin"));
        }
    }

    class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent jTextComponent = super.getComponent();
            if (jTextComponent.isEnabled()) {
                if (jTextComponent.isEditable()) {
                    this.setVisible(true);
                }
                this.setSelectionVisible(true);
                if (jTextComponent instanceof AssistField && ((AssistField)jTextComponent).getSelectWhenFocusGained()) {
                    Document document = jTextComponent.getDocument();
                    this.setDot(0);
                    this.moveDot(document.getLength());
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.setDot(this.getDot());
            this.setVisible(false);
        }

        protected void adjustVisibility(Rectangle rectangle) {
            JTextField jTextField = (JTextField)super.getComponent();
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n2 = rectangle.x + boundedRangeModel.getValue();
            int n3 = boundedRangeModel.getExtent() / 4;
            if (n2 < boundedRangeModel.getValue()) {
                boundedRangeModel.setValue(n2 - n3);
            } else if (n2 > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
                boundedRangeModel.setValue(n2 - 3 * n3);
            }
        }
    }
}

