/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.filesystem;

import com.ibm.db2.tools.common.CmStringPool;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;

public class LocalFileSystemView
extends FileSystemView {
    private static final int FS_ERROR_PATH_EXISTS = 1;
    private static final int FS_ERROR_PATH_DOESNT_EXIST = 2;
    private static final int FS_ERROR_FILEDIR_READ_ONLY = 3;
    private static final int FS_ERROR_FILEDIR_IN_USE = 4;
    private static final int FS_ERROR_FILEDIR_NOT_ACCESSIBLE = 5;
    private static final int FS_ERROR_DEVICE_NOT_AVAILABLE = 6;
    private static final int FS_ERROR_DIR_NOT_EMPTY = 7;
    private static final int FS_ERROR_PATH_NOT_DIR = 8;
    private static final int FS_ERROR_PATH_INVALID = 9;
    private static final int FS_ERROR_PATH_TOO_LONG = 10;
    private static final int FS_ERROR_NO_SPACE_AVAILABLE = 11;
    private static final int FS_ERROR_TOO_MANY_FILES_OPEN = 12;
    private static final int FS_ERROR_EOF_REACHED = 13;
    private static final int FS_ERROR_PHYSICAL_IO_ERROR = 14;
    protected static final String newFolderString = CmStringPool.get(340);
    protected static final String newFolderNextString = newFolderString + " ({0})";
    protected Hashtable fileTypeCache = new Hashtable();
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    protected boolean fsAvailable = true;
    protected int errorCode;
    protected String errorPath;

    public LocalFileSystemView() {
        this.populateFileTypeCache();
    }

    public static FileSystemView getFileSystemView() {
        return new LocalFileSystemView();
    }

    public boolean isRoot(File file) {
        File[] fileArray = this.getRoots();
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].equals(file)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String getSystemTypeDescription(File file) {
        String string;
        if (file.isDirectory()) {
            return CmStringPool.get(339);
        }
        String string2 = this.getExtension(file);
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        if ((string = (String)this.fileTypeCache.get(string2)) == null) {
            string = string2.toUpperCase() + " " + this.fileTypeCache.get("");
            this.fileTypeCache.put(string2, string);
        }
        return string;
    }

    public File createNewFolder(File file) throws IOException {
        File file2 = null;
        try {
            file2 = this.createNewFolderThrowsException(file);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file2;
    }

    public File createNewFolderThrowsException(File file) throws Exception {
        if (file == null) {
            throw new IOException("Containing directory is null:");
        }
        File file2 = null;
        file2 = this.createFileObject(file, newFolderString);
        int n2 = 2;
        while (file2.exists() && n2 < 100) {
            String string = MessageFormat.format(newFolderNextString, new Integer(n2));
            file2 = this.createFileObject(file, string);
            ++n2;
        }
        if (file2.exists()) {
            throw new IOException("Directory already exists:" + file2.getAbsolutePath());
        }
        file2.mkdirs();
        return file2;
    }

    public boolean deleteFileDirThrowsException(File file) throws Exception {
        boolean bl = file.delete();
        if (!bl) {
            if (!file.exists()) {
                this.errorCode = 2;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_PATH_DOESNT_EXIST:" + this.errorPath);
            }
            boolean bl2 = true;
            try {
                bl2 = file.canRead() && file.canWrite();
            }
            catch (SecurityException securityException) {
                bl2 = false;
            }
            if (!bl2) {
                this.errorCode = 5;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_FILEDIR_NOT_ACCESSIBLE:" + this.errorPath);
            }
        }
        return bl;
    }

    public boolean renameFileThrowsException(File file, File file2) throws Exception {
        boolean bl = file.renameTo(file2);
        if (!bl) {
            if (file2.exists()) {
                this.errorCode = 1;
                this.errorPath = file2.getAbsolutePath();
                throw new Exception("FS_ERROR_PATH_EXISTS:" + this.errorPath);
            }
            if (!file.exists()) {
                this.errorCode = 2;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_PATH_DOESNT_EXIST:" + this.errorPath);
            }
            boolean bl2 = true;
            try {
                bl2 = file.canRead() && file.canWrite();
            }
            catch (SecurityException securityException) {
                bl2 = false;
            }
            if (!bl2) {
                this.errorCode = 5;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_FILEDIR_NOT_ACCESSIBLE:" + this.errorPath);
            }
        }
        return bl;
    }

    public boolean pathExistsThrowsException(File file) throws Exception {
        return file.exists();
    }

    public boolean isHiddenFile(File file) {
        return this.fsv.isHiddenFile(file);
    }

    public File[] getRoots() {
        File[] fileArray = new File[]{};
        try {
            fileArray = this.getRootsThrowsException();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileArray;
    }

    public File[] getRootsThrowsException() throws Exception {
        File[] fileArray = File.listRoots();
        int n2 = 0;
        while (n2 < fileArray.length) {
            fileArray[n2] = new FileSystemRoot(fileArray[n2]);
            ++n2;
        }
        return fileArray;
    }

    public File getHomeDirectory() {
        File[] fileArray = this.getRoots();
        if (File.separatorChar == '\\') {
            int n2 = 0;
            while (n2 < fileArray.length) {
                String string = fileArray[n2].getAbsolutePath();
                if (string != null && !string.equals("A:\\") && !string.equals("B:\\")) {
                    return fileArray[n2];
                }
                ++n2;
            }
        }
        if (File.separatorChar == '/' && fileArray != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    public File createFileObject(File file, String string) {
        return this.fsv.createFileObject(file, string);
    }

    public File createFileObject(String string) {
        return this.fsv.createFileObject(string);
    }

    public File[] getFiles(File file, boolean bl) {
        File[] fileArray = new File[]{};
        try {
            fileArray = this.getFilesThrowsException(file, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileArray;
    }

    public File[] getFilesThrowsException(File file, boolean bl) throws Exception {
        File[] fileArray = this.fsv.getFiles(file, bl);
        if (fileArray.length == 0) {
            if (!file.exists()) {
                this.errorCode = 6;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_DEVICE_NOT_AVAILABLE:" + this.errorPath);
            }
            boolean bl2 = true;
            try {
                bl2 = file.canRead();
            }
            catch (SecurityException securityException) {
                bl2 = false;
            }
            if (!bl2) {
                this.errorCode = 5;
                this.errorPath = file.getAbsolutePath();
                throw new Exception("FS_ERROR_FILEDIR_NOT_ACCESSIBLE:" + this.errorPath);
            }
        }
        return fileArray;
    }

    public File getParentDirectory(File file) {
        if (file == null) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file2 = this.createFileObject(file.getAbsolutePath());
        String string = file2.getParent();
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    private void populateFileTypeCache() {
        this.fileTypeCache.put("exe", CmStringPool.get(378));
        this.fileTypeCache.put("asc", CmStringPool.get(379));
        this.fileTypeCache.put("bat", CmStringPool.get(380));
        this.fileTypeCache.put("dat", CmStringPool.get(381));
        this.fileTypeCache.put("", CmStringPool.get(382));
        this.fileTypeCache.put("jpg", "JPEG " + CmStringPool.get(383));
        this.fileTypeCache.put("jpeg", "JPEG " + CmStringPool.get(383));
        this.fileTypeCache.put("gif", "GIF " + CmStringPool.get(383));
        this.fileTypeCache.put("sh", CmStringPool.get(384));
        this.fileTypeCache.put("c", "C " + CmStringPool.get(385));
        this.fileTypeCache.put("cpp", "CPP " + CmStringPool.get(385));
        this.fileTypeCache.put("sys", CmStringPool.get(386));
        this.fileTypeCache.put("txt", CmStringPool.get(387));
        this.fileTypeCache.put("xml", CmStringPool.get(388));
        this.fileTypeCache.put("doc", CmStringPool.get(389));
    }

    private String getExtension(File file) {
        String string;
        int n2;
        String string2 = "";
        if (file != null && (n2 = (string = file.getAbsolutePath()).lastIndexOf(46)) > 0 && n2 < string.length() - 1) {
            string2 = string.substring(n2).toLowerCase();
        }
        return string2;
    }

    public void updateFileSystemAvailability() {
    }

    public boolean isFileSystemAvailable() {
        return this.fsAvailable;
    }

    public String getErrorMessage() {
        switch (this.errorCode) {
            case 1: {
                return CmStringPool.get(398, this.errorPath);
            }
            case 2: {
                return CmStringPool.get(399, this.errorPath);
            }
            case 3: {
                return CmStringPool.get(400, this.errorPath);
            }
            case 4: {
                return CmStringPool.get(401, this.errorPath);
            }
            case 5: {
                return CmStringPool.get(402, this.errorPath);
            }
            case 6: {
                return CmStringPool.get(403, this.errorPath);
            }
        }
        return CmStringPool.get(404);
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File file) {
            super(file, "");
        }

        public FileSystemRoot(String string) {
            super(string);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

