/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common.filesystem;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.filesystem.ExtensionFileFilter;
import com.ibm.db2.tools.common.filesystem.LocalFileSystemView;
import com.ibm.db2.tools.common.plaf.FileChooserUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends JFileChooser {
    public FileFilter sqlScriptsFilter = null;
    public FileFilter dataFilesFilter = null;
    public FileFilter textFilesFilter = null;
    public FileFilter docFilesFilter = null;
    public FileFilter batchFileFilter = null;
    public FileFilter iniFilesFilter = null;
    public FileFilter cFilesFilter = null;
    public FileFilter headerFilesFilter = null;
    public FileFilter javaFilesFilter = null;
    public FileFilter htmlFilesFilter = null;
    public FileFilter xmlFilesFilter = null;
    protected boolean basicFiltersAdded = false;
    private File[] selectedFiles;
    private String homeDirectoryPath = null;

    public FileChooser() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser()");
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    public FileChooser(String string) {
        super(string);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser(String currentDirectoryPath)", new Object[]{string});
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    public FileChooser(File file) {
        super(file);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser(File currentDirectory)", new Object[]{file});
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    public FileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser(FileSystemView fsv)", new Object[]{fileSystemView});
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    public FileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser(File currentDirectory, FileSystemView fsv)", new Object[]{file, fileSystemView});
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    public FileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "FileChooser(String currentDirectoryPath, FileSystemView fsv)", new Object[]{string, fileSystemView});
        }
        this.addBasicFileFilters();
        CommonTrace.exit(commonTrace);
    }

    protected void setup(FileSystemView fileSystemView) {
        if (fileSystemView == null) {
            fileSystemView = new LocalFileSystemView();
        }
        this.setFileSystemView(fileSystemView);
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "setFileSystemView(FileSystemView fsv)", new Object[]{fileSystemView});
        }
        super.setFileSystemView(fileSystemView);
        this.setCurrentDirectory(fileSystemView.getHomeDirectory());
        if (this.isMultiSelectionEnabled()) {
            this.setSelectedFiles(null);
        } else {
            this.setSelectedFile(null);
        }
        this.updateUI();
        CommonTrace.exit(commonTrace);
    }

    public void setCurrentDirectory(File file) {
        this.setCurrentDirectory(file, true);
    }

    public void setCurrentDirectory(File file, boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "setCurrentDirectory(File dir)", new Object[]{file});
        }
        if (bl && file != null) {
            String string = file.getAbsolutePath();
            if (string != null && !string.equals("")) {
                file = this.getFileSystemView().createFileObject(string);
            }
            File file2 = null;
            while (!(file == null || file.exists() && file.isDirectory() || file2 == file)) {
                file2 = file;
                file = this.getFileSystemView().getParentDirectory(file);
                if (file != null) continue;
                file = file2;
            }
        }
        super.setCurrentDirectory(file);
        CommonTrace.exit(commonTrace);
    }

    public void setCurrentDirectory(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "setCurrentDirectory(String directoryPath)", new Object[]{string});
        }
        File file = null;
        if (string != null) {
            if (string != null && !string.equals("")) {
                file = this.getFileSystemView().createFileObject(string);
            }
            File file2 = null;
            while (!(file == null || file.exists() && file.isDirectory() || file2 == file)) {
                file2 = file;
                file = this.getFileSystemView().getParentDirectory(file);
                if (file != null) continue;
                file = file2;
            }
        }
        super.setCurrentDirectory(file);
        CommonTrace.exit(commonTrace);
    }

    public void setApproveButtonToolTipText(String string) {
    }

    public int showDialog(Component component) {
        if (null == this.getDialogTitle()) {
            this.setDialogTitle("");
        }
        return this.showDialog(component, CmStringPool.get(358));
    }

    public String getSelectedFileName() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "getSelectedFileName()");
        }
        String string = null;
        File file = this.getSelectedFile();
        if (file != null) {
            string = file.getAbsolutePath();
        }
        return (String)CommonTrace.exit(commonTrace, string);
    }

    public String[] getSelectedFileNames() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "getSelectedFileNames()");
        }
        String[] stringArray = null;
        File[] fileArray = this.getSelectedFiles();
        int n2 = fileArray.length;
        if (n2 > 0) {
            stringArray = new String[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = fileArray[n3].getAbsolutePath();
            ++n3;
        }
        return (String[])CommonTrace.exit(commonTrace, stringArray);
    }

    public void updateUI() {
        javax.swing.plaf.FileChooserUI fileChooserUI;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "updateUI()");
        }
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if ((fileChooserUI = this.getUI()) != null && fileChooserUI instanceof FileChooserUI) {
            ((FileChooserUI)fileChooserUI).showNormalCursor();
        }
        fileChooserUI = new FileChooserUI(this);
        if (this.getFileSystemView() == null) {
            this.setFileSystemView(new LocalFileSystemView());
        }
        this.setUI(fileChooserUI);
        this.setFileView(this.getUI().getFileView(this));
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        CommonTrace.exit(commonTrace);
    }

    private void createBasicFileFilters() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "createBasicFileFilters()");
        }
        Vector<String> vector = new Vector<String>();
        vector.add("sql");
        vector.add("db2");
        vector.add("clp");
        this.sqlScriptsFilter = new ExtensionFileFilter(vector, CmStringPool.get(361));
        this.dataFilesFilter = new ExtensionFileFilter("dat", CmStringPool.get(362));
        this.textFilesFilter = new ExtensionFileFilter("txt", CmStringPool.get(363));
        this.docFilesFilter = new ExtensionFileFilter("doc", CmStringPool.get(364));
        this.batchFileFilter = new ExtensionFileFilter("bat", CmStringPool.get(365));
        this.iniFilesFilter = new ExtensionFileFilter("ini", CmStringPool.get(366));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("c");
        vector2.add("cpp");
        this.cFilesFilter = new ExtensionFileFilter(vector2, CmStringPool.get(367));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("h");
        vector3.add("hpp");
        this.headerFilesFilter = new ExtensionFileFilter(vector3, CmStringPool.get(368));
        Vector<String> vector4 = new Vector<String>();
        vector4.add("java");
        vector4.add("jav");
        this.javaFilesFilter = new ExtensionFileFilter(vector4, CmStringPool.get(369));
        Vector<String> vector5 = new Vector<String>();
        vector5.add("html");
        vector5.add("htm");
        this.htmlFilesFilter = new ExtensionFileFilter(vector5, CmStringPool.get(370));
        this.xmlFilesFilter = new ExtensionFileFilter("xml", CmStringPool.get(371));
        CommonTrace.exit(commonTrace);
    }

    public void addBasicFileFilters() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "addBasicFileFilters()");
        }
        if (this.basicFiltersAdded) {
            return;
        }
        this.basicFiltersAdded = true;
        if (this.sqlScriptsFilter == null) {
            this.createBasicFileFilters();
        }
        this.removePropertyChangeListener(((FileChooserUI)this.getUI()).getDirectoryModel());
        this.addChoosableFileFilter(this.sqlScriptsFilter);
        this.addChoosableFileFilter(this.dataFilesFilter);
        this.addChoosableFileFilter(this.textFilesFilter);
        this.addChoosableFileFilter(this.docFilesFilter);
        this.addChoosableFileFilter(this.batchFileFilter);
        this.addChoosableFileFilter(this.iniFilesFilter);
        this.addChoosableFileFilter(this.cFilesFilter);
        this.addChoosableFileFilter(this.headerFilesFilter);
        this.addChoosableFileFilter(this.javaFilesFilter);
        this.addChoosableFileFilter(this.htmlFilesFilter);
        this.addChoosableFileFilter(this.xmlFilesFilter);
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
        this.addPropertyChangeListener(((FileChooserUI)this.getUI()).getDirectoryModel());
        CommonTrace.exit(commonTrace);
    }

    public void removeBasicFileFilters() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common.filesystem", "FileChooser", this, "removeBasicFileFilters()");
        }
        if (!this.basicFiltersAdded) {
            return;
        }
        this.basicFiltersAdded = false;
        this.removeChoosableFileFilter(this.sqlScriptsFilter);
        this.removeChoosableFileFilter(this.dataFilesFilter);
        this.removeChoosableFileFilter(this.textFilesFilter);
        this.removeChoosableFileFilter(this.docFilesFilter);
        this.removeChoosableFileFilter(this.batchFileFilter);
        this.removeChoosableFileFilter(this.iniFilesFilter);
        this.removeChoosableFileFilter(this.cFilesFilter);
        this.removeChoosableFileFilter(this.headerFilesFilter);
        this.removeChoosableFileFilter(this.javaFilesFilter);
        this.removeChoosableFileFilter(this.htmlFilesFilter);
        this.removeChoosableFileFilter(this.xmlFilesFilter);
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
        CommonTrace.exit(commonTrace);
    }

    public String getHomeDirectoryPath() {
        return this.homeDirectoryPath;
    }

    public void setHomeDirectory(String string) {
        this.homeDirectoryPath = string;
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return (File[])this.selectedFiles.clone();
    }

    public void setSelectedFiles(File[] fileArray) {
        File[] fileArray2 = this.selectedFiles;
        if (fileArray != null && fileArray.length == 0) {
            fileArray = null;
        }
        this.selectedFiles = fileArray;
        this.setSelectedFile(fileArray != null ? fileArray[0] : null);
        this.firePropertyChange("SelectedFilesChangedProperty", fileArray2, this.selectedFiles);
    }

    public void simulateApproveButtonClicked(ActionEvent actionEvent) {
        ((FileChooserUI)this.getUI()).getApproveSelectionAction().actionPerformed(actionEvent);
    }

    public void simulateCancelButtonClicked(ActionEvent actionEvent) {
        ((FileChooserUI)this.getUI()).getCancelSelectionAction().actionPerformed(actionEvent);
    }

    public void addFileNameDocumentListener(DocumentListener documentListener) {
        ((FileChooserUI)this.getUI()).addFileNameTextFieldDocumentListener(documentListener);
    }

    public void removeFileNameDocumentListener(DocumentListener documentListener) {
        ((FileChooserUI)this.getUI()).removeFileNameTextFieldDocumentListener(documentListener);
    }

    public void addFileNameAssistListener(AssistListener assistListener) {
        ((FileChooserUI)this.getUI()).addFileNameTextFieldAssistListener(assistListener);
    }

    public void removeFileNameAssistListener(AssistListener assistListener) {
        ((FileChooserUI)this.getUI()).removeFileNameTextFieldAssistListener(assistListener);
    }
}

