/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.smartx.support.HtmlSymbols;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class WrappingButton
extends JButton
implements Accessible,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int DEFAULT_MAXWIDTH = 1600;
    protected Rectangle bounds = new Rectangle();
    protected int maxWidth = this.DEFAULT_MAXWIDTH;
    protected ArrayList segments;
    protected ArrayList widths;
    protected BreakIterator wordBreaker;
    protected int hangingIndent;
    private static final String uiClassID = "WrappingButtonUI";

    public WrappingButton() {
        this(null, null);
    }

    public WrappingButton(Icon icon) {
        this(null, icon);
    }

    public WrappingButton(String string) {
        this(string, null);
    }

    public WrappingButton(Action action) {
        this();
        this.setAction(action);
    }

    public WrappingButton(String string, Icon icon) {
        super(string, icon);
        this.setMinimumSize(new Dimension(0, 0));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String getIndentTemplate(String string) {
        if (string == null) {
            string = this.getText();
        }
        string = HtmlSymbols.symbolsToChars(string);
        if (this.wordBreaker == null) {
            this.wordBreaker = BreakIterator.getWordInstance(AssistManager.getPreferredLanguage());
        }
        this.wordBreaker.setText(string);
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        String string2 = "";
        int n2 = this.wordBreaker.first();
        int n3 = this.wordBreaker.next();
        boolean bl = true;
        boolean bl2 = false;
        while (bl && n3 != -1) {
            string2 = string.substring(n2, n3);
            if (bl2 && this.trimAll(string2).length() > 0) {
                bl = false;
            } else if (bl) {
                if (this.trimAll(string2).length() == 0) {
                    bl2 = true;
                }
                reuseStringBuffer.append(string2);
            }
            n2 = n3;
            n3 = this.wordBreaker.next();
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected String trimAll(String string) {
        String string2 = string.trim();
        if (string2.length() > 0) {
            while (string2.length() > 0 && string2.charAt(0) == '\u00a0') {
                string2 = string2.length() == 1 ? "" : string2.substring(1).trim();
            }
            while (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\u00a0') {
                string2 = string2.length() == 1 ? "" : string2.substring(0, string2.length() - 1).trim();
            }
        }
        return string2;
    }

    public void setHangingIndent(String string) {
        Font font = this.getFont();
        if (font == null) {
            font = UIManager.getFont("Button.font");
        }
        if (string == null) {
            string = this.getIndentTemplate(this.getText());
        }
        this.hangingIndent = AssistManager.getStringWidth(string, this, font);
    }

    public int getHangingIndent() {
        return this.hangingIndent;
    }

    public void calculateBreaks() {
        Font font;
        Insets insets = this.getInsets();
        int n2 = this.maxWidth - insets.left - insets.right;
        if (this.segments == null) {
            this.segments = new ArrayList();
            this.widths = new ArrayList();
        }
        if (this.wordBreaker == null) {
            this.wordBreaker = BreakIterator.getWordInstance(AssistManager.getPreferredLanguage());
        }
        if ((font = this.getFont()) == null) {
            font = UIManager.getFont("Button.font");
        }
        this.segments.clear();
        this.widths.clear();
        String string = HtmlSymbols.symbolsToChars(this.getText());
        if (string != null && string.length() > 0) {
            Object object;
            int n3 = AssistManager.getStringWidth(string, this, font);
            if (n2 > n3) {
                this.segments.add(string);
                this.widths.add(new Integer(n3));
                n2 = n3 + insets.left + insets.right;
            } else {
                String string2;
                this.wordBreaker.setText(string);
                object = ReuseStringBuffer.getBuffer();
                int n4 = this.wordBreaker.first();
                int n5 = this.wordBreaker.next();
                int n6 = 0;
                int n7 = 0;
                while (n5 != -1) {
                    String string3 = string.substring(n4, n5);
                    n3 = AssistManager.getStringWidth(string3, this, font);
                    if (n7 + n3 > n2) {
                        n2 = n7 + n3;
                    }
                    if (n6 + n3 > n2 && ((ReuseStringBuffer)object).charAt(((ReuseStringBuffer)object).length() - 1) != '\u00a0') {
                        n7 = this.hangingIndent;
                        n6 = n7 + n3;
                        string2 = ((ReuseStringBuffer)object).toString().trim();
                        if (string2.length() > 0) {
                            this.segments.add(string2);
                        }
                        ((ReuseStringBuffer)object).setLength(0);
                    } else if ((n6 += n3) > n2) {
                        n2 = n6;
                    }
                    ((ReuseStringBuffer)object).append(string3);
                    n4 = n5;
                    n5 = this.wordBreaker.next();
                }
                if (n6 > 0 && (string2 = ((ReuseStringBuffer)object).toString().trim()).length() > 0) {
                    this.segments.add(string2);
                }
                ReuseStringBuffer.freeBuffer((ReuseStringBuffer)object);
                int n8 = 0;
                while (n8 < this.segments.size()) {
                    String string4 = ((String)this.segments.get(n8)).trim();
                    this.segments.set(n8, string4);
                    n6 = AssistManager.getStringWidth(string4, this, font);
                    this.widths.add(new Integer(n6));
                    ++n8;
                }
                n2 += insets.left + insets.right;
                n2 = Math.max(this.maxWidth, n2);
            }
            this.bounds = this.getBounds(this.bounds);
            this.bounds.width = n2;
            object = AssistManager.getLineMetrics(string, this, font);
            this.bounds.height = this.segments.size() * (int)(((LineMetrics)object).getHeight() + ((LineMetrics)object).getLeading()) + insets.top + insets.bottom;
            this.setPreferredSize(new Dimension(this.bounds.width, this.bounds.height));
            this.setMinimumSize(new Dimension(0, this.bounds.height));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.bounds.height));
        }
    }

    public Iterator getSegments() {
        if (this.segments == null) {
            this.calculateBreaks();
        }
        return ((AbstractList)this.segments).iterator();
    }

    public Iterator getSegmentWidths() {
        if (this.widths == null) {
            this.calculateBreaks();
        }
        return ((AbstractList)this.widths).iterator();
    }

    public int getSegmentCount() {
        if (this.segments == null) {
            return 1;
        }
        return this.segments.size();
    }

    public void setMaxWidth(int n2) {
        this.maxWidth = n2;
        this.calculateBreaks();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setText(String string) {
        super.setText(string);
        this.calculateBreaks();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.calculateBreaks();
    }
}

