/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.Page;
import com.ibm.db2.tools.common.Workbook;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.Icon;

public class WorkbookPage
implements Page {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String name;
    protected String title;
    protected Icon icon;
    protected Component client;
    protected Workbook workbook;
    protected boolean enabled = true;
    Rectangle tabBounds = new Rectangle();

    public WorkbookPage() {
        this(null, null, null);
    }

    public WorkbookPage(String string) {
        this(string, null, null);
    }

    public WorkbookPage(String string, String string2) {
        this(string, string2, null);
    }

    public WorkbookPage(String string, Icon icon) {
        this(string, null, icon);
    }

    public WorkbookPage(String string, String string2, Icon icon) {
        this.name = string;
        this.title = string2;
        this.icon = icon;
    }

    public void setClient(Component component) {
        this.client = component;
        if (this.workbook != null) {
            this.workbook.updateClient(this);
        }
    }

    public Component getClient() {
        return this.client;
    }

    public String getTitle() {
        return this.title != null ? this.title : this.name;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.workbook != null) {
            this.workbook.tabModified(this);
            this.workbook.repaint();
        }
    }

    public void setName(String string) {
        this.name = string;
        if (this.workbook != null) {
            this.workbook.tabModified(this);
            this.workbook.repaint();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.workbook != null) {
            this.workbook.tabModified(this);
            this.workbook.repaint();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isSelected() {
        if (this.workbook == null) {
            return false;
        }
        return this.workbook.getCurrentPage() == this;
    }

    public boolean isAdded() {
        return this.workbook != null;
    }

    void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Rectangle getTabBounds() {
        return this.tabBounds;
    }

    public void setTabBounds(int n2, int n3, int n4, int n5) {
        this.tabBounds.x = n2;
        this.tabBounds.y = n3;
        this.tabBounds.width = n4;
        this.tabBounds.height = n5;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.workbook != null) {
            this.workbook.tabModified(this);
            this.workbook.repaint();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDetached() {
        return !this.isAdded();
    }
}

