/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.WorkbookPage;
import com.ibm.db2.tools.common.plaf.WorkbookUI;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Workbook
extends JTabbedPane
implements ItemSelectable,
Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTEBOOK = 1;
    public static final int WORKBOOK = 0;
    public static final int MINOR_WORKBOOK = 2;
    protected Vector pages = new Vector();
    protected boolean historyVisible = true;
    protected boolean tabsVisible = true;
    protected int mode = 0;
    protected NotebookListener nl;
    ActionListener actionListeners;
    ItemListener itemListeners;
    private int idCounter = 0;
    WorkbookPage prev = null;
    boolean nested = false;

    public Workbook() {
        this(0);
    }

    public Workbook(int n2) {
        this.updateNotebookListener(n2);
        this.mode = n2;
        this.updateUI();
    }

    public void setMode(int n2) {
        if (this.mode != n2) {
            this.updateNotebookListener(n2);
            this.mode = n2;
            this.updateUI();
        }
    }

    public int getMode() {
        return this.mode;
    }

    private void updateNotebookListener(int n2) {
        if (this.mode == 1 && this.nl != null) {
            this.removeChangeListener(this.nl);
        }
        if (n2 == 1) {
            if (this.nl == null) {
                this.nl = new NotebookListener();
            }
            this.addChangeListener(this.nl);
        }
    }

    public void setPageHistoryButtonVisible(boolean bl) {
        this.historyVisible = bl;
    }

    public boolean isPageHistoryButtonVisible() {
        return this.historyVisible;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, itemListener);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            this.actionListeners.actionPerformed(actionEvent);
        }
    }

    public void fireItemEvent(ItemEvent itemEvent) {
        if (this.itemListeners != null) {
            this.itemListeners.itemStateChanged(itemEvent);
        }
    }

    public void setShiftLeftToolTip(String string) {
    }

    public void setShiftRightToolTip(String string) {
    }

    public void setPageHistoryToolTip(String string) {
    }

    public void addPage(WorkbookPage workbookPage) {
        this.pages.addElement(workbookPage);
        super.addTab(workbookPage.getTitle(), workbookPage.getIcon(), workbookPage.getClient());
        workbookPage.setWorkbook(this);
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).pageAdded(workbookPage);
        }
    }

    public void removePage(WorkbookPage workbookPage) {
        int n2 = this.findPageIndex(workbookPage);
        if (n2 != -1) {
            if (this.ui instanceof WorkbookUI) {
                ((WorkbookUI)this.ui).pageRemoved(workbookPage);
            }
            this.removeTabAt(n2);
            this.pages.removeElement(workbookPage);
            workbookPage.setWorkbook(null);
            if (this.prev == workbookPage) {
                this.prev = null;
            }
            this.fireStateChanged();
        }
    }

    void tabModified(WorkbookPage workbookPage) {
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).tabModified(workbookPage);
        } else {
            this.fireStateChanged();
        }
    }

    public void removeAllPages() {
        this.pages.removeAllElements();
        while (this.getTabCount() > 0) {
            this.removeTabAt(0);
        }
        this.prev = null;
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).allPagesRemoved();
        }
        this.fireStateChanged();
    }

    public void removePage(String string, String string2) {
        int n2 = this.findPageIndex(string, string2);
        if (n2 != -1) {
            WorkbookPage workbookPage = (WorkbookPage)this.pages.elementAt(n2);
            if (this.ui instanceof WorkbookUI) {
                ((WorkbookUI)this.ui).pageRemoved(workbookPage);
            }
            this.removeTabAt(n2);
            workbookPage.setWorkbook(null);
            this.pages.removeElementAt(n2);
            if (this.prev == workbookPage) {
                this.prev = null;
            }
            this.fireStateChanged();
        }
    }

    public WorkbookPage getCurrentPage() {
        int n2 = this.getSelectedIndex();
        if (n2 > -1 && this.pages.size() > 0) {
            return (WorkbookPage)this.pages.elementAt(n2);
        }
        return null;
    }

    public int getPageCount() {
        return this.getTabCount();
    }

    public int getCurrentPageNumber() {
        return this.getSelectedIndex();
    }

    public Vector getPages() {
        return (Vector)this.pages.clone();
    }

    public WorkbookPage getPageAt(int n2) {
        if (this.pages == null || this.pages.size() == 0) {
            return null;
        }
        return (WorkbookPage)this.pages.elementAt(n2);
    }

    public Vector getAllPages() {
        return this.getPages();
    }

    public void showPage(WorkbookPage workbookPage) {
        this.prev = this.getCurrentPage();
        int n2 = this.findPageIndex(workbookPage);
        if (n2 == -1) {
            return;
        }
        this.setSelectedIndex(n2);
    }

    public WorkbookPage getPreviousPage() {
        return this.prev;
    }

    public void showPage(String string) {
        this.showPage(string, null);
    }

    public void showPage(String string, String string2) {
        int n2 = this.findPageIndex(string, string2);
        if (n2 == -1) {
            return;
        }
        this.setSelectedIndex(n2);
    }

    public WorkbookPage findPage(String string, String string2) {
        int n2 = this.findPageIndex(string, string2);
        if (n2 != -1) {
            return (WorkbookPage)this.pages.elementAt(n2);
        }
        return null;
    }

    public String getUIClassID() {
        return this.mode == 1 ? "TabbedPaneUI" : (this.mode == 0 ? "WorkbookUI" : "MinorWorkbookUI");
    }

    public void updateUI() {
        if (this.pages == null) {
            return;
        }
        super.updateUI();
    }

    public void setTabsVisible(boolean bl) {
        if (this.tabsVisible != bl) {
            this.tabsVisible = bl;
            this.fireStateChanged();
        }
    }

    public boolean getTabsVisible() {
        return this.tabsVisible;
    }

    int findPageIndex(String string, String string2) {
        int n2 = 0;
        while (n2 < this.pages.size()) {
            WorkbookPage workbookPage = (WorkbookPage)this.pages.elementAt(n2);
            if (workbookPage.getName().equals(string) && (string2 == null || workbookPage.getTitle().equals(string2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    int findPageIndex(WorkbookPage workbookPage) {
        int n2 = 0;
        while (n2 < this.pages.size()) {
            WorkbookPage workbookPage2 = (WorkbookPage)this.pages.elementAt(n2);
            if (workbookPage2 == workbookPage) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void updateClient(WorkbookPage workbookPage) {
        int n2 = this.findPageIndex(workbookPage);
        this.setComponentAt(n2, workbookPage.getClient());
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getCurrentPage()};
        return objectArray;
    }

    public void setNested(boolean bl) {
        if (this.nested != bl) {
            this.nested = bl;
            this.fireStateChanged();
        }
    }

    public boolean isNested() {
        return this.nested;
    }

    public void addComponent(Component component) {
        if (this.isAncestorOf(component)) {
            return;
        }
        this.addImpl(component, null, this.getComponentCount());
    }

    public void removeComponent(Component component) {
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            Component component2 = this.getComponent(n2);
            if (component == component2) {
                this.remove(n2);
                return;
            }
            ++n2;
        }
    }

    class NotebookListener
    implements ChangeListener {
        NotebookListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WorkbookPage workbookPage = Workbook.this.getCurrentPage();
            if (Workbook.this.prev != null) {
                Workbook.this.fireItemEvent(new ItemEvent(Workbook.this, 701, Workbook.this.prev, 2));
            }
            Workbook.this.prev = workbookPage;
            Workbook.this.fireItemEvent(new ItemEvent(Workbook.this, 701, workbookPage, 1));
        }
    }
}

