/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;

public class WeakEventListenerList
implements Serializable {
    protected transient Vector listenerList = new Vector();

    public void add(Class clazz, EventListener eventListener) {
        this.listenerList.addElement(clazz);
        this.listenerList.addElement(new WeakReference<EventListener>(eventListener));
    }

    private void cleanList() {
        int n2 = this.listenerList.size();
        while (n2 > 0) {
            WeakReference weakReference = (WeakReference)this.listenerList.elementAt(n2 - 1);
            if (weakReference.get() == null) {
                this.listenerList.removeElementAt(n2 - 1);
                this.listenerList.removeElementAt(n2 - 2);
            }
            n2 -= 2;
        }
    }

    public int getListenerCount() {
        this.cleanList();
        return this.listenerList.size() / 2;
    }

    public int getListenerCount(Class clazz) {
        this.cleanList();
        int n2 = 0;
        Enumeration enumeration = this.listenerList.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(clazz)) {
                ++n2;
            }
            enumeration.nextElement();
        }
        return n2;
    }

    public Object[] getListenerList() {
        this.cleanList();
        return this.listenerList.toArray();
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener[] eventListenerArray = new EventListener[this.getListenerCount(clazz)];
        int n2 = 0;
        Enumeration enumeration = this.listenerList.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(clazz)) {
                eventListenerArray[n2++] = (EventListener)((WeakReference)enumeration.nextElement()).get();
                continue;
            }
            enumeration.nextElement();
        }
        return eventListenerArray;
    }

    public void remove(Class clazz, EventListener eventListener) {
        this.cleanList();
        int n2 = 0;
        while (n2 < this.listenerList.size()) {
            if (this.listenerList.elementAt(n2).equals(clazz) && ((WeakReference)this.listenerList.elementAt(n2 + 1)).get().equals(eventListener)) {
                this.listenerList.removeElementAt(n2 + 1);
                this.listenerList.removeElementAt(n2);
                return;
            }
            n2 += 2;
        }
    }
}

