/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonAction;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.CommonPopupMenu;
import com.ibm.db2.tools.common.CommonToolBar;
import com.ibm.db2.tools.common.CommonView;
import com.ibm.db2.tools.common.FindAction;
import com.ibm.db2.tools.common.FindDialog;
import com.ibm.db2.tools.common.FindInterface;
import com.ibm.db2.tools.common.FindNextAction;
import com.ibm.db2.tools.common.StatusButton;
import com.ibm.db2.tools.common.StatusComboBox;
import com.ibm.db2.tools.common.VariableGridLayout;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.ViewCollapseAllAction;
import com.ibm.db2.tools.common.support.ViewColumnsAction;
import com.ibm.db2.tools.common.support.ViewDeleteAction;
import com.ibm.db2.tools.common.support.ViewDeselectAllAction;
import com.ibm.db2.tools.common.support.ViewExpandAllAction;
import com.ibm.db2.tools.common.support.ViewExportAction;
import com.ibm.db2.tools.common.support.ViewFilterAction;
import com.ibm.db2.tools.common.support.ViewNewAction;
import com.ibm.db2.tools.common.support.ViewObjectNamedSettings;
import com.ibm.db2.tools.common.support.ViewObjectNamedSettingsSet;
import com.ibm.db2.tools.common.support.ViewPageSetupAction;
import com.ibm.db2.tools.common.support.ViewPrintAction;
import com.ibm.db2.tools.common.support.ViewSaveAction;
import com.ibm.db2.tools.common.support.ViewSaveAsAction;
import com.ibm.db2.tools.common.support.ViewSelectAllAction;
import com.ibm.db2.tools.common.support.ViewSelectViewAction;
import com.ibm.db2.tools.common.support.ViewSortAction;
import com.ibm.db2.tools.common.support.ViewTableSettingsCache;
import com.ibm.db2.tools.common.support.ViewTableSortFilterModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleTable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ViewToolBar
extends JPanel
implements FindInterface,
ItemListener,
ActionListener,
PropertyChangeListener,
TableModelListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NO_BUTTONS = 0;
    public static final int SORT_BUTTON = 1;
    public static final int FILTER_BUTTON = 16;
    public static final int COLUMNS_BUTTON = 256;
    public static final int FIND_BUTTON = 4096;
    public static final int SELECT_BUTTON = 65536;
    public static final int DESELECT_BUTTON = 0x100000;
    public static final int EXPAND_BUTTON = 0x1000000;
    public static final int COLLAPSE_BUTTON = 0x10000000;
    public static final int DEFAULT_BUTTONS = 0x111111;
    public static final int ALL_BUTTONS = 0x11111111;
    protected final CommonView commonView;
    protected JLabel nonFilteredItems;
    protected int toolBarLocation;
    protected CommonToolBar toolBar;
    protected int buttonsFlag = 0x111111;
    protected CommonAction[] menuCustomizeActions;
    protected CommonAction[] menuEditActions;
    protected CommonAction[] toolbarCustomizeActions;
    protected CommonAction[] toolbarEditActions;
    protected JButton[] customizeButtons;
    protected JButton[] editButtons;
    protected StatusComboBox namedViewsBox;
    protected StatusButton menuButton;
    protected CommonPopupMenu viewMenu;
    protected String findString;
    protected boolean caseSensitive;

    public ViewToolBar(CommonView commonView, int n2) {
        this(commonView, n2, 0x111111);
    }

    public ViewToolBar(CommonView commonView, int n2, int n3) {
        this.commonView = commonView;
        this.toolBarLocation = n2;
        this.buttonsFlag = n3;
        this.addPropertyChangeListener("UAKey", this);
        this.updateUAKeys();
        this.commonView.getTable().getSettingsCache().addPropertyChangeListener(this);
        this.commonView.getTable().getSettingsCache().getSettingsSet().addPropertyChangeListener(this);
        this.updateComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final Component component = SwingUtilities.getWindowAncestor(this).getFocusOwner();
        if (component != this.viewMenu) {
            this.viewMenu = new CommonPopupMenu(){

                protected void processKeyEvent(KeyEvent keyEvent) {
                    if (9 == keyEvent.getKeyCode()) {
                        keyEvent.setKeyCode(27);
                    }
                    if (27 == keyEvent.getKeyCode()) {
                        keyEvent.setKeyCode(9);
                        if (null != ViewToolBar.this.viewMenu) {
                            ViewToolBar.this.viewMenu.setVisible(false);
                            ViewToolBar.this.viewMenu = null;
                        }
                        component.requestFocus();
                    }
                    super.processKeyEvent(keyEvent);
                }
            };
            this.viewMenu.add(this.getViewActions(true));
            this.viewMenu.show(this.menuButton, this.menuButton.getPreferredSize().width - this.viewMenu.getPreferredSize().width, -this.viewMenu.getPreferredSize().height);
            this.viewMenu.requestFocus();
        } else {
            this.viewMenu = null;
        }
    }

    public String getFindString() {
        return this.findString;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public int find(String string, boolean bl) {
        this.caseSensitive = bl;
        int n2 = 0;
        if (null != string && string.length() > 0) {
            if (string.equals(this.findString)) {
                this.findNextString();
            } else {
                this.findString = string;
                int n3 = this.commonView.getTable().getSelectionModel().getAnchorSelectionIndex();
                int n4 = this.commonView.getTable().getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n3 < 0 || n4 < 0) {
                    n3 = 0;
                    n4 = 0;
                }
                n2 = this.findNext(this.findString, this.caseSensitive, n3, n4, true);
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void findNextString() {
        if (null == this.findString || this.findString.length() == 0) {
            if (this.getCommonView().getOwner() instanceof CommonDialog) {
                new FindDialog((CommonDialog)this.getCommonView().getOwner(), (FindInterface)this);
                return;
            } else {
                if (!(this.getCommonView().getOwner() instanceof JFrame)) throw new IllegalArgumentException("The CommonView whose actions are being created has no valid owner. The owner has to be a CommonDialog or a JFrame. The current owner is " + this.getCommonView().getOwner() + " .");
                new FindDialog((JFrame)this.getCommonView().getOwner(), (FindInterface)this);
            }
            return;
        } else {
            int n2 = this.commonView.getTable().getSelectionModel().getAnchorSelectionIndex();
            int n3 = this.commonView.getTable().getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n2 < 0 || n3 < 0) {
                n2 = 0;
                n3 = 0;
            }
            Dimension dimension = this.getNextCell(n2, n3);
            int n4 = dimension.height;
            int n5 = dimension.width;
            this.findNext(this.findString, this.caseSensitive, n4, n5, false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.namedViewsBox && itemEvent.getStateChange() == 1) {
            this.setCurrentView((String)this.namedViewsBox.getSelectedItem());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("sortFilterModel")) {
            ((ViewTableSortFilterModel)propertyChangeEvent.getOldValue()).removeTableModelListener(this);
            ((ViewTableSortFilterModel)propertyChangeEvent.getNewValue()).addTableModelListener(this);
            this.tableChanged(null);
        } else if (string.equals("currentSettingsSet")) {
            if (null != propertyChangeEvent.getOldValue()) {
                ((ViewObjectNamedSettingsSet)propertyChangeEvent.getOldValue()).removePropertyChangeListener(this);
            }
            ((ViewObjectNamedSettingsSet)propertyChangeEvent.getNewValue()).addPropertyChangeListener(this);
            this.updateComponents();
        } else if (string.equals("currentSettings")) {
            this.updateViewsComboBox();
        } else if (string.equals("currentSettings_notFromTable")) {
            PropertyChangeListener propertyChangeListener = this.commonView.getTable();
            if (null != this.commonView.getTable().getSortFilterModel()) {
                propertyChangeListener = this.commonView.getTable().getSortFilterModel();
                propertyChangeListener.tableChanged(new TableModelEvent(this.commonView.getTable().getModel(), -1));
            }
            this.tableChanged(null);
        } else if (string.equals("UAKey")) {
            this.updateUAKeys();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.nonFilteredItems.setText(CmStringPool.get(99, new Object[]{new Integer(this.commonView.getTable().getSortFilterModel().getRowCount()), new Integer(this.commonView.getTable().getModel().getRowCount())}));
    }

    public CommonView getCommonView() {
        return this.commonView;
    }

    public int getToolBarLocation() {
        return this.toolBarLocation;
    }

    public void setToolBarLocation(int n2) {
        this.toolBarLocation = n2;
    }

    public int getButtonsFlag() {
        return this.buttonsFlag;
    }

    public void setButtonsFlag(int n2) {
        if (n2 < 0 || n2 > 0x11111111) {
            throw new IllegalArgumentException("The parameter show be in the interval defined by NO_BUTTONS and ALL_BUTTONS included");
        }
        if (this.buttonsFlag != n2) {
            this.buttonsFlag = n2;
            this.cleanup();
        }
        this.updateComponents();
    }

    public CommonToolBar getToolBar() {
        return this.toolBar;
    }

    public void showButton(int n2, boolean bl) {
        if (n2 < 0 || n2 > 0x11111111) {
            throw new IllegalArgumentException("The parameter show be in the interval defined by NO_BUTTONS and ALL_BUTTONS");
        }
        if (bl) {
            this.setButtonsFlag(this.getButtonsFlag() | n2);
        } else {
            this.setButtonsFlag(this.getButtonsFlag() & ~n2);
        }
    }

    public boolean setCurrentView(String string) {
        return this.commonView.getTable().getSettingsCache().getSettingsSet().setCurrentSettings(string);
    }

    public CommonAction[] getCustomizeActions(boolean bl) {
        Vector<CommonAction> vector = new Vector<CommonAction>();
        CommonAction[] commonActionArray = null;
        String string = (String)this.getClientProperty("UAKey");
        if (bl && null == this.menuCustomizeActions || !bl && null == this.toolbarCustomizeActions) {
            if (bl && (this.buttonsFlag & 0x10) > 0) {
                vector.add(new ViewFilterAction(this.getCommonView()));
            }
            if ((this.buttonsFlag & 1) > 0) {
                vector.add(new ViewSortAction(this.getCommonView()));
            }
            if (!bl && (this.buttonsFlag & 0x10) > 0) {
                vector.add(new ViewFilterAction(this.getCommonView()));
            }
            if ((this.buttonsFlag & 0x100) > 0) {
                vector.add(new ViewColumnsAction(this.getCommonView()));
            }
            commonActionArray = vector.toArray(new CommonAction[0]);
            if (bl) {
                this.menuCustomizeActions = commonActionArray;
                int n2 = 0;
                while (n2 < this.menuCustomizeActions.length) {
                    this.menuCustomizeActions[n2].setSmallIcon(null);
                    if (null != string) {
                        this.menuCustomizeActions[n2].setUAKey(string + "_" + this.menuCustomizeActions[n2].getClass().getName());
                    }
                    ++n2;
                }
            } else {
                this.toolbarCustomizeActions = commonActionArray;
                if (null != string) {
                    int n3 = 0;
                    while (n3 < this.toolbarCustomizeActions.length) {
                        this.toolbarCustomizeActions[n3].setUAKey(string + "_" + this.toolbarCustomizeActions[n3].getClass().getName());
                        ++n3;
                    }
                }
            }
        } else {
            commonActionArray = bl ? this.menuCustomizeActions : this.toolbarCustomizeActions;
        }
        return commonActionArray;
    }

    public CommonAction[] getEditActions(boolean bl) {
        Vector<CommonAction> vector = new Vector<CommonAction>();
        CommonAction[] commonActionArray = null;
        String string = (String)this.getClientProperty("UAKey");
        if (bl && null == this.menuEditActions || !bl && null == this.toolbarEditActions) {
            if ((this.buttonsFlag & 0x1000) > 0) {
                FindAction findAction;
                FindNextAction findNextAction = null;
                if (this.getCommonView().getOwner() instanceof CommonDialog) {
                    findAction = new FindAction((CommonDialog)this.getCommonView().getOwner(), (FindInterface)this);
                    vector.add(findAction);
                    if (bl) {
                        findNextAction = new FindNextAction((CommonDialog)this.getCommonView().getOwner(), (FindInterface)this);
                        vector.add(findNextAction);
                        vector.add(new CommonAction());
                    }
                } else if (this.getCommonView().getOwner() instanceof JFrame) {
                    findAction = new FindAction((JFrame)this.getCommonView().getOwner(), (FindInterface)this);
                    vector.add(findAction);
                    if (bl) {
                        findNextAction = new FindNextAction((JFrame)this.getCommonView().getOwner(), (FindInterface)this);
                        vector.add(findNextAction);
                        vector.add(new CommonAction());
                    }
                } else {
                    throw new IllegalArgumentException("The CommonView whose actions are being created has no valid owner. The owner has to be a CommonDialog or a JFrame. The current owner is " + this.getCommonView().getOwner() + " .");
                }
            }
            if ((this.buttonsFlag & 0x10000) > 0) {
                vector.add(new ViewSelectAllAction(this.getCommonView()));
            }
            if ((this.buttonsFlag & 0x100000) > 0) {
                vector.add(new ViewDeselectAllAction(this.getCommonView()));
            }
            if (!bl) {
                if ((this.buttonsFlag & 0x1000000) > 0) {
                    vector.add(new ViewExpandAllAction(this.getCommonView()));
                }
                if ((this.buttonsFlag & 0x10000000) > 0) {
                    vector.add(new ViewCollapseAllAction(this.getCommonView()));
                }
            }
            commonActionArray = vector.toArray(new CommonAction[0]);
            if (bl) {
                this.menuEditActions = commonActionArray;
                int n2 = 0;
                while (n2 < this.menuEditActions.length) {
                    this.menuEditActions[n2].setSmallIcon(null);
                    if (null != string) {
                        this.menuEditActions[n2].setUAKey(string + "_" + this.menuEditActions[n2].getClass().getName());
                    }
                    ++n2;
                }
            } else {
                this.toolbarEditActions = commonActionArray;
                if (null != string) {
                    int n3 = 0;
                    while (n3 < this.toolbarEditActions.length) {
                        this.toolbarEditActions[n3].setUAKey(string + "_" + this.toolbarEditActions[n3].getClass().getName());
                        ++n3;
                    }
                }
            }
        } else {
            commonActionArray = bl ? this.menuEditActions : this.toolbarEditActions;
        }
        return commonActionArray;
    }

    public CommonAction[] getViewActions(boolean bl) {
        Object object;
        int n2;
        String string;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(new ViewNewAction(this.getCommonView()));
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = this.commonView.getTable().getSettingsCache().getSettingsSet();
        int n3 = viewObjectNamedSettingsSet.getCurrentSettingsIndex();
        ViewObjectNamedSettings[] viewObjectNamedSettingsArray = viewObjectNamedSettingsSet.getNamedSettings();
        ViewObjectNamedSettings viewObjectNamedSettings = viewObjectNamedSettingsArray[n3];
        String string2 = string = null != viewObjectNamedSettings ? viewObjectNamedSettings.getName() : "";
        if (0 == n3 && (-1 == (n2 = viewObjectNamedSettingsSet.indexOf(string.substring(0, string.length() - 1))) || viewObjectNamedSettingsSet.getFirstCustomSettingsIndex() <= n2)) {
            vector.addElement(new ViewSaveAction(this.getCommonView()));
        }
        vector.addElement(new ViewSaveAsAction(this.getCommonView()));
        if (0 == n3 && viewObjectNamedSettingsArray.length > 1 || n3 >= viewObjectNamedSettingsSet.getFirstCustomSettingsIndex()) {
            vector.addElement(new ViewDeleteAction(this.getCommonView()));
        }
        vector.add(new CommonAction());
        if (bl) {
            CommonAction commonAction = new CommonAction(CmStringPool.get(117));
            commonAction.setMnemonic(CmStringPool.getMnemonic(117));
            ViewObjectNamedSettingsSet viewObjectNamedSettingsSet2 = this.commonView.getTable().getSettingsCache().getSettingsSet();
            if (null != viewObjectNamedSettingsSet2) {
                object = viewObjectNamedSettingsSet2.getNamedSettings();
                boolean bl2 = false;
                if (null != object) {
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        if (0 == n4 && null == object[n4]) {
                            bl2 = true;
                        } else {
                            commonAction.add(new ViewSelectViewAction(this.commonView, ((ViewObjectNamedSettings)object[n4]).getName()));
                        }
                        ++n4;
                    }
                    if (viewObjectNamedSettingsSet2.getCurrentSettingsIndex() >= 0) {
                        Vector vector2 = commonAction.getCascade();
                        ((CommonAction)vector2.elementAt(viewObjectNamedSettingsSet2.getCurrentSettingsIndex() - (bl2 ? 1 : 0))).setCheckBox(true);
                    }
                    vector.add(commonAction);
                    vector.add(new CommonAction());
                }
            }
        }
        CommonAction[] commonActionArray = this.getCustomizeActions(bl);
        int n5 = 0;
        while (n5 < commonActionArray.length) {
            vector.add(commonActionArray[n5]);
            ++n5;
        }
        vector.add(new CommonAction());
        if ((this.buttonsFlag & 0x1000000) > 0) {
            object = new ViewExpandAllAction(this.getCommonView());
            ((CommonAction)object).setSmallIcon(null);
            vector.add(object);
        }
        if ((this.buttonsFlag & 0x10000000) > 0) {
            object = new ViewCollapseAllAction(this.getCommonView());
            ((CommonAction)object).setSmallIcon(null);
            vector.add(object);
        }
        if ((this.buttonsFlag & 0x1000000) > 0 || (this.buttonsFlag & 0x10000000) > 0) {
            vector.add(new CommonAction());
        }
        vector.addElement(new ViewPageSetupAction(this.getCommonView()));
        vector.addElement(new ViewPrintAction(this.getCommonView()));
        vector.addElement(new ViewExportAction(this.getCommonView()));
        object = new CommonAction[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    protected void updateComponents() {
        int n2;
        Object object;
        VariableGridLayout variableGridLayout;
        boolean bl;
        ViewTableSettingsCache viewTableSettingsCache = this.commonView.getTable().getSettingsCache();
        String string = viewTableSettingsCache.getSettingsKey();
        boolean bl2 = bl = null != string && !string.trim().equals("");
        if (!bl) {
            this.cleanup();
        }
        if (3 == this.toolBarLocation && bl) {
            variableGridLayout = new VariableGridLayout(1, 4);
            variableGridLayout.setColumnExpandable(0);
            variableGridLayout.setColumnExpandable(2);
        } else {
            variableGridLayout = new VariableGridLayout(1, 2);
            variableGridLayout.setColumnExpandable(1);
        }
        this.setLayout(variableGridLayout);
        if (3 == this.toolBarLocation) {
            if (bl) {
                if (null == this.nonFilteredItems) {
                    this.nonFilteredItems = new JLabel();
                    this.nonFilteredItems.setHorizontalAlignment(0);
                    this.commonView.getTable().addPropertyChangeListener(this);
                    this.commonView.getTable().getSortFilterModel().addTableModelListener(this);
                    this.tableChanged(null);
                    object = this.nonFilteredItems.getFont();
                    if (null != object) {
                        FontMetrics fontMetrics = null;
                        fontMetrics = ((Component)this).getFontMetrics((Font)object);
                        n2 = fontMetrics.stringWidth(CmStringPool.get(99, new Object[]{new Integer(999), new Integer(999)}));
                        this.nonFilteredItems.setPreferredSize(new Dimension(n2, this.nonFilteredItems.getPreferredSize().height));
                    }
                    this.add(this.nonFilteredItems);
                }
            } else {
                this.nonFilteredItems = null;
                this.commonView.getTable().removePropertyChangeListener(this);
                this.commonView.getTable().getSortFilterModel().removeTableModelListener(this);
            }
        }
        if (null == this.toolBar) {
            int n3 = this.toolBarLocation == 3 || this.toolBarLocation == 1 ? 0 : 1;
            this.toolBar = new CommonToolBar(n3);
            this.toolBar.setPuzzleEdge(false);
            this.toolBar.setFloatable(false);
            if (null != this.nonFilteredItems) {
                this.toolBar.addSeparator();
            }
            this.add(this.toolBar);
        }
        if (bl) {
            if (null == this.customizeButtons) {
                if (null != this.editButtons) {
                    int n4 = 0;
                    while (n4 < this.editButtons.length) {
                        this.toolBar.remove(this.editButtons[n4]);
                        ++n4;
                    }
                    this.editButtons = null;
                    this.menuEditActions = null;
                    this.toolbarEditActions = null;
                }
                object = this.getCustomizeActions(false);
                this.customizeButtons = new JButton[((CommonAction[])object).length];
                int n5 = 0;
                while (n5 < ((CommonAction[])object).length) {
                    this.customizeButtons[n5] = this.toolBar.addButton(object[n5]);
                    this.customizeButtons[n5].setMnemonic(0);
                    ++n5;
                }
            }
        } else {
            this.customizeButtons = null;
        }
        if (null == this.editButtons) {
            object = this.getEditActions(false);
            this.editButtons = new JButton[((CommonAction[])object).length];
            int n6 = 0;
            while (n6 < ((CommonAction[])object).length) {
                this.editButtons[n6] = this.toolBar.addButton(object[n6]);
                this.editButtons[n6].setMnemonic(0);
                ++n6;
            }
        }
        if (3 == this.toolBarLocation) {
            if (bl) {
                if (null == this.namedViewsBox) {
                    this.namedViewsBox = new StatusComboBox(){

                        public boolean isFocusTraversable() {
                            return false;
                        }
                    };
                    this.namedViewsBox.getAccessibleContext().setAccessibleName(CmStringPool.get(117));
                    this.namedViewsBox.addItemListener(this);
                    object = this.nonFilteredItems.getFont();
                    if (null != object) {
                        FontMetrics fontMetrics = ((Component)this).getFontMetrics((Font)object);
                        n2 = fontMetrics.stringWidth(CmStringPool.get(101));
                        this.namedViewsBox.setPreferredSize(new Dimension((int)(1.2 * (double)n2), this.namedViewsBox.getPreferredSize().height));
                    }
                    this.add(this.namedViewsBox);
                }
                this.updateViewsComboBox();
                if (null == this.menuButton) {
                    this.menuButton = new StatusButton(CmStringPool.get(106)){

                        public boolean isFocusTraversable() {
                            return 0 != this.getMnemonic();
                        }
                    };
                    this.menuButton.addActionListener(this);
                    this.add(this.menuButton);
                }
            } else {
                if (null != this.namedViewsBox) {
                    this.namedViewsBox.removeItemListener(this);
                    this.namedViewsBox = null;
                }
                if (null != this.menuButton) {
                    this.menuButton.removeActionListener(this);
                    this.menuButton = null;
                }
            }
        }
        this.updateUAKeys();
        this.repaint();
    }

    protected void cleanup() {
        this.removeAll();
        this.nonFilteredItems = null;
        this.customizeButtons = null;
        this.toolbarCustomizeActions = null;
        this.menuCustomizeActions = null;
        this.editButtons = null;
        this.toolbarEditActions = null;
        this.menuEditActions = null;
        if (null != this.toolBar) {
            this.toolBar.removeAll();
            this.toolBar = null;
        }
        if (null != this.namedViewsBox) {
            this.namedViewsBox.removeItemListener(this);
            this.namedViewsBox = null;
        }
        if (null != this.menuButton) {
            this.menuButton.removeActionListener(this);
            this.menuButton = null;
        }
    }

    protected synchronized void updateViewsComboBox() {
        ViewObjectNamedSettings[] viewObjectNamedSettingsArray;
        this.namedViewsBox.removeItemListener(this);
        this.namedViewsBox.removeAllItems();
        ViewObjectNamedSettingsSet viewObjectNamedSettingsSet = this.commonView.getTable().getSettingsCache().getSettingsSet();
        if (null != viewObjectNamedSettingsSet && null != (viewObjectNamedSettingsArray = viewObjectNamedSettingsSet.getNamedSettings())) {
            int n2 = 0;
            while (n2 < viewObjectNamedSettingsArray.length) {
                if (0 != n2 || null != viewObjectNamedSettingsArray[n2]) {
                    this.namedViewsBox.addItem(viewObjectNamedSettingsArray[n2].getName());
                }
                ++n2;
            }
            if (viewObjectNamedSettingsSet.getCurrentSettingsIndex() >= 0) {
                this.namedViewsBox.setSelectedItem(viewObjectNamedSettingsArray[viewObjectNamedSettingsSet.getCurrentSettingsIndex()].getName());
            }
        }
        this.namedViewsBox.addItemListener(this);
    }

    protected void updateUAKeys() {
        String string = (String)this.getClientProperty("UAKey");
        if (null != string) {
            if (null != this.nonFilteredItems) {
                this.nonFilteredItems.putClientProperty("UAKey", string + "_nonFilteredItems");
            }
            if (null != this.menuCustomizeActions) {
                int n2 = 0;
                while (n2 < this.menuCustomizeActions.length) {
                    this.menuCustomizeActions[n2].setUAKey(string + "_" + this.menuCustomizeActions[n2].getClass().getName());
                    ++n2;
                }
            }
            if (null != this.toolbarCustomizeActions) {
                int n3 = 0;
                while (n3 < this.toolbarCustomizeActions.length) {
                    this.toolbarCustomizeActions[n3].setUAKey(string + "_" + this.toolbarCustomizeActions[n3].getClass().getName());
                    ++n3;
                }
            }
            if (null != this.menuEditActions) {
                int n4 = 0;
                while (n4 < this.menuEditActions.length) {
                    this.menuEditActions[n4].setUAKey(string + "_" + this.menuEditActions[n4].getClass().getName());
                    ++n4;
                }
            }
            if (null != this.toolbarEditActions) {
                int n5 = 0;
                while (n5 < this.toolbarEditActions.length) {
                    this.toolbarEditActions[n5].setUAKey(string + "_" + this.toolbarEditActions[n5].getClass().getName());
                    ++n5;
                }
            }
            if (null != this.namedViewsBox) {
                this.namedViewsBox.putClientProperty("UAKey", string + "_namedViewsBox");
            }
            if (null != this.menuButton) {
                this.menuButton.putClientProperty("UAKey", string + "_menuButton");
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.getWindowAncestor(this.commonView);
        if (null != this.menuButton && null != window && (window instanceof Frame || window instanceof JFrame)) {
            this.menuButton.setMnemonic(0);
        }
    }

    public void setEnabled(boolean bl) {
        this.toolBar.setEnabled(bl);
        if (null != this.nonFilteredItems) {
            this.nonFilteredItems.setEnabled(bl);
        }
        if (null != this.namedViewsBox) {
            this.namedViewsBox.setEnabled(bl);
        }
        if (null != this.menuButton) {
            this.menuButton.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    private int findNext(String string, boolean bl, int n2, int n3, boolean bl2) {
        int n4 = this.findFrom(string, bl, n2, n3);
        if (-1 == n4) {
            String string2 = CmStringPool.get(180, string);
            if (this.getCommonView().getOwner() instanceof CommonDialog) {
                CommonMessage commonMessage = new CommonMessage((CommonDialog)this.getCommonView().getOwner(), "", string2, 0, "DBA1200", "", 512, null, bl2);
            } else if (this.getCommonView().getOwner() instanceof JFrame) {
                CommonMessage commonMessage = new CommonMessage((JFrame)this.getCommonView().getOwner(), "", string2, 0, "DBA1200", "", 512, null, bl2);
            } else {
                throw new IllegalArgumentException("The CommonView whose actions are being created has no valid owner. The owner has to be a CommonDialog or a JFrame. The current owner is " + this.getCommonView().getOwner() + " .");
            }
        }
        return n4;
    }

    private int findFrom(String string, boolean bl, int n2, int n3) {
        int n4 = 0;
        n4 = this.searchForString(string, bl, n2, this.getCommonView().getTable().getRowCount() - 1, n3, this.getCommonView().getTable().getColumnCount() - 1);
        if (n4 == -1) {
            n4 = this.searchForString(string, bl, 0, n2, 0, n3);
        }
        return n4;
    }

    private int searchForString(String string, boolean bl, int n2, int n3, int n4, int n5) {
        String string2 = bl ? string : AssistManager.toUpperCase(string);
        ViewTable viewTable = this.getCommonView().getTable();
        int n6 = viewTable.getColumnModel().getColumnCount();
        AccessibleTable accessibleTable = (AccessibleTable)((Object)viewTable.getAccessibleContext());
        if (n2 >= 0 && n2 < viewTable.getRowCount() && n3 >= 0 && n3 < viewTable.getRowCount()) {
            int n7 = n2;
            while (n7 <= n3) {
                int n8 = 0;
                while (n8 < n6) {
                    Accessible accessible;
                    AccessibleContext accessibleContext;
                    String string3;
                    if (!(n2 == n7 && n8 < n4 || n3 == n7 && n8 > n5 || (string3 = (accessibleContext = (accessible = accessibleTable.getAccessibleAt(n7, n8)).getAccessibleContext()).getAccessibleName()) == null)) {
                        if (!this.caseSensitive) {
                            string3 = AssistManager.toUpperCase(string3);
                        }
                        if (string3.indexOf(string2, 0) != -1) {
                            viewTable.requestFocus();
                            viewTable.setRowSelectionInterval(n7, n7);
                            viewTable.setColumnSelectionInterval(n8, n8);
                            viewTable.getSelectionModel().setAnchorSelectionIndex(n7);
                            viewTable.getSelectionModel().setLeadSelectionIndex(n7);
                            viewTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n8);
                            viewTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(n8);
                            Rectangle rectangle = viewTable.getCellRect(n7, n8, true);
                            JViewport jViewport = this.getCommonView().getScrollPane().getViewport();
                            jViewport.scrollRectToVisible(rectangle);
                            Rectangle rectangle2 = jViewport.getViewRect();
                            if (!rectangle2.contains(rectangle)) {
                                this.getCommonView().getScrollPane().getViewport().setViewPosition(new Point(rectangle.x, rectangle.y));
                            }
                            return n7;
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        return -1;
    }

    private Dimension getNextCell(int n2, int n3) {
        int n4 = this.commonView.getTable().getColumnModel().getColumnCount();
        if (n3 + 1 < n4) {
            ++n3;
        } else {
            n3 = 0;
            int n5 = this.commonView.getTable().getRowCount();
            n2 = n2 + 1 < n5 ? ++n2 : 0;
        }
        return new Dimension(n3, n2);
    }
}

