/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class VariableGridLayout
extends GridLayout
implements Serializable {
    private int[] rowExpandableMultiplier;
    private int[] columnExpandableMultiplier;
    private final int MINIMUM_SIZE = 1;
    private final int PREFERRED_SIZE = 2;

    public VariableGridLayout(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public VariableGridLayout(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.rowExpandableMultiplier = new int[n2];
        this.columnExpandableMultiplier = new int[n3];
        int n6 = 0;
        while (n6 < n2) {
            this.rowExpandableMultiplier[n6] = 0;
            ++n6;
        }
        int n7 = 0;
        while (n7 < n3) {
            this.columnExpandableMultiplier[n7] = 0;
            ++n7;
        }
    }

    public void setColumnExpandable(int n2) {
        this.setColumnExpandable(n2, 1);
    }

    public void setRowExpandable(int n2) {
        this.setRowExpandable(n2, 1);
    }

    public void setColumnExpandable(int n2, int n3) {
        if (n2 < this.getColumns()) {
            this.columnExpandableMultiplier[n2] = n3;
        }
    }

    public void setRowExpandable(int n2, int n3) {
        if (n2 < this.getRows()) {
            this.rowExpandableMultiplier[n2] = n3;
        }
    }

    protected Dimension getLayoutSize(Container container, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n3 = container.getComponentCount();
            int n4 = this.getRows();
            int n5 = this.getColumns();
            int[] nArray = new int[n5];
            int[] nArray2 = new int[n4];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n5) {
                nArray[n8] = 0;
                ++n8;
            }
            int n9 = 0;
            while (n9 < n4) {
                nArray2[n9] = 0;
                ++n9;
            }
            int n10 = 0;
            while (n10 < n3) {
                if (n6 >= n5) {
                    ++n7;
                    n6 = 0;
                }
                Component component = container.getComponent(n10);
                Dimension dimension = n2 == 1 ? component.getMinimumSize() : component.getPreferredSize();
                if (nArray[n6] < dimension.width) {
                    nArray[n6] = dimension.width;
                }
                if (nArray2[n7] < dimension.height) {
                    nArray2[n7] = dimension.height;
                }
                ++n6;
                ++n10;
            }
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n4) {
                n11 += nArray2[n13];
                ++n13;
            }
            int n14 = 0;
            while (n14 < n5) {
                n12 += nArray[n14];
                ++n14;
            }
            Dimension dimension = new Dimension(insets.left + insets.right + n12 + (n5 - 1) * this.getHgap(), insets.top + insets.bottom + n11 + (n4 - 1) * this.getVgap());
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, 2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, 1);
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = this.getRows();
            int n4 = this.getColumns();
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n3];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n4) {
                nArray[n7] = 0;
                ++n7;
            }
            int n8 = 0;
            while (n8 < n3) {
                nArray2[n8] = 0;
                ++n8;
            }
            int n9 = 0;
            while (n9 < n2) {
                if (n5 >= n4) {
                    ++n6;
                    n5 = 0;
                }
                Component component = container.getComponent(n9);
                Dimension dimension = component.getPreferredSize();
                if (nArray[n5] < dimension.width) {
                    nArray[n5] = dimension.width;
                }
                if (nArray2[n6] < dimension.height) {
                    nArray2[n6] = dimension.height;
                }
                ++n5;
                ++n9;
            }
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n3];
            int n16 = 0;
            while (n16 < n3) {
                if (this.rowExpandableMultiplier[n16] == 0) {
                    n10 += nArray2[n16];
                    n10 += this.getVgap();
                    ++n13;
                    dArray2[n16] = 0.0;
                } else {
                    n14 += nArray2[n16];
                }
                ++n16;
            }
            int n17 = 0;
            while (n17 < n4) {
                if (this.columnExpandableMultiplier[n17] == 0) {
                    n11 += nArray[n17];
                    n11 += this.getHgap();
                    ++n12;
                    dArray[n17] = 0.0;
                } else {
                    n15 += nArray[n17];
                }
                ++n17;
            }
            Rectangle rectangle = container.getBounds();
            int n18 = rectangle.width - (insets.left + insets.right);
            int n19 = rectangle.height - (insets.top + insets.bottom);
            double d2 = n18 - (n4 - n12 - 1) * this.getHgap() - n11;
            double d3 = n19 - (n3 - n13 - 1) * this.getVgap() - n10;
            double d4 = n4 > n12 ? d2 - (double)n15 : 0.0;
            double d5 = n3 > n13 ? d3 - (double)n14 : 0.0;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            while (n22 < n4) {
                n20 += this.columnExpandableMultiplier[n22];
                ++n22;
            }
            int n23 = 0;
            while (n23 < n3) {
                n21 += this.rowExpandableMultiplier[n23];
                ++n23;
            }
            d4 /= (double)n20;
            d5 /= (double)n21;
            int n24 = 0;
            while (n24 < n4) {
                if (this.columnExpandableMultiplier[n24] > 0) {
                    dArray[n24] = d4 * (double)this.columnExpandableMultiplier[n24];
                }
                ++n24;
            }
            int n25 = 0;
            while (n25 < n3) {
                if (this.rowExpandableMultiplier[n25] > 0) {
                    dArray2[n25] = d5 * (double)this.rowExpandableMultiplier[n25];
                }
                ++n25;
            }
            int n26 = 0;
            int n27 = insets.left;
            while (n26 < n4) {
                int n28 = (int)((double)nArray[n26] + dArray[n26]);
                int n29 = 0;
                int n30 = insets.top;
                while (n29 < n3) {
                    int n31 = n29 * n4 + n26;
                    if (n31 < n2) {
                        int n32 = (int)((double)nArray2[n29] + dArray2[n29]);
                        container.getComponent(n31).setBounds(n27, n30, n28, n32);
                        n30 += n32 + this.getVgap();
                    }
                    ++n29;
                }
                n27 += n28 + this.getHgap();
                ++n26;
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName() + "[hgap=" + this.getHgap() + ",vgap=" + this.getVgap() + ",rows=" + this.getRows() + ",cols=" + this.getColumns() + "]";
        return string;
    }
}

