/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistSpinner;
import com.ibm.db2.tools.common.RunSelectHH;
import com.ibm.db2.tools.common.RunSelectMM;
import com.ibm.db2.tools.common.RunSelectSS;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TimeSpinButton
extends AssistSpinner
implements FocusListener {
    private final int MAX_TIME = 86399;
    private final int MIN_TIME = 0;
    private final int MAX_SECONDS = 60;
    private final int MAX_MINUTES = 60;
    private final int MAX_HOURS = 24;
    private final int TIME_LENGTH = 8;
    private final int TIME_LENGTH_NO_SECONDS = 5;
    private final String SEPARATOR = ":";
    private final long DEFAULT_TIME = 0L;
    private boolean includeSeconds = true;
    protected int currentSelectionStart = 0;
    protected int currentSelectionEnd = 0;

    public TimeSpinButton(String string) {
        this.setDocument(new TimeDocument());
        this.setDefaults();
        this.setSpinValue(string);
    }

    public TimeSpinButton(String string, boolean bl) {
        this.setDocument(new TimeDocument());
        this.includeSeconds = bl;
        this.setDefaults();
        this.setSpinValue(string);
    }

    public TimeSpinButton(int n2, int n3, int n4) {
        this.setDocument(new TimeDocument());
        this.setDefaults();
        this.setValue(this.getTimeValue(n2, n3, n4));
    }

    public TimeSpinButton(int n2, int n3) {
        this.setDocument(new TimeDocument());
        this.includeSeconds = false;
        this.setDefaults();
        this.setValue(this.getTimeValue(n2, n3, 0));
    }

    private void setDefaults() {
        this.spinField.addMouseListener(this);
        this.spinField.addFocusListener(this);
        if (this.includeSeconds) {
            this.spinField.setColumns(8);
        } else {
            this.spinField.setColumns(5);
        }
        this.setSpinValue(0L);
        this.setRange(0L, 86399L);
    }

    public int getMinimumValue() {
        return 0;
    }

    public int getMaximumValue() {
        return 86399;
    }

    public String getStringValue() {
        int n2 = this.getHours(this.getValue());
        int n3 = this.getMinutes(this.getValue());
        int n4 = this.getSeconds(this.getValue());
        String string = this.includeSeconds ? TimeSpinButton.fixWidth(n2) + ":" + TimeSpinButton.fixWidth(n3) + ":" + TimeSpinButton.fixWidth(n4) : TimeSpinButton.fixWidth(n2) + ":" + TimeSpinButton.fixWidth(n3);
        return string;
    }

    public int getSeconds(long l2) {
        return (int)(l2 % 3600L % 60L);
    }

    public int getSeconds(String string) {
        int n2 = 0;
        if (this.includeSeconds) {
            n2 = new Integer(string.substring(6));
        }
        return n2;
    }

    public int getSeconds() {
        return this.getSeconds(this.getValue());
    }

    public int getMinutes(long l2) {
        return (int)(l2 % 3600L / 60L);
    }

    public int getMinutes(String string) {
        return new Integer(string.substring(3, 5));
    }

    public int getMinutes() {
        return this.getMinutes(this.getValue());
    }

    public int getHours(long l2) {
        return (int)(l2 / 3600L);
    }

    public int getHours(String string) {
        return new Integer(string.substring(0, 2));
    }

    public int getHours() {
        return this.getHours(this.getValue());
    }

    private static String fixWidth(int n2) {
        if (n2 == 0) {
            return "00";
        }
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public void setValue(String string) {
        this.verify(false);
        if (this.valueValid && this.inRange) {
            this.setSpinValue(string);
            this.spinField.setText(this.getStringValue());
        }
    }

    public void setSpinValue(String string) {
        this.setSpinValue(this.getTimeValue(string));
    }

    public void setSpinValue(long l2) {
        this.setValue(l2);
    }

    public void setTimeValue(int n2, int n3, int n4) {
        this.setSpinValue(this.getTimeValue(n2, n3, n4));
    }

    protected int getTimeValue(int n2, int n3, int n4) {
        return n4 + n3 * 60 + n2 * 60 * 60;
    }

    protected int getTimeValue(String string) {
        return this.getSeconds(string) + this.getMinutes(string) * 60 + this.getHours(string) * 60 * 60;
    }

    public JTextField getTF() {
        return this.spinField;
    }

    public void verify(boolean bl) {
        String string = this.spinField.getText();
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.includeSeconds) {
            if (string.length() != 8) {
                bl2 = false;
            }
        } else if (string.length() != 5) {
            bl2 = false;
        }
        if (bl2) {
            int n2;
            String string2 = "0123456789";
            if (string2.indexOf(string.substring(0, 1)) < 0 || string2.indexOf(string.substring(1, 2)) < 0 || string2.indexOf(string.substring(3, 4)) < 0 || string2.indexOf(string.substring(4, 5)) < 0) {
                bl2 = false;
            }
            if (this.includeSeconds && (string2.indexOf(string.substring(6, 7)) < 0 || string2.indexOf(string.substring(7, 8)) < 0)) {
                bl2 = false;
            }
            if (!string.substring(2, 3).equals(":")) {
                bl2 = false;
            }
            if (this.includeSeconds && !string.substring(5, 6).equals(":")) {
                bl2 = false;
            }
            if ((long)(n2 = this.getTimeValue(string)) < this.lowerBound || (long)n2 > this.upperBound) {
                bl3 = false;
            }
        }
        this.valueValid = bl2;
        this.inRange = bl3;
    }

    protected boolean validateSelection(int n2, int n3) {
        if (n2 == 0 && n3 == 8) {
            return true;
        }
        if (n2 == 0 && n3 == 2) {
            return true;
        }
        if (n2 == 3 && n3 == 5) {
            return true;
        }
        return n2 == 6 && n3 == 8;
    }

    protected void highlightSelectedField(int n2, int n3) {
        this.spinField.select(n2, n3);
    }

    protected synchronized void spin(boolean bl) {
        int n2 = this.getHours(this.getValue());
        int n3 = this.getMinutes(this.getValue());
        int n4 = this.getSeconds(this.getValue());
        int n5 = 1;
        if (!bl) {
            n5 = -1;
        }
        if (this.selectedSS()) {
            this.setTimeValue(n2, n3, (n4 + n5 + 60) % 60);
        } else if (this.selectedMM()) {
            this.setTimeValue(n2, (n3 + n5 + 60) % 60, n4);
        } else if (this.selectedHH()) {
            this.setTimeValue((n2 + n5 + 24) % 24, n3, n4);
        } else if (this.includeSeconds) {
            super.spin(bl);
        } else {
            this.setSpinValue((this.getValue() + (long)(n5 * 60) + 86399L) % 86399L);
        }
        this.highlightSelectedField(this.currentSelectionStart, this.currentSelectionEnd);
    }

    public void selectNextField() {
        if (this.selectedHH()) {
            this.selectMM();
        } else if (this.selectedMM() && this.includeSeconds) {
            this.selectSS();
        } else {
            this.selectHH();
        }
    }

    public void selectPreviousField() {
        if (this.selectedMM()) {
            this.selectHH();
        } else if (this.selectedSS()) {
            this.selectMM();
        } else if (this.includeSeconds) {
            this.selectSS();
        } else {
            this.selectMM();
        }
    }

    public boolean selectedSS() {
        return this.currentSelectionStart == 6 && this.currentSelectionEnd == 8;
    }

    public boolean selectedMM() {
        return this.currentSelectionStart == 3 && this.currentSelectionEnd == 5;
    }

    public boolean selectedHH() {
        return this.currentSelectionStart == 0 && this.currentSelectionEnd == 2;
    }

    public boolean selectedTime() {
        return this.currentSelectionStart == 0 && this.currentSelectionEnd == 8;
    }

    public boolean NoSelection() {
        return this.currentSelectionStart == 0 && this.currentSelectionEnd == 0;
    }

    public void selectSS() {
        this.spinField.select(6, 8);
        this.currentSelectionStart = 6;
        this.currentSelectionEnd = 8;
    }

    public void selectMM() {
        this.spinField.select(3, 5);
        this.currentSelectionStart = 3;
        this.currentSelectionEnd = 5;
    }

    public void selectHH() {
        this.spinField.select(0, 2);
        this.currentSelectionStart = 0;
        this.currentSelectionEnd = 2;
    }

    public void selectTime() {
        this.spinField.select(0, 8);
        this.currentSelectionStart = 0;
        this.currentSelectionEnd = 8;
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (keyEvent.getSource() == this.spinField) {
            if (Character.isDigit(keyEvent.getKeyChar())) {
                if (this.selectedHH()) {
                    if (Integer.parseInt(this.getStringValue().substring(1, 2) + keyEvent.getKeyChar()) < 24) {
                        this.setSpinValue(this.getStringValue().substring(1, 2) + keyEvent.getKeyChar() + this.getStringValue().substring(2));
                    } else if (Integer.parseInt(this.getStringValue().substring(0, 1) + keyEvent.getKeyChar()) < 24) {
                        this.setSpinValue(this.getStringValue().substring(0, 1) + keyEvent.getKeyChar() + this.getStringValue().substring(2));
                    } else if (Integer.parseInt("0" + keyEvent.getKeyChar()) < 24) {
                        this.setSpinValue("0" + keyEvent.getKeyChar() + this.getStringValue().substring(2));
                    }
                    this.spinField.select(1, 2);
                }
                if (this.selectedMM()) {
                    if (Integer.parseInt(this.getStringValue().substring(4, 5) + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 3) + this.getStringValue().substring(4, 5) + keyEvent.getKeyChar() + this.getStringValue().substring(5));
                    } else if (Integer.parseInt(this.getStringValue().substring(3, 4) + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 3) + this.getStringValue().substring(3, 4) + keyEvent.getKeyChar() + this.getStringValue().substring(5));
                    } else if (Integer.parseInt("0" + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 3) + "0" + keyEvent.getKeyChar() + this.getStringValue().substring(2));
                    }
                    this.spinField.select(4, 5);
                }
                if (this.selectedSS()) {
                    if (Integer.parseInt(this.getStringValue().substring(7, 8) + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 6) + this.getStringValue().substring(7, 8) + keyEvent.getKeyChar());
                    } else if (Integer.parseInt(this.getStringValue().substring(6, 7) + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 6) + this.getStringValue().substring(6, 7) + keyEvent.getKeyChar());
                    } else if (Integer.parseInt("0" + keyEvent.getKeyChar()) <= 60) {
                        this.setSpinValue(this.getStringValue().substring(0, 6) + "0" + keyEvent.getKeyChar());
                    }
                    this.spinField.select(7, 8);
                }
            }
            if (keyEvent.getKeyCode() != 9 && keyEvent.getModifiers() != 8) {
                keyEvent.consume();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.selectFieldAtCursor();
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.spinThread != null) {
            this.killThread = true;
            this.spinThread = null;
        }
        this.selectFieldAtCursor();
    }

    private void selectFieldAtCursor() {
        this.spinField.requestFocus();
        if (this.spinField.getSelectionStart() <= 2) {
            SwingUtilities.invokeLater(RunSelectHH.getInstance(this));
        } else if (this.spinField.getSelectionStart() > 2 && this.spinField.getSelectionStart() <= 5) {
            SwingUtilities.invokeLater(RunSelectMM.getInstance(this));
        } else if (this.includeSeconds) {
            SwingUtilities.invokeLater(RunSelectSS.getInstance(this));
        } else {
            SwingUtilities.invokeLater(RunSelectMM.getInstance(this));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.spinField) {
            if (this.NoSelection()) {
                if (this.includeSeconds) {
                    this.selectSS();
                } else {
                    this.selectMM();
                }
            }
            this.highlightSelectedField(this.currentSelectionStart, this.currentSelectionEnd);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.spinField) {
            this.spinField.select(0, 0);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.spinField) {
            if (keyEvent.getKeyCode() == 39) {
                this.highlightSelectedField(this.currentSelectionStart, this.currentSelectionEnd);
                this.selectNextField();
            }
            if (keyEvent.getKeyCode() == 37) {
                this.highlightSelectedField(this.currentSelectionStart, this.currentSelectionEnd);
                this.selectPreviousField();
            }
        }
        if (this.spinThread != null) {
            this.killThread = true;
            this.spinThread = null;
        }
    }

    class TimeDocument
    extends PlainDocument {
        TimeDocument() {
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            int n3 = 0;
            while (n3 < cArray.length) {
                if (!(Character.isDigit(cArray[n3]) || cArray[n3] == ':' && string.length() > 1)) {
                    return;
                }
                ++n3;
            }
            super.insertString(n2, string, attributeSet);
        }
    }
}

