/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.Pane;
import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.TiledComponent;
import java.io.Serializable;
import java.util.Vector;

public class TiledPane
extends TiledComponent
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int STATE_NORMAL = 1;
    public static final int STATE_MAXIMIZED = 2;
    public static final int STATE_MINIMIZED = 3;
    public static final int STATE_HIDDEN = 4;
    public static final int STATE_FLOATING = 5;
    int state = 1;

    public TiledPane() {
    }

    public TiledPane(Pane pane) {
        super(pane);
        pane.setTiledPane(this);
    }

    public TiledPane(int n2) {
        super(n2);
    }

    public void setPane(Pane pane) {
        super.setComponent(pane);
        pane.setTiledPane(this);
    }

    public Pane getPane() {
        return (Pane)this.getComponent();
    }

    public void add(TiledPane tiledPane) {
        Pane pane;
        PaneTitleBar paneTitleBar;
        super.add(tiledPane);
        if (tiledPane.getType() == 3 && (paneTitleBar = (pane = tiledPane.getPane()).getTitleBar()) != null) {
            paneTitleBar.setMinimizeButtonVertical(this.type != 2);
        }
    }

    public TiledPane getPaneAt(int n2) {
        return (TiledPane)this.getChildAt(n2);
    }

    public TiledPane getParentPane() {
        return (TiledPane)this.getParent();
    }

    public void setState(int n2) {
        this.state = n2;
        super.setMinimized(n2 == 3);
        super.setVisible(n2 != 4 && n2 != 5);
    }

    public int getState() {
        return this.state;
    }

    public Vector getLeafPanes() {
        Vector<Pane> vector = new Vector<Pane>();
        if (this.getType() == 3) {
            vector.addElement(this.getPane());
        } else {
            this.addLeafPanes(vector);
        }
        return vector;
    }

    public Vector getLeafTiledPanes() {
        Vector<TiledPane> vector = new Vector<TiledPane>();
        if (this.getType() == 3) {
            vector.addElement(this);
        } else {
            this.addLeafTiledPanes(vector);
        }
        return vector;
    }

    void addLeafPanes(Vector vector) {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            TiledPane tiledPane = this.getPaneAt(n2);
            if (tiledPane.getType() == 3) {
                vector.addElement(tiledPane.getPane());
            } else {
                tiledPane.addLeafPanes(vector);
            }
            ++n2;
        }
    }

    void addLeafTiledPanes(Vector vector) {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            TiledPane tiledPane = this.getPaneAt(n2);
            if (tiledPane.getType() == 3) {
                vector.addElement(tiledPane);
            } else {
                tiledPane.addLeafPanes(vector);
            }
            ++n2;
        }
    }
}

