/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Vector;

public class TiledComponent
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int VERTICAL_SPLIT = 2;
    public static final int LEAF = 3;
    protected Component comp;
    protected Object udata;
    protected Vector children;
    protected TiledComponent parent;
    protected int type = 3;
    protected int ratio = 1000;
    protected Rectangle rect = new Rectangle();
    protected Rectangle splitbar = new Rectangle();
    protected boolean minimized = false;
    protected boolean visible = true;
    protected transient FocusListener fmon;
    boolean focusPainted = true;
    boolean borderPainted = true;

    public TiledComponent() {
        this(null, null);
    }

    public TiledComponent(Component component) {
        this(component, null);
    }

    public TiledComponent(int n2) {
        this.type = n2;
    }

    public TiledComponent(Component component, Object object) {
        this.setComponent(component);
        this.udata = object;
    }

    public boolean isLightweight() {
        if (this.comp != null) {
            return this.testLightness(this.comp);
        }
        int n2 = 0;
        while (n2 < this.children.size()) {
            TiledComponent tiledComponent = (TiledComponent)this.children.elementAt(n2);
            if (!tiledComponent.isLightweight()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean testLightness(Component component) {
        if (component instanceof Canvas || component instanceof Panel) {
            return false;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n2 = 0;
            while (n2 < container.getComponentCount()) {
                if (!this.testLightness(container.getComponent(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void setComponent(Component component) {
        this.comp = component;
        this.type = 3;
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setSplitRatio(int n2) {
        this.ratio = n2;
    }

    public int getSplitRatio() {
        return this.ratio;
    }

    public void setUserData(Object object) {
        this.udata = object;
    }

    public Object getUserData() {
        return this.udata;
    }

    public void add(TiledComponent tiledComponent) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(tiledComponent);
        tiledComponent.setParent(this);
    }

    public void remove(TiledComponent tiledComponent) {
        if (this.children == null) {
            return;
        }
        this.children.removeElement(tiledComponent);
        tiledComponent.setParent(null);
    }

    public TiledComponent getChildAt(int n2) {
        if (this.children == null) {
            return null;
        }
        return (TiledComponent)this.children.elementAt(n2);
    }

    Vector getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.rect);
    }

    public TiledComponent getParent() {
        return this.parent;
    }

    void setParent(TiledComponent tiledComponent) {
        this.parent = tiledComponent;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.rect.x = n2;
        this.rect.y = n3;
        this.rect.width = n4;
        this.rect.height = n5;
        if (this.parent != null) {
            if (this.parent.getType() == 2) {
                this.splitbar.x = n2 + n4;
                this.splitbar.y = n3;
            } else {
                this.splitbar.x = n2;
                this.splitbar.y = n3 + n5;
            }
        }
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    public Rectangle getSplitbarBounds() {
        return this.splitbar;
    }

    public void setFocusMonitor(FocusListener focusListener) {
        this.fmon = focusListener;
    }

    public FocusListener getFocusMonitor() {
        return this.fmon;
    }

    public void setMinimized(boolean bl) {
        this.minimized = bl;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    Dimension getMinimizedSize() {
        return this.comp.getMinimumSize();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setFocusPainted(boolean bl) {
        this.focusPainted = bl;
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setExternalBorderPainted(boolean bl) {
        this.borderPainted = bl;
    }

    public boolean isExternalBorderPainted() {
        return this.borderPainted;
    }

    public TiledComponent getAdjustantComponent(boolean bl, boolean bl2) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getType() == 2 && !bl2 || this.parent.getType() == 1 && bl2) {
            return this.parent.getAdjustantComponent(bl, bl2);
        }
        Vector vector = this.parent.getChildren();
        int n2 = vector.size();
        int n3 = vector.indexOf(this);
        if (n3 == 0 && bl || n3 == n2 - 1 && !bl) {
            return this.parent.getAdjustantComponent(bl, bl2);
        }
        if (bl) {
            return (TiledComponent)vector.elementAt(n3 - 1);
        }
        return (TiledComponent)vector.elementAt(n3 + 1);
    }
}

