/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;

public class TaskIndicator
extends JComponent
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int PROGRESS = 1;
    public static final int WAIT = 2;
    public static final int HASHED = 3;
    public static final int SOLID = 4;
    boolean active = false;
    int mode = 2;
    int style = 3;
    int hashWidth = 8;
    int hashGap = 2;
    int minValue = 0;
    int maxValue = 100;
    int value = 0;
    boolean showValue = true;
    String prefix;
    String postfix;
    Color shaftColor = null;
    Color progressColor = Color.blue.darker().darker();
    int td = 70;
    int waitDelta = 4;
    WaitThread wt = null;

    public boolean isFocusTraversable() {
        return false;
    }

    public synchronized void setActive(boolean bl) {
        this.active = bl;
        if (this.mode == 2) {
            if (bl) {
                if (this.wt == null) {
                    this.wt = new WaitThread();
                } else if (this.wt.isAlive()) {
                    this.wt.interrupt();
                }
                this.wt.start();
            } else if (this.wt != null) {
                this.wt.interrupt();
                this.wt = null;
                this.value = 0;
            }
        }
        this.repaint();
    }

    public synchronized void initializeProgress(int n2, int n3, int n4) {
        this.mode = 1;
        this.minValue = n2;
        this.maxValue = n3;
        this.value = n4;
        this.setActive(true);
    }

    public void setStyle(int n2) {
        this.style = n2;
        this.shaftColor = n2 == 3 ? null : Color.white;
    }

    public int getStyle() {
        return this.style;
    }

    public void setMode(int n2) {
        this.mode = n2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setShaftColor(Color color) {
        this.shaftColor = color;
    }

    public Color getShaftColor() {
        return this.shaftColor;
    }

    public void setBarColor(Color color) {
        this.progressColor = color;
    }

    public Color getBarColor() {
        return this.progressColor;
    }

    public void setShowValue(boolean bl) {
        this.showValue = bl;
    }

    public boolean isShowValue() {
        return this.showValue;
    }

    public void setPrefixText(String string) {
        this.prefix = string;
    }

    public String getPrefixText() {
        return this.prefix;
    }

    public void setPostfixText(String string) {
        this.postfix = string;
    }

    public String getPostfixText() {
        return this.postfix;
    }

    public synchronized void setValue(int n2) {
        if (this.mode == 2) {
            return;
        }
        this.value = n2;
        if (this.active) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.mode == 2 ? 0 : this.value;
    }

    public void setMinimumValue(int n2) {
        this.minValue = n2;
    }

    public int getMinimumValue() {
        return this.minValue;
    }

    public void setMaximumValue(int n2) {
        this.maxValue = n2;
    }

    public int getMaximumValue() {
        return this.maxValue;
    }

    public void paint(Graphics graphics) {
        super.paintBorder(graphics);
        Dimension dimension = new Dimension(this.getSize());
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (this.active) {
            if (this.mode == 1) {
                Color color = this.getBackground();
                graphics.setColor(this.shaftColor != null ? this.shaftColor : color);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                int n2 = this.value * dimension.width / (this.maxValue - this.minValue);
                if (this.style == 3) {
                    int n3 = 0;
                    graphics.setColor(this.progressColor);
                    while (n3 <= n2) {
                        if (n3 + this.hashWidth <= n2) {
                            graphics.fillRect(n3, 0, this.hashWidth, dimension.height);
                            n3 += this.hashWidth + this.hashGap;
                            continue;
                        }
                        break;
                    }
                } else {
                    graphics.setColor(this.progressColor);
                    if (this.showValue) {
                        Font font = this.getFont();
                        FontMetrics fontMetrics = graphics.getFontMetrics(font);
                        graphics.setFont(font);
                        String string = Integer.toString(this.value);
                        if (this.prefix != null) {
                            string = this.prefix + string;
                        }
                        if (this.postfix != null) {
                            string = string + this.postfix;
                        }
                        graphics.drawString(string, dimension.width / 2 - fontMetrics.stringWidth(string) / 2, dimension.height / 2 + fontMetrics.getHeight() / 2 - fontMetrics.getMaxDescent());
                        graphics.setXORMode(this.shaftColor != null ? this.shaftColor : color);
                    }
                    graphics.setColor(this.progressColor);
                    graphics.fillRect(0, 0, n2, dimension.height);
                }
            } else {
                int n4 = dimension.width / 2;
                int n5 = 0;
                Color color = this.getBackground();
                if (this.waitDelta > 0) {
                    n5 = this.value > n4 ? n4 : this.value;
                    graphics.setColor(color);
                    if (this.value > n4) {
                        graphics.fillRect(this.value - this.waitDelta, 0, this.waitDelta, dimension.height);
                    }
                    graphics.setColor(color.darker());
                    graphics.fillRect(this.value - n5, 0, n5, dimension.height);
                } else {
                    int n6 = dimension.width - this.value;
                    n5 = n6 > n4 ? n4 : n6;
                    graphics.setColor(color);
                    if (n6 > n4) {
                        graphics.fillRect(this.value + n5, 0, -this.waitDelta, dimension.height);
                    }
                    graphics.setColor(color.darker());
                    graphics.fillRect(this.value, 0, n5, dimension.height);
                }
                this.value += this.waitDelta;
                if (this.waitDelta < 0 && this.value < 0) {
                    this.value = 0;
                    this.waitDelta = -this.waitDelta;
                } else if (this.waitDelta > 0 && this.value > dimension.width) {
                    this.value = dimension.width;
                    this.waitDelta = -this.waitDelta;
                }
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics.translate(-insets.left, -insets.top);
    }

    class WaitThread
    extends Thread {
        WaitThread() {
        }

        public synchronized void run() {
            try {
                while (true) {
                    Thread.sleep(TaskIndicator.this.td);
                    TaskIndicator.this.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

