/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class StgMonitorPanel
extends JPanel
implements Serializable {
    protected static final String totalMemMsg = "Total memory = ";
    protected static final String usedMemMsg = "Used memory = ";
    protected JTree stgTree;
    protected JLabel totalMemLB;
    protected JLabel usedMemLB;

    public StgMonitorPanel() {
        Component component;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        Vector vector = new Vector();
        this.getLabels(vector);
        jPanel.setLayout(new GridLayout(vector.size(), 1));
        int n2 = 0;
        while (n2 < vector.size()) {
            component = (Component)vector.elementAt(n2);
            jPanel.add(component);
            ++n2;
        }
        this.stgTree = new JTree();
        component = new JScrollPane(this.stgTree);
        this.add("North", jPanel);
        this.add("Center", component);
    }

    public void getLabels(Vector vector) {
        this.totalMemLB = new JLabel(totalMemMsg);
        this.usedMemLB = new JLabel(usedMemMsg);
        vector.add(this.totalMemLB);
        vector.add(this.usedMemLB);
    }

    public void refresh() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Monitored Objects", true);
        this.buildTree(defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.stgTree.setModel(defaultTreeModel);
        Runtime runtime = Runtime.getRuntime();
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###");
        String string = decimalFormat.format(new Long(runtime.totalMemory()));
        String string2 = decimalFormat.format(new Long(runtime.totalMemory() - runtime.freeMemory()));
        this.totalMemLB.setText(totalMemMsg + string);
        this.usedMemLB.setText(usedMemMsg + string2);
    }

    protected void buildTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.buildNodeFor(CommonDialog.instances, "CommonDialog", defaultMutableTreeNode);
        this.buildNodeFor(CommonFrame.instances, "CommonFrame", defaultMutableTreeNode);
    }

    protected void buildNodeFor(Vector vector, String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector vector2 = new Vector();
        CommonUtils.removeFreedReferences(vector);
        Hashtable hashtable = this.buildObjectHashtable(vector);
        int n2 = this.convertHashToTree(hashtable, vector2);
        String string2 = n2 + " " + string;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2, true);
        int n3 = 0;
        while (n3 < vector2.size()) {
            defaultMutableTreeNode2.add((MutableTreeNode)vector2.elementAt(n3));
            ++n3;
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    protected int convertHashToTree(Hashtable hashtable, Vector vector) {
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(clazz);
            String string = vector2.size() + " " + clazz.getName();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string, true);
            vector.addElement(defaultMutableTreeNode);
            int n3 = 0;
            while (n3 < vector2.size()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(vector2.elementAt(n3).toString(), false);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                ++n3;
            }
            n2 += vector2.size();
        }
        return n2;
    }

    protected Hashtable buildObjectHashtable(Vector vector) {
        Hashtable hashtable = new Hashtable();
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            WeakReference weakReference = (WeakReference)vector.elementAt(n2);
            Object t2 = weakReference.get();
            if (t2 != null) {
                Class<?> clazz = t2.getClass();
                Vector<String> vector2 = (Vector<String>)hashtable.get(clazz);
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                    hashtable.put(clazz, vector2);
                }
                String string = this.formatIntoString(t2);
                vector2.addElement(string);
            }
            --n2;
        }
        return hashtable;
    }

    protected String formatIntoString(Object object) {
        String string = "";
        string = object instanceof JDialog ? ((JDialog)object).getTitle() : (object instanceof JFrame ? ((JFrame)object).getTitle() : object.toString());
        return string;
    }
}

