/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class StatusLine
extends JLabel
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int HEIGHT = 20;

    public StatusLine(boolean bl) {
        super(" ");
        LineMetrics lineMetrics;
        int n2;
        if (bl) {
            this.setBorder(new TopBorder());
        }
        if ((n2 = Math.round((lineMetrics = AssistManager.getLineMetrics("X", this, this.getFont())).getLeading() * 2.0f + lineMetrics.getDescent() + lineMetrics.getAscent() + 5.0f)) > HEIGHT) {
            HEIGHT = n2;
        }
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, HEIGHT));
    }

    public void setStatus(String string) {
        if (string == null || string.length() == 0) {
            this.setText(" ");
        } else {
            this.setText(string);
        }
    }

    public String getStatus() {
        String string = this.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void clear() {
        this.setText(" ");
    }

    public static void setHeight(int n2) {
        if (n2 > HEIGHT) {
            HEIGHT = n2;
        }
    }

    class TopBorder
    extends EmptyBorder {
        public TopBorder() {
            super(0, 0, 0, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Color color = graphics.getColor();
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n3, n2 + n4, n3);
            graphics.setColor(color);
        }
    }
}

