/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.DialogButtons;
import com.ibm.db2.tools.common.DockingPane;
import com.ibm.db2.tools.common.StandardContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class StandardDialog
extends JDialog
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String OK_BUTTON_TEXT = "OK_BUTTON_TEXT";
    public static final String CANCEL_BUTTON_TEXT = "CANCEL_BUTTON_TEXT";
    public static final String HELP_BUTTON_TEXT = "HELP_BUTTON_TEXT";
    public static final String BACK_BUTTON_TEXT = "BACK_BUTTON_TEXT";
    public static final String NEXT_BUTTON_TEXT = "NEXT_BUTTON_TEXT";
    public static final String OK_BUTTON_MNEMONIC = "OK_BUTTON_MNEMONIC";
    public static final String CANCEL_BUTTON_MNEMONIC = "CANCEL_BUTTON_MNEMONIC";
    public static final String HELP_BUTTON_MNEMONIC = "HELP_BUTTON_MNEMONIC";
    public static final String BACK_BUTTON_MNEMONIC = "BACK_BUTTON_MNEMONIC";
    public static final String NEXT_BUTTON_MNEMONIC = "NEXT_BUTTON_MNEMONIC";
    public static final String OK_BUTTON_VISIBLE = "OK_BUTTON_V";
    public static final String CANCEL_BUTTON_VISIBLE = "CANCEL_BUTTON_V";
    public static final String HELP_BUTTON_VISIBLE = "HELP_BUTTON_V";
    public static final String BACK_BUTTON_VISIBLE = "BACK_BUTTON_V";
    public static final String NEXT_BUTTON_VISIBLE = "NEXT_BUTTON_V";
    protected StandardContext context;
    protected Hashtable prop;
    protected Buttons buttons;

    public StandardDialog() {
        this((JFrame)null, "", false);
    }

    public StandardDialog(String string) {
        this((JFrame)null, string, false);
    }

    public StandardDialog(JFrame jFrame) {
        this(jFrame, "", false);
    }

    public StandardDialog(JFrame jFrame, String string, boolean bl) {
        super(jFrame, string, true);
        this.buttons = new Buttons(bl);
        this.putProperty(OK_BUTTON_TEXT, "OK");
        this.putProperty(CANCEL_BUTTON_TEXT, "Cancel");
        this.putProperty(HELP_BUTTON_TEXT, "Help");
        this.putProperty(BACK_BUTTON_TEXT, "<<Back");
        this.putProperty(NEXT_BUTTON_TEXT, "Next>>");
        this.putProperty(HELP_BUTTON_MNEMONIC, new Character('H'));
        this.putProperty(BACK_BUTTON_MNEMONIC, new Character('B'));
        this.putProperty(NEXT_BUTTON_MNEMONIC, new Character('N'));
        this.putProperty(OK_BUTTON_VISIBLE, Boolean.TRUE);
        this.putProperty(CANCEL_BUTTON_VISIBLE, Boolean.TRUE);
        this.putProperty(HELP_BUTTON_VISIBLE, Boolean.TRUE);
        this.putProperty(BACK_BUTTON_VISIBLE, Boolean.FALSE);
        this.putProperty(NEXT_BUTTON_VISIBLE, Boolean.FALSE);
        this.setStatusComponent(this.buttons);
    }

    public void setStandardContext(StandardContext standardContext) {
        this.context = standardContext;
    }

    public StandardContext getStandardContext() {
        if (this.context == null) {
            this.context = new StandardContext(this);
        }
        return this.context;
    }

    public void setClient(Component component) {
        this.getStandardContext().setClient(component);
    }

    public Component getClient() {
        return this.getStandardContext().getClient();
    }

    public void setStatusComponent(JComponent jComponent) {
        this.getStandardContext().setStatusComponent(jComponent);
    }

    public DockingPane getDockingPane() {
        return this.getStandardContext().getDockingPane();
    }

    public void putProperty(String string, Object object) {
        if (this.prop == null) {
            this.prop = new Hashtable();
        }
        this.prop.put(string, object);
        if (this.buttons != null) {
            this.buttons.propertyChanged(string, object);
        }
    }

    public Object getProperty(String string) {
        return this.prop != null ? this.prop.get(string) : null;
    }

    protected void handleNext() {
    }

    protected void handleBack() {
    }

    protected void handleHelp() {
    }

    protected void handleOK() {
    }

    protected void handleCancel() {
    }

    public class Buttons
    extends DialogButtons
    implements ActionListener {
        public Buttons(boolean bl) {
            super(bl);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                StandardDialog.this.handleOK();
            } else if (object == this.cancelButton) {
                StandardDialog.this.handleCancel();
            } else if (object == this.backButton) {
                StandardDialog.this.handleBack();
            } else if (object == this.nextButton) {
                StandardDialog.this.handleNext();
            } else if (object == this.helpButton) {
                StandardDialog.this.handleHelp();
            }
        }

        public void propertyChanged(String string, Object object) {
            if (string.equals(StandardDialog.OK_BUTTON_TEXT)) {
                this.okButton.setText((String)object);
            } else if (string.equals(StandardDialog.CANCEL_BUTTON_TEXT)) {
                this.cancelButton.setText((String)object);
            } else if (string.equals(StandardDialog.HELP_BUTTON_TEXT)) {
                this.helpButton.setText((String)object);
            } else if (string.equals(StandardDialog.BACK_BUTTON_TEXT)) {
                this.backButton.setText((String)object);
            } else if (string.equals(StandardDialog.NEXT_BUTTON_TEXT)) {
                this.nextButton.setText((String)object);
            } else if (string.equals(StandardDialog.OK_BUTTON_MNEMONIC)) {
                Character c2 = (Character)object;
                this.okButton.setMnemonic(c2.charValue());
            } else if (string.equals(StandardDialog.CANCEL_BUTTON_MNEMONIC)) {
                Character c3 = (Character)object;
                this.cancelButton.setMnemonic(c3.charValue());
            } else if (string.equals(StandardDialog.HELP_BUTTON_MNEMONIC)) {
                Character c4 = (Character)object;
                this.helpButton.setMnemonic(c4.charValue());
            } else if (string.equals(StandardDialog.BACK_BUTTON_MNEMONIC)) {
                Character c5 = (Character)object;
                this.backButton.setMnemonic(c5.charValue());
            } else if (string.equals(StandardDialog.NEXT_BUTTON_MNEMONIC)) {
                Character c6 = (Character)object;
                this.nextButton.setMnemonic(c6.charValue());
            } else if (string.equals(StandardDialog.OK_BUTTON_VISIBLE)) {
                this.okButton.setVisible((Boolean)object);
            } else if (string.equals(StandardDialog.CANCEL_BUTTON_VISIBLE)) {
                this.cancelButton.setVisible((Boolean)object);
            } else if (string.equals(StandardDialog.HELP_BUTTON_VISIBLE)) {
                this.helpButton.setVisible((Boolean)object);
            } else if (string.equals(StandardDialog.BACK_BUTTON_VISIBLE)) {
                this.backButton.setVisible((Boolean)object);
            } else if (string.equals(StandardDialog.NEXT_BUTTON_VISIBLE)) {
                this.nextButton.setVisible((Boolean)object);
            }
        }

        public void setOKEnabled(boolean bl) {
            this.okButton.setEnabled(bl);
        }

        public void setCancelEnabled(boolean bl) {
            this.cancelButton.setEnabled(bl);
        }

        public void setBackEnabled(boolean bl) {
            this.backButton.setEnabled(bl);
        }

        public void setNextEnabled(boolean bl) {
            this.nextButton.setEnabled(bl);
        }
    }
}

