/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.DockingArea;
import com.ibm.db2.tools.common.DockingPane;
import com.ibm.db2.tools.common.FrameStatusLine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public class StandardContext
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected FrameStatusLine statusLine;
    protected JComponent statusComponent;
    protected DockingPane dockingPane;
    protected Component client;
    protected RootPaneContainer rootPane;

    public StandardContext(RootPaneContainer rootPaneContainer) {
        this.rootPane = rootPaneContainer;
        this.statusLine = new FrameStatusLine();
        this.dockingPane = new DockingPane();
        Container container = rootPaneContainer.getContentPane();
        container.add((Component)this.dockingPane, "Center");
        container.add((Component)this.statusLine, "South");
        DockingArea.compensateMenuBar(this.dockingPane, true);
        Color color = UIManager.getColor("CommonBackground");
        if (color != null) {
            this.dockingPane.setBackground(color);
        }
    }

    public RootPaneContainer getRootPane() {
        return this.rootPane;
    }

    public void detach() {
        Container container = this.rootPane.getContentPane();
        container.remove(this.dockingPane);
        if (this.statusLine != null) {
            container.remove(this.statusLine);
        }
    }

    public void setClient(Component component) {
        this.dockingPane.setClient(component);
    }

    public Component getClient() {
        return this.dockingPane.getClient();
    }

    public void setStatusLine(FrameStatusLine frameStatusLine) {
        Container container = this.rootPane.getContentPane();
        if (this.statusComponent != null) {
            container.remove(this.statusComponent);
            this.statusComponent = null;
        }
        if (this.statusLine != null) {
            container.remove(this.statusLine);
        }
        container.add((Component)frameStatusLine, "South");
    }

    public void setStatusComponent(JComponent jComponent) {
        Container container = this.rootPane.getContentPane();
        if (this.statusLine != null && container.isAncestorOf(this.statusLine)) {
            container.remove(this.statusLine);
        }
        if (this.statusComponent != null && container.isAncestorOf(this.statusComponent)) {
            container.remove(this.statusComponent);
        }
        container.add((Component)jComponent, "South");
        this.statusComponent = jComponent;
    }

    public JComponent getStatusComponent() {
        return this.statusComponent;
    }

    public FrameStatusLine getStatusLine() {
        return this.statusLine;
    }

    public DockingPane getDockingPane() {
        return this.dockingPane;
    }

    public void setStatusLineVisible(boolean bl) {
        Container container = this.rootPane.getContentPane();
        if (!bl && this.statusLine != null) {
            container.remove(this.statusLine);
            this.statusLine = null;
        } else if (bl && this.statusLine == null) {
            this.statusLine = new FrameStatusLine();
            container.add((Component)this.statusLine, "South");
        }
    }
}

