/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.ComponentSplitter;
import com.ibm.db2.tools.common.TiledComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;

public class SplitterLayout
implements LayoutManager,
Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private Dimension calculateSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize();
    }

    public void layoutContainer(Container container) {
        ComponentSplitter componentSplitter = (ComponentSplitter)container;
        Dimension dimension = componentSplitter.getSize();
        TiledComponent tiledComponent = componentSplitter.getRoot();
        if (tiledComponent == null) {
            return;
        }
        Insets insets = componentSplitter.getInsets();
        int n2 = dimension.width - insets.left - insets.right;
        int n3 = dimension.height - insets.top - insets.bottom;
        TiledComponent tiledComponent2 = componentSplitter.getMaximizedComponent();
        if (tiledComponent2 != null) {
            this.setMaxedPaneBounds(componentSplitter, tiledComponent, tiledComponent2, insets.left, insets.top, n2, n3);
        } else {
            this.setPaneBounds(componentSplitter, tiledComponent, insets.left, insets.top, n2, n3);
        }
    }

    private void setMaxedPaneBounds(ComponentSplitter componentSplitter, TiledComponent tiledComponent, TiledComponent tiledComponent2, int n2, int n3, int n4, int n5) {
        block3: {
            block1: {
                Component component;
                block2: {
                    if (tiledComponent.getType() != 3) break block1;
                    component = tiledComponent.getComponent();
                    if (tiledComponent != tiledComponent2) break block2;
                    component.setVisible(true);
                    component.setBounds(n2, n3, n4, n5);
                    break block3;
                }
                if (!tiledComponent.isVisible()) break block3;
                component.setVisible(false);
                break block3;
            }
            int n6 = 0;
            while (n6 < tiledComponent.getChildCount()) {
                TiledComponent tiledComponent3 = tiledComponent.getChildAt(n6);
                this.setMaxedPaneBounds(componentSplitter, tiledComponent3, tiledComponent2, n2, n3, n4, n5);
                ++n6;
            }
        }
    }

    private boolean setPaneBounds(ComponentSplitter componentSplitter, TiledComponent tiledComponent, int n2, int n3, int n4, int n5) {
        if (!tiledComponent.isVisible()) {
            return false;
        }
        tiledComponent.setBounds(n2, n3, n4, n5);
        int n6 = componentSplitter.getSplitBarSize();
        if (tiledComponent.getType() == 3) {
            Component component = tiledComponent.getComponent();
            component.setVisible(true);
            component.setBounds(n2, n3, n4, n5);
            return true;
        }
        if (tiledComponent.getType() == 2) {
            int n7 = tiledComponent.getChildCount();
            TiledComponent tiledComponent2 = null;
            int n8 = 0;
            int n9 = 0;
            int n10 = (n7 - 1) * n6;
            int n11 = n4 - n10;
            int n12 = 0;
            int n13 = n2;
            int n14 = 0;
            while (n14 < n7) {
                TiledComponent tiledComponent3 = tiledComponent.getChildAt(n14);
                int n15 = 0;
                if (n14 == n7 - 1) {
                    if (tiledComponent2 != null && !tiledComponent3.isVisible()) {
                        Rectangle rectangle = tiledComponent2.getBounds();
                        this.setPaneBounds(componentSplitter, tiledComponent2, rectangle.x, rectangle.y, n2 + n4 - rectangle.x, rectangle.height);
                        break;
                    }
                    if (tiledComponent2 != null && tiledComponent3.isMinimized()) {
                        Rectangle rectangle = tiledComponent2.getBounds();
                        n15 = n4 - n8;
                        int n16 = tiledComponent3.getMinimizedSize().width;
                        this.setPaneBounds(componentSplitter, tiledComponent2, rectangle.x, rectangle.y, rectangle.width + n15 - n16, rectangle.height);
                        n13 += n15 - n16;
                        n15 = n16;
                    } else {
                        n15 = n4 - n8;
                    }
                } else {
                    if (tiledComponent3.isMinimized()) {
                        n15 = tiledComponent3.getMinimizedSize().width;
                        n8 += n15 + n6;
                    } else {
                        double d2 = (double)tiledComponent3.getSplitRatio() * (double)n11 / 1000.0;
                        n15 = (int)Math.rint(d2);
                        if (tiledComponent3.isVisible()) {
                            n8 += (n15 += n12) + n6;
                        }
                    }
                    tiledComponent3.splitbar.width = n6;
                    tiledComponent3.splitbar.height = n5;
                }
                if (tiledComponent3.isVisible()) {
                    boolean bl = this.setPaneBounds(componentSplitter, tiledComponent3, n13, n3, n15, n5);
                    if (bl) {
                        n13 += n15 + n6;
                        if (!tiledComponent3.isMinimized()) {
                            n12 = 0;
                        }
                        ++n9;
                    } else if (n14 == n7 - 1) {
                        if (tiledComponent2 != null) {
                            Rectangle rectangle = tiledComponent2.getBounds();
                            this.setPaneBounds(componentSplitter, tiledComponent2, rectangle.x, rectangle.y, n2 + n4 - rectangle.x, rectangle.height);
                        }
                    } else {
                        n12 += n15;
                    }
                } else {
                    n12 += n15;
                }
                tiledComponent2 = tiledComponent3;
                ++n14;
            }
            return n9 > 0;
        }
        if (tiledComponent.getType() == 1) {
            int n17 = tiledComponent.getChildCount();
            TiledComponent tiledComponent4 = null;
            int n18 = 0;
            int n19 = 0;
            int n20 = (n17 - 1) * n6;
            int n21 = n5 - n20;
            int n22 = 0;
            int n23 = n3;
            int n24 = 0;
            while (n24 < n17) {
                TiledComponent tiledComponent5 = tiledComponent.getChildAt(n24);
                int n25 = 0;
                if (n24 == n17 - 1) {
                    if (tiledComponent4 != null && !tiledComponent5.isVisible()) {
                        Rectangle rectangle = tiledComponent4.getBounds();
                        this.setPaneBounds(componentSplitter, tiledComponent4, rectangle.x, rectangle.y, rectangle.width, n3 + n5 - rectangle.y);
                        break;
                    }
                    if (tiledComponent4 != null && tiledComponent5.isMinimized()) {
                        Rectangle rectangle = tiledComponent4.getBounds();
                        n25 = n5 - n18;
                        int n26 = tiledComponent5.getMinimizedSize().height;
                        this.setPaneBounds(componentSplitter, tiledComponent4, rectangle.x, rectangle.y, rectangle.width, rectangle.height + n25 - n26);
                        n23 += n25 - n26;
                        n25 = n26;
                    } else {
                        n25 = n5 - n18;
                    }
                } else {
                    if (tiledComponent5.isMinimized()) {
                        n25 = tiledComponent5.getMinimizedSize().height;
                        n18 += n25 + n6;
                    } else {
                        double d3 = (double)tiledComponent5.getSplitRatio() * (double)n21 / 1000.0;
                        n25 = (int)Math.rint(d3);
                        if (tiledComponent5.isVisible()) {
                            n18 += (n25 += n22) + n6;
                        }
                    }
                    tiledComponent5.splitbar.width = n4;
                    tiledComponent5.splitbar.height = n6;
                }
                if (tiledComponent5.isVisible()) {
                    boolean bl = this.setPaneBounds(componentSplitter, tiledComponent5, n2, n23, n4, n25);
                    if (bl) {
                        n23 += n25 + n6;
                        if (!tiledComponent5.isMinimized()) {
                            n22 = 0;
                        }
                        ++n19;
                    } else if (n24 == n17 - 1) {
                        if (tiledComponent4 != null) {
                            Rectangle rectangle = tiledComponent4.getBounds();
                            this.setPaneBounds(componentSplitter, tiledComponent4, rectangle.x, rectangle.y, rectangle.width, n3 + n5 - rectangle.y);
                        }
                    } else {
                        n22 += n25;
                    }
                } else {
                    n22 += n25;
                }
                tiledComponent4 = tiledComponent5;
                ++n24;
            }
            return n19 > 0;
        }
        return false;
    }
}

