/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.SplashWindowFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

class SplashWindow
extends Window
implements Serializable {
    private transient Image _splashImage;
    private static final int BORDER_WIDTH = 1;
    AccessibleContext accessibleContext = null;

    SplashWindow(Frame frame, Image image) {
        super(frame);
        this._splashImage = image;
        ((Component)this).setSize(this._splashImage.getWidth(null) + 2, this._splashImage.getHeight(null) + 2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        ((Component)this).setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.setCursor(Cursor.getPredefinedCursor(3));
        ((Component)this).setVisible(true);
    }

    public void paint(Graphics graphics) {
        if (this._splashImage == null) {
            return;
        }
        graphics.drawRect(0, 0, this._splashImage.getWidth(null) + 1, this._splashImage.getHeight(null) + 1);
        graphics.drawImage(this._splashImage, 1, 1, this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSplashWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSplashWindow
    extends Window.AccessibleAWTWindow {
        protected AccessibleSplashWindow() {
            super(SplashWindow.this);
        }

        public String getAccessibleName() {
            return SplashWindowFrame.getSingleInstance().getAccessibleContext().getAccessibleName();
        }

        public String getAccessibleDescription() {
            return SplashWindowFrame.getSingleInstance().getAccessibleContext().getAccessibleDescription();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = SplashWindow.this.getParent();
            if (container instanceof Accessible && container.isVisible()) {
                return (Accessible)((Object)container);
            }
            return null;
        }
    }
}

