/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.SloshBucketAbstractPanel;
import com.ibm.db2.tools.common.SloshBucketButtonsPanel;
import com.ibm.db2.tools.common.SloshBucketItemsVectorPanel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class SloshBucketAbstractTree
extends SloshBucketAbstractPanel
implements MouseListener,
TreeModelListener,
TreeSelectionListener,
TreeExpansionListener,
SloshBucketItemsVectorPanel {
    protected TreeModel treeModel;
    protected int keepParentsLevel = 0;
    protected boolean sloshLeafs = true;

    public SloshBucketAbstractTree(String string) {
        super(string, new JScrollPane(), null, 0, null);
    }

    public SloshBucketAbstractTree(String string, JTree jTree) {
        this(string);
        this.setTree(jTree);
    }

    public void setTree(JTree jTree) {
        JTree jTree2 = this.getTree();
        if (jTree != jTree2) {
            if (null != jTree2) {
                this.getTree().removeMouseListener(this);
                this.getTree().removeTreeSelectionListener(this);
                this.getTree().removeTreeExpansionListener(this);
            }
            this.component = jTree;
            this.label.setLabelFor(this.component);
            this.getScrollPane().setViewportView(this.getTree());
            this.getScrollPane().validate();
            this.getTree().addMouseListener(this);
            this.getTree().addTreeSelectionListener(this);
            this.getTree().addTreeExpansionListener(this);
            this.setModel(this.getTree().getModel());
        }
    }

    public JTree getTree() {
        return (JTree)this.component;
    }

    public void setModel(TreeModel treeModel) {
        this.getTree().getModel().removeTreeModelListener(this);
        this.treeModel = treeModel;
        this.getTree().setModel(this.treeModel);
        this.treeModel.addTreeModelListener(this);
        this.updateButtonsState();
    }

    public void setSloshLeafs(boolean bl) {
        this.sloshLeafs = bl;
    }

    public boolean getSloshLeafs() {
        return this.sloshLeafs;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getTree().isEnabled() && mouseEvent.getClickCount() == 2 && !mouseEvent.isPopupTrigger()) {
            TreePath[] treePathArray = this.getTree().getSelectionPaths();
            boolean bl = true;
            if (null != treePathArray) {
                int n2 = 0;
                while (n2 < treePathArray.length) {
                    if (!this.isLeaf(treePathArray[n2].getLastPathComponent())) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    int n3 = 0;
                    while (n3 < this.listenersVector.size()) {
                        if (this.listenersVector.elementAt(n3) instanceof SloshBucketButtonsPanel) {
                            ((SloshBucketButtonsPanel)this.listenersVector.elementAt(n3)).moveSelected(this);
                            break;
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.updateButtonsState();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.updateButtonsState();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.updateButtonsState();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.updateButtonsState();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treeSelectionEvent.isAddedPath(treePath)) {
            TreePath treePath2;
            TreePath treePath3 = treePath;
            while ((treePath2 = treePath3.getParentPath()) != null) {
                if (this.getTree().isPathSelected(treePath2)) {
                    this.getTree().removeTreeSelectionListener(this);
                    this.getTree().removeSelectionPath(treePath2);
                    this.getTree().addTreeSelectionListener(this);
                    break;
                }
                treePath3 = treePath2;
            }
            this.deselectChildNodes(treePath);
            this.getTree().removeTreeSelectionListener(this);
            this.getTree().addSelectionPath(treePath);
            this.getTree().addTreeSelectionListener(this);
        }
        this.updateButtonsState();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        int n2 = this.treeModel.getChildCount(treePath.getLastPathComponent());
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = this.treeModel.getChild(treePath.getLastPathComponent(), n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (null != this.findInVector(treePath.pathByAddingChild(objectArray[n4]), this.removedItems)) {
                this.removeObject(treePath.pathByAddingChild(objectArray[n4]));
            }
            ++n4;
        }
    }

    public boolean hasSelectedItems() {
        boolean bl = false;
        TreePath[] treePathArray = this.getTree().getSelectionPaths();
        if (null != treePathArray) {
            bl = true;
            int n2 = 0;
            while (n2 < treePathArray.length) {
                if (!this.hasObjectsAtPath(treePathArray[n2], true)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public void clear() {
        this.removeAllItems();
        super.clear();
    }

    public boolean hasItems() {
        return this.hasObjectsAtPath(new TreePath(this.treeModel.getRoot()), true);
    }

    public void shutdown() {
        this.treeModel.removeTreeModelListener(this);
        this.getTree().removeTreeExpansionListener(this);
        this.getTree().removeTreeSelectionListener(this);
        super.shutdown();
    }

    public Vector getSelectedItems() {
        boolean bl = this.getSloshLeafs();
        this.setSloshLeafs(true);
        Vector vector = this.getExternalData(SloshBucketAbstractTree.convertToVector(this.getUniqueLeafsPathsAtPaths(this.getTree().getSelectionPaths())));
        this.setSloshLeafs(bl);
        return vector;
    }

    public Vector getAllItems() {
        boolean bl = this.getSloshLeafs();
        this.setSloshLeafs(true);
        Vector vector = this.getExternalData(SloshBucketAbstractTree.convertToVector(this.getLeafsPathsAtPath(new TreePath(this.treeModel.getRoot()))));
        this.setSloshLeafs(bl);
        return vector;
    }

    public Vector removeSelectedItems() {
        this.getTree().removeTreeSelectionListener(this);
        TreePath[] treePathArray = this.getTree().getSelectionPaths();
        Object[] objectArray = null != treePathArray ? this.getRemovedUniqueLeafsAtPaths(treePathArray) : new TreePath[]{};
        this.getTree().addTreeSelectionListener(this);
        return this.getInternalData(SloshBucketAbstractTree.convertToVector(objectArray));
    }

    public Vector removeAllItems() {
        this.getTree().removeTreeSelectionListener(this);
        Object[] objectArray = this.getRemovedLeafsPathsAtPath(new TreePath(this.treeModel.getRoot()));
        this.getTree().addTreeSelectionListener(this);
        return this.getInternalData(SloshBucketAbstractTree.convertToVector(objectArray));
    }

    public void addItems(Vector vector, boolean bl) {
        this.addObjects(this.getFromInternalData(vector), bl, false);
    }

    public Vector getRemovedItems() {
        return this.getExternalData(this.removedItems);
    }

    public Vector getAddedItems() {
        return this.getExternalData(this.addedItems);
    }

    public Vector removeItems(Vector vector) {
        return this.getInternalData(this.removeObjects(this.getFromInternalData(vector)));
    }

    public void setKeepParentsLevel(int n2) {
        this.keepParentsLevel = n2;
    }

    public void loadItems(Vector vector) {
        this.addObjects(this.getFromExternalData(vector), true, true);
    }

    public Vector unloadItems(Vector vector) {
        return this.getExternalData(this.removeObjects(this.getFromExternalData(vector)));
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n2 = 0;
        while (n2 < objectArray.length) {
            vector.addElement(objectArray[n2]);
            ++n2;
        }
        return vector;
    }

    public void updateButtonsState() {
        this.notifyListeners();
    }

    protected boolean hasObjectsAtPath(TreePath treePath) {
        return this.hasObjectsAtPath(treePath, false);
    }

    protected boolean hasObjectsAtPath(TreePath treePath, boolean bl) {
        boolean bl2 = false;
        Object object = treePath.getLastPathComponent();
        if (this.isLeaf(object)) {
            bl2 = bl ? null == this.moveableInterface || null != this.moveableInterface && this.moveableInterface.isMoveable(this.getExternalData(treePath)) : true;
        } else if (this.isPopulated(object)) {
            int n2 = this.treeModel.getChildCount(object);
            TreePath[] treePathArray = new TreePath[n2];
            int n3 = 0;
            while (n3 < n2) {
                treePathArray[n3] = treePath.pathByAddingChild(this.getChildAt(object, n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < treePathArray.length) {
                if (this.hasObjectsAtPath(treePathArray[n4], bl)) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    protected TreePath[] getLeafsPathsAtPath(TreePath treePath) {
        Vector<TreePath> vector = new Vector<TreePath>();
        Object object = treePath.getLastPathComponent();
        if (this.isLeaf(object)) {
            vector.addElement(treePath);
        } else if (this.sloshLeafs || this.isPopulated(object)) {
            int n2 = this.treeModel.getChildCount(object);
            int n3 = 0;
            while (n3 < n2) {
                TreePath[] treePathArray = this.getLeafsPathsAtPath(treePath.pathByAddingChild(this.getChildAt(object, n3)));
                int n4 = 0;
                while (n4 < treePathArray.length) {
                    vector.addElement(treePathArray[n4]);
                    ++n4;
                }
                ++n3;
            }
        } else {
            vector.addElement(treePath);
        }
        Object[] objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected TreePath[] getUniqueLeafsPathsAtPaths(TreePath[] treePathArray) {
        Vector<TreePath> vector = new Vector<TreePath>();
        if (null != treePathArray) {
            int n2 = 0;
            while (n2 < treePathArray.length) {
                TreePath[] treePathArray2 = this.getLeafsPathsAtPath(treePathArray[n2]);
                int n3 = 0;
                while (n3 < treePathArray2.length) {
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        if (this.areTheSameObjects((TreePath)vector.elementAt(n4), treePathArray2[n3])) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        vector.addElement(treePathArray2[n3]);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        Object[] objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected TreePath[] getRemovedLeafsPathsAtPath(TreePath treePath) {
        TreePath treePath2;
        Object object;
        Vector<TreePath> vector = new Vector<TreePath>();
        Object object2 = treePath.getLastPathComponent();
        if (this.sloshLeafs || this.isPopulated(object2)) {
            int n2 = this.treeModel.getChildCount(object2);
            TreePath[] treePathArray = new TreePath[n2];
            int n3 = 0;
            while (n3 < n2) {
                treePathArray[n3] = treePath.pathByAddingChild(this.getChildAt(object2, n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                object = this.getRemovedLeafsPathsAtPath(treePathArray[n4]);
                int n5 = 0;
                while (n5 < ((TreePath[])object).length) {
                    vector.addElement(object[n5]);
                    ++n5;
                }
                ++n4;
            }
        }
        if (object2 != this.treeModel.getRoot() && this.treeModel.getIndexOfChild((treePath2 = treePath.getParentPath()).getLastPathComponent(), object2) >= 0 && (null == this.moveableInterface || null != this.moveableInterface && this.moveableInterface.isMoveable(this.getExternalData(treePath2.pathByAddingChild(object2))))) {
            if (treePath.getPathCount() > this.keepParentsLevel + 1) {
                this.removeObject(treePath2.pathByAddingChild(object2));
                object = this.findInVector(treePath, this.addedItems);
                if (null != object) {
                    this.addedItems.removeElement(treePath);
                } else if (null == this.findInVector(treePath, this.removedItems) && this.isLeaf(treePath.getLastPathComponent())) {
                    this.removedItems.addElement(treePath);
                }
            }
            if (this.isLeaf(object2)) {
                vector.addElement(treePath);
            } else if (!this.sloshLeafs && !this.isPopulated(object2)) {
                vector.addElement(treePath);
            }
            this.removeChildlessNode(treePath2);
        }
        Object[] objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected TreePath[] getRemovedUniqueLeafsAtPaths(TreePath[] treePathArray) {
        Vector<TreePath> vector = new Vector<TreePath>();
        int n2 = 0;
        while (n2 < treePathArray.length) {
            TreePath[] treePathArray2 = this.getRemovedLeafsPathsAtPath(treePathArray[n2]);
            int n3 = 0;
            while (n3 < treePathArray2.length) {
                boolean bl = false;
                int n4 = 0;
                while (n4 < vector.size()) {
                    if (this.areTheSameObjects((TreePath)vector.elementAt(n4), treePathArray2[n3])) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    vector.addElement(treePathArray2[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        Object[] objectArray = new TreePath[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void removeChildlessNode(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (this.treeModel.getRoot() != object && 0 == this.treeModel.getChildCount(object) && (null == this.moveableInterface || null != this.moveableInterface && this.moveableInterface.isMoveable(this.getExternalData(treePath))) && treePath.getPathCount() > this.keepParentsLevel + 1) {
            TreePath treePath2 = treePath.getParentPath();
            this.removeObject(treePath);
            Object object2 = this.findInVector(treePath, this.addedItems);
            if (null != object2) {
                this.addedItems.removeElement(treePath);
            } else if (null == this.findInVector(treePath, this.removedItems) && this.isLeaf(treePath.getLastPathComponent())) {
                this.removedItems.addElement(treePath);
            }
            this.removeChildlessNode(treePath2);
        }
    }

    protected void addObjects(Vector vector, boolean bl, boolean bl2) {
        TreePath[] treePathArray = new TreePath[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            treePathArray[n2] = (TreePath)vector.elementAt(n2);
            ++n2;
        }
        TreePath[] treePathArray2 = new TreePath[treePathArray.length];
        int n3 = 0;
        while (n3 < treePathArray.length) {
            TreePath treePath = new TreePath(this.treeModel.getRoot());
            int n4 = 1;
            while (n4 < treePathArray[n3].getPathCount()) {
                TreePath treePath2;
                TreePath treePath3;
                Object object = treePath.getLastPathComponent();
                Object object2 = treePathArray[n3].getPathComponent(n4);
                Object object3 = this.findNewChild(treePath, treePath.pathByAddingChild(object2));
                if (null == object3) {
                    treePath3 = null;
                    if (this.rememberOrder) {
                        treePath3 = (TreePath)this.getFirstPreviousFromRemoved(treePath.pathByAddingChild(object2));
                    }
                    treePath2 = null;
                    if (null != treePath3) {
                        Object object4 = treePath3.getLastPathComponent();
                        if (this.areTheSameObjects(treePath3, treePath.pathByAddingChild(object2))) {
                            treePath2 = this.insertObject(treePath, object2, 0, treePathArray[n3]);
                        } else {
                            Object object5 = this.findNewChild(treePath, treePath.pathByAddingChild(object4));
                            if (null != object5) {
                                int n5 = this.treeModel.getIndexOfChild(object, object5);
                                treePath2 = this.treeModel.getChildCount(object) <= n5 + 1 ? this.insertObject(treePath, object2, -1, treePathArray[n3]) : this.insertObject(treePath, object2, n5 + 1, treePathArray[n3]);
                            } else {
                                treePath2 = this.insertObject(treePath, object2, 0, treePathArray[n3]);
                            }
                        }
                    } else {
                        treePath2 = this.insertObject(treePath, object2, -1, treePathArray[n3]);
                    }
                    object3 = treePath2.getLastPathComponent();
                }
                if (null != (treePath3 = (TreePath)this.findInVector(treePath.pathByAddingChild(object3), this.removedItems))) {
                    this.removedItems.removeElement(treePath3);
                } else if (!bl2 && null == this.findInVector(treePath.pathByAddingChild(object3), this.addedItems) && this.isLeaf(treePath.pathByAddingChild(object3).getLastPathComponent())) {
                    this.addedItems.addElement(treePath.pathByAddingChild(object3));
                }
                if (this.rememberOrder) {
                    this.removeFromHash(this.previousPeers, treePath.pathByAddingChild(object3));
                    this.removeFromHash(this.nextPeers, treePath.pathByAddingChild(object3));
                }
                treePath = treePath2 = treePath.pathByAddingChild(object3);
                ++n4;
            }
            treePathArray2[n3] = treePath;
            ++n3;
        }
        this.getTree().setSelectionPaths(treePathArray2);
    }

    public Vector removeObjects(Vector vector) {
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (null == this.findInVector(vector.elementAt(n2), this.removedItems)) {
                if (this.isLeaf(((TreePath)vector.elementAt(n2)).getLastPathComponent())) {
                    this.removedItems.addElement(vector.elementAt(n2));
                }
                vector2.addElement(vector.elementAt(n2));
            }
            ++n2;
        }
        return vector2;
    }

    protected void removeObject(Object object) {
        if (this.rememberOrder) {
            Object object2 = this.getKeyFromElement(this.nextPeers, object);
            Object object3 = this.getKeyFromElement(this.previousPeers, object);
            if (null == object2) {
                object2 = this.getPreviousInCurrentTree((TreePath)object);
            }
            if (null == object3) {
                object3 = this.getNextInCurrentTree((TreePath)object);
            }
            this.previousPeers.put(object, object2 != null ? object2 : object);
            this.nextPeers.put(object, object3 != null ? object3 : object);
        }
        this.removeChild((TreePath)object);
    }

    protected void deselectChildNodes(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (this.isPopulated(object)) {
            int n2 = this.treeModel.getChildCount(object);
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = this.getChildAt(object, n3);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                this.deselectChildNodes(treePath2);
                if (this.getTree().isPathSelected(treePath2)) {
                    this.getTree().removeTreeSelectionListener(this);
                    this.getTree().removeSelectionPath(treePath2);
                    this.getTree().addTreeSelectionListener(this);
                }
                ++n3;
            }
        }
    }

    protected Object findNewChild(TreePath treePath, TreePath treePath2) {
        Object object = null;
        int n2 = 0;
        while (n2 < this.treeModel.getChildCount(treePath.getLastPathComponent())) {
            Object object2 = this.getChildAt(treePath.getLastPathComponent(), n2);
            if (this.areTheSameObjects(treePath2, treePath.pathByAddingChild(object2))) {
                object = object2;
                break;
            }
            ++n2;
        }
        return object;
    }

    protected Object getPreviousInCurrentTree(TreePath treePath) {
        Object object;
        Object object2 = treePath.getParentPath().getLastPathComponent();
        int n2 = this.treeModel.getIndexOfChild(object2, object = treePath.getLastPathComponent());
        if (n2 - 1 >= 0) {
            return treePath.getParentPath().pathByAddingChild(this.treeModel.getChild(object2, n2 - 1));
        }
        return null;
    }

    protected Object getNextInCurrentTree(TreePath treePath) {
        Object object;
        Object object2 = treePath.getParentPath().getLastPathComponent();
        int n2 = this.treeModel.getIndexOfChild(object2, object = treePath.getLastPathComponent());
        if (n2 + 1 < this.treeModel.getChildCount(object2)) {
            return treePath.getParentPath().pathByAddingChild(this.treeModel.getChild(object2, n2 + 1));
        }
        return null;
    }

    public void moveUpSelected(int n2) {
    }

    protected abstract TreePath insertObject(TreePath var1, Object var2, int var3, TreePath var4);

    protected abstract void removeChild(TreePath var1);

    protected abstract Object getChildAt(Object var1, int var2);

    protected abstract Object getParent(Object var1);

    protected abstract boolean isLeaf(Object var1);

    protected abstract boolean isPopulated(Object var1);
}

