/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.SloshBucketAbstractPanel;
import com.ibm.db2.tools.common.SloshBucketButtonsPanel;
import com.ibm.db2.tools.common.SloshBucketItemsVectorPanel;
import com.ibm.db2.tools.common.SloshBucketOrderInterface;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SloshBucketAbstractTable
extends SloshBucketAbstractPanel
implements ListSelectionListener,
SloshBucketItemsVectorPanel {
    public SloshBucketAbstractTable(String string, Component component, int n2) {
        this(string, component, n2, null);
    }

    public SloshBucketAbstractTable(String string, Component component, JPanel jPanel, int n2) {
        this(string, component, jPanel, n2, null);
    }

    public SloshBucketAbstractTable(String string, Component component, int n2, SloshBucketOrderInterface sloshBucketOrderInterface) {
        this(string, component, null, n2, sloshBucketOrderInterface);
    }

    protected SloshBucketAbstractTable(String string, Component component, JPanel jPanel, int n2, SloshBucketOrderInterface sloshBucketOrderInterface) {
        super(string, component, jPanel, n2, sloshBucketOrderInterface);
        this.updateSortButtons();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.component.isEnabled() && mouseEvent.getClickCount() == 2 && !mouseEvent.isPopupTrigger()) {
            int n2 = 0;
            while (n2 < this.listenersVector.size()) {
                if (this.listenersVector.elementAt(n2) instanceof SloshBucketButtonsPanel) {
                    ((SloshBucketButtonsPanel)this.listenersVector.elementAt(n2)).moveSelected(this);
                    break;
                }
                ++n2;
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.notifyListeners();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateSortButtons();
    }

    public void notifyListeners() {
        super.notifyListeners();
        this.updateSortButtons();
    }

    public boolean hasSelectedItems() {
        Vector vector = this.getSelectedObjects();
        boolean bl = false;
        if (vector.size() > 0) {
            bl = true;
            if (null != this.moveableInterface) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (!this.moveableInterface.isMoveable(this.getExternalData(vector.elementAt(n2)))) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public boolean hasItems() {
        Vector vector = this.getAllObjects();
        boolean bl = false;
        if (vector.size() > 0) {
            bl = true;
            if (null != this.moveableInterface) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (!this.moveableInterface.isMoveable(this.getExternalData(vector.elementAt(n2)))) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public void clear() {
        this.removeAllItems();
        super.clear();
    }

    public Vector getSelectedItems() {
        return this.getExternalData(this.getSelectedObjects());
    }

    public Vector getAllItems() {
        return this.getExternalData(this.getAllObjects());
    }

    public Vector removeSelectedItems() {
        Vector vector = this.getSelectedObjects();
        Vector vector2 = new Vector();
        int[] nArray = this.getTrueSelectedIndexes();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (null == this.moveableInterface || this.moveableInterface.isMoveable(this.getExternalData(e2))) {
                vector2.addElement(e2);
                this.removeObject(e2);
            }
            ++n2;
        }
        int n3 = this.getAllObjects().size();
        int n4 = -1;
        if (nArray.length > 0) {
            int n5 = n4 = n3 > nArray[0] ? nArray[0] : n3 - 1;
        }
        if (n4 > -1) {
            this.addSelectionInterval(n4, n4);
        } else {
            this.clearSelection();
        }
        return this.getInternalData(vector2);
    }

    public Vector removeAllItems() {
        Vector vector = this.getAllObjects();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (null == this.moveableInterface || this.moveableInterface.isMoveable(this.getExternalData(e2))) {
                vector2.addElement(e2);
                this.removeObject(e2);
            }
            ++n2;
        }
        this.clearSelection();
        return this.getInternalData(vector2);
    }

    public void addItems(Vector vector, boolean bl) {
        this.addRows(this.getFromInternalData(vector), bl, false);
    }

    public Vector getRemovedItems() {
        return this.removedItems;
    }

    public Vector getAddedItems() {
        return this.addedItems;
    }

    public Vector removeItems(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (this.removeObject(vector.elementAt(n2))) {
                vector2.addElement(this.getInternalData(vector.elementAt(n2)));
            }
            ++n2;
        }
        return vector2;
    }

    public void loadItems(Vector vector) {
        this.addRows(this.getFromExternalData(vector), true, true);
    }

    public Component getContainer() {
        return this.component;
    }

    public Component getContainingPanel() {
        return this.toAddToPanelObject;
    }

    public void moveUpSelected(int n2) {
        int n3 = this.getTrueSelectedIndexes()[0];
        if (n2 < 0) {
            this.moveElementAtDown(n3);
        } else {
            this.moveElementAtUp(n3);
        }
        this.clearSelection();
        this.addSelectionInterval(n3 - n2, n3 - n2);
    }

    protected void updateSortButtons() {
        if (null != this.upButton && null != this.downButton) {
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray = this.getTrueSelectedIndexes();
            if (1 == nArray.length) {
                bl = 0 != nArray[0];
                bl2 = this.getAllObjects().size() - 1 != nArray[0];
            }
            this.upButton.setEnabled(bl && this.isEnabled());
            this.downButton.setEnabled(bl2 && this.isEnabled());
            if (null != this.orderInterface) {
                Vector vector = this.getSelectedItems();
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                if (1 == vector.size() && vector.elementAt(0) != null) {
                    bl3 = true;
                    if (this.orderInterface.getIsAscending(vector.elementAt(0))) {
                        bl4 = true;
                    } else {
                        bl5 = true;
                    }
                }
                this.ascendentRadioButton.setSelected(bl4);
                this.descendentRadioButton.setSelected(bl5);
                this.ascendentRadioButton.setEnabled(bl3 && this.isEnabled());
                this.descendentRadioButton.setEnabled(bl3 && this.isEnabled());
            }
        }
    }

    protected int[] getTrueSelectedIndexes() {
        Vector<Integer> vector = new Vector<Integer>();
        int[] nArray = this.getSelectedIndices();
        int n2 = this.getAllObjects().size();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < n2) {
                vector.addElement(new Integer(nArray[n3]));
            }
            ++n3;
        }
        int[] nArray2 = new int[vector.size()];
        int n4 = 0;
        while (n4 < vector.size()) {
            nArray2[n4] = (Integer)vector.elementAt(n4);
            ++n4;
        }
        return nArray2;
    }

    protected void addRows(Vector vector, boolean bl, boolean bl2) {
        Object object = null;
        this.clearSelection();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            Object object2 = null;
            Vector vector2 = this.getAllObjects();
            Object object3 = null;
            if (this.rememberOrder) {
                object3 = this.getFirstPreviousFromRemoved(vector.elementAt(n2));
            }
            if (null != object3) {
                if (this.areTheSameTableObjects(object3, e2)) {
                    this.insertRow(e2, 0);
                    if (!bl) {
                        this.addSelectionInterval(0, 0);
                    }
                } else {
                    Object object4 = this.findNewChild(object3);
                    if (null != object4) {
                        int n3 = this.getObjectIndex(object4);
                        if (vector2.size() <= n3 + 1) {
                            this.addRow(e2);
                            if (!bl) {
                                this.addSelectionInterval(vector2.size(), vector2.size());
                            }
                        } else {
                            this.insertRow(e2, n3 + 1);
                            if (!bl) {
                                this.addSelectionInterval(n3 + 1, n3 + 1);
                            }
                        }
                    } else {
                        this.insertRow(e2, 0);
                        if (!bl) {
                            this.addSelectionInterval(0, 0);
                        }
                    }
                }
            } else {
                this.addRow(vector.elementAt(n2));
                if (!bl) {
                    this.addSelectionInterval(vector2.size(), vector2.size());
                }
            }
            object2 = this.findNewChild(vector.elementAt(n2));
            if (this.rememberOrder) {
                this.removeFromHash(this.previousPeers, object2);
                this.removeFromHash(this.nextPeers, object2);
            }
            if (null != (object = this.findInVector(vector.elementAt(n2), this.removedItems))) {
                this.removedItems.removeElement(object);
            } else if (!bl2 && null == this.findInVector(vector.elementAt(n2), this.addedItems)) {
                this.addedItems.addElement(vector.elementAt(n2));
            }
            ++n2;
        }
    }

    protected boolean removeObject(Object object) {
        boolean bl;
        Object object2;
        if (this.rememberOrder) {
            Object object3 = this.getKeyFromElement(this.nextPeers, object);
            object2 = this.getKeyFromElement(this.previousPeers, object);
            if (null == object3) {
                object3 = this.getPreviousInTable(object);
            }
            if (null == object2) {
                object2 = this.getNextInTable(object);
            }
            this.previousPeers.put(object, object3 != null ? object3 : object);
            this.nextPeers.put(object, object2 != null ? object2 : object);
        }
        if (bl = this.removeRow(object)) {
            object2 = this.findInVector(object, this.addedItems);
            if (null != object2) {
                this.addedItems.removeElement(object2);
            } else if (null == this.findInVector(object, this.removedItems)) {
                this.removedItems.addElement(object);
            }
        }
        return bl;
    }

    protected Object getPreviousInTable(Object object) {
        Vector vector = this.getAllObjects();
        int n2 = this.getObjectIndex(object);
        if (n2 >= 1) {
            return vector.elementAt(n2 - 1);
        }
        return null;
    }

    protected Object getNextInTable(Object object) {
        Vector vector = this.getAllObjects();
        int n2 = this.getObjectIndex(object);
        if (n2 >= 0 && n2 + 1 < vector.size()) {
            return vector.elementAt(n2 + 1);
        }
        return null;
    }

    protected Object findNewChild(Object object) {
        Object var2_2 = null;
        Vector vector = this.getAllObjects();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (this.areTheSameTableObjects(object, e2)) {
                var2_2 = e2;
                break;
            }
            ++n2;
        }
        return var2_2;
    }

    protected int getObjectIndex(Object object) {
        Vector vector = this.getAllObjects();
        int n2 = -1;
        int n3 = 0;
        while (n3 < vector.size()) {
            if (this.areTheSameTableObjects(object, vector.elementAt(n3))) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    protected boolean areTheSameObjects(Object object, Object object2) {
        return this.areTheSameTableObjects(object, object2);
    }

    protected abstract void addRow(Object var1);

    protected abstract void insertRow(Object var1, int var2);

    protected abstract boolean removeRow(Object var1);

    protected abstract void addSelectionInterval(int var1, int var2);

    protected abstract int[] getSelectedIndices();

    protected abstract void clearSelection();

    protected abstract Vector getSelectedObjects();

    protected abstract Vector getAllObjects();

    protected abstract void moveElementAtDown(int var1);

    protected abstract void moveElementAtUp(int var1);

    protected abstract boolean areTheSameTableObjects(Object var1, Object var2);
}

