/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonFrame;
import com.ibm.db2.tools.common.CommonMessage;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.TurningGears;
import com.ibm.db2.tools.common.smartguide.SmartGuide;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class ProgressWindow
extends CommonDialog
implements ActionListener,
Serializable,
ResultProcessor {
    protected boolean toShowTerminateButton = false;
    protected long elapsedTime;
    protected long startTime;
    protected boolean executeFlag;
    protected boolean hideDialog = true;
    protected boolean actionPerformedOnce = false;
    protected String title;
    protected Window makeActiveOnClose = null;
    protected JLabel lblElapsedTimeDesc;
    protected JLabel lblElapsedTime;
    protected TurningGears gears;
    protected JButton closeButton;
    protected JButton terminateButton;
    protected final int MAX_MSG_LENGTH = 300;
    public static final int MIN_TIME_BEFORE_DISPLAY = 2000;
    protected static final int FRAMES_PER_SECOND = 10;
    protected int delay;
    protected int timeBetweenFrames = 100;
    protected Timer timer;
    protected JLabel titlePanel;
    protected Vector titleMessages;
    protected CommonMessage terminationWarning;

    public ProgressWindow(CommonDialog commonDialog, boolean bl, int n2) {
        this(commonDialog, commonDialog.getTitle(), true, n2, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = bl;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog, String string) {
        this(commonDialog, string, true, 2000, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = true;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog, String string, boolean bl) {
        this(commonDialog, string, true, 2000, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = bl;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog) {
        this(commonDialog, commonDialog.getTitle(), true, 2000, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = true;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog, boolean bl) {
        this(commonDialog, commonDialog.getTitle(), true, 2000, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = bl;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog, int n2) {
        this(commonDialog, commonDialog.getTitle(), true, n2, false);
        super.setParentDialog(commonDialog);
        this.hideDialog = true;
        CommonDialog.moveRelative(this, commonDialog, true, 1, 1, true);
    }

    public ProgressWindow(CommonDialog commonDialog, String string, int n2) {
        this(commonDialog, string, true, n2, false);
        super.setParentDialog(commonDialog);
    }

    public ProgressWindow(CommonDialog commonDialog, String string, boolean bl, int n2) {
        this(commonDialog, string, bl, n2, false);
        super.setParentDialog(commonDialog);
    }

    public ProgressWindow(CommonDialog commonDialog, String string, boolean bl, int n2, boolean bl2) {
        super(commonDialog, CmStringPool.get(96), bl, 0L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "ProgressWindow(CommonDialog dialog, String title, boolean modal, int delay, boolean showTerminateButton)", new Object[]{commonDialog, string, new Boolean(bl), new Integer(n2), new Boolean(bl2)});
        }
        super.setParentDialog(commonDialog);
        this.setBusyCursor(false);
        this.toShowTerminateButton = bl2;
        this.delay = n2 > 2000 ? n2 : 2000;
        this.title = string;
        this.initialize();
        CommonTrace.exit(commonTrace);
    }

    public ProgressWindow(SmartGuide smartGuide, String string, int n2) {
        this((JFrame)smartGuide.getParentFrame(), string, true, n2, false);
        super.setParentSmartGuide(smartGuide);
        CommonDialog.moveRelative(this, smartGuide, true, 1, 1, true);
    }

    public ProgressWindow(SmartGuide smartGuide, String string, boolean bl, int n2) {
        this((JFrame)smartGuide.getParentFrame(), string, bl, n2, false);
        super.setParentSmartGuide(smartGuide);
        CommonDialog.moveRelative(this, smartGuide, true, 1, 1, true);
    }

    public ProgressWindow(JFrame jFrame, String string) {
        this(jFrame, string, false, 2000, false);
    }

    public ProgressWindow(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, false, 2000, bl);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, String string, int n2, boolean bl) {
        this(jFrame, string, false, n2, false);
        this.hideDialog = bl;
    }

    public ProgressWindow(JFrame jFrame) {
        this(jFrame, jFrame.getTitle(), false, 2000, false);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, int n2) {
        this(jFrame, jFrame.getTitle(), false, n2, false);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, String string, int n2) {
        this(jFrame, string, true, n2, false);
        this.hideDialog = false;
    }

    public ProgressWindow(boolean bl, JFrame jFrame, String string, int n2) {
        this(jFrame, string, false, n2, bl);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, String string, boolean bl, int n2) {
        this(jFrame, string, bl, n2, false);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, String string, boolean bl, int n2, boolean bl2) {
        this(jFrame, string, bl, n2, bl2, false);
        this.hideDialog = false;
    }

    public ProgressWindow(JFrame jFrame, String string, boolean bl, int n2, boolean bl2, boolean bl3) {
        super(jFrame, CmStringPool.get(96), bl, 0L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "ProgressWindow(JFrame parent, String title, boolean modal, int delay, boolean showTerminateButton)", new Object[]{jFrame, string, new Boolean(bl), new Integer(n2), new Boolean(bl2)});
        }
        this.setBusyCursor(false);
        this.toShowTerminateButton = bl2;
        this.delay = bl3 ? n2 : (n2 > 2000 ? n2 : 2000);
        this.title = string;
        this.initialize();
        CommonTrace.exit(commonTrace);
    }

    private void initialize() {
        this.startTime = new Date().getTime();
        this.setResizable(false);
        this.makeLayout();
        this.executeFlag = true;
        this.timer = new Timer(this.timeBetweenFrames, this);
        this.timer.setInitialDelay(this.delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void setProgressMessages(Vector vector) {
        this.titleMessages = vector;
        FontMetrics fontMetrics = ((Component)this.titlePanel).getFontMetrics(this.getFont());
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            int n4 = fontMetrics.stringWidth((String)vector.elementAt(n3));
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (n2 > 300) {
            n2 = 300;
        }
        Dimension dimension = this.titlePanel.getPreferredSize();
        this.titlePanel.setPreferredSize(new Dimension(n2, dimension.height));
    }

    public void setProgressMessage(int n2) {
        if (this.titleMessages != null) {
            this.titlePanel.setText((String)this.titleMessages.elementAt(n2));
        }
    }

    protected void makeLayout() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.closeButton = new JButton(CmStringPool.get(25));
        this.lblElapsedTimeDesc = new JLabel(CmStringPool.get(95), 2);
        this.lblElapsedTime = new JLabel(this.getStringValue(this.elapsedTime), 2);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        if (this.toShowTerminateButton) {
            this.terminateButton = new JButton(CmStringPool.get(47));
            this.terminateButton.setMnemonic(CmStringPool.getMnemonic(47));
            this.terminateButton.addActionListener(this);
            jPanel2.add(this.terminateButton);
        }
        this.setDefaultFocusComponent(this.closeButton);
        this.gears = new TurningGears();
        this.titlePanel = new JLabel(this.title);
        jPanel.add("North", this.titlePanel);
        jPanel.add("Center", this.makeCenterGridPanel(this.getPanel()));
        jPanel.add("South", jPanel2);
        jPanel.add("East", this.gears);
        this.setClient(jPanel);
        this.addWindowListener(this);
    }

    private Container makeParentTitlePanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add("West", new JLabel(this.title));
        return container;
    }

    protected Container makeCenterGridPanel(Container container) {
        if (container instanceof JPanel) {
            ((JPanel)container).setBorder(new EmptyBorder(0, 0, 0, 10));
        }
        container.setLayout(new GridLayout(2, 1, 0, 0));
        container.add(this.makeElapsedTimeLabelPanel(this.getPanel()));
        container.add(this.makeElapsedTimePanel(this.getPanel()));
        return container;
    }

    private Container makeElapsedTimeLabelPanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add("South", this.lblElapsedTimeDesc);
        return container;
    }

    private Container makeElapsedTimePanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add("North", this.lblElapsedTime);
        return container;
    }

    public void processResult(Object object, Object object2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "processResult(Object handler, Object returnValue)", new Object[]{object, object2});
        }
        if (object2.equals("Yes")) {
            Graphics graphics;
            this.terminationWarning.dispose();
            super.setVisible(true);
            if (!super.isModal() && (graphics = super.getGraphics()) != null) {
                super.paintComponents(graphics);
            }
        } else if (object2.equals("No")) {
            if (this.terminationWarning != null) {
                Graphics graphics;
                this.terminationWarning.dispose();
                super.setVisible(true);
                if (!super.isModal() && (graphics = super.getGraphics()) != null) {
                    super.paintComponents(graphics);
                }
            }
            this.setFocusTransferToParent(true);
        }
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "actionPerformed(ActionEvent e)", new Object[]{actionEvent});
        }
        if (actionEvent.getSource() == this.terminateButton) {
            this.terminationWarning = new CommonMessage(this, CmStringPool.get(5), CmStringPool.get(200), 1, "", "", 16, (ResultProcessor)this, false);
            super.setVisible(false);
        } else if (actionEvent.getSource() == this.closeButton) {
            super.setVisible(false);
            this.executeFlag = false;
            this.timer.stop();
        }
        if (this.executeFlag) {
            this.elapsedTime = new Date().getTime() - this.startTime;
            this.lblElapsedTime.setText(this.getStringValue(this.elapsedTime));
            if (this.actionPerformedOnce) {
                this.gears.advance();
                ((Container)this).paint(((Component)this).getGraphics());
            } else {
                Graphics graphics;
                if (this.hideDialog && super.getParentDialog() != null) {
                    super.getParentDialog().setVisible(false);
                }
                this.actionPerformedOnce = true;
                super.setVisible(true);
                if (!super.isModal() && (graphics = super.getGraphics()) != null) {
                    super.paintComponents(graphics);
                }
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public String getStringValue(long l2) {
        String string = ":";
        int n2 = (int)(l2 / 1000L);
        int n3 = n2 % 3600 % 60;
        int n4 = n2 % 3600 / 60;
        int n5 = n2 / 3600;
        return new String(ProgressWindow.fixWidth(n5) + string + ProgressWindow.fixWidth(n4) + string + ProgressWindow.fixWidth(n3));
    }

    private static String fixWidth(int n2) {
        if (n2 == 0) {
            return "00";
        }
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (this.timer != null) {
            this.timer.setInitialDelay(0);
            this.timer.setRepeats(true);
            this.timer.restart();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "windowClosing(WindowEvent e)", new Object[]{windowEvent});
        }
        super.windowClosing(windowEvent);
        this.executeFlag = false;
        this.pressClose();
        CommonTrace.exit(commonTrace);
    }

    public void pressClose() {
        this.executeFlag = false;
        this.shutdown();
    }

    public void stop() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "stop()");
        }
        this.executeFlag = false;
        this.dispatchEvent(new WindowEvent(this, 201));
        CommonTrace.exit(commonTrace);
    }

    public void shutdown() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "ProgressWindow", this, "shutdown()");
        }
        Component component = this.getFocusOwner();
        super.setVisible(false);
        this.executeFlag = false;
        if (this.timer != null) {
            this.timer.stop();
        }
        if (super.getParentDialog() != null) {
            super.getParentDialog().progressWindowStop();
            if (this.hideDialog) {
                super.getParentDialog().setVisible(true);
            }
        } else if (super.getParentFrame() instanceof CommonFrame) {
            ((CommonFrame)super.getParentFrame()).progressWindowStop();
        }
        if (this.makeActiveOnClose != null && component != null && this.makeActiveOnClose.isShowing()) {
            this.makeActiveOnClose.toFront();
            this.makeActiveOnClose = null;
        }
        this.dispose();
        if (null != this.terminationWarning) {
            this.terminationWarning.dispose();
            this.terminationWarning = null;
        }
        this.gears = null;
        this.timer = null;
        super.setParentDialog(null);
        super.setParentSmartGuide(null);
        CommonTrace.exit(commonTrace);
    }

    public void suspend() {
        super.setVisible(false);
        this.executeFlag = false;
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void resume() {
        this.startTime = new Date().getTime();
        this.elapsedTime = new Date().getTime() - this.startTime;
        this.actionPerformedOnce = false;
        this.executeFlag = true;
        if (this.timer != null) {
            this.timer.restart();
        }
    }

    public boolean suspended() {
        return !this.timer.isRunning();
    }

    public void setBringToFrontOnClose(Window window) {
        this.makeActiveOnClose = window;
    }
}

