/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.Pane;
import com.ibm.db2.tools.common.plaf.PaneTitleBarUI;
import java.awt.AWTEventMulticaster;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;

public class PaneTitleBar
extends JLayeredPane {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Pane pane;
    protected boolean animation = false;
    protected boolean linkButtonVisible = true;
    protected boolean titleButtonVisible = true;
    protected boolean viewButtonVisible = true;
    protected boolean maxButtonVisible = true;
    protected boolean minButtonVisible = true;
    protected boolean minButtonVertical = false;
    protected boolean maxButtonActive = false;
    protected boolean minButtonActive = false;
    protected boolean narrow = false;
    protected String title;
    protected String viewName;
    protected String linkButtonToolTipText;
    protected Icon titleIcon;
    protected Icon viewIcon;
    protected static Font defaultTextFont = new Font("Helvetica", 1, 11);
    protected Font textFont;
    protected ActionListener listeners;
    protected MouseListener mlisteners;
    protected MouseMotionListener mmlisteners;
    public static final String LINK_COMMAND = "LinkButton";
    public static final String TITLE_COMMAND = "TitleButton";
    public static final String VIEW_COMMAND = "ViewButton";
    public static final String MINIMIZE_COMMAND = "MinimizeButton";
    public static final String MAXIMIZE_COMMAND = "MaximizeButton";
    public static final String TITLE_DOUBLE_CLICK_COMMAND = "TitleDoubleClick";
    boolean linkState = false;
    protected boolean redirect = false;

    public PaneTitleBar(Pane pane) {
        this.pane = pane;
        this.setDoubleBuffered(true);
        this.updateUI();
    }

    public Pane getPane() {
        return this.pane;
    }

    public void setTitleAnimationEnabled(boolean bl) {
        this.animation = bl;
    }

    public boolean isTitleAnimationEnabled() {
        return this.animation;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateTitle(this);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleIcon(Icon icon) {
        this.titleIcon = icon;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateTitle(this);
        }
    }

    public Icon getTitleIcon() {
        return this.titleIcon;
    }

    public void setViewName(String string) {
        this.viewName = string;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateView(this);
        }
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewIcon(Icon icon) {
        this.viewIcon = icon;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateView(this);
        }
    }

    public Icon getViewIcon() {
        return this.viewIcon;
    }

    public void setLinkButtonVisible(boolean bl) {
        this.linkButtonVisible = bl;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateLink(this);
        }
    }

    public void setLinkButtonToolTipText(String string) {
        this.linkButtonToolTipText = string;
    }

    public String getLinkButtonToolTipText() {
        return this.linkButtonToolTipText;
    }

    public boolean isLinkButtonVisible() {
        return this.linkButtonVisible;
    }

    public void setTitleButtonVisible(boolean bl) {
        this.titleButtonVisible = bl;
    }

    public boolean isTitleButtonVisible() {
        return this.titleButtonVisible;
    }

    public void setViewButtonVisible(boolean bl) {
        this.viewButtonVisible = bl;
    }

    public boolean isViewButtonVisible() {
        return this.viewButtonVisible;
    }

    public void setMaximizeButtonVisible(boolean bl) {
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateButtons(this);
        }
        this.maxButtonVisible = bl;
    }

    public boolean isMaximizeButtonVisible() {
        return this.maxButtonVisible;
    }

    public void setMinimizeButtonVisible(boolean bl) {
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateButtons(this);
        }
        this.minButtonVisible = bl;
    }

    public boolean isMinimizeButtonVisible() {
        return this.minButtonVisible;
    }

    public void setMinimizeButtonVertical(boolean bl) {
        this.minButtonVertical = bl;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateButtons(this);
        }
    }

    public boolean isMinimizeButtonVertical() {
        return this.minButtonVertical;
    }

    public void addComponent(JComponent jComponent, Object object) {
    }

    public void removeComponent(JComponent jComponent) {
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "PaneTitleBarUI";
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, actionListener);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this.listeners != null) {
            this.listeners.actionPerformed(actionEvent);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.mlisteners = AWTEventMulticaster.add(this.mlisteners, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.mlisteners = AWTEventMulticaster.remove(this.mlisteners, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.mmlisteners = AWTEventMulticaster.add(this.mmlisteners, mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.mmlisteners = AWTEventMulticaster.remove(this.mmlisteners, mouseMotionListener);
    }

    public void fireMouseEvent(MouseEvent mouseEvent) {
        if (this.mlisteners == null) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 500: {
                this.mlisteners.mouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this.mlisteners.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mlisteners.mouseExited(mouseEvent);
                break;
            }
            case 501: {
                this.mlisteners.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mlisteners.mouseReleased(mouseEvent);
            }
        }
    }

    public void fireMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mmlisteners == null) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 503: {
                this.mmlisteners.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mmlisteners.mouseDragged(mouseEvent);
            }
        }
    }

    public void setMaximizeButtonActive(boolean bl) {
        this.maxButtonActive = bl;
        ((PaneTitleBarUI)this.ui).updateButtons(this);
    }

    public boolean isMaximizeButtonActive() {
        return this.maxButtonActive;
    }

    public void setMinimizeButtonActive(boolean bl) {
        this.minButtonActive = bl;
        ((PaneTitleBarUI)this.ui).updateButtons(this);
    }

    public boolean isMinimizeButtonActive() {
        return this.minButtonActive;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setLinkState(boolean bl) {
        this.linkState = bl;
        if (this.ui != null) {
            ((PaneTitleBarUI)this.ui).updateLink(this);
        }
    }

    public boolean getLinkState() {
        return this.linkState;
    }

    public void updateState() {
        PaneTitleBarUI paneTitleBarUI = (PaneTitleBarUI)this.ui;
        paneTitleBarUI.updateButtons(this);
    }

    public void setNarrow(boolean bl) {
        this.narrow = bl;
    }

    public boolean isNarrow() {
        return this.narrow;
    }

    public void setMouseRemapEnabled(boolean bl) {
        this.redirect = bl;
    }

    public boolean isMouseRemapEnabled() {
        return this.redirect;
    }
}

