/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.ComponentSplitter;
import com.ibm.db2.tools.common.Pane;
import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.TiledComponent;
import com.ibm.db2.tools.common.TiledPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class PaneSplitter
extends ComponentSplitter
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PaneActionMonitor amon = new PaneActionMonitor();

    public PaneSplitter() {
    }

    public PaneSplitter(TiledPane tiledPane) {
        this.setRoot(tiledPane);
    }

    public void setPaneTree(TiledPane tiledPane) {
        super.setRoot(tiledPane);
    }

    public TiledPane getPaneTree() {
        return (TiledPane)this.getRoot();
    }

    public Pane getSelectedPane() {
        return (Pane)this.getSelectedComponent();
    }

    protected void leafComponentAdded(TiledComponent tiledComponent) {
        if (!(tiledComponent instanceof TiledPane)) {
            return;
        }
        TiledPane tiledPane = (TiledPane)tiledComponent;
        Pane pane = tiledPane.getPane();
        PaneTitleBar paneTitleBar = pane.getTitleBar();
        if (paneTitleBar != null) {
            paneTitleBar.addActionListener(this.amon);
        }
    }

    protected void leafComponentRemoved(TiledComponent tiledComponent) {
        if (!(tiledComponent instanceof TiledPane)) {
            return;
        }
        TiledPane tiledPane = (TiledPane)tiledComponent;
        Pane pane = tiledPane.getPane();
        pane.getTitleBar().removeActionListener(this.amon);
    }

    class PaneActionMonitor
    implements ActionListener,
    Serializable {
        PaneActionMonitor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Pane pane = (Pane)actionEvent.getSource();
            TiledPane tiledPane = pane.getTiledPane();
            String string = actionEvent.getActionCommand();
            boolean bl = false;
            if (string.equals("MaximizeButton")) {
                if (tiledPane.getState() == 2) {
                    pane.setState(1);
                    PaneSplitter.this.setMaximizedComponent(null);
                    bl = true;
                } else if (tiledPane.getState() != 5) {
                    pane.setState(2);
                    PaneSplitter.this.setMaximizedComponent(tiledPane);
                    bl = true;
                }
            } else if (string.equals("MinimizeButton")) {
                if (tiledPane.getState() == 3) {
                    pane.setState(1);
                    bl = true;
                } else if (tiledPane.getState() != 5 && tiledPane.getState() != 2) {
                    pane.setState(3);
                    bl = true;
                }
            }
            if (bl) {
                PaneSplitter.this.invalidate();
                PaneSplitter.this.validate();
                PaneSplitter.this.repaint();
            }
        }
    }
}

