/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.PaneTitleBar;
import com.ibm.db2.tools.common.TiledPane;
import com.ibm.db2.tools.common.plaf.PaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class Pane
extends JComponent {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Component client;
    protected JComponent jclient;
    protected PaneTitleBar tbar;
    protected boolean titleVisible = true;
    protected boolean linkState = true;
    TiledPane tpane = null;

    public Pane() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.updateUI();
        this.tbar = new PaneTitleBar(this);
        this.add((Component)this.tbar, "North");
    }

    public void setClient(Component component) {
        if (this.client != null) {
            if (this.jclient != null) {
                this.jclient.remove(component);
            } else {
                this.remove(this.client);
            }
        }
        if (component != null) {
            if (component instanceof JComponent) {
                this.jclient = null;
                this.add(component, "Center");
            } else {
                this.jclient = new JPanel();
                this.jclient.setLayout(new GridLayout(1, 1));
                this.jclient.add(component);
                this.add((Component)this.jclient, "Center");
            }
        }
        this.client = component;
        if (this.ui != null) {
            ((PaneUI)this.ui).clientAdded(this);
        }
    }

    public Component getClient() {
        return this.client;
    }

    public JComponent getJClient() {
        return this.jclient != null ? this.jclient : (JComponent)this.client;
    }

    public void updateUI() {
        this.setUI((PaneUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "PaneUI";
    }

    public void setTitleBarVisible(boolean bl) {
        if (this.titleVisible != bl) {
            if (!bl) {
                this.remove(this.tbar);
            } else {
                this.add((Component)this.tbar, "North");
            }
            this.invalidate();
            this.validate();
            this.titleVisible = bl;
        }
    }

    public boolean isTitleBarVisible() {
        return this.titleVisible;
    }

    public PaneTitleBar getTitleBar() {
        return this.tbar;
    }

    void setTiledPane(TiledPane tiledPane) {
        this.tpane = tiledPane;
    }

    public TiledPane getTiledPane() {
        return this.tpane;
    }

    public int getState() {
        return this.tpane != null ? this.tpane.getState() : 1;
    }

    public void setState(int n2) {
        boolean bl;
        boolean bl2 = n2 == 2;
        boolean bl3 = bl = n2 == 3;
        if (this.tbar != null) {
            this.tbar.setMaximizeButtonActive(bl2);
            this.tbar.setMinimizeButtonActive(bl);
        }
        boolean bl4 = false;
        if (this.tpane != null) {
            this.tpane.setState(n2);
            if (this.tbar != null) {
                if (n2 == 3 && this.tpane.getParent() != null && this.tpane.getParent().getType() == 2) {
                    bl4 = true;
                }
                this.tbar.setNarrow(bl4);
                this.tbar.setMinimizeButtonVisible(this.isMinimizeButtonAvailable() && n2 != 2 && n2 != 5);
                this.tbar.setMaximizeButtonVisible(n2 != 5);
                this.tbar.updateState();
            }
        }
    }

    protected boolean isMinimizeButtonAvailable() {
        return true;
    }

    public void setLinkState(boolean bl) {
        this.tbar.setLinkState(bl);
    }

    public boolean getLinkState() {
        return this.tbar.getLinkState();
    }

    public Dimension getMinimumSize() {
        int n2 = 0;
        int n3 = 0;
        if (this.tbar != null) {
            n2 = this.tbar.getMinimumSize().width;
            n3 = this.tbar.getPreferredSize().height;
        }
        return new Dimension(n2, n3);
    }

    public boolean handleTitlePopup(JPopupMenu jPopupMenu) {
        return false;
    }

    public boolean handleViewPopup(JPopupMenu jPopupMenu) {
        return false;
    }

    public void titleItemSelected(Object object, Object object2) {
    }

    public void viewItemSelected(Object object, Object object2) {
    }

    public boolean isSelected() {
        return false;
    }
}

