/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.NavLinkEvent;
import com.ibm.db2.tools.common.NavLinkListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class NavLinkLabel
extends JComponent
implements Serializable {
    private String text = "";
    private Vector linkSegments = new Vector();
    private int forcedWidth = 200;
    private transient BreakIterator breakIterator;
    protected EventListenerList evlistenerList = new EventListenerList();
    private static final Color defaultLinkColor = new Color(0, 0, 128);
    private Color linkColor = defaultLinkColor;
    public static final String NEWLINE = "\n";
    public static final String TAB = "\t";
    public static final String SPACE_TO_TRIM = " ";
    private static final String START_LINK_TAG = "<a ";
    private static final String END_TAG = ">";
    private static final String END_LINK_TAG = "</a>";
    private static final String HREF_EQUALS = "href=";
    private static final String TAB_STRING = "        ";
    protected static Font tfont;
    private Image dimage = null;
    private Image textImage = null;
    private Image logoImage = null;
    static Color bgColor;
    static Color textColor;
    Color bright1 = null;
    Color bright2 = null;
    Color bright3 = null;
    Color dark1 = null;
    Color dark2 = null;
    Color dark3 = null;
    private MemoryImageSource memoryImage = null;
    private Image image = null;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 50;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$NavLinkListener;

    public NavLinkLabel() {
        this("");
    }

    public NavLinkLabel(String string) {
        this.updateUI();
        this.breakIterator = BreakIterator.getLineInstance();
        this.setText(string);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public NavLinkLabel(String string, Locale locale) {
        this.updateUI();
        this.breakIterator = BreakIterator.getLineInstance(locale);
        this.setText(string);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setText(String string) {
        this.text = string;
        this.breakIterator.setText(string);
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public int getPreferredHeight(int n2) {
        return this.getPreferredHeight(n2, this.getText());
    }

    public int getPreferredHeight(int n2, String string) {
        Dimension dimension = this.getCalculatedSize(n2, string);
        return dimension.height;
    }

    public void setForcedWidth(int n2) {
        this.forcedWidth = n2;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.getPreferredSize().height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int n2 = this.forcedWidth;
        if (this.getWidth() > 0) {
            n2 = this.getWidth();
        }
        return this.getCalculatedSize(n2, this.getText());
    }

    public Dimension getCalculatedSize(int n2, String string) {
        Font font = this.getFont();
        Insets insets = this.getInsets();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        int n3 = insets.left;
        int n4 = fontMetrics.getHeight();
        int n5 = n4 + insets.top;
        if (string.length() == 0) {
            return new Dimension(0, n5);
        }
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = 0;
        string = this.trimAHref(string);
        this.breakIterator.setText(string);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n12;
            String string2;
            n7 = this.breakIterator.next();
            if (n7 != -1) {
                string2 = string.substring(n6, n7);
            } else {
                string2 = string.substring(n6);
                bl2 = true;
            }
            int n13 = fontMetrics.stringWidth(string2);
            if (n3 + n13 > n2 - insets.right) {
                n3 = insets.left;
                n5 += n4;
            }
            if (string2.indexOf(NEWLINE) != -1) {
                n9 = this.getNumberOfOccurances(string2, NEWLINE);
                string2 = string2.replace(NEWLINE.charAt(0), SPACE_TO_TRIM.charAt(0));
                string2.trim();
            } else {
                n9 = 0;
            }
            n11 = n10;
            if (string2.indexOf(TAB) != -1) {
                n10 = this.getNumberOfOccurances(string2, TAB);
                string2 = string2.replace(TAB.charAt(0), SPACE_TO_TRIM.charAt(0));
                string2.trim();
            } else {
                n10 = 0;
            }
            int n14 = 1;
            while (n14 <= n11) {
                string2 = TAB_STRING + string2;
                ++n14;
            }
            if (n11 > 0 || n9 > 0 || n10 > 0) {
                n13 = fontMetrics.stringWidth(string2);
            }
            if (n13 > n2 - insets.right) {
                n12 = 0;
                int n15 = 0;
                while (n15 < string2.length()) {
                    int n16 = fontMetrics.charWidth(string2.charAt(n15));
                    if (n3 + (n12 += n16) > n2 - insets.right) {
                        n5 += n4;
                        n12 = n16;
                        n3 = insets.left;
                    }
                    ++n15;
                }
                n3 = n12;
            } else {
                n8 = Math.max(n3 += n13, n8);
            }
            if (n9 > 0) {
                n12 = 1;
                while (n12 <= n9) {
                    n5 += n4;
                    ++n12;
                }
                n3 = insets.left;
            }
            n6 = this.breakIterator.current();
        }
        Dimension dimension = new Dimension();
        dimension.height = n5 + fontMetrics.getMaxDescent() + insets.bottom;
        dimension.width = n8 + insets.right;
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n2 = insets.left;
        Font font = this.getFont();
        graphics.setFont(font);
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.getAscent() + insets.top;
        int n5 = 0;
        int n6 = 0;
        this.linkSegments = null;
        this.linkSegments = new Vector();
        LinkSegment linkSegment = null;
        this.breakIterator.setText(this.text);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl) {
            String string;
            int n13;
            int n14;
            int n15;
            int n16;
            String string2;
            n6 = this.breakIterator.next();
            if (n6 != -1) {
                string2 = this.text.substring(n5, n6);
            } else {
                string2 = this.text.substring(n5);
                bl = true;
            }
            if (string2.indexOf(NEWLINE) != -1) {
                n7 = this.getNumberOfOccurances(string2, NEWLINE);
                string2 = string2.replace(NEWLINE.charAt(0), SPACE_TO_TRIM.charAt(0));
                string2.trim();
            } else {
                n7 = 0;
            }
            n9 = n8;
            if (string2.indexOf(TAB) != -1) {
                n8 = this.getNumberOfOccurances(string2, TAB);
                string2 = string2.replace(TAB.charAt(0), SPACE_TO_TRIM.charAt(0));
                string2.trim();
            } else {
                n8 = 0;
            }
            if (string2.toLowerCase().endsWith(START_LINK_TAG)) {
                n16 = this.text.toLowerCase().indexOf(START_LINK_TAG, n5);
                n15 = string2.toLowerCase().indexOf(START_LINK_TAG);
                n14 = this.text.toLowerCase().indexOf(END_TAG, n16 + START_LINK_TAG.length());
                if (this.text.toLowerCase().startsWith(HREF_EQUALS, n16 + START_LINK_TAG.length()) && n14 != -1 && (n13 = this.text.toLowerCase().indexOf(END_LINK_TAG, n14 + END_TAG.length())) != -1) {
                    string2 = n15 > 0 ? string2.substring(0, n15) : "";
                    bl2 = true;
                    bl3 = true;
                    bl4 = false;
                    string = this.parseLinkStatement(this.text, n16 + START_LINK_TAG.length(), n14);
                    linkSegment = new LinkSegment(string);
                    this.linkSegments.addElement(linkSegment);
                    n10 = n16;
                }
            } else if (bl3 && string2.toLowerCase().startsWith(HREF_EQUALS) && (n11 = string2.toLowerCase().indexOf(END_TAG, HREF_EQUALS.length())) != -1) {
                string2 = string2.substring(n11 + END_TAG.length());
                bl2 = false;
                bl3 = true;
                bl4 = false;
            }
            if (bl3) {
                n12 = n16 = string2.toLowerCase().indexOf(END_LINK_TAG);
                if (n16 > 0) {
                    bl2 = false;
                    bl3 = false;
                    bl4 = true;
                    String string3 = string2.substring(n12 + END_LINK_TAG.length());
                    String string4 = string2.substring(0, n12);
                    string2 = string4 + string3;
                } else if (n16 == 0) {
                    String string5;
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    string2 = string5 = string2.substring(n12 + END_LINK_TAG.length());
                }
            }
            n16 = 1;
            while (n16 <= n9) {
                string2 = TAB_STRING + string2;
                ++n12;
                ++n16;
            }
            n15 = fontMetrics.stringWidth(string2);
            if (n2 + n15 > dimension.width - insets.right) {
                n2 = insets.left;
                n4 += n3;
            }
            if (n15 > dimension.width - insets.right) {
                String string6;
                n14 = 0;
                n13 = 0;
                int n17 = 0;
                n17 = 0;
                while (n17 < string2.length()) {
                    int n18 = fontMetrics.charWidth(string2.charAt(n17));
                    if (n2 + (n14 += n18) > dimension.width - insets.right) {
                        if (bl4) {
                            string6 = string2.substring(n13, n17 - 1).substring(0, n12);
                            this.drawThisText(string6, n2, n4, true, linkSegment, graphics, fontMetrics);
                            this.drawThisText(string2.substring(n13, n17 - 1).substring(n12), n2 + fontMetrics.stringWidth(string6), n4, false, linkSegment, graphics, fontMetrics);
                            bl4 = false;
                        } else if (bl3 & !bl2) {
                            this.drawThisText(string2.substring(n13, n17 - 1), n2, n4, true, linkSegment, graphics, fontMetrics);
                        } else {
                            this.drawThisText(string2.substring(n13, n17 - 1), n2, n4, false, linkSegment, graphics, fontMetrics);
                        }
                        n4 += n3;
                        n14 = n18;
                        n2 = insets.left;
                        n13 = n17 - 1;
                    }
                    ++n17;
                }
                if (n13 < n17) {
                    string = string2.substring(n13);
                    if (bl4) {
                        string6 = string.substring(0, n12);
                        this.drawThisText(string6, n2, n4, true, linkSegment, graphics, fontMetrics);
                        this.drawThisText(string.substring(n12), n2 + fontMetrics.stringWidth(string6), n4, false, linkSegment, graphics, fontMetrics);
                        bl4 = false;
                    } else if (bl3 & !bl2) {
                        this.drawThisText(string, n2, n4, true, linkSegment, graphics, fontMetrics);
                    } else {
                        this.drawThisText(string, n2, n4, false, linkSegment, graphics, fontMetrics);
                    }
                    n2 += fontMetrics.stringWidth(string);
                }
            } else {
                if (bl4) {
                    String string7 = string2.substring(0, n12);
                    this.drawThisText(string7, n2, n4, true, linkSegment, graphics, fontMetrics);
                    this.drawThisText(string2.substring(n12), n2 + fontMetrics.stringWidth(string7), n4, false, linkSegment, graphics, fontMetrics);
                    bl4 = false;
                } else if (bl3 & !bl2) {
                    this.drawThisText(string2, n2, n4, true, linkSegment, graphics, fontMetrics);
                } else {
                    this.drawThisText(string2, n2, n4, false, linkSegment, graphics, fontMetrics);
                }
                n2 += n15;
            }
            if (n7 > 0) {
                int n19 = 1;
                while (n19 <= n7) {
                    n4 += n3;
                    ++n19;
                }
                n2 = insets.left;
            }
            n5 = this.breakIterator.current();
        }
        if (this.linkSegments.size() > 0) {
            this.underlineLinks(graphics, fontMetrics);
        }
    }

    private void drawThisText(String string, int n2, int n3, boolean bl, LinkSegment linkSegment, Graphics graphics, FontMetrics fontMetrics) {
        if (bl) {
            graphics.setColor(this.linkColor);
            linkSegment.addSegment(n2, n3, fontMetrics.stringWidth(string), fontMetrics);
        } else {
            graphics.setColor(this.getForeground());
        }
        if (!this.isEnabled()) {
            Color color = graphics.getColor();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[2] = 0.53f;
            Color color2 = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
            graphics.setColor(Color.white);
            graphics.drawString(string, n2 + 1, n3 + 1);
            graphics.setColor(color2);
        }
        graphics.drawString(string, n2, n3);
    }

    private int getNumberOfOccurances(String string, String string2) {
        int n2 = 0;
        while (string.indexOf(string2) != -1) {
            ++n2;
            try {
                string = string.substring(string.indexOf(string2) + 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string = "";
            }
        }
        return n2;
    }

    private String trimAHref(String string) {
        String string2 = "<a href=";
        int n2 = string.toLowerCase().indexOf(string2);
        while (n2 != -1) {
            int n3 = string.toLowerCase().indexOf(END_TAG, n2 + string2.length());
            if (n3 != -1) {
                int n4 = string.toLowerCase().indexOf(END_LINK_TAG, n3 + END_TAG.length());
                if (n4 != -1) {
                    String string3 = string.substring(0, n2);
                    String string4 = string.substring(n3 + END_TAG.length(), n4);
                    String string5 = string.substring(n4 + END_LINK_TAG.length());
                    string = string3 + string4 + string5;
                    n2 = string.toLowerCase().indexOf(string2);
                    continue;
                }
                n2 = -1;
                continue;
            }
            n2 = -1;
        }
        return string;
    }

    LinkSegment findSegmentUnder(Point point) {
        if (this.linkSegments == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.linkSegments.size()) {
            LinkSegment linkSegment = (LinkSegment)this.linkSegments.elementAt(n2);
            if (linkSegment.contains(point)) {
                return linkSegment;
            }
            ++n2;
        }
        return null;
    }

    String parseLinkStatement(String string, int n2, int n3) {
        String string2 = string.substring(n2, n3).toLowerCase();
        int n4 = string2.indexOf(HREF_EQUALS);
        if (n4 == -1) {
            return "";
        }
        String string3 = string2.substring(n4 += 5);
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        boolean bl = false;
        int n5 = 0;
        while (n5 < string3.length()) {
            char c2 = string3.charAt(n5);
            if (c2 == '\"') {
                if (bl) {
                    bl = false;
                    break;
                }
                bl = true;
            } else {
                if (c2 == '\\') {
                    c2 = string3.charAt(++n5);
                }
                stringBuffer.append(c2);
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    void underlineLinks(Graphics graphics, FontMetrics fontMetrics) {
        graphics.setColor(this.linkColor);
        int n2 = 0;
        while (n2 < this.linkSegments.size()) {
            LinkSegment linkSegment = (LinkSegment)this.linkSegments.elementAt(n2);
            linkSegment.underlineLinks(graphics, fontMetrics);
            ++n2;
        }
    }

    public void updateUI() {
        this.setFont((Font)UIManager.get("Label.font"));
        this.setBackground((Color)UIManager.get("Label.background"));
        this.setForeground((Color)UIManager.get("Label.foreground"));
    }

    public void addNavLinkListener(NavLinkListener navLinkListener) {
        this.evlistenerList.add(class$com$ibm$db2$tools$common$NavLinkListener == null ? (class$com$ibm$db2$tools$common$NavLinkListener = NavLinkLabel.class$("com.ibm.db2.tools.common.NavLinkListener")) : class$com$ibm$db2$tools$common$NavLinkListener, navLinkListener);
    }

    public void removeNavLinkListener(NavLinkListener navLinkListener) {
        this.evlistenerList.remove(class$com$ibm$db2$tools$common$NavLinkListener == null ? (class$com$ibm$db2$tools$common$NavLinkListener = NavLinkLabel.class$("com.ibm.db2.tools.common.NavLinkListener")) : class$com$ibm$db2$tools$common$NavLinkListener, navLinkListener);
    }

    void fireNavLinkChanged(String string, int n2) {
        Object[] objectArray = this.evlistenerList.getListenerList();
        NavLinkEvent navLinkEvent = new NavLinkEvent(this, string, n2);
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$com$ibm$db2$tools$common$NavLinkListener == null ? NavLinkLabel.class$("com.ibm.db2.tools.common.NavLinkListener") : class$com$ibm$db2$tools$common$NavLinkListener)) {
                ((NavLinkListener)objectArray[n3 + 1]).navLinkStateChanged(navLinkEvent);
            }
            n3 -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bgColor = new Color(192, 192, 192);
        textColor = new Color(0, 0, 128);
    }

    class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        LinkSegment currentSegment = null;

        MouseHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            LinkSegment linkSegment = NavLinkLabel.this.findSegmentUnder(mouseEvent.getPoint());
            if (linkSegment != null) {
                if (linkSegment != this.currentSegment) {
                    NavLinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                    if (this.currentSegment != null) {
                        NavLinkLabel.this.fireNavLinkChanged(this.currentSegment.href, 1002);
                    }
                    this.currentSegment = linkSegment;
                    NavLinkLabel.this.fireNavLinkChanged(this.currentSegment.href, 1001);
                }
            } else {
                NavLinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.currentSegment != null) {
                    NavLinkLabel.this.fireNavLinkChanged(this.currentSegment.href, 1002);
                }
                this.currentSegment = null;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.currentSegment != null) {
                NavLinkLabel.this.fireNavLinkChanged(this.currentSegment.href, 1000);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            NavLinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.currentSegment != null) {
                NavLinkLabel.this.fireNavLinkChanged(this.currentSegment.href, 1002);
            }
            this.currentSegment = null;
        }
    }

    class LinkSegment
    implements Serializable {
        String href;
        Vector rectangles;

        LinkSegment(String string) {
            this.href = string;
            this.rectangles = new Vector();
        }

        public void addSegment(int n2, int n3, int n4, FontMetrics fontMetrics) {
            Rectangle rectangle = new Rectangle(n2, n3 - fontMetrics.getAscent(), n4 + 1, fontMetrics.getAscent() + fontMetrics.getDescent() + 1);
            this.rectangles.addElement(rectangle);
        }

        boolean contains(Point point) {
            int n2 = 0;
            while (n2 < this.rectangles.size()) {
                Rectangle rectangle = (Rectangle)this.rectangles.elementAt(n2);
                if (rectangle.contains(point)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void underlineLinks(Graphics graphics, FontMetrics fontMetrics) {
            int n2 = 0;
            while (n2 < this.rectangles.size()) {
                Rectangle rectangle = (Rectangle)this.rectangles.elementAt(n2);
                int n3 = rectangle.y + fontMetrics.getAscent() + fontMetrics.getDescent() - 1;
                graphics.setColor(NavLinkLabel.this.linkColor);
                graphics.drawLine(rectangle.x, n3, rectangle.x + rectangle.width - 1, n3);
                graphics.setColor(NavLinkLabel.this.getForeground());
                ++n2;
            }
        }
    }
}

