/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.MultiLineLabel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public abstract class MultiLineToggleButton
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
ItemSelectable,
MouseListener {
    protected String labelText;
    protected JToggleButton internalButton;
    protected InternalMultiLineLabel internalLabel;
    protected EventListenerList listenerList;
    protected String actionCommand = null;
    protected int INTER_SPACE = 3;
    protected int BUFFER_WIDTH = 5;
    protected int sizingMode = 2;
    protected int defaultWidth;
    protected int forcedWidth;
    protected int minimumScrollingWidth;
    protected Dimension preferredSize = null;
    protected Dimension minimumSize = null;
    protected Dimension maximumSize = null;
    protected int buttonMinWidth = 0;
    protected Container myContainer;
    protected static final char BLANK_CHAR = '\u2400';
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$javax$swing$JViewport;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    protected MultiLineToggleButton(String string, char c2, int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "MultiLineToggleButton", this, "MultiLineToggleButton(String label, char buttonMnemonic, int widthIn, int buttonType)", new Object[]{string, new Character(c2), new Integer(n2)});
        }
        this.init(string, c2, null, n2);
        CommonTrace.exit(commonTrace);
    }

    protected MultiLineToggleButton(String string, char c2, Container container) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "MultiLineRadioButton", this, "MultiLineRadioButton(String label, char buttonMnemonic, Container containerIn, int buttonType)", new Object[]{string, new Character(c2), container});
        }
        this.init(string, c2, container, -1);
        CommonTrace.exit(commonTrace);
    }

    protected abstract JToggleButton createButton();

    protected void init(String string, char c2, Container container, int n2) {
        this.labelText = string == null ? "" : string;
        this.listenerList = new EventListenerList();
        this.internalButton = this.createButton();
        this.buttonMinWidth = this.internalButton.getMinimumSize().width;
        if (n2 >= 0) {
            this.forcedWidth = Math.max(0, n2 - this.buttonMinWidth);
        }
        this.internalLabel = this.forcedWidth - this.buttonMinWidth >= 0 ? new InternalMultiLineLabel(this.labelText, this.forcedWidth - this.buttonMinWidth, this.buttonMinWidth) : new InternalMultiLineLabel(this.labelText, this, this.buttonMinWidth);
        this.setDefaultWidth(400);
        this.setMinimumScrollingWidth(100);
        if (container != null) {
            this.myContainer = container;
        }
        if (c2 != '\u2400') {
            this.internalButton.setMnemonic(c2);
            this.internalLabel.setDisplayedMnemonic(c2);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)this.internalButton, "Center");
        jPanel2.add((Component)this.internalLabel, "Center");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints2);
        this.internalButton.addActionListener(this);
        this.internalButton.addItemListener(this);
        this.internalButton.addFocusListener(this);
        this.internalLabel.addFocusListener(this);
        this.internalLabel.addMouseListener(this);
        this.internalButton.addMouseListener(this);
        this.setBorder(UIManager.getBorder("Label.border"));
        this.addFocusListener(this);
        this.setupKeyboardActions();
        this.validate();
    }

    public void validate() {
        this.preferredSize = null;
        this.minimumSize = null;
        this.maximumSize = null;
        super.validate();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listenerList != null) {
            this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MultiLineToggleButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MultiLineToggleButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.listenerList != null) {
            this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = MultiLineToggleButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = MultiLineToggleButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
        }
    }

    public void setEnabled(boolean bl) {
        this.internalButton.setEnabled(bl);
        this.internalLabel.setEnabled(bl);
    }

    public void setContainer(Container container) {
        this.myContainer = container;
    }

    public void setSelected(boolean bl) {
        this.internalButton.setSelected(bl);
    }

    public boolean isSelected() {
        return this.internalButton.isSelected();
    }

    public String getText() {
        return this.labelText;
    }

    public void setText(String string) {
        this.internalLabel.setText(string);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public JToggleButton getInternalButton() {
        return this.internalButton;
    }

    public Object[] getSelectedObjects() {
        if (!this.internalButton.isSelected()) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getText()};
        return objectArray;
    }

    public void setSizingMode(int n2) {
        this.sizingMode = n2;
    }

    private void setupKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(32, 0, false);
        this.registerKeyboardAction(new KeyPressAction(this), keyStroke, 0);
    }

    public void setForcedWidth(int n2) {
        this.sizingMode = 1;
        this.forcedWidth = n2;
        this.internalLabel.setForcedWidth(this.forcedWidth - this.buttonMinWidth);
        this.repaint();
    }

    public void setDefaultWidth(int n2) {
        this.defaultWidth = n2;
        this.internalLabel.setDefaultWidth(this.defaultWidth - this.buttonMinWidth);
    }

    public void setMinimumScrollingWidth(int n2) {
        this.minimumScrollingWidth = n2;
        this.internalLabel.setMinimumScrollingWidth(n2 - this.buttonMinWidth);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed(actionEvent);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ActionListener == null ? MultiLineToggleButton.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (actionEvent2 == null) {
                    String string = actionEvent.getActionCommand();
                    if (string == null) {
                        string = this.getActionCommand();
                    }
                    actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getModifiers());
                }
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent2);
            }
            n2 -= 2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fireItemStateChanged(itemEvent);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ItemListener == null ? MultiLineToggleButton.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                if (itemEvent2 == null) {
                    itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
                }
                ((ItemListener)objectArray[n2 + 1]).itemStateChanged(itemEvent2);
            }
            n2 -= 2;
        }
        if (this.accessibleContext != null) {
            if (itemEvent.getStateChange() == 1) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(0), new Integer(1));
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(1), new Integer(0));
            }
        }
    }

    protected Insets getOffsets() {
        Insets insets = this.getInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        LayoutManager layoutManager = this.getParent().getLayout();
        if (layoutManager instanceof GridBagLayout) {
            GridBagConstraints gridBagConstraints = ((GridBagLayout)layoutManager).getConstraints(this);
            insets.left += gridBagConstraints.insets.left;
            insets.right += gridBagConstraints.insets.right;
        } else if (layoutManager instanceof BorderLayout) {
            insets.left += ((BorderLayout)layoutManager).getHgap();
            insets.right += ((BorderLayout)layoutManager).getHgap();
        } else {
            insets.left += 10;
            insets.right += 10;
        }
        return insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.isValid()) {
            Dimension dimension2;
            Dimension dimension3 = this.internalButton.getPreferredSize();
            int n2 = this.defaultWidth;
            Insets insets = null;
            switch (this.sizingMode) {
                case 2: {
                    if (this.myContainer != null) {
                        n2 = this.myContainer.getSize().width;
                        insets = this.getOffsets();
                    } else if (this.getParent() != null) {
                        n2 = this.getParent().getSize().width;
                        insets = this.getOffsets();
                    }
                    if (n2 == 0) {
                        n2 = this.defaultWidth;
                    } else if (insets != null) {
                        n2 -= insets.left + insets.right;
                    }
                    dimension2 = this.internalLabel.getCalculatedSize(n2 - dimension3.width, this.getText());
                    break;
                }
                case 1: {
                    n2 = this.forcedWidth;
                    if (n2 <= 0) {
                        n2 = this.defaultWidth;
                    }
                    dimension2 = this.internalLabel.getCalculatedSize(n2 - dimension3.width, this.getText());
                    break;
                }
                case 3: {
                    JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = MultiLineToggleButton.class$("javax.swing.JViewport")) : class$javax$swing$JViewport, this);
                    if (jViewport != null) {
                        n2 = jViewport.getWidth();
                        Container container = this.getParent();
                        Container container2 = jViewport.getParent();
                        insets = new Insets(0, 0, 0, 0);
                        while (container != null && container != container2) {
                            Insets insets2 = container.getInsets();
                            if (insets2 != null) {
                                insets.left += insets2.left;
                                insets.right += insets2.right;
                            }
                            container = container.getParent();
                        }
                    } else if (this.myContainer != null) {
                        n2 = this.myContainer.getSize().width;
                        insets = this.getOffsets();
                    } else if (this.getParent() != null) {
                        n2 = this.getParent().getSize().width;
                        insets = this.getOffsets();
                    }
                    if (n2 <= 0) {
                        n2 = this.defaultWidth;
                    } else if (insets != null) {
                        n2 -= insets.left + insets.right + 5;
                    }
                    n2 = Math.max(n2, this.minimumScrollingWidth);
                    dimension2 = this.internalLabel.getCalculatedSize(n2 - dimension3.width, this.getText());
                    break;
                }
                default: {
                    this.preferredSize.width -= dimension3.width;
                    dimension2 = this.internalLabel.getUnwrappedSize(this.preferredSize);
                }
            }
            dimension = new Dimension((int)(dimension3.getWidth() + dimension2.getWidth() + (double)this.INTER_SPACE + (double)this.BUFFER_WIDTH), (int)Math.max(dimension3.getHeight(), dimension2.getHeight()));
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.getPreferredSize();
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            this.minimumSize = new Dimension();
        }
        if (this.preferredSize == null) {
            this.preferredSize = this.getPreferredSize();
        }
        if (0 == this.sizingMode) {
            this.minimumSize.width = this.preferredSize.width;
            this.minimumSize.height = this.preferredSize.height;
        } else if (3 == this.sizingMode) {
            this.minimumSize.width = Math.min(this.preferredSize.width, this.minimumScrollingWidth);
            this.minimumSize.height = this.preferredSize.height;
        } else {
            this.minimumSize.width = 0;
            this.minimumSize.height = this.preferredSize.height;
        }
        return this.minimumSize;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.internalLabel && !this.internalLabel.isFocusTraversable()) {
            this.internalButton.doClick();
            this.grabFocus();
        } else if (mouseEvent.getSource() == this.internalButton) {
            this.grabFocus();
        }
        this.fireMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.fireMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.fireMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fireMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.fireMouseEvent(mouseEvent);
    }

    public void setUAKeys(String string) {
        this.putClientProperty("UAKey", string);
        this.internalLabel.putClientProperty("UAKey", string);
        this.internalButton.putClientProperty("UAKey", string);
    }

    protected void fireMouseEvent(MouseEvent mouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$MouseListener == null ? MultiLineToggleButton.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                if (aWTEvent == null) {
                    aWTEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                }
                switch (aWTEvent.getID()) {
                    case 500: {
                        ((MouseListener)objectArray[n2 + 1]).mouseClicked((MouseEvent)aWTEvent);
                        break;
                    }
                    case 504: {
                        ((MouseListener)objectArray[n2 + 1]).mouseEntered((MouseEvent)aWTEvent);
                        break;
                    }
                    case 505: {
                        ((MouseListener)objectArray[n2 + 1]).mouseExited((MouseEvent)aWTEvent);
                        break;
                    }
                    case 501: {
                        ((MouseListener)objectArray[n2 + 1]).mousePressed((MouseEvent)aWTEvent);
                        break;
                    }
                    case 502: {
                        ((MouseListener)objectArray[n2 + 1]).mouseReleased((MouseEvent)aWTEvent);
                    }
                }
            }
            n2 -= 2;
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.hasFocus()) {
            super.paintBorder(graphics);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class InternalMultiLineLabel
    extends MultiLineLabel {
        private int buttonMinWidth = 0;

        InternalMultiLineLabel(String string, Container container, int n2) {
            super(string, container);
            this.buttonMinWidth = n2;
        }

        InternalMultiLineLabel(String string, int n2, int n3) {
            super(string, n2);
            this.buttonMinWidth = n3;
        }

        protected int getContainerWidth() {
            int n2 = super.getContainerWidth();
            return Math.max(n2 - this.buttonMinWidth, 0);
        }

        public boolean isFocusTraversable() {
            boolean bl = this.hyperLinkPolicy && this.anchors != null && this.anchors.size() > 0;
            return bl;
        }
    }

    class KeyPressAction
    extends AbstractAction {
        MultiLineToggleButton button = null;

        KeyPressAction(MultiLineToggleButton multiLineToggleButton2) {
            this.button = multiLineToggleButton2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.button.setSelected(!this.button.isSelected());
        }
    }
}

